/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncGrant;
import com.edb.gridsql.metadata.SysPermission;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.parser.SqlGrant;
import java.sql.SQLException;

public class SyncRevoke
implements IMetaDataUpdate {
    private static final XLogger logger = XLogger.getLogger(SyncGrant.class);
    private int tabprivid = -1;
    private SqlGrant parent;
    private String updateCommand;

    public SyncRevoke(SqlGrant sqlGrant) {
        this.parent = sqlGrant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultPermissions(int n, int n2, boolean bl) throws SQLException {
        Object object;
        if (this.tabprivid == -1) {
            object = MetaData.getMetaData().executeQuery("SELECT max(privid) FROM xsystabprivs");
            try {
                object.next();
                this.tabprivid = object.getInt(1) + 1;
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                object.close();
                throw throwable;
            }
            object.close();
            {
            }
        }
        object = new StringBuffer("insert into xsystabprivs (privid, userid, tableid, selectpriv, insertpriv, updatepriv, deletepriv, referencespriv, indexpriv, alterpriv) values (");
        ((StringBuffer)object).append(this.tabprivid++).append(", ");
        ((StringBuffer)object).append(n2).append(", ");
        ((StringBuffer)object).append(n).append(", ");
        ((StringBuffer)object).append(bl && this.parent.hasSelect() ? "'N', " : "'Y', ");
        ((StringBuffer)object).append(bl && this.parent.hasInsert() ? "'N', " : "'Y', ");
        ((StringBuffer)object).append(bl && this.parent.hasUpdate() ? "'N', " : "'Y', ");
        ((StringBuffer)object).append(bl && this.parent.hasDelete() ? "'N', " : "'Y', ");
        ((StringBuffer)object).append(bl && this.parent.hasReferences() ? "'N', " : "'Y', ");
        ((StringBuffer)object).append(bl && this.parent.hasIndex() ? "'N', " : "'Y', ");
        ((StringBuffer)object).append(bl && this.parent.hasAlter() ? "'N')" : "'Y')");
        if (MetaData.getMetaData().executeUpdate(((StringBuffer)object).toString()) != 1) {
            XDBServerException xDBServerException = new XDBServerException("Failed to insert row into \"xsystabprivs\"");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    private void updateFor(SysPermission sysPermission, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = !(bl || !this.parent.hasSelect() && sysPermission.getSelect() == 1 || !this.parent.hasInsert() && sysPermission.getInsert() == 1 || !this.parent.hasUpdate() && sysPermission.getUpdate() == 1 || !this.parent.hasDelete() && sysPermission.getDelete() == 1 || !this.parent.hasReferences() && sysPermission.getReference() == 1 || !this.parent.hasIndex() && sysPermission.getIndex() == 1 || !this.parent.hasAlter() && sysPermission.getAlter() == 1);
        if (bl2) {
            MetaData.getMetaData().executeUpdate("delete from xsystabprivs where privid = " + sysPermission.getPermissionId());
        } else {
            if (this.updateCommand == null) {
                StringBuffer stringBuffer = new StringBuffer("update xsystabprivs set ");
                if (this.parent.hasSelect()) {
                    stringBuffer.append("selectpriv = 'N', ");
                }
                if (this.parent.hasInsert()) {
                    stringBuffer.append("insertpriv = 'N', ");
                }
                if (this.parent.hasUpdate()) {
                    stringBuffer.append("updatepriv = 'N', ");
                }
                if (this.parent.hasDelete()) {
                    stringBuffer.append("deletepriv = 'N', ");
                }
                if (this.parent.hasReferences()) {
                    stringBuffer.append("referencespriv = 'N', ");
                }
                if (this.parent.hasIndex()) {
                    stringBuffer.append("indexpriv = 'N', ");
                }
                if (this.parent.hasAlter()) {
                    stringBuffer.append("alterpriv = 'N', ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append(" where privid = ");
                this.updateCommand = stringBuffer.toString();
            }
            MetaData.getMetaData().executeUpdate(this.updateCommand + sysPermission.getPermissionId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        try {
            for (SysTable sysTable : this.parent.getTableList()) {
                if (sysTable.getSysPermissions().isEmpty()) {
                    boolean bl = this.parent.getGranteeList().remove(sysTable.getOwner());
                    this.createDefaultPermissions(sysTable.getTableId(), sysTable.getOwner().getUserID(), bl);
                }
                for (SysUser sysUser : this.parent.getGranteeList()) {
                    SysPermission sysPermission = sysTable.getSysPermission(sysUser);
                    if (sysPermission == null) continue;
                    this.updateFor(sysPermission, sysUser == sysTable.getOwner());
                }
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() throws Exception {
        try {
            for (SysTable sysTable : this.parent.getTableList()) {
                for (SysUser sysUser : this.parent.getGranteeList()) {
                    sysUser.removeGranted(sysTable);
                }
                sysTable.readPermissionsInfo();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }
}

