/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysIndexKey;
import com.edb.gridsql.metadata.SysTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysIndex {
    public static final String ROWID_INDEXNAME = "IDX_XROWID";
    public SysTable sysTable;
    public int idxid = -1;
    public String idxname;
    public int tableid;
    public int keycnt;
    private List<SysIndexKey> indexKeys;
    private List<SysColumn> sysColumnList;
    public char idxtype;
    public int issyscreated;
    public boolean is_constrained;
    public int estRowsPerPage = 0;
    public boolean isDistributed = false;
    public int tablespaceID = -1;
    public String usingtype;
    public String wherepred;
    private int indexLength;

    public SysIndex(SysTable sysTable) {
        this.sysTable = sysTable;
    }

    public void readIndexKeysInfo() throws Exception {
        if (this.idxid == -1) {
            String string = ErrorMessageRepository.SYSINDEX_CORRUPT + " ( " + this.idxid + " ) ";
            throw new XDBServerException(string, 0, ErrorMessageRepository.SYSINDEX_CORRUPT_CODE);
        }
        try {
            ResultSet resultSet = MetaData.getMetaData().executeQuery("SELECT * FROM xsysindexkeys WHERE idxid = " + this.idxid + " ORDER BY idxkeyseq");
            this.indexKeys = new ArrayList<SysIndexKey>();
            this.sysColumnList = new ArrayList<SysColumn>();
            int n = 0;
            this.indexLength = 4;
            while (resultSet.next()) {
                SysIndexKey sysIndexKey = new SysIndexKey();
                sysIndexKey.idxkeyid = resultSet.getInt("idxkeyid");
                sysIndexKey.idxid = resultSet.getInt("idxid");
                sysIndexKey.idxkeyseq = resultSet.getInt("idxkeyseq");
                sysIndexKey.idxascdesc = resultSet.getInt("idxascdesc");
                sysIndexKey.colid = resultSet.getInt("colid");
                sysIndexKey.coloperator = resultSet.getString("coloperator");
                sysIndexKey.sysColumn = this.sysTable.getSysColumn(sysIndexKey.colid);
                this.indexKeys.add(sysIndexKey);
                this.sysColumnList.add(sysIndexKey.sysColumn);
                sysIndexKey.sysColumn.addIndexUsage(this, ++n);
                this.indexLength += sysIndexKey.sysColumn.getColumnLength();
            }
            if (n == 0) {
                throw new SQLException("No index keys defined for " + this.idxname);
            }
            this.keycnt = n;
            this.estRowsPerPage = 8096 / this.indexLength;
        }
        catch (SQLException sQLException) {
            String string = ErrorMessageRepository.SYSINDEX_READ_FAILURE + " : " + this.idxname;
            throw new XDBServerException(string, 0, ErrorMessageRepository.SYSINDEX_READ_FAILURE_CODE);
        }
    }

    public List<SysIndexKey> getIndexKeys() {
        return this.indexKeys;
    }

    public List<SysColumn> getKeyColumns() {
        return this.sysColumnList;
    }

    public int getIndexLength() {
        return this.indexLength;
    }

    public String toString() {
        String string = "";
        switch (this.idxtype) {
            case 'P': {
                string = "primary key ";
                break;
            }
            case 'U': {
                string = "unique index ";
                break;
            }
            default: {
                string = "index ";
            }
        }
        if (this.idxname != null) {
            string = string + this.idxname + " ";
        }
        if (this.sysTable != null) {
            string = string + "on " + this.sysTable.getTableName() + " ";
            if (this.sysColumnList != null) {
                string = string + "(";
                for (SysColumn sysColumn : this.sysColumnList) {
                    string = string + sysColumn.getColName() + ", ";
                }
                string = string.substring(0, string.length() - 2) + ")";
            }
        }
        return string;
    }
}

