/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysUser;
import java.security.MessageDigest;
import java.util.Arrays;

public class SysLogin {
    private static final XLogger logger = XLogger.getLogger(SysLogin.class);
    public static final int USER_CLASS_DBA = 0;
    public static final int USER_CLASS_RESOURCE = 1;
    public static final int USER_CLASS_STANDARD = 2;
    public static final String USER_CLASS_DBA_STR = "DBA";
    public static final String USER_CLASS_RESOURCE_STR = "RESOURCE";
    public static final String USER_CLASS_STANDARD_STR = "STANDARD";
    private int id;
    private String name;
    private int userClass = -1;
    private String password;

    public static final String encryptPassword(String string) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            if (messageDigest != null) {
                byte[] byArray = new byte[16];
                Arrays.fill(byArray, (byte)0);
                messageDigest.update(string.getBytes());
                messageDigest.digest(byArray, 0, byArray.length);
                StringBuffer stringBuffer = new StringBuffer(32);
                for (byte by : byArray) {
                    int n = by >> 4 & 0xF;
                    stringBuffer.append((char)(n < 10 ? 48 + n : 97 + n - 10));
                    int n2 = by & 0xF;
                    stringBuffer.append((char)(n2 < 10 ? 48 + n2 : 97 + n2 - 10));
                }
                return stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            logger.catching(exception);
        }
        return "";
    }

    public static String getUserClassStr(int n) {
        switch (n) {
            case 0: {
                return USER_CLASS_DBA_STR;
            }
            case 1: {
                return USER_CLASS_RESOURCE_STR;
            }
        }
        return USER_CLASS_STANDARD_STR;
    }

    public SysLogin(int n, String string, String string2, String string3) {
        this.id = n;
        this.name = string;
        this.password = string2;
        this.setUserClass(string3);
    }

    public void setPassword(String string, boolean bl) throws XDBSecurityException {
        if (string == null || string.length() == 0) {
            XDBSecurityException xDBSecurityException = new XDBSecurityException("Failed to encrypt password");
            logger.throwing(xDBSecurityException);
            throw xDBSecurityException;
        }
        this.password = bl ? SysLogin.encryptPassword(string) : string;
    }

    public void setUserClass(String string) {
        String string2 = string.toUpperCase().trim();
        this.userClass = USER_CLASS_DBA_STR.equals(string2) ? 0 : (USER_CLASS_RESOURCE_STR.equals(string2) ? 1 : 2);
    }

    public void checkPassword(String string) throws XDBSecurityException {
        if (!this.password.equals(SysLogin.encryptPassword(string))) {
            throw new XDBSecurityException("Invalid login");
        }
    }

    public int getLoginID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getUserClass() {
        if (this.id == -1) {
            throw new XDBServerException("User " + this.name + " was concurrently dropped");
        }
        return this.userClass;
    }

    String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void canSetUserClass(String string) throws XDBSecurityException {
        String string2 = string.toUpperCase().trim();
        if (this.userClass == 0 && !USER_CLASS_DBA_STR.equals(string2)) {
            boolean bl = false;
            for (SysLogin sysLogin : MetaData.getMetaData().getSysLogins()) {
                if (sysLogin == this || sysLogin.userClass != 0) continue;
                bl = true;
                break;
            }
            if (!bl) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("System must have at least one DBA user");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
        }
        if (USER_CLASS_STANDARD_STR.equals(string2)) {
            for (SysDatabase sysDatabase : MetaData.getMetaData().getSysDatabases()) {
                sysDatabase.admin();
                SysUser sysUser = sysDatabase.getSysUser(this.name);
                String string3 = sysUser.getOwnedStr();
                if (string3 == null) continue;
                XDBSecurityException xDBSecurityException = new XDBSecurityException("User " + this.name + " owns some objects: " + string3);
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
        }
    }

    void invalidate() {
        this.id = -1;
    }

    public String toString() {
        return this.name + "[" + SysLogin.getUserClassStr(this.userClass) + "]";
    }
}

