/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysViewColumns;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import com.edb.gridsql.parser.core.ParseException;
import java.io.IOException;
import java.sql.ResultSet;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysView {
    private static final XLogger logger = XLogger.getLogger(SysView.class);
    private SysDatabase database = null;
    private int viewid;
    private String viewName;
    private String viewText;
    private Vector<SysViewColumns> viewColumns;
    private Vector<SysColumn> viewDepends;

    public SysView(SysDatabase sysDatabase, int n, String string, String string2) {
        this.database = sysDatabase;
        this.viewid = n;
        this.viewName = string;
        this.viewText = string2;
        this.viewColumns = new Vector();
        this.viewDepends = new Vector();
        this.readViewInfo();
    }

    void readViewInfo() throws XDBServerException {
        try {
            this.readViewColumns();
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR, exception, ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR_CODE);
        }
    }

    private void readViewColumns() throws Exception {
        String string = "SELECT * FROM xsysviewscolumns  WHERE viewid = " + this.viewid + " ORDER BY viewcolseqno";
        ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
        this.viewColumns.clear();
        while (resultSet.next()) {
            SysViewColumns sysViewColumns = new SysViewColumns(resultSet.getInt("viewcolid"), this.viewid, resultSet.getInt("viewcolseqno"), resultSet.getString("viewcolumn"), resultSet.getInt("coltype"), resultSet.getInt("collength"), resultSet.getInt("colscale"), resultSet.getInt("colprecision"));
            this.viewColumns.add(sysViewColumns);
        }
        string = "SELECT * FROM xsysviewdeps  WHERE viewid = " + this.viewid + " ORDER BY tableid";
        resultSet = MetaData.getMetaData().executeQuery(string);
        this.viewDepends.clear();
        while (resultSet.next()) {
            this.viewDepends.add(this.database.getSysTable(resultSet.getInt("tableid")).getSysColumn(resultSet.getInt("columnid")));
        }
    }

    public int getViewid() {
        return this.viewid;
    }

    public void setViewid(int n) {
        this.viewid = n;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public String getViewText() {
        return this.viewText;
    }

    public void setViewText(String string) {
        this.viewText = string;
    }

    public Vector<SysViewColumns> getViewColumns() {
        return this.viewColumns;
    }

    public SysDatabase getSysDatabase() {
        return this.database;
    }

    public boolean hasDependedTable(int n) {
        Iterator<SysColumn> iterator = this.viewDepends.iterator();
        while (iterator.hasNext()) {
            SysTable sysTable = iterator.next().getSysTable();
            if (sysTable.getTableId() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasDependedColumn(int n) {
        for (SysColumn sysColumn : this.viewDepends) {
            if (sysColumn.getColID() != n) continue;
            return true;
        }
        return false;
    }

    public boolean canRenameTable(SysTable sysTable, XDBSessionContext xDBSessionContext) {
        return false;
    }

    public void renameTable(String string, String string2, XDBSessionContext xDBSessionContext) throws XDBServerException, ParseException, IOException {
        Parser parser = new Parser(xDBSessionContext);
        parser.parseStatement(this.viewText);
        SqlSelect sqlSelect = (SqlSelect)parser.getSqlObject();
        QueryTree queryTree = sqlSelect.aQueryTree;
        int n = 0;
        for (RelationNode relationNode : queryTree.getRelationNodeList()) {
            if (relationNode.getTableName().equals(string)) {
                relationNode.setTableName(string2);
                relationNode.setAlias(string2);
            }
            ++n;
        }
        queryTree.rebuildString();
    }
}

