/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.partitions;

import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashPartitionMap
implements PartitionMap {
    private static final long serialVersionUID = -5952477578322320409L;
    private static final int HASH_SIZE = 256;
    private Integer[] mappingTable;
    private transient HashSet<Integer> partitions;

    @Override
    public Collection<Integer> findPartitions(String string) {
        return Collections.singleton(this.getNodeId(string));
    }

    @Override
    public void generateDistribution(Collection<Integer> collection) {
        this.partitions = new HashSet<Integer>(collection);
        Iterator<Integer> iterator = collection.iterator();
        this.mappingTable = new Integer[256];
        for (int i = 0; i < this.mappingTable.length; ++i) {
            if (!iterator.hasNext()) {
                iterator = collection.iterator();
            }
            this.mappingTable[i] = iterator.next();
        }
    }

    @Override
    public Collection<Integer> getPartitions(String string) {
        return Collections.singleton(this.getNodeId(string));
    }

    @Override
    public Collection<Integer> joinPartitions() {
        return this.allPartitions();
    }

    @Override
    public Collection<Integer> allPartitions() {
        if (this.partitions == null) {
            this.partitions = new HashSet();
            for (Integer n : this.mappingTable) {
                this.partitions.add(n);
            }
        }
        return this.partitions;
    }

    @Override
    public int getRedundancyLevel() {
        return 1;
    }

    @Override
    public PartitionMap clone() {
        try {
            return (PartitionMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HashPartitionMap) {
            return Arrays.equals((Object[])this.mappingTable, (Object[])((HashPartitionMap)object).mappingTable);
        }
        return false;
    }

    private Integer getNodeId(String string) {
        return this.getNodeFromHash(HashPartitionMap.hash(string));
    }

    private Integer getNodeFromHash(int n) {
        if (this.mappingTable[n] == null) {
            String string = ErrorMessageRepository.NODE_INFORMATION_LOST_FROM_NODE_TABLE + " ( " + n + " )";
            throw new XDBServerException(string, 2, ErrorMessageRepository.NODE_INFORMATION_LOST_FROM_NODE_TABLE_CODE);
        }
        return this.mappingTable[n];
    }

    private static final int hash(String string) {
        return HashPartitionMap.hash(string == null ? null : string.getBytes());
    }

    private static final int hash(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 596579247 * byArray.length;
        for (int i = 0; i < byArray.length; ++i) {
            n = n + (byArray[i] << i * 5 % 24) & Integer.MAX_VALUE;
        }
        return (1103515243 * n + 12345) % 65537 & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readMapFromMetadataDB(MetaData metaData, SysTable sysTable) throws SQLException {
        this.mappingTable = new Integer[256];
        String string = "SELECT hashValue, nodeid FROM xsystabparthash WHERE tableid = " + sysTable.getTableId();
        ResultSet resultSet = metaData.executeQuery(string);
        try {
            while (resultSet.next()) {
                this.mappingTable[resultSet.getInt((int)1)] = resultSet.getInt(2);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeMapToMetadataDB(MetaData metaData, SysDatabase sysDatabase, int n) throws SQLException {
        String string;
        int n2 = 0;
        String string2 = "SELECT max(parthashid) FROM xsystabparthash";
        ResultSet resultSet = metaData.executeQuery(string2);
        try {
            resultSet.next();
            n2 = resultSet.getInt(1) + 1;
            string = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        for (int i = 0; i < this.mappingTable.length; ++i) {
            string = "INSERT INTO xsystabparthash (parthashid, tableid, dbid, hashValue, nodeid) VALUES (" + n2++ + ", " + n + ", " + sysDatabase.getDbid() + ", " + i + ", " + this.mappingTable[i] + ")";
            metaData.executeUpdate(string);
        }
    }

    @Override
    public void removeMapFromMetadataDB(MetaData metaData, SysTable sysTable) throws SQLException {
        String string = "DELETE FROM xsystabparthash WHERE tableid = " + sysTable.getTableId();
        metaData.executeUpdate(string);
        string = "DELETE FROM xsystabparts WHERE tableid = " + sysTable.getTableId();
        metaData.executeUpdate(string);
    }
}

