/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.misc.combinedresultset;

import com.edb.gridsql.common.XDBResultSetMetaData;
import com.edb.gridsql.common.util.SQLTypeConverter;
import com.edb.gridsql.misc.combinedresultset.ResultSetPosManager;
import com.edb.gridsql.misc.combinedresultset.ServerResultSet;
import com.edb.gridsql.misc.combinedresultset.SortCriteria;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerResultSetImpl
implements ResultSet,
ServerResultSet {
    private List<SortCriteria> sortedOrderList;
    private ResultSetPosManager currentResultSetManager;
    private XDBResultSetMetaData rsImpl;
    private List<ResultSetPosManager> resultSetManagerList = new ArrayList<ResultSetPosManager>();
    private TreeSet<ResultSetPosManager> aTreeSet;
    private LinkedList<ResultSetPosManager> aLinkedList;
    private Collection<String> finalCoordTempTableList;
    private Collection<String> finalNodeTempTableList;
    private long limit = -1L;
    private long currentRow = 0L;

    @Override
    public ResultSetMetaData getMetaData() {
        return this.rsImpl;
    }

    public ServerResultSetImpl(Collection<? extends ResultSet> collection, List<SortCriteria> list, boolean bl, long l, long l2, XDBResultSetMetaData xDBResultSetMetaData) throws SQLException {
        ArrayList<SortCriteria> arrayList = new ArrayList<SortCriteria>();
        this.limit = l;
        if (collection == null) {
            throw new NullPointerException("The resultset list is null");
        }
        if (list == null) {
            this.sortedOrderList = new ArrayList<SortCriteria>();
        } else {
            this.sortedOrderList = list;
            for (SortCriteria object : list) {
                if (object.isIncludeInResult()) continue;
                arrayList.add(object);
            }
        }
        int n = 0;
        for (ResultSet resultSet : collection) {
            ResultSetPosManager resultSetPosManager = new ResultSetPosManager(resultSet, this.sortedOrderList, n);
            this.resultSetManagerList.add(resultSetPosManager);
            if (bl) continue;
            ++n;
        }
        if (this.sortedOrderList == null || this.sortedOrderList.isEmpty()) {
            this.aLinkedList = new LinkedList();
            for (ResultSetPosManager resultSetPosManager : this.resultSetManagerList) {
                if (!resultSetPosManager.next()) continue;
                this.aLinkedList.addFirst(resultSetPosManager);
            }
        } else {
            this.aTreeSet = new TreeSet();
            for (ResultSetPosManager resultSetPosManager : this.resultSetManagerList) {
                boolean bl2 = false;
                while (!bl2 && resultSetPosManager.next()) {
                    bl2 = this.aTreeSet.add(resultSetPosManager);
                }
            }
        }
        while (l2 > 0L) {
            this.do_next();
            --l2;
        }
        this.rsImpl = xDBResultSetMetaData;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentRow == this.limit) {
            this.close();
            this.currentResultSetManager = null;
            this.aTreeSet = null;
            this.aLinkedList = null;
            return false;
        }
        ++this.currentRow;
        return this.do_next();
    }

    private boolean do_next() {
        if (this.currentResultSetManager != null) {
            if (this.aTreeSet != null) {
                boolean bl = false;
                while (!bl && this.currentResultSetManager.next()) {
                    bl = this.aTreeSet.add(this.currentResultSetManager);
                }
            } else if (this.aLinkedList != null && this.currentResultSetManager.next()) {
                this.aLinkedList.addFirst(this.currentResultSetManager);
            }
        }
        if (this.aTreeSet != null) {
            if (this.aTreeSet.isEmpty()) {
                this.currentResultSetManager = null;
            } else {
                this.currentResultSetManager = this.aTreeSet.last();
                this.aTreeSet.remove(this.currentResultSetManager);
            }
        } else if (this.aLinkedList != null) {
            this.currentResultSetManager = this.aLinkedList.isEmpty() ? null : this.aLinkedList.removeLast();
        }
        return this.currentResultSetManager != null;
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        return SQLTypeConverter.getBytes(this.currentResultSetManager.getObject(n));
    }

    @Override
    public String getString(int n) throws SQLException {
        return SQLTypeConverter.getString(this.currentResultSetManager.getObject(n));
    }

    @Override
    public int getInt(int n) throws SQLException {
        return SQLTypeConverter.getInt(this.currentResultSetManager.getObject(n));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        return SQLTypeConverter.getLong(this.currentResultSetManager.getObject(n));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    public void setFinalCoordTempTableList(Collection<String> collection) {
        this.finalCoordTempTableList = collection;
    }

    public Collection<String> getFinalCoordTempTableList() {
        return this.finalCoordTempTableList;
    }

    public void setFinalNodeTempTableList(Collection<String> collection) {
        this.finalNodeTempTableList = collection;
    }

    public Collection<String> getFinalNodeTempTableList() {
        return this.finalNodeTempTableList;
    }

    public void addToFinalNodeTempTableList(Collection<String> collection) {
        if (this.finalNodeTempTableList == null) {
            this.finalNodeTempTableList = new ArrayList<String>(collection);
        } else {
            this.finalNodeTempTableList.addAll(collection);
        }
    }

    @Override
    public void close() throws SQLException {
        for (ResultSetPosManager resultSetPosManager : this.resultSetManagerList) {
            resultSetPosManager.close();
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("Operation is not supported");
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n = this.rsImpl.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            if (!string.equalsIgnoreCase(this.rsImpl.getColumnName(i))) continue;
            return i;
        }
        throw new SQLException("Column name is not found: " + string);
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public Array getArray(int n) throws SQLException {
        return SQLTypeConverter.getArray(this.currentResultSetManager.getObject(n));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        return SQLTypeConverter.getAsciiStream(this.currentResultSetManager.getObject(n));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        return SQLTypeConverter.getBigDecimal(this.currentResultSetManager.getObject(n));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this.getBigDecimal(n);
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        return SQLTypeConverter.getBinaryStream(this.currentResultSetManager.getObject(n));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        return SQLTypeConverter.getBlob(this.currentResultSetManager.getObject(n));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        return SQLTypeConverter.getBoolean(this.currentResultSetManager.getObject(n));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        return SQLTypeConverter.getByte(this.currentResultSetManager.getObject(n));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        return SQLTypeConverter.getCharacterStream(this.currentResultSetManager.getObject(n));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        return SQLTypeConverter.getClob(this.currentResultSetManager.getObject(n));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public int getConcurrency() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public Date getDate(int n) throws SQLException {
        return this.getDate(n, Calendar.getInstance());
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string), Calendar.getInstance());
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        return SQLTypeConverter.getDate(this.currentResultSetManager.getObject(n), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        return SQLTypeConverter.getDouble(this.currentResultSetManager.getObject(n));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public float getFloat(int n) throws SQLException {
        return SQLTypeConverter.getFloat(this.currentResultSetManager.getObject(n));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        return this.currentResultSetManager.getObject(n);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        return SQLTypeConverter.getObject(this.currentResultSetManager.getObject(n), map);
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        return SQLTypeConverter.getRef(this.currentResultSetManager.getObject(n));
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public int getRow() throws SQLException {
        return 0;
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public short getShort(int n) throws SQLException {
        return SQLTypeConverter.getShort(this.currentResultSetManager.getObject(n));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        return this.getTime(n, Calendar.getInstance());
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        return SQLTypeConverter.getTime(this.currentResultSetManager.getObject(n), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string), Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        return this.getTimestamp(n, Calendar.getInstance());
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return SQLTypeConverter.getTimestamp(this.currentResultSetManager.getObject(n), calendar);
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        return SQLTypeConverter.getURL(this.currentResultSetManager.getObject(n));
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        return SQLTypeConverter.getAsciiStream(this.currentResultSetManager.getObject(n));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean relative(int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new SQLException("method not supported");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.currentResultSetManager.lastValueWasNull();
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return null;
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return null;
    }

    @Override
    public String getNString(int n) throws SQLException {
        return null;
    }

    @Override
    public String getNString(String string) throws SQLException {
        return null;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }
}

