/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.FunctionAnalysis;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.parser.ExprTypeHelper;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.CastTemplates;
import com.edb.gridsql.parser.handler.DataTypeHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExpression
implements IRebuildString {
    private static final XLogger logger = XLogger.getLogger(SqlExpression.class);
    private static final String subsecondBaseString = "000000000";
    private static final int CONSTANT_DOUBLE_SCALE_VALUE = 10;
    private static final int CONSTANT_PRECISION_DOUBLE_VALUE = 32;
    public static final int INTERNALMAPPING = 1;
    public static final int EXTERNALMAPPING = 2;
    public static final int ORIGINAL = 3;
    public static final int SQLEX_CONSTANT = 2;
    public static final int SQLEX_COLUMN = 4;
    public static final int SQLEX_UNARY_EXPRESSION = 8;
    public static final int SQLEX_OPERATOR_EXPRESSION = 16;
    public static final int SQLEX_FUNCTION = 32;
    public static final int SQLEX_SUBQUERY = 64;
    public static final int SQLEX_CONDITION = 128;
    public static final int SQLEX_CASE = 256;
    public static final int SQLEX_LIST = 512;
    public static final int SQLEX_PARAMETER = 1024;
    public static final int SQLEX_COLUMNLIST = 512;
    public static final int SQLEX_ALL = 958;
    private int exprType;
    private ExpressionType exprDataType;
    private String exprString = "";
    private QueryTree belongsToTree;
    private String alias = "";
    private String aggAlias = "";
    private String outerAlias = "";
    private String projectionLabel = null;
    private String constantValue = "";
    private AttributeColumn column;
    private SqlExpression leftExpr;
    private SqlExpression rightExpr;
    private String unaryOperator = "";
    private QueryCondition aQueryCondition = null;
    private String operandSign = "";
    private String operator = "";
    private int mapped = 3;
    private SqlExpression mappedExpression = null;
    private int paramNumber;
    private String paramValue = null;
    private int functionId;
    private String functionName = "";
    private List<SqlExpression> functionParams = new ArrayList<SqlExpression>();
    private String argSeparator = ", ";
    private boolean needParenthesisInFunction = true;
    private DataTypeHandler expTypeOfCast;
    private boolean isDistinctGroupFunction = false;
    private boolean isDeferredGroup = false;
    private boolean isAllCountGroupFunction = false;
    private boolean isDistinctExtraGroup = false;
    private SCase caseConstruct = new SCase();
    private QueryTree subqueryTree;
    private boolean isTemporaryExpression = false;
    private RelationNode parentContainerNode;
    private boolean isAdded = false;
    private List<SqlExpression> expressionList = new ArrayList<SqlExpression>();

    public QueryTree getBelongsToTree() {
        return this.belongsToTree;
    }

    public void setBelongsToTree(QueryTree queryTree) {
        this.belongsToTree = queryTree;
        if (this.subqueryTree == null) {
            for (SqlExpression sqlExpression : SqlExpression.getNodes(this, 4)) {
                sqlExpression.getColumn().setMyParentTree(queryTree);
            }
        }
    }

    public void setTempExpr(boolean bl) {
        this.isTemporaryExpression = bl;
    }

    public boolean isTempExpr() {
        return this.isTemporaryExpression;
    }

    public static Vector<SqlExpression> getNodes(SqlExpression sqlExpression, int n) {
        return SqlExpression.getNodes(sqlExpression, n, null);
    }

    private static Vector<SqlExpression> getNodes(SqlExpression sqlExpression, int n, HashSet<SqlExpression> hashSet) {
        if (hashSet == null) {
            hashSet = new HashSet();
        }
        if (hashSet.contains(sqlExpression)) {
            return new Vector<SqlExpression>();
        }
        hashSet.add(sqlExpression);
        Vector<SqlExpression> vector = new Vector<SqlExpression>();
        SqlExpression sqlExpression2 = sqlExpression.rightExpr;
        SqlExpression sqlExpression3 = sqlExpression.leftExpr;
        if (sqlExpression2 != null) {
            vector.addAll(SqlExpression.getNodes(sqlExpression2, n, hashSet));
        }
        if (sqlExpression3 != null) {
            vector.addAll(SqlExpression.getNodes(sqlExpression3, n, hashSet));
        }
        if ((sqlExpression.getExprType() & 0x40) > 0) {
            if ((sqlExpression.subqueryTree.getQueryType() & 6) == 0) {
                for (SqlExpression iRebuildString : sqlExpression.parentContainerNode.getProjectionList()) {
                    if (hashSet != null && hashSet.contains(iRebuildString)) continue;
                    vector.addAll(SqlExpression.getNodes(iRebuildString, n, hashSet));
                }
            }
            if ((sqlExpression.subqueryTree.getQueryType() & 0xA) > 0 && sqlExpression.subqueryTree != null) {
                for (QueryCondition queryCondition : sqlExpression.subqueryTree.getConditionList()) {
                    for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                        vector.addAll(SqlExpression.getNodes(queryCondition2.getExpr(), n, hashSet));
                    }
                }
            }
        }
        if ((sqlExpression.getExprType() & 0x20) > 0) {
            for (SqlExpression sqlExpression4 : sqlExpression.functionParams) {
                vector.addAll(SqlExpression.getNodes(sqlExpression4, n, hashSet));
            }
        }
        if ((sqlExpression.getExprType() & 0x100) > 0) {
            for (SqlExpression sqlExpression5 : sqlExpression.getCaseConstruct().getSQLExpressions()) {
                vector.addAll(SqlExpression.getNodes(sqlExpression5, n, hashSet));
            }
        }
        if ((sqlExpression.getExprType() & n) > 0) {
            vector.add(sqlExpression);
        }
        return vector;
    }

    public SqlExpression(QueryTree queryTree) {
        this.setExprType(64);
        this.subqueryTree = queryTree;
    }

    public SqlExpression() {
    }

    public SqlExpression(String string, ExpressionType expressionType) {
        this.exprType = 2;
        this.constantValue = string;
        this.exprString = string;
        this.exprDataType = expressionType;
    }

    public static SqlExpression copy(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
        sqlExpression2.exprType = sqlExpression.exprType;
        sqlExpression2.exprString = sqlExpression.exprString;
        sqlExpression2.unaryOperator = sqlExpression.unaryOperator;
        sqlExpression2.operator = sqlExpression.operator;
        sqlExpression2.operandSign = sqlExpression.operandSign;
        sqlExpression2.constantValue = sqlExpression.constantValue;
        sqlExpression2.column = sqlExpression.column;
        sqlExpression2.functionId = sqlExpression.functionId;
        sqlExpression2.functionName = sqlExpression.functionName;
        sqlExpression2.functionParams = sqlExpression.functionParams;
        sqlExpression2.expTypeOfCast = sqlExpression.expTypeOfCast;
        sqlExpression2.needParenthesisInFunction = sqlExpression.needParenthesisInFunction;
        sqlExpression2.argSeparator = sqlExpression.argSeparator;
        sqlExpression2.alias = sqlExpression.alias;
        sqlExpression2.outerAlias = sqlExpression.outerAlias;
        sqlExpression2.leftExpr = sqlExpression.leftExpr;
        sqlExpression2.rightExpr = sqlExpression.rightExpr;
        sqlExpression2.exprDataType = sqlExpression.exprDataType;
        sqlExpression2.aQueryCondition = sqlExpression.aQueryCondition;
        sqlExpression2.isDistinctGroupFunction = sqlExpression.isDistinctGroupFunction;
        sqlExpression2.isDeferredGroup = sqlExpression.isDeferredGroup;
        sqlExpression2.isAllCountGroupFunction = sqlExpression.isAllCountGroupFunction;
        sqlExpression2.caseConstruct = sqlExpression.caseConstruct;
        sqlExpression2.subqueryTree = sqlExpression.subqueryTree;
        sqlExpression2.projectionLabel = sqlExpression.projectionLabel;
        sqlExpression2.paramNumber = sqlExpression.paramNumber;
        sqlExpression2.paramValue = sqlExpression.paramValue;
        return sqlExpression2;
    }

    public SqlExpression copy() {
        return SqlExpression.copy(this, new SqlExpression());
    }

    public void rebuildExpression() {
        this.rebuildExpression(null);
    }

    private void rebuildExpression(XDBSessionContext xDBSessionContext) {
        if (this.unaryOperator.equals("+")) {
            this.unaryOperator = "";
            this.exprString = SqlExpression.rebuildExpression(this, xDBSessionContext);
        } else if (this.unaryOperator.equals("")) {
            this.exprString = SqlExpression.rebuildExpression(this, xDBSessionContext);
        } else if (this.getExprType() == 1024) {
            SqlExpression.rebuildExpression(this, xDBSessionContext);
        } else {
            this.exprString = this.unaryOperator.equals("|/") ? "|/ " + this.operandSign + SqlExpression.rebuildExpression(this, xDBSessionContext) : (this.unaryOperator.equals("||/") ? "||/ " + this.operandSign + SqlExpression.rebuildExpression(this, xDBSessionContext) : (this.unaryOperator.equals("!") ? this.operandSign + SqlExpression.rebuildExpression(this, xDBSessionContext) + " !" : (this.unaryOperator.equals("!!") ? "!! " + this.operandSign + SqlExpression.rebuildExpression(this, xDBSessionContext) : (this.unaryOperator.equals("@") ? "@ " + this.operandSign + SqlExpression.rebuildExpression(this, xDBSessionContext) : (this.unaryOperator.equals("~") ? "~ " + SqlExpression.rebuildExpression(this, xDBSessionContext) : "-" + SqlExpression.rebuildExpression(this, xDBSessionContext))))));
        }
    }

    private static String rebuildExpression(SqlExpression sqlExpression, XDBSessionContext xDBSessionContext) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!sqlExpression.isTemporaryExpression) {
            if (sqlExpression.getExprType() != 16) {
                if (sqlExpression.getExprType() == 4) {
                    AttributeColumn attributeColumn = sqlExpression.getColumn();
                    if (attributeColumn.relationNode != null) {
                        string3 = attributeColumn.relationNode.getCurrentTempTableName().length() > 0 ? IdentifierHandler.quote(attributeColumn.relationNode.getCurrentTempTableName()) : (!attributeColumn.relationNode.getAlias().equals("") ? IdentifierHandler.quote(attributeColumn.relationNode.getAlias()) : (attributeColumn.getTableAlias().length() > 0 ? IdentifierHandler.quote(attributeColumn.getTableAlias()) : IdentifierHandler.quote(attributeColumn.getTableName())));
                    } else if (attributeColumn.getTableAlias() != null && attributeColumn.getTableAlias().length() > 0) {
                        string3 = IdentifierHandler.quote(attributeColumn.getTableAlias());
                    }
                    string3 = sqlExpression.getColumn().tempColumnAlias.length() > 0 ? string3 + "." + IdentifierHandler.quote(sqlExpression.getColumn().tempColumnAlias) : (sqlExpression.getColumn().columnAlias != null && sqlExpression.getColumn().columnAlias.length() > 0 ? (sqlExpression.getColumn().getTableName().length() > 0 ? string3 + "." + IdentifierHandler.quote(sqlExpression.getColumn().columnAlias) : string3 + IdentifierHandler.quote(sqlExpression.getColumn().columnAlias)) : (sqlExpression.getColumn().getTableName().length() > 0 ? string3 + "." + IdentifierHandler.quote(sqlExpression.getColumn().columnName) : (string3 == null || string3.equals("") ? string3 + IdentifierHandler.quote(sqlExpression.getColumn().columnName) : string3 + "." + IdentifierHandler.quote(sqlExpression.getColumn().columnName))));
                } else if (sqlExpression.getExprType() == 32 && !sqlExpression.isTemporaryExpression) {
                    switch (sqlExpression.functionId) {
                        case 163: {
                            String string4 = "" + new Timestamp(System.currentTimeMillis());
                            int n = string4.indexOf(".");
                            if (n > 0) {
                                string4 = string4.substring(0, n);
                            }
                            return "timestamp '" + string4 + "'";
                        }
                        case 189: {
                            return "date '" + new Date(System.currentTimeMillis()) + "'";
                        }
                        case 190: {
                            return "time '" + new Time(System.currentTimeMillis()) + "'";
                        }
                        case 191: {
                            return "timestamp '" + new Timestamp(System.currentTimeMillis()) + "'";
                        }
                        case 161: {
                            return xDBSessionContext == null ? sqlExpression.constantValue : "'" + xDBSessionContext.getSysDatabase().getDbname().replaceAll("'", "''") + "'";
                        }
                        case 192: {
                            return xDBSessionContext == null ? sqlExpression.constantValue : "'" + xDBSessionContext.getCurrentUser().getName().replaceAll("'", "''") + "'";
                        }
                        case 84: {
                            return "'" + "2.0.0.0".replaceAll("'", "''") + "'";
                        }
                    }
                    string3 = Property.get("xdb.sqlfunction." + sqlExpression.functionName + ".template");
                    if (string3 == null) {
                        string3 = sqlExpression.functionName;
                        if (sqlExpression.functionId == 106) {
                            SqlExpression sqlExpression2 = sqlExpression.functionParams.get(0);
                            sqlExpression2.rebuildExpression();
                            if (sqlExpression2.getExprDataType() == null) {
                                return sqlExpression2.getConstantValue();
                            }
                            int n = sqlExpression2.getExprType() == 4 ? sqlExpression2.getColumn().columnType.type : sqlExpression2.getExprDataType().type;
                            string3 = CastTemplates.getTemplate(n, sqlExpression.expTypeOfCast.getSqlType());
                            if (string3 == null || string3.trim().equals("")) {
                                throw new XDBServerException("Can not cast those datatypes.");
                            }
                            HashMap<String, String> hashMap = new HashMap<String, String>();
                            int n2 = 0;
                            for (SqlExpression sqlExpression3 : sqlExpression.functionParams) {
                                ++n2;
                                sqlExpression3.rebuildExpression();
                                hashMap.put("arg", sqlExpression3.exprString);
                                hashMap.put("type", sqlExpression.expTypeOfCast.getTypeString());
                            }
                            string3 = ParseCmdLine.substitute(string3, hashMap);
                        } else if (sqlExpression.functionId != 77) {
                            string3 = sqlExpression.needParenthesisInFunction ? string3 + "( " : string3 + " ";
                            if (FunctionAnalysis.isGroupFunction(sqlExpression.functionId) && sqlExpression.isDistinctGroupFunction) {
                                string3 = string3 + "DISTINCT ";
                            }
                            if (FunctionAnalysis.isGroupFunction(sqlExpression.functionId) && sqlExpression.isAllCountGroupFunction) {
                                string3 = string3 + "ALL ";
                            }
                            boolean bl = false;
                            for (SqlExpression sqlExpression4 : sqlExpression.functionParams) {
                                if (bl) {
                                    string3 = string3 + sqlExpression.getArgSeparator();
                                }
                                bl = true;
                                sqlExpression4.rebuildExpression();
                                string3 = string3 + sqlExpression4.exprString;
                            }
                            string3 = sqlExpression.needParenthesisInFunction ? string3 + ") " : string3 + " ";
                        } else if (string3 == null) {
                            string3 = sqlExpression.exprString;
                        }
                    } else {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        int n = 0;
                        for (SqlExpression sqlExpression5 : sqlExpression.functionParams) {
                            sqlExpression5.rebuildExpression();
                            hashMap.put("arg" + ++n, sqlExpression5.exprString);
                        }
                        string3 = ParseCmdLine.substitute(string3, hashMap);
                    }
                } else if (sqlExpression.getExprType() == 256) {
                    string3 = sqlExpression.getCaseConstruct().rebuildString();
                } else if (sqlExpression.getExprType() == 2) {
                    string3 = Props.XDB_STRIP_INTERVAL_QUOTES && sqlExpression.getConstantValue() != null && sqlExpression.getConstantValue().toLowerCase().startsWith("interval") ? sqlExpression.getConstantValue().replaceAll("'", "") : sqlExpression.getConstantValue();
                } else if (sqlExpression.getExprType() == 64) {
                    string3 = "(" + sqlExpression.subqueryTree.rebuildString() + ")";
                } else if (sqlExpression.getExprType() == 512) {
                    boolean bl = true;
                    for (SqlExpression sqlExpression6 : sqlExpression.expressionList) {
                        if (bl) {
                            string3 = string3 + "( " + sqlExpression6.rebuildString();
                            bl = false;
                            continue;
                        }
                        string3 = string3 + " , " + sqlExpression6.rebuildString();
                    }
                    string3 = string3 + " )";
                } else {
                    string3 = sqlExpression.exprString;
                }
            } else if (sqlExpression.leftExpr != null) {
                sqlExpression.leftExpr.rebuildExpression();
                string2 = sqlExpression.leftExpr.exprString;
                sqlExpression.rightExpr.rebuildExpression();
                string = sqlExpression.rightExpr.exprString;
                if (sqlExpression.operator.compareTo("\\") == 0) {
                    sqlExpression.operator = "/";
                }
                string3 = "(" + string2 + " " + sqlExpression.operator + " " + string + ")";
            }
        } else {
            string3 = sqlExpression.exprType == 4 && sqlExpression.exprString != null && sqlExpression.exprString.length() > 0 && !sqlExpression.exprString.startsWith("\"") ? IdentifierHandler.quote(sqlExpression.exprString) : sqlExpression.exprString;
        }
        return string3;
    }

    public boolean isAggregateExpression() {
        if (this.getExprType() == 32) {
            switch (this.functionId) {
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: 
                case 169: 
                case 170: 
                case 171: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean containsAggregates() {
        for (SqlExpression sqlExpression : SqlExpression.getNodes(this, 32)) {
            if (!sqlExpression.isAggregateExpression()) continue;
            return true;
        }
        return false;
    }

    public String toString(String string) {
        return string + " " + this.exprString;
    }

    public static SqlExpression getSqlColumnExpression(String string, String string2, String string3, String string4, String string5) {
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.exprString = string;
        sqlExpression.setExprType(4);
        sqlExpression.setColumn(new AttributeColumn());
        sqlExpression.getColumn().columnName = string;
        sqlExpression.setAlias(sqlExpression.getColumn().columnName);
        sqlExpression.getColumn().setTableName(string2);
        sqlExpression.operator = string5 == null || string5.equals("") ? "+" : string5;
        sqlExpression.getColumn().columnAlias = string4 == null || string4.equals("") ? string : string4;
        if (string3 == null || string3.equals("")) {
            sqlExpression.getColumn().setTableAlias(string2);
        } else {
            sqlExpression.getColumn().setTableAlias(string3);
        }
        sqlExpression.setAlias(sqlExpression.getColumn().columnAlias);
        sqlExpression.outerAlias = sqlExpression.getAlias();
        return sqlExpression;
    }

    public ExpressionType setExpressionResultType(SqlExpression sqlExpression, SysColumn sysColumn) {
        sqlExpression.setExprDataType(new ExpressionType());
        sqlExpression.getExprDataType().setExpressionType(sysColumn.getColType(), sysColumn.getColLength(), sysColumn.getColPrecision(), sysColumn.getColScale());
        return sqlExpression.getExprDataType();
    }

    public static ExpressionType setExpressionResultType(SqlExpression sqlExpression, SysDatabase sysDatabase) throws XDBServerException, ColumnNotFoundException {
        if (sqlExpression.getExprDataType() != null && sqlExpression.getExprDataType().type != 0) {
            return sqlExpression.getExprDataType();
        }
        if (sqlExpression.getExprType() == 1024) {
            return sqlExpression.getExprDataType();
        }
        if (sqlExpression.getExprType() == 64) {
            return sqlExpression.subqueryTree.getProjectionList().get(0).getExprDataType();
        }
        if (sqlExpression.getExprType() == 128) {
            // empty if block
        }
        if (sqlExpression.getExprType() == 512) {
            // empty if block
        }
        if (sqlExpression.getExprType() == 2) {
            int n = sqlExpression.getConstantDataType();
            ExpressionType expressionType = new ExpressionType();
            expressionType.setExpressionType(n, sqlExpression.getConstantValue() == null ? -1 : sqlExpression.getConstantValue().length(), 32, 10);
            sqlExpression.setExprDataType(expressionType);
            return expressionType;
        }
        if (sqlExpression.getExprType() == 32) {
            if (sqlExpression.functionId == 106) {
                sqlExpression.functionParams.get(0).rebuildExpression();
                SqlExpression.setExpressionResultType(sqlExpression.functionParams.get(0), sysDatabase);
                sqlExpression.setExprDataType(new ExpressionType());
                sqlExpression.exprDataType.type = sqlExpression.expTypeOfCast.getSqlType();
                sqlExpression.exprDataType.length = sqlExpression.expTypeOfCast.getLength();
                sqlExpression.exprDataType.precision = sqlExpression.expTypeOfCast.getPrecision();
                sqlExpression.exprDataType.scale = sqlExpression.expTypeOfCast.getScale();
                if ((sqlExpression.exprDataType.type == 1 || sqlExpression.exprDataType.type == 12) && sqlExpression.exprDataType.length == -1) {
                    sqlExpression.exprDataType.length = 1024;
                }
                return sqlExpression.exprDataType;
            }
            for (SqlExpression sqlExpression2 : sqlExpression.functionParams) {
                sqlExpression2.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase));
            }
            ExpressionType expressionType = sqlExpression.getFunctionOutputValue(sysDatabase);
            sqlExpression.setExprDataType(expressionType);
            return expressionType;
        }
        if (sqlExpression.getExprType() == 8) {
            ExpressionType expressionType = SqlExpression.setExpressionResultType(sqlExpression.leftExpr, sysDatabase);
            sqlExpression.setExprDataType(expressionType);
            return sqlExpression.getExprDataType();
        }
        if (sqlExpression.getExprType() == 4) {
            if ((sqlExpression.getColumn().columnGenre & 8) == 8 && sqlExpression.getColumn().relationNode == null) {
                return null;
            }
            AttributeColumn attributeColumn = sqlExpression.getColumn();
            if (sqlExpression.mapped == 1) {
                sqlExpression.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression.mappedExpression, sysDatabase));
            } else {
                sqlExpression.setExprDataType(attributeColumn.getColumnType(sysDatabase));
            }
            return sqlExpression.getExprDataType();
        }
        if (sqlExpression.getExprType() == 16) {
            try {
                ExpressionType expressionType = SqlExpression.setExpressionResultType(sqlExpression.leftExpr, sysDatabase);
                ExpressionType expressionType2 = SqlExpression.setExpressionResultType(sqlExpression.rightExpr, sysDatabase);
                ExprTypeHelper exprTypeHelper = new ExprTypeHelper();
                exprTypeHelper.leftExprType = expressionType;
                exprTypeHelper.righExprType = expressionType2;
                exprTypeHelper.Operator = sqlExpression.operator;
                sqlExpression.setExprDataType(expressionType.GetExpressionType(exprTypeHelper));
            }
            catch (XDBServerException xDBServerException) {
                String string = ErrorMessageRepository.EXPRESSION_TYPE_UNDETERMINED;
                throw new XDBServerException(string + sqlExpression.rebuildString(), xDBServerException, ErrorMessageRepository.EXPRESSION_TYPE_UNDETERMINED_CODE);
            }
            return sqlExpression.getExprDataType();
        }
        if (sqlExpression.getExprType() == 256) {
            sqlExpression.setExprDataType(sqlExpression.getCaseConstruct().setDataType(sysDatabase));
            return sqlExpression.getExprDataType();
        }
        if (sqlExpression.getExprType() == 512) {
            SqlExpression sqlExpression3 = sqlExpression.expressionList.get(0);
            ExpressionType expressionType = SqlExpression.setExpressionResultType(sqlExpression3, sysDatabase);
            for (SqlExpression sqlExpression4 : sqlExpression.expressionList) {
                ExpressionType expressionType3 = SqlExpression.setExpressionResultType(sqlExpression4, sysDatabase);
                if (expressionType3.type == expressionType.type) continue;
                throw new XDBServerException("The Expression " + sqlExpression3.rebuildString() + " and " + sqlExpression4.rebuildString() + " are not of the same type");
            }
            return expressionType;
        }
        throw new XDBServerException(ErrorMessageRepository.INVALID_DATATYPE + "( " + sqlExpression.getExprType() + " , " + sqlExpression.exprString + " ) ", 0, ErrorMessageRepository.INVALID_DATATYPE_CODE);
    }

    int getConstantDataType() {
        if (this.getExprType() == 2) {
            if (this.constantValue == null) {
                return 0;
            }
            try {
                Double.parseDouble(this.constantValue);
                return 8;
            }
            catch (NumberFormatException numberFormatException) {
                return 12;
            }
        }
        return -1;
    }

    public boolean isNullConstant() {
        return this.exprType == 2 && this.constantValue == null;
    }

    ExpressionType getFunctionOutputValue(SysDatabase sysDatabase) throws ColumnNotFoundException {
        ExpressionType expressionType = new ExpressionType();
        switch (this.functionId) {
            case 107: {
                expressionType = FunctionAnalysis.analyzeTimeOfDayParameter(this);
                break;
            }
            case 108: {
                expressionType = FunctionAnalysis.analyzeIsFiniteParameter(this);
                break;
            }
            case 109: {
                expressionType = FunctionAnalysis.analyzeExtractParameter(this);
                break;
            }
            case 111: {
                expressionType = FunctionAnalysis.analyzeDatePartParameter(this);
                break;
            }
            case 112: {
                expressionType = FunctionAnalysis.analyzeAgeParameter(this);
                break;
            }
            case 110: {
                expressionType = FunctionAnalysis.analyzeDateTruncParameter(this);
                break;
            }
            case 11: 
            case 15: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 40: {
                if (this.functionParams.get(0).getExprType() == 2) {
                    this.functionParams.get(0).setConstantValue(SqlExpression.normalizeDate(this.functionParams.get(0).getConstantValue()));
                }
                expressionType = FunctionAnalysis.analyzeDayOfMonth_DayOfWeek_DayOfYear_Month_Year_WeekOfYear_Parameter(this, sysDatabase);
                break;
            }
            case 16: 
            case 18: 
            case 42: {
                if (this.functionParams.get(0).getExprType() == 2) {
                    this.functionParams.get(0).setConstantValue(SqlExpression.normalizeTime(this.functionParams.get(0).getConstantValue()));
                }
                expressionType = FunctionAnalysis.analyzeHour_Min_SecParameter(this, sysDatabase);
                break;
            }
            case 60: 
            case 63: {
                expressionType = FunctionAnalysis.analyzeLengthParameter(this);
                break;
            }
            case 27: 
            case 37: {
                expressionType = FunctionAnalysis.analyzeAddDate_SubDateParameter(this, sysDatabase);
                break;
            }
            case 28: 
            case 38: {
                expressionType = FunctionAnalysis.analyzeAddTime_SubTimeParameter(this, sysDatabase);
                break;
            }
            case 29: {
                if (this.functionParams.get(0).getExprType() == 2) {
                    this.functionParams.get(0).setConstantValue(SqlExpression.normalizeDate(this.functionParams.get(0).getConstantValue()));
                }
                expressionType = FunctionAnalysis.analyzeDateParameter(this, sysDatabase);
                break;
            }
            case 147: 
            case 153: {
                expressionType = FunctionAnalysis.analyzeToDateParameter(this, sysDatabase);
                break;
            }
            case 30: {
                for (int i = 0; i < 2; ++i) {
                    if (this.functionParams.get(i).getExprType() != 2) continue;
                    try {
                        this.functionParams.get(i).setConstantValue(SqlExpression.normalizeDate(this.functionParams.get(i).getConstantValue()));
                        continue;
                    }
                    catch (Exception exception) {
                        this.functionParams.get(i).setConstantValue(SqlExpression.normalizeTimeStamp(this.functionParams.get(i).getConstantValue()));
                    }
                }
                expressionType = FunctionAnalysis.analyzeDateDiff(this, sysDatabase);
                break;
            }
            case 32: 
            case 36: {
                expressionType = FunctionAnalysis.analyzeDayName_MonthName_Parameter(this, sysDatabase);
                break;
            }
            case 21: {
                if (this.functionParams.get(0).getExprType() == 2) {
                    this.functionParams.get(0).setConstantValue(SqlExpression.normalizeTimeStamp(this.functionParams.get(0).getConstantValue()));
                }
                expressionType = FunctionAnalysis.analyzeTimeStamp(this, sysDatabase);
                break;
            }
            case 39: {
                if (this.functionParams.get(0).getExprType() == 2) {
                    this.functionParams.get(0).setConstantValue(SqlExpression.normalizeTime(this.functionParams.get(0).getConstantValue()));
                }
                expressionType = FunctionAnalysis.analyzeTime(this, sysDatabase);
                break;
            }
            case 43: 
            case 45: 
            case 50: {
                expressionType = FunctionAnalysis.analyzeCeil_Floor_Sign(this, sysDatabase);
                break;
            }
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 87: 
            case 88: 
            case 90: 
            case 91: {
                expressionType = FunctionAnalysis.analyzeExp_LN_POWER_ASIN_ATAN_COS_COT_DEGREES_RADIANS_SIN_TAN_ACOS_LOG10_SQRT_COSH(this, sysDatabase);
                break;
            }
            case 23: {
                expressionType = FunctionAnalysis.analyzeTrunc(this, sysDatabase);
                break;
            }
            case 93: 
            case 96: {
                expressionType = FunctionAnalysis.analyzeLog_Float_ATAN2(this, sysDatabase);
                break;
            }
            case 59: {
                expressionType = FunctionAnalysis.analyzeRound(this, sysDatabase);
                break;
            }
            case 48: 
            case 140: 
            case 141: {
                expressionType = FunctionAnalysis.analyzePI(this);
                break;
            }
            case 64: 
            case 73: 
            case 98: 
            case 99: {
                expressionType = FunctionAnalysis.analyzeAscii_Upper_Lower_Soundex_InitCap(this, sysDatabase);
                break;
            }
            case 101: {
                expressionType = FunctionAnalysis.analyzeMapchar(this, sysDatabase);
                break;
            }
            case 100: {
                expressionType = FunctionAnalysis.analyzeLfill(this, sysDatabase);
                break;
            }
            case 104: {
                expressionType = FunctionAnalysis.analyzeConcat(this, sysDatabase);
                break;
            }
            case 66: 
            case 70: 
            case 72: {
                expressionType = FunctionAnalysis.analyzeLtrim_Rtirm_Trim(this, sysDatabase);
                break;
            }
            case 61: 
            case 74: {
                expressionType = FunctionAnalysis.analyzeIndex_InStr(this, sysDatabase);
                break;
            }
            case 62: 
            case 68: {
                expressionType = FunctionAnalysis.analyzeLeft_Right(this, sysDatabase);
                break;
            }
            case 65: 
            case 69: {
                expressionType = FunctionAnalysis.analyzeLpad_Rpad(this, sysDatabase);
                break;
            }
            case 67: {
                expressionType = FunctionAnalysis.analyzeReplace(this, sysDatabase);
                break;
            }
            case 71: {
                expressionType = FunctionAnalysis.analyzeSubString(this, sysDatabase);
                break;
            }
            case 75: {
                expressionType = FunctionAnalysis.analyzeAverageParameter(this, sysDatabase);
                break;
            }
            case 76: {
                expressionType = FunctionAnalysis.analyzeCountParameter(this);
                break;
            }
            case 80: 
            case 81: {
                expressionType = FunctionAnalysis.analyzeMax_MinParameter(this, sysDatabase);
                break;
            }
            case 0: {
                expressionType = FunctionAnalysis.analyzeAbsParameter(this, sysDatabase);
                break;
            }
            case 82: {
                expressionType = FunctionAnalysis.analyzeSumParameter(this, sysDatabase);
                break;
            }
            case 77: {
                expressionType.setExpressionType(4, 10, 10, 0);
                for (SqlExpression sqlExpression : this.functionParams) {
                    sqlExpression.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression, sysDatabase));
                }
                break;
            }
            case 84: 
            case 161: 
            case 192: {
                expressionType = FunctionAnalysis.analyzeDatabase_Version_User(this);
                break;
            }
            case 85: {
                expressionType = FunctionAnalysis.analyzeValue(this, sysDatabase);
                break;
            }
            case 94: 
            case 95: {
                expressionType = FunctionAnalysis.analyzeGreatest_Least(this, sysDatabase);
                break;
            }
            case 102: {
                expressionType = FunctionAnalysis.analyzeNUM(this);
                break;
            }
            case 132: {
                expressionType = FunctionAnalysis.analyzeStrPos(this, sysDatabase);
                break;
            }
            case 130: 
            case 133: 
            case 137: {
                expressionType = FunctionAnalysis.analyzeBtrim(this, sysDatabase);
                break;
            }
            case 131: {
                expressionType = FunctionAnalysis.analyzeToASCII(this, sysDatabase);
                break;
            }
            case 186: 
            case 187: {
                expressionType = FunctionAnalysis.analyzeNVL(this);
                break;
            }
            case 188: {
                expressionType = FunctionAnalysis.analyzeCoalesce(this, sysDatabase);
                break;
            }
            case 129: {
                expressionType = FunctionAnalysis.analyzeChr(this, sysDatabase);
                break;
            }
            case 120: {
                expressionType = FunctionAnalysis.analyzeConvert(this, sysDatabase);
                break;
            }
            case 136: {
                expressionType = FunctionAnalysis.analyzeDecode(this);
                break;
            }
            case 135: {
                expressionType = FunctionAnalysis.analyzeEncode(this);
                break;
            }
            case 127: 
            case 128: {
                expressionType = FunctionAnalysis.analyzeMd5(this, sysDatabase);
                break;
            }
            case 125: 
            case 126: {
                expressionType = FunctionAnalysis.analyzeQuote(this, sysDatabase);
                break;
            }
            case 134: {
                expressionType = FunctionAnalysis.analyzeRepeat(this, sysDatabase);
                break;
            }
            case 124: {
                expressionType = FunctionAnalysis.analyzeToHex(this, sysDatabase);
                break;
            }
            case 138: 
            case 139: {
                expressionType = FunctionAnalysis.analyzeSetSeed(this);
                break;
            }
            case 89: {
                expressionType = FunctionAnalysis.analyzeMod(this);
                break;
            }
            case 78: 
            case 79: 
            case 181: 
            case 182: 
            case 183: 
            case 184: {
                expressionType = FunctionAnalysis.analyzeVarianceOrStddev(this);
                break;
            }
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                expressionType = FunctionAnalysis.analyzeCoRegFunc(this, sysDatabase);
                break;
            }
            case 174: {
                expressionType = FunctionAnalysis.analyzeRegrCount(this, sysDatabase);
                break;
            }
            case 148: {
                expressionType = FunctionAnalysis.analyzeNullIf(this, sysDatabase);
                break;
            }
            case 149: 
            case 150: {
                expressionType = FunctionAnalysis.analyzeSetBitByte(this, sysDatabase);
                break;
            }
            case 142: 
            case 146: {
                expressionType = FunctionAnalysis.analyzeGetBitByte(this, sysDatabase);
                break;
            }
            case 151: {
                expressionType = FunctionAnalysis.analyzeToChar(this, sysDatabase);
                break;
            }
            case 152: {
                expressionType = FunctionAnalysis.analyzeToNumber(this, sysDatabase);
                break;
            }
            case 154: {
                expressionType = FunctionAnalysis.analyzeAddMonth(this, sysDatabase);
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                expressionType = FunctionAnalysis.analyzeJustify(this, sysDatabase);
                break;
            }
            case 159: {
                expressionType = FunctionAnalysis.analyzeMonthsBetween(this, sysDatabase);
                break;
            }
            case 160: {
                expressionType = FunctionAnalysis.analyzeNextDay(this, sysDatabase);
                break;
            }
            case 185: {
                expressionType = FunctionAnalysis.analyzeRegexpReplace(this, sysDatabase);
                break;
            }
            case 164: 
            case 165: {
                expressionType = FunctionAnalysis.analyzeBitAnd(this, sysDatabase);
                break;
            }
            case 166: 
            case 167: 
            case 168: {
                expressionType = FunctionAnalysis.analyzeBoolAnd(this, sysDatabase);
                break;
            }
            case 163: 
            case 189: 
            case 190: 
            case 191: {
                expressionType = FunctionAnalysis.analyzeCurrDateTime(this);
                break;
            }
            case 193: {
                expressionType = FunctionAnalysis.analyzeAbbrev(this);
                break;
            }
            case 194: {
                expressionType = FunctionAnalysis.analyzeBroadcast(this);
                break;
            }
            case 195: {
                expressionType = FunctionAnalysis.analyzeFamily(this);
                break;
            }
            case 196: {
                expressionType = FunctionAnalysis.analyzeHost(this);
                break;
            }
            case 197: {
                expressionType = FunctionAnalysis.analyzeHostmask(this);
                break;
            }
            case 198: {
                expressionType = FunctionAnalysis.analyzeMasklen(this);
                break;
            }
            case 199: {
                expressionType = FunctionAnalysis.analyzeNetmask(this);
                break;
            }
            case 200: {
                expressionType = FunctionAnalysis.analyzeNetwork(this);
                break;
            }
            case 201: {
                expressionType = FunctionAnalysis.analyzeSet_Masklen(this);
                break;
            }
            case 202: {
                expressionType = FunctionAnalysis.analyzeText(this);
                break;
            }
            default: {
                expressionType = FunctionAnalysis.analyzeCustom(this, sysDatabase);
            }
        }
        return expressionType;
    }

    public String rebuildString(XDBSessionContext xDBSessionContext) {
        this.rebuildExpression(xDBSessionContext);
        return this.exprString;
    }

    @Override
    public String rebuildString() {
        this.rebuildExpression();
        return this.exprString;
    }

    public boolean isConstantExpr() {
        if (this.getExprType() == 2) {
            return true;
        }
        if (this.getExprType() == 16) {
            if (this.leftExpr != null && !this.leftExpr.isConstantExpr()) {
                return false;
            }
            return this.rightExpr == null || this.rightExpr.isConstantExpr();
        }
        if (this.getExprType() == 32) {
            if (this.containsAggregates()) {
                return false;
            }
            for (int i = 0; i < this.functionParams.size(); ++i) {
                SqlExpression sqlExpression = this.functionParams.get(i);
                if (sqlExpression.isConstantExpr()) continue;
                return false;
            }
            return true;
        }
        if (this.getExprType() == 8) {
            return this.leftExpr.isConstantExpr();
        }
        return false;
    }

    public RelationNode getParentContainerNode() {
        return this.parentContainerNode;
    }

    public void setParentContainerNode(RelationNode relationNode) {
        this.parentContainerNode = relationNode;
    }

    public boolean contains(SqlExpression sqlExpression) {
        boolean bl = false;
        if (sqlExpression == this) {
            return true;
        }
        if (this.leftExpr != null) {
            bl = this.leftExpr.contains(sqlExpression);
        }
        if (!bl && this.rightExpr != null) {
            return this.rightExpr.contains(sqlExpression);
        }
        return bl;
    }

    public boolean containsColumnsExclusiveFromTable(String string) {
        boolean bl = false;
        if (this.getExprType() == 4) {
            return this.getColumn().relationNode.getCurrentTempTableName().equalsIgnoreCase(string);
        }
        return bl;
    }

    public boolean containsColumn(AttributeColumn attributeColumn) {
        boolean bl = false;
        if (this.getExprType() == 4) {
            return this.getColumn() == attributeColumn;
        }
        if ((this.getExprType() & 0x20) > 0) {
            for (SqlExpression sqlExpression : this.functionParams) {
                if (!sqlExpression.containsColumn(attributeColumn)) continue;
                return true;
            }
        } else if ((this.getExprType() & 0x100) > 0) {
            for (SqlExpression sqlExpression : this.caseConstruct.getSQLExpressions()) {
                if (!sqlExpression.containsColumn(attributeColumn)) continue;
                return true;
            }
        } else if ((this.getExprType() & 0x40) > 0 && (this.subqueryTree.getQueryType() & 6) == 0) {
            for (SqlExpression sqlExpression : this.parentContainerNode.getProjectionList()) {
                if (!sqlExpression.containsColumn(attributeColumn)) continue;
                return true;
            }
        }
        if (this.leftExpr != null && (bl = this.leftExpr.containsColumn(attributeColumn))) {
            return true;
        }
        if (this.rightExpr != null) {
            return this.rightExpr.containsColumn(attributeColumn);
        }
        return bl;
    }

    public boolean contains(RelationNode relationNode) {
        boolean bl = false;
        if (this.getExprType() == 4) {
            return this.getColumn().relationNode == relationNode;
        }
        if ((this.getExprType() & 0x20) > 0) {
            for (SqlExpression sqlExpression : this.functionParams) {
                if (!sqlExpression.contains(relationNode)) continue;
                return true;
            }
        } else if ((this.getExprType() & 0x100) > 0) {
            for (SqlExpression sqlExpression : this.caseConstruct.getSQLExpressions()) {
                if (!sqlExpression.contains(relationNode)) continue;
                return true;
            }
        } else if ((this.getExprType() & 0x40) > 0 && (this.subqueryTree.getQueryType() & 6) == 0) {
            for (SqlExpression sqlExpression : this.parentContainerNode.getProjectionList()) {
                if (!sqlExpression.contains(relationNode)) continue;
                return true;
            }
        }
        if (this.leftExpr != null && (bl = this.leftExpr.contains(relationNode))) {
            return true;
        }
        if (this.rightExpr != null) {
            return this.rightExpr.contains(relationNode);
        }
        return bl;
    }

    private static String normalizeNumber(String string, int n) {
        int n2;
        int n3 = Math.max(string.indexOf("E"), string.indexOf("e"));
        if (n3 > 0) {
            return SqlExpression.normalizeNumber(string.substring(0, n3), n) + "E" + SqlExpression.normalizeNumber(string.substring(n3 + 1), 0);
        }
        boolean bl = string.charAt(0) == '-';
        n3 = string.indexOf(".");
        int n4 = string.length() - 1;
        if (n3 > -1) {
            while (string.charAt(n4) == '0') {
                --n4;
            }
            if (n4 == n3) {
                --n4;
            }
        } else {
            n3 = n4 + 1;
        }
        for (n2 = 0; n2 < n3 && (string.charAt(n2) == '-' || string.charAt(n2) == '+' || string.charAt(n2) == '0'); ++n2) {
        }
        if (n4 - n3 > n) {
            n4 = n3 + n;
        }
        return (bl ? "-" : "") + (n2 == n3 ? "0" : string.substring(n2, n3)) + (n4 > n3 ? string.substring(n3, n4 + 1) : "");
    }

    public static String normalizeDate(String string) {
        String string2;
        String string3 = "";
        if (string.toLowerCase().startsWith("date")) {
            string = string.substring(4, string.length()).trim();
            string3 = "date";
        }
        while (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        if (string.matches("[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]")) {
            string2 = string.substring(0, 4) + "-" + string.substring(4, 6) + "-" + string.substring(6, 8);
        } else if (string.matches("[0-9][0-9][0-9][0-9]\\-[0-9][0-9]\\-[0-9][0-9]")) {
            string2 = string;
        } else if (string.matches("[0-9][0-9][0-9][0-9]\\-[0-9]\\-[0-9]")) {
            string2 = string.substring(0, 5) + "0" + string.substring(5, 7) + "0" + string.substring(7, 8);
        } else if (string.matches("[0-9]{1,4}\\-[a-zA-Z]*[[0-9]{1,2}]?\\-[0-9]{1,2} [0-9]{1,2}:[0-9]{1,2}[:[0-9]{0,2}]?[\\.[0-9]*]?")) {
            string2 = string;
        } else if (string.matches("[0-9]{1,2}\\-[a-zA-Z]*[0-9]{0,2}\\-[0-9]{2,4}[ [0-9]{1,2}:[0-9]{1,2}:[0-9]{0,2}[\\.[0-9]*]?]?")) {
            string2 = string;
        } else if (string.matches("[0-9]{1,2}/[0-9]{0,2}/[0-9]{2,4}[ [0-9]{1,2}:[0-9]{1,2}:[0-9]{0,2}[\\.[0-9]*]?]?")) {
            string2 = string;
        } else if (string.matches("[0-9][0-9][0-9][0-9]\\-[0-9]\\-[0-9][0-9]")) {
            string2 = string.substring(0, 5) + "0" + string.substring(5, 9);
        } else if (string.matches("[0-9][0-9][0-9][0-9]\\-[0-9][0-9]\\-[0-9]")) {
            string2 = string.substring(0, 8) + "0" + string.substring(8, 9);
        } else {
            throw new XDBServerException("Invalid date/time format " + string);
        }
        string2 = "'" + string2 + "'";
        if (string3.length() != 0) {
            string2 = string3 + string2;
        }
        return string2;
    }

    public static String normalizeTime(String string) {
        String string2;
        String string3 = "";
        if (string.toLowerCase().startsWith("time")) {
            string = string.substring(4, string.length()).trim();
            string3 = "time";
        }
        while (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        if (string.matches("[0-9][0-9][0-9][0-9][0-9][0-9]")) {
            string2 = string.substring(0, 2) + ":" + string.substring(2, 4) + ":" + string.substring(4, 6);
        } else if (string.matches("[0-9]{1,2}\\:[0-9]{1,2}\\:[0-9]{1,2}[.\\d+]*")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                if (stringArray[n].length() == 1) {
                    stringArray[n] = "0" + stringArray[n];
                }
                ++n;
            }
            string2 = stringArray[0] + ":" + stringArray[1] + ":" + stringArray[2];
        } else if (string.matches("[0-9]{1,2}\\:[0-9]{1,2}")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n] = stringTokenizer.nextToken();
                if (stringArray[n].length() == 1) {
                    stringArray[n] = "0" + stringArray[n];
                }
                ++n;
            }
            string2 = stringArray[0] + ":" + stringArray[1] + ":00";
        } else if (string.matches("[0-9]{1,2}")) {
            string2 = string.length() == 1 ? "00:00:0" + string : "00:00:" + string;
        } else {
            throw new XDBServerException("Invalid date/time format " + string);
        }
        string2 = "'" + string2 + "'";
        if (string3.length() != 0) {
            string2 = string3 + string2;
        }
        return string2;
    }

    public static String normalizeTimeStamp(String string) {
        int n;
        String string2 = null;
        String string3 = null;
        String string4 = "";
        String string5 = "";
        if (string.toLowerCase().startsWith("timestamp")) {
            string = string.substring(9, string.length()).trim();
            string5 = "timestamp";
        }
        while (string.charAt(0) == '\'' && string.charAt(string.length() - 1) == '\'') {
            string = string.substring(1, string.length() - 1);
        }
        if (Props.XDB_SUBSECOND_PRECISION > 0) {
            string4 = subsecondBaseString.substring(0, Props.XDB_SUBSECOND_PRECISION);
        }
        string2 = SqlExpression.normalizeDate((n = string.indexOf(" ")) < 0 ? string : string.substring(0, n));
        string2 = string2.replaceAll("'", "");
        if (n < 0) {
            string3 = Props.XDB_SUBSECOND_PRECISION > 0 ? "00:00:00." + string4 : "00:00:00";
        } else {
            int n2;
            String string6;
            String string7 = string.substring(n + 1).trim();
            String string8 = "";
            int n3 = string7.indexOf(45);
            if (n3 < 0) {
                n3 = string7.indexOf(43);
            }
            if (n3 >= 0) {
                string6 = string7.substring(0, n3).trim();
                string8 = string7.substring(n3).trim();
            } else {
                char c;
                for (n2 = string7.length() - 1; n2 >= 0 && ((c = string7.charAt(n2)) >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z'); --n2) {
                }
                string6 = string7.substring(0, n2 + 1);
                string8 = string7.substring(string6.length()).trim();
                string6 = string6.trim();
            }
            n2 = string6.indexOf(".");
            String string9 = n2 < 0 ? string4 : string6.substring(n2 + 1);
            if (string9.length() > Props.XDB_SUBSECOND_PRECISION) {
                throw new XDBServerException("Invalid timestamp format, beyond max subsecond precision " + string);
            }
            if (string9.length() < Props.XDB_SUBSECOND_PRECISION) {
                string9 = string9 + string4.substring(0, Props.XDB_SUBSECOND_PRECISION - string9.length());
            }
            string3 = SqlExpression.normalizeTime(n2 < 0 ? string6.trim() : string6.substring(0, n2).trim());
            string3 = string3.replaceAll("'", "");
            if (Props.XDB_SUBSECOND_PRECISION > 0) {
                string3 = string3 + '.' + string9;
            }
            if (string8.length() > 0) {
                string3 = string3 + " " + string8;
            }
        }
        String string10 = "'" + string2 + " " + string3 + "'";
        if (string5.length() != 0) {
            string10 = string5 + string10;
        }
        return string10;
    }

    public static String normalizeMacaddr(String string) {
        String string2 = "";
        if (string.toLowerCase().startsWith("macaddr")) {
            string = string.substring(7, string.length()).trim();
        }
        string2 = string;
        string2 = string2.replaceAll("-", "");
        string2 = string2.replaceAll(":", "");
        string2 = string2.replaceAll("\\.", "");
        String string3 = "'" + string2 + "'";
        return string3;
    }

    private static String normalizeIPv4(String string) throws NumberFormatException {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = string.indexOf(".");
        if (n5 > 0) {
            n = Integer.parseInt(string.substring(0, n5));
            if ((n5 = (string = string.substring(n5 + 1)).indexOf(".")) > 0) {
                n2 = Integer.parseInt(string.substring(0, n5));
                if ((n5 = (string = string.substring(n5 + 1)).indexOf(".")) > 0) {
                    n3 = Integer.parseInt(string.substring(0, n5));
                    string = string.substring(n5 + 1);
                    n4 = Integer.parseInt(string);
                } else {
                    n3 = Integer.parseInt(string);
                }
            } else {
                n2 = Integer.parseInt(string);
            }
        } else {
            n = Integer.parseInt(string);
        }
        return n + "." + n2 + "." + n3 + "." + n4;
    }

    private static String normalizeIPv6(String string) throws NumberFormatException {
        int n;
        int[] nArray = new int[8];
        int n2 = 0;
        int n3 = -1;
        int n4 = string.indexOf(":");
        while (n4 >= 0) {
            if (n4 == 0) {
                if (n3 != -1) {
                    throw new NumberFormatException("Malformed IPv6 address");
                }
                n3 = n2;
                if (n2 == 0 && string.length() > 1 && string.charAt(1) == ':') {
                    ++n4;
                }
            } else {
                nArray[n2++] = Integer.parseInt(string.substring(0, n4), 16);
            }
            string = string.substring(n4 + 1);
            n4 = string.indexOf(":");
        }
        int n5 = 8;
        String string2 = null;
        n4 = string.indexOf(".");
        if (n4 > 0) {
            string2 = SqlExpression.normalizeIPv4(string);
            n5 = 6;
        } else if (string.length() > 0) {
            nArray[n2++] = Integer.parseInt(string, 16);
        }
        if (n3 != -1) {
            n = n5 - 1;
            --n2;
            while (n2 >= n3) {
                nArray[n] = nArray[n2];
                --n2;
                --n;
            }
            while (n >= n3) {
                nArray[n] = 0;
                --n;
            }
        }
        n = -1;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        for (int i = 0; i < n5; ++i) {
            if (nArray[i] == 0) {
                if (n7 == -1) {
                    n7 = i;
                }
                ++n8;
                continue;
            }
            if (n8 > 1 && n8 > n6) {
                n6 = n8;
                n = n7;
            }
            n7 = -1;
            n8 = 0;
        }
        if (n8 > 1 && n8 > n6) {
            n6 = n8;
            n = n7;
        }
        String string3 = "";
        for (int i = 0; i < n5; ++i) {
            if (i == n) {
                string3 = string3.length() == 0 ? "::" : string3 + ":";
                i += n6 - 1;
                continue;
            }
            string3 = string3 + Integer.toHexString(nArray[i]) + ":";
        }
        if (string2 == null) {
            if (string3.endsWith("::")) {
                return string3;
            }
            return string3.substring(0, string3.length() - 1);
        }
        return string3 + string2;
    }

    public static String normalizeInet(String string) {
        String string2 = string.trim();
        if (string2.startsWith("inet")) {
            string2 = string2.substring(4).trim();
        }
        if (string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        int n = 0;
        try {
            int n2 = string2.indexOf("/");
            if (n2 > 0) {
                n = Integer.parseInt(string2.substring(n2 + 1));
                string2 = string2.substring(0, n2);
            }
            if (string2.indexOf(":") >= 0) {
                String string3 = SqlExpression.normalizeIPv6(string2);
                if (n == 0 || n == 128) {
                    return "'" + string3 + "'";
                }
                return "'" + string3 + "/" + n + "'";
            }
            String string4 = SqlExpression.normalizeIPv4(string2);
            if (n == 0 || n == 32) {
                return "'" + string4 + "'";
            }
            return "'" + string4 + "/" + n + "'";
        }
        catch (NumberFormatException numberFormatException) {
            throw new XDBServerException("Invalid inet format: " + string);
        }
    }

    public static String normalizeCidr(String string) {
        String string2 = string.trim();
        if (string2.startsWith("cidr")) {
            string2 = string2.substring(4).trim();
        }
        if (string2.charAt(0) == '\'' && string2.charAt(string2.length() - 1) == '\'') {
            string2 = string2.substring(1, string2.length() - 1);
        }
        int n = 0;
        try {
            int n2 = string2.indexOf("/");
            if (n2 > 0) {
                n = Integer.parseInt(string2.substring(n2 + 1));
                string2 = string2.substring(0, n2);
            }
            if (string2.indexOf(":") >= 0) {
                String string3 = SqlExpression.normalizeIPv6(string2);
                if (n == 0) {
                    return "'" + string3 + "/128" + "'";
                }
                return "'" + string3 + "/" + n + "'";
            }
            String string4 = SqlExpression.normalizeIPv4(string2);
            if (n == 0) {
                return "'" + string4 + "/32" + "'";
            }
            return "'" + string4 + "/" + n + "'";
        }
        catch (NumberFormatException numberFormatException) {
            throw new XDBServerException("Invalid cidr format: " + string);
        }
    }

    public static boolean checkCompatibilityForUnion(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
        if (sqlExpression.getExprDataType() == null || sqlExpression2.getExprDataType() == null) {
            return true;
        }
        int n = sqlExpression.getExprDataType().type;
        int n2 = sqlExpression2.getExprDataType().type;
        switch (n) {
            case 1: 
            case 12: {
                switch (n2) {
                    case 1: 
                    case 12: {
                        return true;
                    }
                }
                return false;
            }
            case 122: {
                switch (n2) {
                    case 122: {
                        return true;
                    }
                }
                return false;
            }
            case 92: {
                switch (n2) {
                    case 92: {
                        return true;
                    }
                }
                return false;
            }
            case 93: {
                switch (n2) {
                    case 93: {
                        return true;
                    }
                }
                return false;
            }
            case 91: {
                switch (n2) {
                    case 91: {
                        return true;
                    }
                }
                return false;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                switch (n2) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            case 16: {
                switch (n2) {
                    case 16: {
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceColumnInExpression(List<AttributeColumn> list) {
        for (SqlExpression sqlExpression : SqlExpression.getNodes(this, 4)) {
            AttributeColumn attributeColumn = sqlExpression.getColumn();
            if (list.contains(attributeColumn)) {
                return;
            }
            for (AttributeColumn attributeColumn2 : list) {
                if (!attributeColumn.isEquivalent(attributeColumn2) || attributeColumn.relationNode != attributeColumn2.relationNode) continue;
                sqlExpression.setColumn(attributeColumn2);
            }
        }
    }

    public boolean hasSubQuery() {
        switch (this.getExprType()) {
            case 64: {
                return true;
            }
            case 32: {
                for (SqlExpression sqlExpression : this.functionParams) {
                    if (!sqlExpression.hasSubQuery()) continue;
                    return true;
                }
                return false;
            }
            case 256: {
                if (this.getCaseConstruct().getDefaultexpr().hasSubQuery()) {
                    return true;
                }
                for (Map.Entry entry : this.getCaseConstruct().aHashtable.entrySet()) {
                    if (((QueryCondition)entry.getKey()).isSimple() && !((SqlExpression)entry.getValue()).hasSubQuery()) continue;
                    return true;
                }
                return false;
            }
            case 128: {
                return this.getQueryCondition().isSimple();
            }
        }
        return false;
    }

    public String getNormalizedValue() {
        if (this.exprType == 2 && this.constantValue != null) {
            String string = this.constantValue.trim();
            while (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
                string = string.substring(1, string.length() - 1);
            }
            if ("-".equals(this.unaryOperator)) {
                string = this.unaryOperator + string;
            }
            BigDecimal bigDecimal = null;
            switch (this.exprDataType.type) {
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    bigDecimal = new BigDecimal(string);
                    return SqlExpression.normalizeNumber(((Object)bigDecimal).toString(), this.exprDataType.scale);
                }
                case 91: {
                    return SqlExpression.normalizeDate(this.constantValue);
                }
                case 92: {
                    return SqlExpression.normalizeTime(this.constantValue);
                }
                case 93: {
                    return SqlExpression.normalizeTimeStamp(this.constantValue);
                }
                case 1: 
                case 12: {
                    if (this.getExprDataType().length > 0 && string.length() > this.getExprDataType().length) {
                        string = string.substring(0, this.getExprDataType().length);
                    }
                    return string;
                }
                case 119: {
                    return SqlExpression.normalizeMacaddr(this.constantValue);
                }
                case 121: {
                    return SqlExpression.normalizeInet(this.constantValue);
                }
                case 120: {
                    return SqlExpression.normalizeCidr(this.constantValue);
                }
            }
        }
        return this.constantValue;
    }

    public static SqlExpression createNewTempFunction(String string, int n) {
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.setExprType(32);
        sqlExpression.functionName = string;
        sqlExpression.functionId = n;
        sqlExpression.setTempExpr(true);
        return sqlExpression;
    }

    public static SqlExpression createNewTempOpExpression(String string, SqlExpression sqlExpression, SqlExpression sqlExpression2) {
        SqlExpression sqlExpression3 = new SqlExpression();
        sqlExpression3.setExprType(16);
        sqlExpression3.operator = string;
        sqlExpression3.leftExpr = sqlExpression;
        sqlExpression3.rightExpr = sqlExpression2;
        sqlExpression3.setTempExpr(true);
        return sqlExpression3;
    }

    public static SqlExpression createConstantExpression(String string, ExpressionType expressionType) {
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.setExprType(2);
        sqlExpression.setExprDataType(expressionType);
        sqlExpression.setConstantValue(string);
        return sqlExpression;
    }

    public Collection<SqlExpression> getDeferredExpressions() {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        if (this.isDeferredGroup()) {
            arrayList.add(this);
        } else if ((this.getExprType() & 0x20) > 0) {
            for (SqlExpression sqlExpression : this.functionParams) {
                arrayList.addAll(sqlExpression.getDeferredExpressions());
            }
        } else if ((this.getExprType() & 0x100) > 0) {
            for (SqlExpression sqlExpression : this.caseConstruct.getSQLExpressions()) {
                arrayList.addAll(sqlExpression.getDeferredExpressions());
            }
        } else if ((this.getExprType() & 0x40) > 0 && (this.subqueryTree.getQueryType() & 6) == 0) {
            for (SqlExpression sqlExpression : this.parentContainerNode.getProjectionList()) {
                arrayList.addAll(sqlExpression.getDeferredExpressions());
            }
        }
        if (this.leftExpr != null) {
            arrayList.addAll(this.leftExpr.getDeferredExpressions());
        }
        if (this.rightExpr != null) {
            arrayList.addAll(this.rightExpr.getDeferredExpressions());
        }
        return arrayList;
    }

    public void setAggAlias(String string) {
        this.aggAlias = string;
    }

    public String getAggAlias() {
        return this.aggAlias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setQueryCondition(QueryCondition queryCondition) {
        this.aQueryCondition = queryCondition;
    }

    public QueryCondition getQueryCondition() {
        return this.aQueryCondition;
    }

    public void setArgSeparator(String string) {
        this.argSeparator = string;
    }

    public String getArgSeparator() {
        return this.argSeparator;
    }

    public SCase getCaseConstruct() {
        return this.caseConstruct;
    }

    public void setCaseConstruct(SCase sCase) {
        this.caseConstruct = sCase;
    }

    public void setColumn(AttributeColumn attributeColumn) {
        this.column = attributeColumn;
    }

    public AttributeColumn getColumn() {
        return this.column;
    }

    public void setConstantValue(String string) {
        this.constantValue = string;
    }

    public String getConstantValue() {
        return this.constantValue;
    }

    public void setExprDataType(ExpressionType expressionType) {
        this.exprDataType = expressionType;
    }

    public ExpressionType getExprDataType() {
        return this.exprDataType;
    }

    public void setExpressionList(List<SqlExpression> list) {
        this.expressionList = list;
    }

    public List<SqlExpression> getExpressionList() {
        return this.expressionList;
    }

    public void setExprString(String string) {
        this.exprString = string;
    }

    public String getExprString() {
        return this.exprString;
    }

    public void setExprType(int n) {
        this.exprType = n;
    }

    public int getExprType() {
        return this.exprType;
    }

    public void setExpTypeOfCast(DataTypeHandler dataTypeHandler) {
        this.expTypeOfCast = dataTypeHandler;
    }

    public void setFunctionId(int n) {
        this.functionId = n;
    }

    public int getFunctionId() {
        return this.functionId;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionParams(List<SqlExpression> list) {
        this.functionParams = list;
    }

    public List<SqlExpression> getFunctionParams() {
        return this.functionParams;
    }

    public void setAdded(boolean bl) {
        this.isAdded = bl;
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public void setAllCountGroupFunction(boolean bl) {
        this.isAllCountGroupFunction = bl;
    }

    public boolean isAllCountGroupFunction() {
        return this.isAllCountGroupFunction;
    }

    public void setDeferredGroup(boolean bl) {
        this.isDeferredGroup = bl;
    }

    public boolean isDeferredGroup() {
        return this.isDeferredGroup;
    }

    public void setDistinctExtraGroup(boolean bl) {
        this.isDistinctExtraGroup = bl;
    }

    public boolean isDistinctExtraGroup() {
        return this.isDistinctExtraGroup;
    }

    public void setDistinctGroupFunction(boolean bl) {
        this.isDistinctGroupFunction = bl;
    }

    public boolean isDistinctGroupFunction() {
        return this.isDistinctGroupFunction;
    }

    public boolean isDistinctGroupFunctionOnPartitionedCol(SysDatabase sysDatabase) {
        AttributeColumn attributeColumn;
        if (this.isDistinctGroupFunction && (attributeColumn = this.getFunctionParams().get(0).getColumn()) != null) {
            return attributeColumn.getSysTable(sysDatabase).isPartitionedColumn(attributeColumn.columnName);
        }
        return false;
    }

    public void setLeftExpr(SqlExpression sqlExpression) {
        this.leftExpr = sqlExpression;
    }

    public SqlExpression getLeftExpr() {
        return this.leftExpr;
    }

    public void setMapped(int n) {
        this.mapped = n;
    }

    public int getMapped() {
        return this.mapped;
    }

    public void setMappedExpression(SqlExpression sqlExpression) {
        this.mappedExpression = sqlExpression;
    }

    public SqlExpression getMappedExpression() {
        return this.mappedExpression;
    }

    public void setNeedParenthesisInFunction(boolean bl) {
        this.needParenthesisInFunction = bl;
    }

    public boolean needParenthesisInFunction() {
        return this.needParenthesisInFunction;
    }

    public void setOperandSign(String string) {
        this.operandSign = string;
    }

    public String getOperandSign() {
        return this.operandSign;
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public String getOperator() {
        return this.operator;
    }

    public String setOuterAlias(String string) {
        this.outerAlias = string;
        return this.outerAlias;
    }

    public String getOuterAlias() {
        return this.outerAlias;
    }

    public void setParamNumber(int n) {
        this.paramNumber = n;
        this.exprString = "&xp" + n + "xp&";
    }

    public int getParamNumber() {
        return this.paramNumber;
    }

    public void setParamValue(String string) {
        this.paramValue = string;
        this.exprString = string == null ? "null" : (this.exprDataType != null && (this.exprDataType.type == 12 || this.exprDataType.type == 1 || this.exprDataType.type == 93 || this.exprDataType.type == 91 || this.exprDataType.type == 92 || this.exprDataType.type == 1111) ? "'" + ParseCmdLine.escape(string) + "'" : string);
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setProjectionLabel(String string) {
        this.projectionLabel = string;
    }

    public String getProjectionLabel() {
        return this.projectionLabel;
    }

    public void setRightExpr(SqlExpression sqlExpression) {
        this.rightExpr = sqlExpression;
    }

    public SqlExpression getRightExpr() {
        return this.rightExpr;
    }

    public void setSubqueryTree(QueryTree queryTree) {
        this.subqueryTree = queryTree;
    }

    public QueryTree getSubqueryTree() {
        return this.subqueryTree;
    }

    public void setUnaryOperator(String string) {
        this.unaryOperator = string;
    }

    public String getUnaryOperator() {
        return this.unaryOperator;
    }

    public boolean hasColumnInExpression(AttributeColumn attributeColumn) {
        switch (this.exprType) {
            case 32: {
                if (this.functionParams == null) break;
                int n = this.functionParams.size();
                for (int i = 0; i < n; ++i) {
                    SqlExpression sqlExpression = this.functionParams.get(i);
                    if (!sqlExpression.hasColumnInExpression(attributeColumn)) continue;
                    return true;
                }
                break;
            }
            case 4: {
                if (this.column.columnName != attributeColumn.columnName || !attributeColumn.getTableAlias().equals("") && this.column.getTableName() != attributeColumn.getTableName()) break;
                return true;
            }
        }
        return false;
    }

    public boolean isAlliasSameAsColumnNameInFunction(AttributeColumn attributeColumn) {
        if (this.exprType == 32 && this.functionParams != null) {
            int n = this.functionParams.size();
            for (int i = 0; i < n; ++i) {
                SqlExpression sqlExpression = this.functionParams.get(i);
                if (!sqlExpression.hasColumnInExpression(attributeColumn)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSameFunction(SqlExpression sqlExpression) {
        return this.exprType == 32 && sqlExpression.exprType == 32 && this.functionId == sqlExpression.functionId && this.outerAlias.equalsIgnoreCase(sqlExpression.outerAlias) && this.exprString.equalsIgnoreCase(sqlExpression.exprString);
    }

    public boolean isColumn() {
        return this.exprType == 4;
    }

    public void moveDown(RelationNode relationNode) {
        for (SqlExpression sqlExpression : SqlExpression.getNodes(this, 4)) {
            if (sqlExpression.mappedExpression == null || sqlExpression.column == null || !relationNode.equals(sqlExpression.column.relationNode)) continue;
            SqlExpression.copy(sqlExpression.mappedExpression, sqlExpression);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SCase
    implements IRebuildString {
        private SqlExpression defaultexpr = null;
        private Hashtable<QueryCondition, SqlExpression> aHashtable = new Hashtable();

        public ExpressionType setDataType(SysDatabase sysDatabase) throws ColumnNotFoundException {
            boolean bl = true;
            boolean bl2 = true;
            ExpressionType expressionType = null;
            ExpressionType expressionType2 = null;
            String string = "";
            String string2 = "";
            for (QueryCondition object : this.aHashtable.keySet()) {
                for (QueryCondition queryCondition : QueryCondition.getNodes(object, 4)) {
                    SqlExpression sqlExpression = queryCondition.getExpr();
                    SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
                }
                SqlExpression sqlExpression = this.aHashtable.get(object);
                expressionType2 = SqlExpression.setExpressionResultType(sqlExpression, sysDatabase);
                if (expressionType == null) {
                    if (expressionType2.type == 0) continue;
                    expressionType = expressionType2;
                    bl = expressionType2.isNumeric();
                    string = sqlExpression.rebuildString();
                    continue;
                }
                bl2 = bl;
                string2 = string;
                bl = expressionType2.isNumeric();
                string = sqlExpression.rebuildString();
                if (bl2 == bl) continue;
                String string3 = ErrorMessageRepository.CASE_STATEMENT_TYPE_MISMATCH + "(" + string2 + " <--> " + string + ")";
                throw new XDBServerException(string3, 0, ErrorMessageRepository.CASE_STATEMENT_TYPE_MISMATCH_CODE);
            }
            if (this.defaultexpr != null) {
                expressionType2 = SqlExpression.setExpressionResultType(this.defaultexpr, sysDatabase);
                if (expressionType != null && expressionType2.type != 0) {
                    boolean bl3 = expressionType2.isNumeric();
                    if (bl3 == bl) {
                        return expressionType2;
                    }
                    String string4 = ErrorMessageRepository.CASE_STATEMENT_TYPE_MISMATCH + "(" + string + " <--> " + this.defaultexpr.rebuildString() + ")";
                    throw new XDBServerException(string4, 0, ErrorMessageRepository.CASE_STATEMENT_TYPE_MISMATCH_CODE);
                }
            }
            return expressionType == null ? expressionType2 : expressionType;
        }

        public Collection<SqlExpression> getSQLExpressions() {
            LinkedList<SqlExpression> linkedList = new LinkedList<SqlExpression>();
            if (this.aHashtable != null) {
                for (QueryCondition queryCondition : this.aHashtable.keySet()) {
                    for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                        linkedList.add(queryCondition2.getExpr());
                    }
                }
                linkedList.addAll(this.aHashtable.values());
            }
            if (this.defaultexpr != null) {
                linkedList.add(this.defaultexpr);
            }
            return linkedList;
        }

        public Map<QueryCondition, SqlExpression> getCases() {
            return this.aHashtable;
        }

        public void addCase(QueryCondition queryCondition, SqlExpression sqlExpression) {
            this.aHashtable.put(queryCondition, sqlExpression);
        }

        public SqlExpression getCaseSqlExpr(QueryCondition queryCondition) {
            return this.aHashtable.get(queryCondition);
        }

        @Override
        public String rebuildString() {
            if (this.aHashtable == null) {
                return "";
            }
            String string = "";
            string = "( CASE ";
            for (QueryCondition queryCondition : this.aHashtable.keySet()) {
                queryCondition.rebuildCondString();
                SqlExpression sqlExpression = this.getCaseSqlExpr(queryCondition);
                sqlExpression.rebuildExpression();
                string = string + "  WHEN ( " + queryCondition.getCondString() + " )  THEN ( " + sqlExpression.getExprString() + " )  ";
            }
            if (this.defaultexpr != null) {
                this.defaultexpr.rebuildExpression();
                string = string + " else " + this.defaultexpr.getExprString();
            }
            string = string + " end)";
            return string;
        }

        public void setDefaultexpr(SqlExpression sqlExpression) {
            this.defaultexpr = sqlExpression;
        }

        public SqlExpression getDefaultexpr() {
            return this.defaultexpr;
        }
    }
}

