/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableAddColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.SqlCreateTableColumn;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.ArrayList;
import java.util.HashMap;

public class SqlAlterAddColumn
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterAddColumn.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private SqlCreateTableColumn aSqlCreateTableColumn;
    boolean positionFirst = false;
    private String afterColumnName = null;
    private String[] commands;

    public SqlAlterAddColumn(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public Object visit(NodeSequence nodeSequence, Object object) {
        Object var3_3 = null;
        Node node = nodeSequence.elementAt(1);
        this.aSqlCreateTableColumn = new SqlCreateTableColumn(this.parent.getCommandToExecute());
        node.accept(this.aSqlCreateTableColumn, null);
        NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(2);
        if (nodeOptional.present()) {
            NodeChoice nodeChoice = (NodeChoice)nodeOptional.node;
            switch (nodeChoice.which) {
                case 0: {
                    this.positionFirst = true;
                    break;
                }
                case 1: {
                    NodeSequence nodeSequence2 = (NodeSequence)nodeChoice.choice;
                    this.afterColumnName = (String)nodeSequence2.elementAt(1).accept(new IdentifierHandler(), object);
                }
            }
        }
        return var3_3;
    }

    public SqlCreateTableColumn getColDef() {
        return this.aSqlCreateTableColumn;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            SysTable sysTable = this.parent.getTable();
            sysTable.ensurePermission(this.client.getCurrentUser(), (short)6);
            if (sysTable.getSysColumn(this.aSqlCreateTableColumn.columnName) != null) {
                throw new XDBServerException("The Table Already Has A Column Named " + this.aSqlCreateTableColumn.columnName);
            }
            if (this.aSqlCreateTableColumn.isSerial() && sysTable.getSerialColumn() != null) {
                throw new XDBServerException("The Table Already Has A Serial Column");
            }
            String string = Props.XDB_SQLCOMMAND_ALTERTABLE_ADDCOLUMN;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("table", IdentifierHandler.quote(sysTable.getTableName()));
            hashMap.put("colname", this.aSqlCreateTableColumn.rebuildString());
            string = ParseCmdLine.substitute(string, hashMap);
            if (Props.XDB_SQLCOMMAND_ALTERTABLE_ADDCOLUMN_TO_PARENT) {
                this.parent.addCommonCommand(string);
            } else {
                arrayList.add(string);
            }
            if (this.afterColumnName != null && sysTable.getSysColumn(this.afterColumnName) == null) {
                throw new XDBServerException("The Table Does Not Have A Column Named " + this.afterColumnName);
            }
            if (this.aSqlCreateTableColumn.isSerial()) {
                String string2 = "create index " + SqlCreateTableColumn.IDX_SERIAL_NAME + " on " + sysTable.getTableName() + " ( " + this.aSqlCreateTableColumn.columnName + " ) ";
                arrayList.add(string2);
            }
            this.commands = arrayList.toArray(new String[arrayList.size()]);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableAddColumn(this), this.client);
            ExecutionResult executionResult = null;
            Object var4_3 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

