/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableInherit;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.Inherit;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;

public class SqlAlterInherit
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterInherit.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String tableName = null;
    private SysTable table = null;
    private boolean noInherit;
    private String[] commands;

    public SqlAlterInherit(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public Object visit(Inherit inherit, Object object) {
        this.noInherit = inherit.f0.present();
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        inherit.f2.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        return null;
    }

    public boolean isNoInherit() {
        return this.noInherit;
    }

    public String getTableName() {
        return this.tableName;
    }

    public SysTable getTable() {
        if (this.table == null) {
            this.table = this.client.getSysDatabase().getSysTable(this.tableName);
        }
        return this.table;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        try {
            this.commands = new String[0];
            this.parent.getTable().ensurePermission(this.client.getCurrentUser(), (short)6);
            SysTable sysTable = this.getTable();
            SysTable sysTable2 = this.parent.getTable();
            if (this.noInherit) {
                if (sysTable != sysTable2.getParentTable()) {
                    throw new XDBServerException("Table " + this.parent.getTableName() + " does not inherits from " + this.tableName);
                }
            } else {
                if (sysTable2.getParentTable() != null) {
                    throw new XDBServerException("Table " + this.parent.getTableName() + " already inherits from " + sysTable2.getParentTable().getTableName());
                }
                if (!sysTable.getPartitionMap().equals(sysTable2.getPartitionMap())) {
                    throw new XDBServerException("Partitioning of table " + this.parent.getTableName() + " differs from " + this.tableName);
                }
                if (sysTable.getPartitionColumn() == null ? sysTable2.getPartitionColumn() != null : sysTable2.getPartitionColumn() == null || !sysTable2.getPartitionColumn().equals(sysTable.getPartitionColumn())) {
                    throw new XDBServerException("Partitioning of table " + this.parent.getTableName() + " differs from " + this.tableName);
                }
                if (sysTable.getColumns().size() > sysTable2.getColumns().size()) {
                    throw new XDBServerException("Columns of table " + this.parent.getTableName() + " are not compatible with " + this.tableName);
                }
                for (int i = 0; i < sysTable.getColumns().size(); ++i) {
                    SysColumn sysColumn = sysTable.getColumns().get(i);
                    SysColumn sysColumn2 = sysTable2.getColumns().get(i);
                    if (!sysColumn.getColName().equals(sysColumn2.getColName())) {
                        throw new XDBServerException("Columns of table " + this.parent.getTableName() + " are not compatible with " + this.tableName);
                    }
                    if (sysColumn.getColType() != sysColumn2.getColType()) {
                        throw new XDBServerException("Columns of table " + this.parent.getTableName() + " are not compatible with " + this.tableName);
                    }
                    if (sysColumn.getColLength() != sysColumn2.getColLength()) {
                        throw new XDBServerException("Columns of table " + this.parent.getTableName() + " are not compatible with " + this.tableName);
                    }
                    if (sysColumn.getColScale() != sysColumn2.getColScale()) {
                        throw new XDBServerException("Columns of table " + this.parent.getTableName() + " are not compatible with " + this.tableName);
                    }
                    if (sysColumn.getColPrecision() == sysColumn2.getColPrecision()) continue;
                    throw new XDBServerException("Columns of table " + this.parent.getTableName() + " are not compatible with " + this.tableName);
                }
            }
            String string = "ALTER TABLE " + IdentifierHandler.quote(this.parent.getTableName()) + (this.noInherit ? " NO" : "") + " INHERIT " + IdentifierHandler.quote(this.tableName);
            this.commands = new String[]{string};
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (this.commands != null && this.commands.length != 0) {
                engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableInherit(this), this.client);
            }
            ExecutionResult executionResult = null;
            Object var4_3 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

