/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncAlterTableSetTablespace;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.SetTablespace;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.HashMap;
import java.util.Map;

public class SqlAlterSetTablespace
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterSetTablespace.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String tablespaceName = null;
    private SysTablespace tablespace = null;
    private Map<DBNode, String> commands = null;

    public SqlAlterSetTablespace(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public Object visit(SetTablespace setTablespace, Object object) {
        this.tablespaceName = (String)setTablespace.f2.accept(new IdentifierHandler(), object);
        return null;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public SysTablespace getTablespace() {
        return this.tablespace;
    }

    public boolean isPrepared() {
        return this.tablespace != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        try {
            if (!this.isPrepared()) {
                if (this.client.getCurrentUser().getUserClass() != 0) {
                    XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA can change table workspace");
                    logger.throwing(xDBSecurityException);
                    throw xDBSecurityException;
                }
                SysTablespace sysTablespace = MetaData.getMetaData().getTablespace(this.tablespaceName);
                this.commands = new HashMap<DBNode, String>();
                for (DBNode dBNode : this.parent.getTable().getNodeList()) {
                    if (!sysTablespace.getLocations().containsKey(dBNode.getNodeId())) {
                        throw new XDBServerException("Tablespace " + IdentifierHandler.quote(this.tablespaceName) + " does not exist on Node " + dBNode.getNodeId());
                    }
                    String string = "ALTER TABLE " + IdentifierHandler.quote(this.parent.getTableName()) + " SET TABLESPACE " + IdentifierHandler.quote(this.tablespaceName + "_" + dBNode.getNodeId());
                    this.commands.put(dBNode, string);
                }
                this.tablespace = sysTablespace;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            engine.executeDDLOnMultipleNodes(this.commands, new SyncAlterTableSetTablespace(this), this.client);
            ExecutionResult executionResult = null;
            Object var4_3 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

