/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncAlterUser;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.AlterUser;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAlterUser
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterUser.class);
    private XDBSessionContext client;
    private String iUserName = null;
    private String iPassword = null;
    private String iUserClass = null;
    private SysUser user;

    public SqlAlterUser(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Object visit(AlterUser alterUser, Object object) {
        Object var3_3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.iUserName = (String)alterUser.f2.accept(identifierHandler, object);
        if (alterUser.f3.present()) {
            alterUser.f3.accept(identifierHandler, object);
            this.iPassword = identifierHandler.getIdentifier();
        }
        if (alterUser.f4.present()) {
            switch (((NodeChoice)alterUser.f4.node).which) {
                case 0: {
                    this.iUserClass = "DBA";
                    break;
                }
                case 1: {
                    this.iUserClass = "RESOURCE";
                    break;
                }
                case 2: {
                    this.iUserClass = "STANDARD";
                }
            }
        }
        return var3_3;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    public String getPassword() {
        return this.iPassword;
    }

    public String getUserClass() {
        return this.iUserClass;
    }

    public String getUserName() {
        return this.iUserName;
    }

    public SysUser getUser() {
        return this.user;
    }

    @Override
    public boolean isPrepared() {
        return this.user != null;
    }

    @Override
    public void prepare() throws Exception {
        if (!this.isPrepared()) {
            this.user = this.client.getSysDatabase().getSysUser(this.iUserName);
            if (this.client.getCurrentUser().getUserClass() != 0 && (this.client.getCurrentUser() != this.user || this.iUserClass != null)) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA can alter users");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            if (this.iUserClass != null) {
                this.user.getLogin().canSetUserClass(this.iUserClass);
            } else if (this.iPassword == null) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("You must specify either password or user class");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
        }
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncAlterUser syncAlterUser = new SyncAlterUser(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncAlterUser.execute(this.client);
            metaData.commitTransaction(syncAlterUser);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        return ExecutionResult.createSuccessResult(4);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

