/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.AnalyzeDatabase;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.TableName;
import com.edb.gridsql.parser.core.syntaxtree.UpdateStats;
import com.edb.gridsql.parser.core.syntaxtree.VacuumDatabase;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAnalyzeDatabase
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAnalyzeDatabase.class);
    private static final String VACUUM_TYPE_NONE = "";
    private static final String VACUUM_TYPE_FULL = "FULL";
    private static final String VACUUM_TYPE_FREEZE = "FREEZE";
    private XDBSessionContext client;
    private SysDatabase database;
    private boolean doVacuum = false;
    private boolean doAnalyze = false;
    private String vacuumType = "";
    private String tableName = null;
    private List<String> columnNameList = null;
    private String templateUpdate;
    private String templateQuery;
    private HashMap<String, String> params;
    private Map<SysTable, Object[]> statements;

    public SqlAnalyzeDatabase(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    @Override
    public Object visit(UpdateStats updateStats, Object object) {
        this.doVacuum = true;
        this.doAnalyze = true;
        updateStats.f1.accept(this, object);
        return null;
    }

    @Override
    public Object visit(VacuumDatabase vacuumDatabase, Object object) {
        this.doVacuum = true;
        if (vacuumDatabase.f1.present()) {
            NodeChoice nodeChoice = (NodeChoice)vacuumDatabase.f1.node;
            this.vacuumType = nodeChoice.which == 0 ? VACUUM_TYPE_FULL : VACUUM_TYPE_FREEZE;
        }
        vacuumDatabase.f2.accept(this, object);
        return null;
    }

    @Override
    public Object visit(AnalyzeDatabase analyzeDatabase, Object object) {
        this.doAnalyze = true;
        analyzeDatabase.f1.accept(this, object);
        return null;
    }

    @Override
    public Object visit(TableName tableName, Object object) {
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        tableName.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        return null;
    }

    @Override
    public Object visit(ColumnNameList columnNameList, Object object) {
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        columnNameList.accept(columnNameListHandler, object);
        this.columnNameList = columnNameListHandler.getColumnNameList();
        return null;
    }

    @Override
    public long getCost() {
        return 10000000000L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        Object object;
        Collection<Object> collection;
        if (this.tableName == null) {
            collection = new LinkedList();
            object = this.database.getAllTables();
            while (object.hasMoreElements()) {
                SysTable sysTable = (SysTable)object.nextElement();
                if (sysTable.isTemporary()) continue;
                collection.add(sysTable);
            }
        } else {
            collection = Collections.singleton(this.database.getSysTable(this.tableName));
        }
        object = Collections.emptyList();
        if (this.vacuumType == VACUUM_TYPE_FULL) {
            return new LockSpecification<SysTable>((Collection<SysTable>)object, (Collection<SysTable>)collection);
        }
        return new LockSpecification<SysTable>((Collection<SysTable>)collection, (Collection<SysTable>)object);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        if (this.tableName == null) {
            return this.database.getDBNodeList();
        }
        return this.database.getSysTable(this.tableName).getNodeList();
    }

    @Override
    public boolean isPrepared() {
        return this.statements != null;
    }

    @Override
    public void prepare() throws Exception {
        if (!this.isPrepared()) {
            if (this.client.getCurrentUser().getUserClass() != 0) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("Only DBA can update statistics");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            if (this.columnNameList == null) {
                if (this.doVacuum && this.doAnalyze) {
                    this.templateUpdate = Props.XDB_SQLCOMMAND_VACUUM_ANALYZE_TEMPLATE_TABLE;
                } else if (this.doVacuum) {
                    this.templateUpdate = Props.XDB_SQLCOMMAND_VACUUM_TEMPLATE_TABLE;
                } else if (this.doAnalyze) {
                    this.templateUpdate = Props.XDB_SQLCOMMAND_ANALYZE_TEMPLATE_TABLE;
                }
            } else if (this.doVacuum && this.doAnalyze) {
                this.templateUpdate = Props.XDB_SQLCOMMAND_VACUUM_ANALYZE_TEMPLATE_COLUMN;
            } else if (this.doVacuum) {
                this.templateUpdate = Props.XDB_SQLCOMMAND_VACUUM_TEMPLATE_COLUMN;
            } else if (this.doAnalyze) {
                this.templateUpdate = Props.XDB_SQLCOMMAND_ANALYZE_TEMPLATE_COLUMN;
            }
            if (this.templateUpdate == null || this.templateUpdate.length() == 0) {
                XDBServerException xDBServerException = new XDBServerException("Template is not specified for such kind of VACUUM ... ANALYZE");
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            this.templateQuery = Props.XDB_SQLCOMMAND_UPDATESTATISTICS_QUERY;
            this.params = new HashMap();
            this.params.put("vacuum_type", this.vacuumType);
            if (this.tableName == null) {
                this.statements = new HashMap<SysTable, Object[]>();
                Enumeration enumeration = this.database.getAllTables();
                while (enumeration.hasMoreElements()) {
                    SysTable sysTable = (SysTable)enumeration.nextElement();
                    if (sysTable.isTemporary()) continue;
                    this.statements.put(sysTable, this.createStatements(sysTable));
                }
            } else {
                SysTable sysTable = this.database.getSysTable(this.tableName);
                this.statements = Collections.singletonMap(sysTable, this.createStatements(sysTable));
            }
        }
    }

    private Object[] createStatements(SysTable sysTable) throws Exception {
        CharSequence charSequence;
        Object[] objectArray = this.doAnalyze ? new Object[4] : new Object[1];
        this.params.put("table", IdentifierHandler.quote(sysTable.getTableName()));
        Collection<SysColumn> collection = this.createColumnList(sysTable);
        if (this.columnNameList != null) {
            charSequence = new StringBuffer();
            for (SysColumn stringArray : collection) {
                ((StringBuffer)charSequence).append(IdentifierHandler.quote(stringArray.getColName())).append(", ");
            }
            this.params.put("column_list", ((StringBuffer)charSequence).substring(0, ((StringBuffer)charSequence).length() - 2));
        }
        objectArray[0] = ParseCmdLine.substitute(this.templateUpdate, this.params);
        if (this.doAnalyze) {
            charSequence = Props.XDB_SQLCOMMAND_UPDATESTATISTICS_ROWCOUNT;
            boolean bl = Props.XDB_SQLCOMMAND_UPDATESTATISTICS_ROWCOUNT_QUOTED;
            if (((String)charSequence).length() == 0) {
                charSequence = "SELECT count(*) FROM {table}";
                bl = true;
            }
            if (!bl) {
                this.params.put("table", sysTable.getTableName());
            }
            objectArray[1] = ParseCmdLine.substitute((String)charSequence, this.params);
            if (!bl) {
                this.params.put("table", IdentifierHandler.quote(sysTable.getTableName()));
            }
            if (this.templateQuery == null || this.templateQuery.length() == 0) {
                StringBuffer stringBuffer = new StringBuffer("SELECT ");
                for (SysColumn sysColumn : collection) {
                    if (this.columnNameList == null && this.isUnique(sysColumn)) {
                        stringBuffer.append("null, ");
                        continue;
                    }
                    stringBuffer.append("count (distinct ").append(sysColumn.getColName()).append("), ");
                }
                stringBuffer.append("count (*) from ").append(sysTable.getTableName());
                objectArray[2] = stringBuffer.toString();
            } else {
                String[] stringArray = new String[collection.size()];
                int n = 0;
                for (SysColumn sysColumn : collection) {
                    this.params.put("column", IdentifierHandler.quote(sysColumn.getColName()));
                    stringArray[n++] = ParseCmdLine.substitute(this.templateQuery, this.params);
                }
                objectArray[2] = stringArray;
            }
            objectArray[3] = collection;
        }
        return objectArray;
    }

    private boolean isUnique(SysColumn sysColumn) {
        return sysColumn.bestIndexColPos == 1 && sysColumn.bestIndex.getIndexKeys().size() == 1 && (sysColumn.bestIndex.idxtype == 'U' || sysColumn.bestIndex.idxtype == 'P');
    }

    private Collection<SysColumn> createColumnList(SysTable sysTable) {
        ArrayList<SysColumn> arrayList;
        if (this.columnNameList == null) {
            arrayList = new ArrayList<SysColumn>(sysTable.getColumns().size());
            for (SysColumn sysColumn : sysTable.getColumns()) {
                SysColumn sysColumn2 = sysColumn;
                if (sysColumn2.getColName().equalsIgnoreCase("xrowid")) continue;
                arrayList.add(sysColumn2);
            }
        } else {
            arrayList = new ArrayList(this.columnNameList.size());
            for (String string : this.columnNameList) {
                String string2 = string;
                SysColumn sysColumn = sysTable.getSysColumn(string2);
                if (sysColumn == null) {
                    throw new XDBServerException("Column " + string2 + " is not found in table " + sysTable.getTableName());
                }
                arrayList.add(sysColumn);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Map.Entry<SysTable, Object[]> entry : this.statements.entrySet()) {
            SysTable sysTable = entry.getKey();
            Object[] objectArray = entry.getValue();
            try {
                long l;
                Object object;
                String string = (String)objectArray[0];
                MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(sysTable.getNodeList());
                multinodeExecutor.execute(string, sysTable.getNodeList(), true);
                if (!this.doAnalyze) continue;
                long l2 = 0L;
                Collection<DBNode> collection = sysTable.getJoinNodeList();
                Map<Integer, ResultSet> map = engine.executeQueryOnMultipleNodes((String)objectArray[1], collection, this.client);
                for (ResultSet resultSet : map.values()) {
                    try {
                        if (!resultSet.next()) {
                            throw new XDBServerException("Could not count rows for table: " + sysTable.getTableName());
                        }
                        l2 += resultSet.getLong(1);
                        object = null;
                    }
                    catch (Throwable throwable) {
                        object = null;
                        resultSet.close();
                        throw throwable;
                    }
                    resultSet.close();
                }
                String string2 = "UPDATE xsystables SET numrows=" + l2 + " where tableid=" + sysTable.getTableId();
                MetaData.getMetaData().executeUpdate(string2);
                sysTable.setNumrows(l2);
                Collection collection2 = (Collection)objectArray[3];
                long[] lArray = new long[collection2.size()];
                Arrays.fill(lArray, 0L);
                if (l2 > 0L) {
                    int n;
                    if (objectArray[2] instanceof String) {
                        object = engine.executeQueryOnMultipleNodes((String)objectArray[2], collection, this.client);
                        for (ResultSet resultSet : object.values()) {
                            Object var24_39;
                            block28: {
                                block29: {
                                    try {
                                        if (!resultSet.next()) break block28;
                                        n = resultSet.getInt(lArray.length + 1);
                                        if (n == 0) {
                                            var24_39 = null;
                                            break block29;
                                        }
                                        for (int i = 0; i < lArray.length; ++i) {
                                            l = resultSet.getLong(i + 1);
                                            if (resultSet.wasNull()) continue;
                                            int n2 = i;
                                            lArray[n2] = lArray[n2] + l * (long)n / l2;
                                        }
                                        break block28;
                                    }
                                    catch (Throwable throwable) {
                                        var24_39 = null;
                                        resultSet.close();
                                        throw throwable;
                                    }
                                }
                                resultSet.close();
                                continue;
                            }
                            var24_39 = null;
                            resultSet.close();
                        }
                    } else {
                        object = (String[])objectArray[2];
                        for (int i = 0; i < ((String[])object).length; ++i) {
                            Map<Integer, ResultSet> map2 = engine.executeQueryOnMultipleNodes((String)object[i], collection, this.client);
                            n = collection.size();
                            for (ResultSet resultSet : map2.values()) {
                                Object var26_40;
                                try {
                                    if (resultSet.next()) {
                                        long l3 = resultSet.getLong(1);
                                        if (l3 > 0L) {
                                            int n3 = i;
                                            lArray[n3] = lArray[n3] + l3 / (long)n;
                                        } else {
                                            int n4 = i;
                                            lArray[n4] = (long)((double)lArray[n4] + (0.0 - resultSet.getDouble(1)) * (double)l2 / (double)n);
                                        }
                                    }
                                    var26_40 = null;
                                }
                                catch (Throwable throwable) {
                                    var26_40 = null;
                                    resultSet.close();
                                    throw throwable;
                                }
                                resultSet.close();
                            }
                        }
                    }
                }
                int n = 0;
                Iterator<Object> iterator = collection2.iterator();
                while (iterator.hasNext()) {
                    double d = 0.0;
                    SysColumn sysColumn = (SysColumn)iterator.next();
                    l = lArray[n] == 0L ? l2 : lArray[n];
                    ++n;
                    if (l > 0L) {
                        d = 1.0 / (double)l;
                    }
                    sysColumn.setSelectivity(d);
                    String string3 = "update xsyscolumns set selectivity = " + d + " where colid = " + sysColumn.getColID();
                    MetaData.getMetaData().executeUpdate(string3);
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
                linkedList.add(sysTable.getTableName());
            }
        }
        if (linkedList.size() <= 0) {
            return ExecutionResult.createSuccessResult(5);
        }
        StringBuffer stringBuffer = new StringBuffer("Failed to update statistics for table(s):\n");
        Iterator iterator = linkedList.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                XDBServerException xDBServerException = new XDBServerException(stringBuffer.toString());
                logger.throwing(xDBServerException);
                throw xDBServerException;
            }
            String string = (String)iterator.next();
            stringBuffer.append((Object)string).append("\n");
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

