/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.metadata.scheduler.LockType;
import com.edb.gridsql.parser.IXDBSql;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlBulkInsert
implements IXDBSql,
IExecutable {
    private static final XLogger logger = XLogger.getLogger(SqlBulkInsert.class);
    private SysTable table;
    private XDBSessionContext client;
    private String address;
    private LockSpecification<SysTable> lockSpecs = null;

    public SqlBulkInsert(String string, XDBSessionContext xDBSessionContext) {
        String string2;
        this.client = xDBSessionContext;
        int n = string.indexOf("|");
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(0, n);
            this.address = string.substring(n + "|".length());
        }
        this.table = xDBSessionContext.getSysDatabase().getSysTable(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<DBNode> getNodeList() {
        try {
            Collection<DBNode> collection = this.table.getNodeList();
            Object var3_2 = null;
            return collection;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCost() {
        try {
            long l = 10000000000L;
            Object var4_2 = null;
            return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        try {
            if (this.lockSpecs == null) {
                this.lockSpecs = new LockSpecification();
                this.lockSpecs.add(this.table, LockType.get(2, false));
            }
            LockSpecification<SysTable> lockSpecification = this.lockSpecs;
            Object var3_2 = null;
            return lockSpecification;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public SysTable getSysTable() {
        return this.table;
    }

    public void startLoaders(Engine engine) throws Exception {
        if (this.address != null) {
            engine.startLoaders(this.table.getTableName(), this.address, this.getNodeList(), this.client);
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        ExecutionResult executionResult;
        if (!this.client.isInTransaction()) {
            engine.beginTransaction(this.client, this.getNodeList());
        }
        this.startLoaders(engine);
        PartitionMap partitionMap = this.table.getPartitionMap();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            try {
                objectOutputStream.writeObject(partitionMap);
                objectOutputStream.flush();
                executionResult = ExecutionResult.createSerializedObjectResult(26, byteArrayOutputStream.toByteArray());
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                objectOutputStream.close();
                throw throwable;
            }
            objectOutputStream.close();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            byteArrayOutputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.close();
        return executionResult;
    }
}

