/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Cluster;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCluster
extends ObjectDepthFirst
implements IXDBSql,
IExecutable,
IPreparable {
    private XDBSessionContext client;
    private String aTableName;
    private String aIndexName;
    private String clusterStatement;

    public SqlCluster(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.client.getSysDatabase().getDBNodeList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        SysTable sysTable = null;
        Collection<DBNode> collection = this.getNodeList();
        MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(collection);
        if (this.aTableName != null) {
            sysTable = MetaData.getMetaData().getSysDatabase(this.client.getDBName()).getSysTable(this.aTableName.trim());
            this.clusterTable(sysTable, sysTable.getNodeList(), multinodeExecutor, this.clusterStatement, this.aIndexName);
        } else {
            Enumeration enumeration = MetaData.getMetaData().getSysDatabase(this.client.getDBName()).getAllTables();
            while (enumeration.hasMoreElements()) {
                SysTable sysTable2 = (SysTable)enumeration.nextElement();
                if (this.client.getCurrentUser().getUserClass() != 0 && this.client.getCurrentUser() != sysTable2.getOwner() || sysTable2.getClusteridx() == null) continue;
                String string = "CLUSTER " + IdentifierHandler.quote(sysTable2.getClusteridx()) + " ON " + IdentifierHandler.quote(sysTable2.getTableName());
                this.clusterTable(sysTable2, sysTable2.getNodeList(), multinodeExecutor, string, sysTable2.getClusteridx());
            }
        }
        return ExecutionResult.createSuccessResult(7);
    }

    public void clusterTable(SysTable sysTable, Collection<DBNode> collection, MultinodeExecutor multinodeExecutor, String string, String string2) {
        multinodeExecutor.executeCommand(string, collection, true);
        String string3 = "update xsystables set clusteridx = '" + string2 + "' where tableid = " + sysTable.getTableId();
        sysTable.setClusteridx(string2);
        MetaData.getMetaData().executeUpdate(string3);
    }

    @Override
    public boolean isPrepared() {
        return this.clusterStatement != null;
    }

    @Override
    public void prepare() throws Exception {
        SysTable sysTable = null;
        if (this.aIndexName == null && this.aTableName == null) {
            return;
        }
        if (this.aTableName != null) {
            sysTable = MetaData.getMetaData().getSysDatabase(this.client.getDBName()).getSysTable(this.aTableName.trim());
            if (this.aIndexName == null) {
                if (sysTable.getClusteridx() == null) {
                    throw new XDBServerException("there is no previously clustered index for table \"" + this.aTableName + "\"");
                }
                this.aIndexName = sysTable.getClusteridx().trim();
            }
            this.clusterStatement = "CLUSTER " + IdentifierHandler.quote(this.aIndexName) + " ON " + IdentifierHandler.quote(this.aTableName);
        }
    }

    @Override
    public Object visit(Cluster cluster, Object object) {
        Object var3_3 = null;
        if (cluster.f1.present()) {
            IdentifierHandler identifierHandler = new IdentifierHandler();
            NodeSequence nodeSequence = (NodeSequence)cluster.f1.node;
            NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(1);
            NodeSequence nodeSequence2 = (NodeSequence)nodeOptional.node;
            if (nodeSequence2 == null) {
                this.aTableName = (String)nodeSequence.elementAt(0).accept(identifierHandler, object);
            } else {
                this.aIndexName = (String)nodeSequence.elementAt(0).accept(identifierHandler, object);
                this.aTableName = (String)nodeSequence2.elementAt(1).accept(identifierHandler, object);
            }
        }
        return var3_3;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

