/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateIndex;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlCreateIndexKey;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.WhereClause;
import com.edb.gridsql.parser.core.syntaxtree.columnListIndexSpec;
import com.edb.gridsql.parser.core.syntaxtree.createIndex;
import com.edb.gridsql.parser.core.syntaxtree.tablespaceDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.SQLExpressionHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateIndex
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateIndex.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private SysTable table;
    private Command commandToExecute;
    private String indexName;
    private LinkedList<SqlCreateIndexKey> indexKeyDefinitions;
    private String indexTableName;
    private boolean unique;
    private boolean isSysCreated = false;
    private String createIndexSQL;
    private String usingType = null;
    private String wherePred = null;
    private String tablespaceName = null;
    private SysTablespace tablespace = null;

    public SqlCreateIndex(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.indexKeyDefinitions = new LinkedList();
        this.commandToExecute = new Command(4, this, new QueryTreeTracker(), xDBSessionContext);
    }

    @Override
    public Object visit(createIndex createIndex2, Object object) {
        Object var3_3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.unique = createIndex2.f1.present();
        this.indexName = (String)createIndex2.f3.accept(identifierHandler, object);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        createIndex2.f5.accept(tableNameHandler, object);
        this.indexTableName = tableNameHandler.getTableName();
        if (createIndex2.f6.present()) {
            NodeSequence nodeSequence = (NodeSequence)createIndex2.f6.node;
            this.setUsingType((String)nodeSequence.elementAt(1).accept(identifierHandler, object));
        }
        createIndex2.f8.accept(this, object);
        createIndex2.f10.accept(this, object);
        createIndex2.f11.accept(this, object);
        return var3_3;
    }

    @Override
    public Object visit(WhereClause whereClause, Object object) {
        QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
        whereClause.f1.accept(queryConditionHandler, object);
        this.setWherePred(queryConditionHandler.aRootCondition.rebuildString());
        return null;
    }

    @Override
    public Object visit(tablespaceDef tablespaceDef2, Object object) {
        this.tablespaceName = (String)tablespaceDef2.f1.accept(new IdentifierHandler(), object);
        return null;
    }

    @Override
    public Object visit(columnListIndexSpec columnListIndexSpec2, Object object) {
        Object var3_3 = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        if (columnListIndexSpec2.f1.present()) {
            if (((NodeChoice)columnListIndexSpec2.f1.node).which == 2) {
                string3 = (String)columnListIndexSpec2.f1.node.accept(identifierHandler, object);
            } else {
                string2 = ((NodeToken)((NodeChoice)columnListIndexSpec2.f1.node).choice).tokenImage;
            }
        }
        if (columnListIndexSpec2.f0.which == 0) {
            string = (String)columnListIndexSpec2.f0.choice.accept(identifierHandler, object);
            this.indexKeyDefinitions.add(new SqlCreateIndexKey(string, string2, string3));
        } else {
            SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
            ((Node)((NodeSequence)columnListIndexSpec2.f0.choice).nodes.get(1)).accept(sQLExpressionHandler, null);
            this.indexKeyDefinitions.add(new SqlCreateIndexKey(sQLExpressionHandler.aroot, string2, string3));
        }
        columnListIndexSpec2.f1.accept(this, object);
        columnListIndexSpec2.f2.accept(this, object);
        for (Object e : columnListIndexSpec2.f2.nodes) {
            NodeSequence nodeSequence = (NodeSequence)e;
            NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(2);
            if (nodeOptional.present()) {
                if (((NodeChoice)nodeOptional.node).which == 2) {
                    string3 = (String)nodeOptional.node.accept(identifierHandler, object);
                } else {
                    string2 = ((NodeToken)((NodeChoice)nodeOptional.node).choice).tokenImage;
                }
            }
            NodeChoice nodeChoice = (NodeChoice)nodeSequence.elementAt(1);
            if (nodeChoice.which == 0) {
                string = (String)nodeChoice.choice.accept(identifierHandler, object);
                this.indexKeyDefinitions.add(new SqlCreateIndexKey(string, string2, string3));
                continue;
            }
            SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
            ((Node)((NodeSequence)nodeChoice.choice).nodes.get(1)).accept(sQLExpressionHandler, null);
            this.indexKeyDefinitions.add(new SqlCreateIndexKey(sQLExpressionHandler.aroot, string2, string3));
        }
        return var3_3;
    }

    public List<SqlCreateIndexKey> getIndexKeyDefinitions() {
        return this.indexKeyDefinitions;
    }

    public void setSysCreated(boolean bl) {
        this.isSysCreated = bl;
    }

    public boolean isSysCreated() {
        return this.isSysCreated;
    }

    public String getIndexTableName() {
        return this.indexTableName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getSize() {
        return this.indexKeyDefinitions.size();
    }

    public boolean isUnique() {
        return this.unique;
    }

    public String getTableName() {
        return this.indexTableName;
    }

    public SysTablespace getTablespace() {
        return this.tablespace;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        Vector<SysTable> vector = new Vector<SysTable>();
        Vector vector2 = new Vector();
        vector.add(this.database.getSysTable(this.getTableName()));
        return new LockSpecification<SysTable>(vector, vector2);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return new ArrayList<DBNode>(this.database.getSysTable(this.getTableName()).getNodeList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPrepared() {
        try {
            boolean bl = this.table != null;
            Object var3_2 = null;
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            Iterator<DBNode> iterator;
            this.table = this.database.getSysTable(this.indexTableName);
            this.table.ensurePermission(this.client.getCurrentUser(), (short)5);
            if (this.table.getSysIndex(this.indexName) != null) {
                throw new XDBServerException("Index with name " + IdentifierHandler.quote(this.indexName) + " already exists on table " + IdentifierHandler.quote(this.indexTableName));
            }
            ArrayList<SysColumn> arrayList = new ArrayList<SysColumn>(this.indexKeyDefinitions.size());
            for (SqlCreateIndexKey iterator2 : this.indexKeyDefinitions) {
                for (String string : iterator2.getKeyColumnNames()) {
                    arrayList.add(this.table.getSysColumn(string));
                }
            }
            if (this.unique) {
                // empty if block
            }
            if (this.tablespaceName != null) {
                this.tablespace = MetaData.getMetaData().getTablespace(this.tablespaceName);
                iterator = this.table.getNodeList().iterator();
                while (iterator.hasNext()) {
                    DBNode dBNode;
                    DBNode dBNode2 = dBNode = iterator.next();
                    if (this.tablespace.getLocations().containsKey(new Integer(dBNode2.getNodeId()))) continue;
                    throw new XDBServerException("Tablespace " + IdentifierHandler.quote(this.tablespaceName) + " does not exist on Node " + dBNode2.getNodeId());
                }
            }
            if (arrayList.size() != 1 || this.table.getSerialColumn() != arrayList.get(0)) {
                iterator = new StringBuffer("CREATE ");
                ((StringBuffer)((Object)iterator)).append(this.unique ? "UNIQUE" : "").append(" INDEX ");
                ((StringBuffer)((Object)iterator)).append(this.indexName).append(" ON ").append(IdentifierHandler.quote(this.indexTableName));
                if (this.getUsingType() != null) {
                    ((StringBuffer)((Object)iterator)).append(" USING ");
                    ((StringBuffer)((Object)iterator)).append(this.getUsingType());
                }
                ((StringBuffer)((Object)iterator)).append(" (");
                for (SqlCreateIndexKey sqlCreateIndexKey : this.indexKeyDefinitions) {
                    ((StringBuffer)((Object)iterator)).append(sqlCreateIndexKey.rebuildString());
                    ((StringBuffer)((Object)iterator)).append(", ");
                }
                ((StringBuffer)((Object)iterator)).setLength(((StringBuffer)((Object)iterator)).length() - 2);
                ((StringBuffer)((Object)iterator)).append(")");
                this.createIndexSQL = ((StringBuffer)((Object)iterator)).toString();
            }
            Object var7_13 = null;
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            Object object;
            if (this.tablespace == null) {
                if (this.getWherePred() != null) {
                    this.createIndexSQL = this.createIndexSQL + " WHERE " + this.getWherePred();
                }
                engine.executeDDLOnMultipleNodes(this.createIndexSQL, this.table.getNodeList(), (IMetaDataUpdate)new SyncCreateIndex(this, this.database), this.client);
            } else {
                object = new HashMap<DBNode, String>();
                Iterator<DBNode> iterator = this.table.getNodeList().iterator();
                while (iterator.hasNext()) {
                    DBNode dBNode;
                    DBNode dBNode2 = dBNode = iterator.next();
                    String string = this.createIndexSQL + " TABLESPACE " + this.tablespace.getNodeTablespaceName(dBNode2.getNodeId());
                    if (this.getWherePred() != null) {
                        string = string + " WHERE " + this.getWherePred();
                    }
                    ((HashMap)object).put(dBNode2, string);
                }
                engine.executeDDLOnMultipleNodes((Map<DBNode, String>)object, new SyncCreateIndex(this, this.database), this.client);
            }
            object = ExecutionResult.createSuccessResult(10);
            Object var8_7 = null;
            return object;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    public String getUsingType() {
        return this.usingType;
    }

    public void setUsingType(String string) {
        this.usingType = string;
    }

    public String getWherePred() {
        return this.wherePred;
    }

    public void setWherePred(String string) {
        this.wherePred = string;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

