/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.IConstraintChecker;
import com.edb.gridsql.engine.BatchInsertGroup;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IParametrizedSql;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.ILockCost;
import com.edb.gridsql.metadata.scheduler.Lock;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.metadata.scheduler.LockType;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlModifyTable
extends ObjectDepthFirst
implements IPreparable,
IXDBSql,
IParametrizedSql {
    private static final XLogger logger = XLogger.getLogger(SqlModifyTable.class);
    protected static final String NODE_ID = "XDB__NODE__ID";
    protected XDBSessionContext client;
    protected SysDatabase database;
    protected Command commandToExecute;
    protected String tableName;
    protected Collection<DBNode> nodeList;
    private SysTable targetTable;
    private long cost = 0L;
    private BatchInsertGroup group = null;
    private long result;
    private boolean batchMode = false;
    private boolean usesFinalTempTable = true;
    protected LockSpecification<SysTable> lockSpecs = null;
    private boolean prepared;
    private SysTable tempTable;
    private Object dataSource;
    private Object finalStatements;
    protected Collection<IConstraintChecker> validators;

    public SqlModifyTable(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    public String getTableName() {
        return this.tableName;
    }

    public SysTable getTargetTable() throws XDBServerException {
        if (this.targetTable == null) {
            this.targetTable = this.database.getSysTable(this.getTableName());
        }
        return this.targetTable;
    }

    public Collection<SysTable> getReadTables() {
        Object object;
        HashSet<SysTable> hashSet = new HashSet<SysTable>();
        if (this.dataSource instanceof ILockCost) {
            for (Lock cloneable2 : ((ILockCost)this.dataSource).getLockSpecs().getCombinedVector()) {
                hashSet.add((SysTable)cloneable2.getManagedObject());
            }
        }
        SysTable sysTable = this.getTargetTable();
        Vector<SysReference> vector = sysTable.getSysFkReferenceList();
        Vector<SysReference> vector2 = sysTable.getSysReferences();
        for (SysReference sysReference : vector) {
            object = this.database.getSysTable(sysReference.getRefTableID());
            hashSet.add((SysTable)object);
        }
        for (SysReference sysReference : vector2) {
            object = sysReference.getForeignKeys();
            SysForeignKey sysForeignKey = (SysForeignKey)((Vector)object).elementAt(0);
            SysTable sysTable2 = sysForeignKey.getReferringSysColumn(this.database).getSysTable();
            hashSet.add(sysTable2);
        }
        return hashSet;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        if (this.lockSpecs == null) {
            this.lockSpecs = new LockSpecification<SysTable>(this.getReadTables(), list);
            this.lockSpecs.add(this.getTargetTable(), LockType.get(2, false));
        }
        return this.lockSpecs;
    }

    protected abstract Collection<DBNode> getExecutionNodes();

    @Override
    public Collection<DBNode> getNodeList() {
        if (this.nodeList == null) {
            Object object;
            this.nodeList = new HashSet<DBNode>();
            this.nodeList.addAll(this.getExecutionNodes());
            SysTable sysTable = this.getTargetTable();
            Vector<SysReference> vector = sysTable.getSysFkReferenceList();
            Vector<SysReference> vector2 = sysTable.getSysReferences();
            for (SysReference sysReference : vector) {
                if (sysReference.getConstraint().getIsSoft() != 1) continue;
                object = this.database.getSysTable(sysReference.getRefTableID());
                this.nodeList.addAll(((SysTable)object).getNodeList());
            }
            for (SysReference sysReference : vector2) {
                if (sysReference.getConstraint().getIsSoft() != 1) continue;
                object = sysReference.getForeignKeys();
                SysForeignKey sysForeignKey = (SysForeignKey)((Vector)object).elementAt(0);
                SysTable sysTable2 = sysForeignKey.getReferringSysColumn(this.database).getSysTable();
                this.nodeList.addAll(sysTable2.getNodeList());
            }
        }
        return this.nodeList;
    }

    protected abstract Collection<SysColumn> getColumnsInvolved();

    protected abstract IConstraintChecker getPKChecker(SysTable var1, Collection<SysColumn> var2);

    protected abstract IConstraintChecker getFKChecker(SysTable var1, Collection<SysColumn> var2);

    protected abstract IConstraintChecker getFRChecker(SysTable var1, Collection<SysColumn> var2);

    protected SysTable createTempTableMetadata(SysTable sysTable, Collection<SysColumn> collection) throws Exception {
        return this.database.createTempSysTable(this.tableName + "_", sysTable.getPartitionScheme(), sysTable.getPartitionMap(), sysTable.getPartitionColumn(), sysTable.getSerialHandler(), sysTable.getRowIDHandler(), collection);
    }

    protected abstract Object prepareDataSource(SysTable var1, SysTable var2) throws Exception;

    protected abstract Object prepareFinalStatements(SysTable var1, SysTable var2) throws Exception;

    protected abstract long fillTable(Object var1, SysTable var2, Engine var3) throws Exception;

    protected int internalExecute(Object object, Engine engine) throws Exception {
        int n;
        if (object instanceof String) {
            n = engine.executeOnMultipleNodes((String)object, this.getExecutionNodes(), this.client);
        } else if (object instanceof Map) {
            n = engine.executeOnMultipleNodes((Map)object, this.client);
        } else {
            XDBServerException xDBServerException = new XDBServerException("Invalid statements: " + object);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        return n;
    }

    protected boolean groupExecute(Object object, Engine engine) throws Exception {
        if (object instanceof String) {
            return engine.addToBatchOnNodes((String)object, this.getNodeList(), this.client);
        }
        if (object instanceof Map) {
            return engine.addToBatchOnNodes((Map)object, this.client);
        }
        XDBServerException xDBServerException = new XDBServerException("Invalid statements: " + object);
        logger.throwing(xDBServerException);
        throw xDBServerException;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    protected SysTable getTempTable() {
        return this.tempTable;
    }

    protected Object getFinalStatements() {
        return this.finalStatements;
    }

    protected abstract short getPrivilege();

    protected void createTempTable(SysTable sysTable, Engine engine) {
        if (Props.XDB_COMMIT_AFTER_CREATE_TEMP_TABLE || !sysTable.isTemporary()) {
            MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(sysTable.getNodeList());
            multinodeExecutor.executeCommand(sysTable.getTableDef(false), sysTable.getNodeList(), true);
        } else {
            engine.executeOnMultipleNodes(sysTable.getTableDef(false), sysTable.getNodeList(), this.client);
        }
    }

    protected void dropTempTable(SysTable sysTable, Engine engine) {
        engine.executeOnMultipleNodes("DROP TABLE " + IdentifierHandler.quote(sysTable.getTableName()), sysTable.getNodeList(), this.client);
        this.database.dropSysTable(sysTable.getTableName());
    }

    protected boolean isBatcheable() {
        return this.tempTable == null;
    }

    public void setBatchMode() {
        this.batchMode = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        this.validators = new ArrayList<IConstraintChecker>();
        this.getTargetTable().ensurePermission(this.client.getCurrentUser(), this.getPrivilege());
        IConstraintChecker iConstraintChecker = this.getPKChecker(this.targetTable, this.getColumnsInvolved());
        if (iConstraintChecker != null && !iConstraintChecker.isEmpty()) {
            this.validators.add(iConstraintChecker);
        }
        if ((iConstraintChecker = this.getFKChecker(this.targetTable, this.getColumnsInvolved())) != null && !iConstraintChecker.isEmpty()) {
            this.validators.add(iConstraintChecker);
        }
        if ((iConstraintChecker = this.getFRChecker(this.targetTable, this.getColumnsInvolved())) != null && !iConstraintChecker.isEmpty()) {
            this.validators.add(iConstraintChecker);
        }
        this.tempTable = this.createTempTableMetadata(this.getTargetTable(), this.getColumnsInvolved());
        this.dataSource = this.prepareDataSource(this.targetTable, this.tempTable);
        for (IConstraintChecker iConstraintChecker2 : this.validators) {
            iConstraintChecker2.setTempTable(this.tempTable);
            iConstraintChecker2.prepare();
        }
        this.finalStatements = this.prepareFinalStatements(this.targetTable, this.tempTable);
        if (this.batchMode) {
            if (this.isBatcheable()) {
                this.group = this.client.getInsertGroup(this);
            } else {
                this.client.closeInsertGroup(this);
            }
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        Object object;
        if (!this.isPrepared()) {
            this.prepare();
        }
        if (this.tempTable != null && this.usesFinalTempTable) {
            this.createTempTable(this.tempTable, engine);
        }
        try {
            if (this.group != null) {
                if (!this.group.executed()) {
                    Object object2;
                    this.group.setExecuted();
                    object = new LinkedList();
                    for (SqlModifyTable sqlModifyTable : this.group.getMembers()) {
                        object.add((SqlModifyTable)sqlModifyTable);
                        if (!sqlModifyTable.groupExecute(sqlModifyTable.finalStatements, engine)) continue;
                        object2 = engine.executeBatchOnNodes(this.client, false);
                        int n = 0;
                        Iterator iterator = object.iterator();
                        while (iterator.hasNext()) {
                            SqlModifyTable sqlModifyTable2 = (SqlModifyTable)iterator.next();
                            if (this.targetTable.isLookup()) {
                                sqlModifyTable2.result = (long)(object2[n++] / this.targetTable.getNodeList().size());
                                continue;
                            }
                            sqlModifyTable2.result = (long)object2[n++];
                        }
                        object = new LinkedList();
                    }
                    if (object.size() > 0) {
                        Object object3 = engine.executeBatchOnNodes(this.client, false);
                        int n = 0;
                        object2 = object.iterator();
                        while (object2.hasNext()) {
                            SqlModifyTable sqlModifyTable = (SqlModifyTable)object2.next();
                            if (this.targetTable.isLookup()) {
                                sqlModifyTable.result = (long)(object3[n++] / this.targetTable.getNodeList().size());
                                continue;
                            }
                            sqlModifyTable.result = (long)object3[n++];
                        }
                    }
                }
            } else {
                if (this.getParamCount() > 0) {
                    this.finalStatements = this.prepareFinalStatements(this.targetTable, this.tempTable);
                }
                this.result = this.fillTable(this.dataSource, this.tempTable, engine);
                if (this.usesFinalTempTable) {
                    for (IConstraintChecker iConstraintChecker : this.validators) {
                        ((IExecutable)iConstraintChecker).execute(engine);
                    }
                    this.result = this.internalExecute(this.finalStatements, engine);
                }
                if (this.targetTable.isLookup()) {
                    this.result /= (long)this.targetTable.getNodeList().size();
                }
            }
            object = ExecutionResult.createRowCountResult(this.getResultType(), Long.valueOf(this.result).intValue());
        }
        catch (Throwable throwable) {
            try {
                if (this.tempTable != null && this.usesFinalTempTable) {
                    this.dropTempTable(this.tempTable, engine);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (this.tempTable != null && this.usesFinalTempTable) {
                this.dropTempTable(this.tempTable, engine);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public abstract int getResultType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCost() {
        if (this.cost == 0L) {
            try {
                if (!this.isPrepared()) {
                    this.prepare();
                }
                if (this.dataSource instanceof ILockCost) {
                    this.cost += 2L * ((ILockCost)this.dataSource).getCost();
                }
                for (IConstraintChecker iConstraintChecker : this.validators) {
                    if (!(iConstraintChecker instanceof ILockCost)) continue;
                    this.cost += ((ILockCost)((Object)iConstraintChecker)).getCost();
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
            }
        }
        long l = this.cost;
        return l;
    }

    protected void executeCurrentBatch(Engine engine) throws XDBServerException {
        int[] nArray;
        for (int n : nArray = engine.executeBatchOnNodes(this.client, true)) {
            if (n != -3) continue;
            XDBServerException xDBServerException = new XDBServerException("Failed to populate temp table");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }

    @Override
    public int getParamCount() throws XDBServerException {
        return this.commandToExecute.getParamCount();
    }

    @Override
    public void setParamValue(int n, String string) throws ArrayIndexOutOfBoundsException, XDBServerException {
        this.commandToExecute.getParameter(n + 1).setParamValue(string);
    }

    @Override
    public void setParamValues(String[] stringArray) throws ArrayIndexOutOfBoundsException, XDBServerException {
        for (int i = 0; i < stringArray.length; ++i) {
            this.commandToExecute.getParameter(i + 1).setParamValue(stringArray[i]);
        }
    }

    @Override
    public int getParamDataType(int n) throws ArrayIndexOutOfBoundsException, XDBServerException {
        ExpressionType expressionType = this.commandToExecute.getParameter(n + 1).getExprDataType();
        return expressionType == null ? 0 : expressionType.type;
    }

    @Override
    public int[] getParamDataTypes() throws ArrayIndexOutOfBoundsException, XDBServerException {
        int[] nArray = new int[this.commandToExecute.getParamCount()];
        for (int i = 0; i < this.commandToExecute.getParamCount(); ++i) {
            ExpressionType expressionType = this.commandToExecute.getParameter(i + 1).getExprDataType();
            nArray[i] = expressionType == null ? 0 : expressionType.type;
        }
        return nArray;
    }

    @Override
    public String getParamValue(int n) throws ArrayIndexOutOfBoundsException, XDBServerException {
        return this.commandToExecute.getParameter(n + 1).getParamValue();
    }

    @Override
    public String[] getParamValues() throws ArrayIndexOutOfBoundsException, XDBServerException {
        String[] stringArray = new String[this.commandToExecute.getParamCount()];
        for (int i = 0; i < this.commandToExecute.getParamCount(); ++i) {
            stringArray[i] = this.commandToExecute.getParameter(i + 1).getParamValue();
        }
        return null;
    }

    @Override
    public void setParamDataType(int n, int n2) throws ArrayIndexOutOfBoundsException, XDBServerException {
        ExpressionType expressionType = this.commandToExecute.getParameter(n + 1).getExprDataType();
        if (expressionType == null) {
            expressionType = new ExpressionType();
            this.commandToExecute.getParameter(n + 1).setExprDataType(expressionType);
        }
        expressionType.type = n2;
    }

    @Override
    public void setParamDataTypes(int[] nArray) throws ArrayIndexOutOfBoundsException, XDBServerException {
        for (int i = 0; i < nArray.length; ++i) {
            ExpressionType expressionType = this.commandToExecute.getParameter(i + 1).getExprDataType();
            if (expressionType == null) {
                expressionType = new ExpressionType();
                this.commandToExecute.getParameter(i + 1).setExprDataType(expressionType);
            }
            expressionType.type = nArray[i];
        }
    }

    protected void setUsesFinalTempTable(boolean bl) {
        this.usesFinalTempTable = bl;
    }
}

