/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.IsolationLevel;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.SetProperty;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSetProperty
extends ObjectDepthFirst
implements IXDBSql,
IExecutable {
    private static final String TRANSACTION_ISOLATION = "TRANSACTION ISOLATION LEVEL";
    private String propertyToSet = null;
    private String propertyValue = null;
    private XDBSessionContext client;
    private List<DBNode> nodeList;
    private int desiredLevel = 0;

    public SqlSetProperty(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.nodeList = new ArrayList<DBNode>(xDBSessionContext.getSysDatabase().getDBNodeList());
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.nodeList;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Object visit(SetProperty setProperty, Object object) {
        if (setProperty.f1.which == 0) {
            NodeSequence nodeSequence = (NodeSequence)setProperty.f1.choice;
            IdentifierHandler identifierHandler = new IdentifierHandler();
            this.propertyToSet = (String)((Node)nodeSequence.nodes.get(0)).accept(identifierHandler, object);
            NodeChoice nodeChoice = (NodeChoice)nodeSequence.nodes.get(2);
            switch (nodeChoice.which) {
                case 0: 
                case 2: 
                case 3: 
                case 4: {
                    this.propertyValue = nodeChoice.choice.toString();
                    break;
                }
                case 1: {
                    this.propertyValue = (String)nodeChoice.accept(identifierHandler, object);
                }
            }
        } else {
            this.propertyToSet = TRANSACTION_ISOLATION;
            setProperty.f1.choice.accept(this, object);
            this.nodeList = Collections.emptyList();
        }
        return null;
    }

    @Override
    public Object visit(IsolationLevel isolationLevel, Object object) {
        switch (isolationLevel.f0.which) {
            case 0: {
                this.desiredLevel = 8;
                break;
            }
            case 1: {
                this.desiredLevel = 4;
                break;
            }
            case 2: {
                this.desiredLevel = 2;
                break;
            }
            case 3: {
                this.desiredLevel = 1;
            }
        }
        return null;
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (this.propertyToSet == TRANSACTION_ISOLATION) {
            if (this.desiredLevel != 0) {
                if (this.client.isInTransaction()) {
                    engine.commitTransaction(this.client, this.getNodeList());
                }
                this.client.setTransactionIsolation(this.desiredLevel);
            }
            return ExecutionResult.createSuccessResult(27);
        }
        if (this.propertyToSet.equalsIgnoreCase("client_encoding")) {
            if (!Props.XDB_CLIENT_ENCODING_IGNORE && !"UNICODE".equalsIgnoreCase(this.propertyValue)) {
                throw new SQLException("Setting client_encoding is not allowed; must use UNICODE");
            }
            return ExecutionResult.createSuccessResult(27);
        }
        this.client.setUsedSet();
        try {
            String string = "SET " + this.propertyToSet + " TO ";
            string = this.propertyValue.startsWith("'") || this.propertyValue.startsWith("\"") ? string + this.propertyValue : string + "'" + this.propertyValue + "'";
            MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.getNodeList());
            multinodeExecutor.executeCommand(string, this.getNodeList(), true);
            Connection connection = this.client.getAndSetCoordinatorConnection();
            Statement statement = connection.createStatement();
            statement.execute(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ExecutionResult.createSuccessResult(27);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

