/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.parser.core.syntaxtree.Constraint;
import com.edb.gridsql.parser.core.syntaxtree.ForeignKeyDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForeignKeyHandler
extends ObjectDepthFirst {
    private XDBSessionContext client;
    private String foreignKeyConstraintName;
    private String foreignTableName;
    private SysTable foreignTable;
    private List<String> foreignconstraintColumnList;
    private List<String> localconstraintColumnList;
    private int unique = 0;

    public ForeignKeyHandler(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Object visit(Constraint constraint, Object object) {
        this.foreignKeyConstraintName = (String)constraint.f1.accept(new IdentifierHandler(), object);
        return null;
    }

    @Override
    public Object visit(ForeignKeyDef foreignKeyDef, Object object) {
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        foreignKeyDef.f2.accept(columnNameListHandler, null);
        this.localconstraintColumnList = columnNameListHandler.getColumnNameList();
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        foreignKeyDef.f5.accept(tableNameHandler, null);
        this.foreignTableName = tableNameHandler.getTableName();
        columnNameListHandler = new ColumnNameListHandler();
        foreignKeyDef.f7.accept(columnNameListHandler, null);
        this.foreignconstraintColumnList = columnNameListHandler.getColumnNameList();
        return null;
    }

    public void clearConstraintName() {
        this.foreignKeyConstraintName = null;
        ++this.unique;
    }

    public String getConstraintName() {
        if (this.foreignKeyConstraintName == null) {
            this.foreignKeyConstraintName = "FK_" + this.foreignTableName + "_" + this.unique;
        }
        return this.foreignKeyConstraintName;
    }

    public List<String> getLocalColumnNames() {
        return this.localconstraintColumnList;
    }

    public String getForeignTableName() {
        return this.foreignTableName;
    }

    public SysTable getForeignTable() {
        if (this.foreignTable == null) {
            this.foreignTable = this.client.getSysDatabase().getSysTable(this.foreignTableName);
        }
        return this.foreignTable;
    }

    public List<String> getForeignColumnNames() {
        return this.foreignconstraintColumnList;
    }

    public boolean isSoft(String string, PartitionMap partitionMap) {
        if (this.getForeignTable().isLookup()) {
            return false;
        }
        return !partitionMap.equals(this.getForeignTable().getPartitionMap()) || (string != null || this.getForeignTable().getPartitionColumn() != null) && (!this.localconstraintColumnList.get(0).equalsIgnoreCase(string) || !this.getForeignTable().isPartitionedColumn(this.foreignconstraintColumnList.get(0)));
    }
}

