/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.NoParentTreeException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.core.syntaxtree.IntoClause;
import com.edb.gridsql.parser.core.syntaxtree.LimitClause;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.OffsetClause;
import com.edb.gridsql.parser.core.syntaxtree.SelectWithoutOrder;
import com.edb.gridsql.parser.core.syntaxtree.SelectWithoutOrderAndSet;
import com.edb.gridsql.parser.core.syntaxtree.UnionSpec;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.core.visitor.ObjectVisitor;
import com.edb.gridsql.parser.handler.FromClauseHandler;
import com.edb.gridsql.parser.handler.GroupByClauseHandler;
import com.edb.gridsql.parser.handler.ProjectionListHandler;
import com.edb.gridsql.parser.handler.QCHelperColumnList;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.parser.handler.WhereClauseHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTreeHandler
extends ObjectDepthFirst {
    private static final XLogger logger = XLogger.getLogger(QueryTreeHandler.class);
    private Command commandToExecute;
    public static final int PROJECTION = 1;
    public static final int CONDITION = 2;
    public static final int HAVING = 3;
    public static final int ORDERBY = 4;
    public static final int GROUPBY = 5;
    private SysDatabase database = null;
    private static int genCount = 0;
    int unionType = 0;

    public QueryTreeHandler(Command command) {
        this.commandToExecute = command;
        this.database = MetaData.getMetaData().getSysDatabase(command.getDBName());
    }

    public static void checkAndExpand(List<SqlExpression> list, List<RelationNode> list2, SysDatabase sysDatabase, Command command) {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        List<SqlExpression> list3 = new ArrayList<SqlExpression>();
        for (SqlExpression sqlExpression : list) {
            if (sqlExpression.getExprType() == 512) {
                arrayList.add(sqlExpression);
            }
            if (sqlExpression.getExprType() == 32) {
                QueryTreeHandler.checkAndExpand(sqlExpression.getFunctionParams(), list2, sysDatabase, command);
                if (sqlExpression.getAlias() == null || sqlExpression.getAlias().equals("")) {
                    sqlExpression.setOuterAlias("EXPRESSION" + ++genCount);
                    sqlExpression.setAlias(sqlExpression.getOuterAlias());
                    if (sqlExpression.getExprType() == 32) {
                        sqlExpression.setProjectionLabel(sqlExpression.getFunctionName());
                    } else if (sqlExpression.getExprType() == 256) {
                        sqlExpression.setProjectionLabel("case");
                    }
                }
            }
            if (sqlExpression.getExprType() == 2 && (sqlExpression.getAlias() == null || sqlExpression.getAlias().equals(""))) {
                sqlExpression.setOuterAlias("EXPRESSION" + ++genCount);
                sqlExpression.setAlias(sqlExpression.getOuterAlias());
            }
            if (sqlExpression.getExprType() != 4 || sqlExpression.getColumn().getTableName() != null && (!sqlExpression.getColumn().getTableName().equals("") || sqlExpression.getColumn().getTableAlias().equals(""))) continue;
            arrayList.add(sqlExpression);
            if (sqlExpression.getAlias() != null && sqlExpression.getAlias().length() > 0) {
                sqlExpression.setProjectionLabel(sqlExpression.getAlias());
                continue;
            }
            sqlExpression.setProjectionLabel(sqlExpression.getColumn().getColumnName());
        }
        for (SqlExpression sqlExpression : arrayList) {
            if (sqlExpression.getExprString().equals("*")) {
                list3.clear();
                for (RelationNode n : list2) {
                    list3.addAll(QueryTreeHandler.populateProjectionList(n, sysDatabase));
                }
                list.addAll(list.indexOf(sqlExpression), list3);
                list.remove(sqlExpression);
                continue;
            }
            Object object3 = "";
            if (sqlExpression.getExprType() != 4) {
                int n = sqlExpression.getExprString().lastIndexOf(".");
                if (n < 0) {
                    throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
                }
                object3 = sqlExpression.getExprString().substring(0, n);
            } else {
                object3 = sqlExpression.getColumn().getTableAlias();
            }
            ArrayList<RelationNode> arrayList2 = new ArrayList<RelationNode>();
            for (RelationNode relationNode : list2) {
                Object object = object3;
                if (relationNode.getAlias() != null && relationNode.getAlias().equals(relationNode.getTableName())) {
                    if (relationNode.getAlias() == null || !relationNode.getAlias().equalsIgnoreCase((String)object)) continue;
                    arrayList2.add(relationNode);
                    continue;
                }
                if (!((String)object3).equalsIgnoreCase(relationNode.getAlias())) continue;
                arrayList2.add(relationNode);
            }
            if (arrayList2.size() < 1) {
                throw new XDBServerException(ErrorMessageRepository.TABLE_ALIAS_NOT_FOUND_FROM_CLAUSE + "(" + sqlExpression.getColumn().getTableAlias() + ")", 0, ErrorMessageRepository.TABLE_ALIAS_NOT_FOUND_FROM_CLAUSE_CODE);
            }
            if (arrayList2.size() > 1) {
                throw new XDBServerException(ErrorMessageRepository.TABLE_ALIAS_FOUND_AMBIGOUS + "( " + sqlExpression.getExprString() + " )", 0, ErrorMessageRepository.TABLE_ALIAS_FOUND_AMBIGOUS_CODE);
            }
            RelationNode relationNode = (RelationNode)arrayList2.get(0);
            if (sqlExpression.getExprType() == 512) {
                list3 = QueryTreeHandler.populateProjectionList(relationNode, sysDatabase);
                list.addAll(list.indexOf(sqlExpression), list3);
                list.remove(sqlExpression);
                continue;
            }
            if (sqlExpression.getExprType() != 4) continue;
            sqlExpression.getColumn().setTableName(relationNode.getTableName());
            sqlExpression.getColumn().setTableAlias(relationNode.getAlias());
            sqlExpression.getColumn().relationNode = relationNode;
        }
        Iterator<SqlExpression> iterator = list.iterator();
        while (iterator.hasNext()) {
            SqlExpression sqlExpression;
            sqlExpression = iterator.next();
            if (sqlExpression.getExprType() != 512) continue;
            iterator.remove();
        }
    }

    private static List<SqlExpression> populateProjectionList(RelationNode relationNode, SysDatabase sysDatabase) {
        ArrayList<SqlExpression> arrayList;
        block5: {
            block4: {
                arrayList = new ArrayList<SqlExpression>();
                if (relationNode.getNodeType() != 2) break block4;
                SysTable sysTable = sysDatabase.getSysTable(relationNode.getTableName());
                if (sysTable == null) {
                    throw new XDBServerException(ErrorMessageRepository.NO_TABLES_FOUND + " ( " + relationNode.getTableName() + "  ) ", 0, ErrorMessageRepository.NO_TABLE_FOUND_CODE);
                }
                for (SysColumn sysColumn : sysTable.getColumns()) {
                    String string = null;
                    String string2 = null;
                    if (sysColumn.getColName().equalsIgnoreCase("xrowid")) continue;
                    SqlExpression sqlExpression = SqlExpression.getSqlColumnExpression(sysColumn.getColName(), sysTable.getTableName(), relationNode.getAlias(), string, string2);
                    sqlExpression.getColumn().relationNode = relationNode;
                    sqlExpression.setProjectionLabel(sysColumn.getColName());
                    arrayList.add(sqlExpression);
                    relationNode.getProjectionList().add(sqlExpression);
                }
                break block5;
            }
            if (relationNode.getNodeType() != 4) break block5;
            for (SqlExpression sqlExpression : relationNode.getSubqueryTree().getProjectionList()) {
                SqlExpression sqlExpression2 = new SqlExpression();
                if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
                    // empty if block
                }
                sqlExpression2.setExprType(4);
                sqlExpression2.setMapped(2);
                sqlExpression2.setMappedExpression(sqlExpression);
                sqlExpression2.setColumn(new AttributeColumn());
                sqlExpression2.getColumn().columnGenre |= 4;
                sqlExpression2.getColumn().relationNode = relationNode;
                sqlExpression2.setProjectionLabel(sqlExpression.getProjectionLabel());
                QueryTreeHandler.fillColumnExpression(relationNode, sqlExpression2, sqlExpression);
                arrayList.add(sqlExpression2);
            }
        }
        return arrayList;
    }

    private static void fillColumnExpression(RelationNode relationNode, SqlExpression sqlExpression, SqlExpression sqlExpression2) {
        if (sqlExpression.getMapped() != 1) {
            if (relationNode.getAlias() != null && !relationNode.getAlias().equals("")) {
                if (sqlExpression2.getColumn() != null) {
                    sqlExpression.getColumn().setTableAlias(sqlExpression2.getColumn().getTableAlias());
                    sqlExpression.getColumn().setTableName(sqlExpression2.getColumn().getTableAlias());
                } else {
                    sqlExpression.getColumn().setTableAlias(relationNode.getAlias());
                    sqlExpression.getColumn().setTableName(relationNode.getAlias());
                }
            }
        } else {
            sqlExpression.setExprDataType(sqlExpression2.getExprDataType());
            sqlExpression.setExprString(sqlExpression2.getExprString());
            sqlExpression.setAlias(sqlExpression2.getOuterAlias());
            if (sqlExpression2.getColumn() != null && (sqlExpression2.getColumn().columnAlias == null || sqlExpression2.getColumn().columnAlias.equals("") || sqlExpression2.getColumn().columnName.equals(sqlExpression2.getColumn().columnAlias))) {
                sqlExpression.setColumn(sqlExpression2.getColumn());
            }
        }
        if (sqlExpression2.getOuterAlias() == null || sqlExpression2.getOuterAlias().equals("") || sqlExpression.getMapped() != 2) {
            if (sqlExpression2.getAlias() == null || sqlExpression2.getAlias().equals("")) {
                if (sqlExpression2.getExprType() == 4) {
                    if (sqlExpression2.getColumn().columnAlias != null && !sqlExpression2.getColumn().columnAlias.equals("")) {
                        sqlExpression.getColumn().columnAlias = sqlExpression.getColumn().columnName = sqlExpression2.getColumn().columnAlias;
                        sqlExpression.setAlias(sqlExpression2.getColumn().columnAlias);
                    } else {
                        sqlExpression.getColumn().columnName = sqlExpression2.getColumn().columnName;
                        sqlExpression.setAlias(sqlExpression2.getColumn().columnName);
                        sqlExpression.getColumn().columnAlias = sqlExpression.getColumn().columnName;
                    }
                } else {
                    sqlExpression.setOuterAlias("EXPRESSION" + ++genCount);
                    if (sqlExpression2.getOuterAlias() != null && !sqlExpression2.getOuterAlias().equals("")) {
                        sqlExpression.setAlias(sqlExpression2.getOuterAlias());
                        sqlExpression.getColumn().columnName = sqlExpression2.getOuterAlias();
                    } else {
                        sqlExpression.setAlias(sqlExpression.getOuterAlias());
                        sqlExpression.getColumn().columnName = sqlExpression.getOuterAlias();
                    }
                    sqlExpression.getColumn().columnAlias = sqlExpression.getColumn().columnName;
                }
            } else {
                sqlExpression.setAlias(sqlExpression2.getAlias());
                if (sqlExpression2.getColumn() != null) {
                    sqlExpression.getColumn().columnName = sqlExpression2.getColumn().columnName;
                    sqlExpression.getColumn().columnAlias = sqlExpression2.getColumn().columnAlias;
                }
            }
        } else {
            if (sqlExpression.getAlias() == null || sqlExpression.getAlias().equals("")) {
                sqlExpression.setAlias(sqlExpression2.getOuterAlias());
            }
            sqlExpression.getColumn().columnAlias = sqlExpression.getColumn().columnName = sqlExpression2.getOuterAlias();
        }
    }

    @Override
    public Object visit(LimitClause limitClause, Object object) {
        QueryTree queryTree = (QueryTree)object;
        if (limitClause.f1.which == 0) {
            queryTree.setLimit(new Integer(((NodeToken)limitClause.f1.choice).tokenImage).longValue());
        }
        return null;
    }

    @Override
    public Object visit(IntoClause intoClause, Object object) {
        QueryTree queryTree = (QueryTree)object;
        TableNameHandler tableNameHandler = new TableNameHandler(this.commandToExecute.getClientContext());
        intoClause.f3.accept(tableNameHandler, object);
        queryTree.setIntoTable(tableNameHandler.getTableName(), tableNameHandler.getTableName(), intoClause.f1.present());
        return null;
    }

    @Override
    public Object visit(OffsetClause offsetClause, Object object) {
        QueryTree queryTree = (QueryTree)object;
        queryTree.setOffset(new Integer(offsetClause.f1.tokenImage).longValue());
        return null;
    }

    @Override
    public Object visit(SelectWithoutOrder selectWithoutOrder, Object object) {
        QueryTree queryTree = (QueryTree)object;
        selectWithoutOrder.f0.accept(this, queryTree);
        if (selectWithoutOrder.f1.present()) {
            queryTree.setHasUnion(true);
            for (NodeSequence nodeSequence : selectWithoutOrder.f1.nodes) {
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.nodes.elementAt(1);
                NodeChoice nodeChoice = (NodeChoice)nodeSequence.nodes.elementAt(2);
                QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
                this.unionType = nodeOptional.present() ? 2 : 1;
                QueryTree queryTree2 = new QueryTree();
                switch (nodeChoice.which) {
                    case 0: {
                        queryTree2.setUnionType(this.unionType);
                        nodeChoice.accept(queryTreeHandler, queryTree2);
                        queryTree.getUnionQueryTreeList().add(queryTree2);
                        break;
                    }
                    case 1: {
                        queryTree2.setUnionType(this.unionType);
                        nodeChoice.accept(queryTreeHandler, queryTree2);
                        queryTree.getUnionQueryTreeList().add(queryTree2);
                        break;
                    }
                }
            }
        } else {
            this.unionType = 0;
        }
        return null;
    }

    @Override
    public Object visit(UnionSpec unionSpec, Object object) {
        unionSpec.f1.accept(this, object);
        return null;
    }

    @Override
    public Object visit(SelectWithoutOrderAndSet selectWithoutOrderAndSet, Object object) {
        Object object3;
        QueryTreeTracker queryTreeTracker = this.commandToExecute.getaQueryTreeTracker();
        QueryTree queryTree = (QueryTree)object;
        queryTreeTracker.registerTree(queryTree);
        if (selectWithoutOrderAndSet.f1.present()) {
            switch (((NodeChoice)selectWithoutOrderAndSet.f1.node).which) {
                case 0: {
                    queryTree.setDistinct(false);
                    break;
                }
                case 1: {
                    queryTree.setDistinct(true);
                    break;
                }
                case 2: {
                    queryTree.setDistinct(true);
                }
            }
        }
        if (queryTree.isPartOfExistClause()) {
            queryTree.getProjectionList().clear();
            object3 = new SqlExpression();
            ((SqlExpression)object3).setExprType(2);
            ((SqlExpression)object3).setConstantValue("1");
            queryTree.getProjectionList().add((SqlExpression)object3);
        } else {
            object3 = new ProjectionListHandler(this.commandToExecute);
            selectWithoutOrderAndSet.f2.accept((ObjectVisitor)object3, queryTree);
        }
        selectWithoutOrderAndSet.f3.accept(this, queryTree);
        if (selectWithoutOrderAndSet.f4.present()) {
            object3 = new FromClauseHandler(this.commandToExecute);
            selectWithoutOrderAndSet.f4.accept((ObjectVisitor)object3, queryTree);
        } else {
            object3 = queryTree.newRelationNode();
            ((RelationNode)object3).setNodeType(1);
            ((RelationNode)object3).setClient(this.commandToExecute.getClientContext());
        }
        for (QueryCondition object22 : queryTree.getFromClauseConditions()) {
            QueryTreeHandler.processWhereCondition(object22, queryTree, this.commandToExecute.getaQueryTreeTracker(), this.database, true);
        }
        QueryTreeHandler.checkAndExpand(queryTree.getProjectionList(), queryTree.getRelationNodeList(), this.database, this.commandToExecute);
        for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
            QueryTreeHandler.SetBelongsToTree(sqlExpression, queryTree);
        }
        object3 = QueryTreeHandler.checkAndFillTableNames(queryTree.getProjectionList(), queryTree.getRelationNodeList(), new Vector<SqlExpression>(), 1, this.commandToExecute.getaQueryTreeTracker(), this.database);
        queryTree.getSelectOrphans().addAll((Collection<SqlExpression>)object3);
        WhereClauseHandler whereClauseHandler = new WhereClauseHandler(this.commandToExecute);
        selectWithoutOrderAndSet.f5.accept(whereClauseHandler, queryTree);
        QueryCondition queryCondition = queryTree.getWhereRootCondition();
        if (queryTree.getWhereRootCondition() != null) {
            QueryTreeHandler.ProcessWhereCondition(queryCondition, queryTree, this.commandToExecute.getaQueryTreeTracker(), this.database);
        }
        GroupByClauseHandler groupByClauseHandler = new GroupByClauseHandler(this.commandToExecute);
        selectWithoutOrderAndSet.f6.accept(groupByClauseHandler, queryTree);
        selectWithoutOrderAndSet.f7.accept(groupByClauseHandler, queryTree);
        queryTree.setGroupByList(groupByClauseHandler.expressionList);
        for (SqlExpression sqlExpression : queryTree.getGroupByList()) {
            QueryTreeHandler.SetBelongsToTree(sqlExpression, queryTree);
        }
        queryTree.setHavingList(groupByClauseHandler.havingList);
        QueryTreeHandler.checkAndExpand(queryTree.getGroupByList(), queryTree.getRelationNodeList(), this.database, this.commandToExecute);
        queryTree.setGroupByList(this.replaceExpressionsFromList(queryTree.getProjectionList(), queryTree.getGroupByList()));
        QueryTreeHandler.checkAndFillTableNames(queryTree.getGroupByList(), queryTree.getRelationNodeList(), queryTree.getProjectionList(), 5, this.commandToExecute.getaQueryTreeTracker(), this.database);
        if (queryTree.getHavingList().size() > 0) {
            QueryCondition queryCondition2 = queryTree.getHavingList().get(0);
            QueryTreeHandler.setBelongsToTree(queryCondition2, queryTree);
            QueryTreeHandler.checkAndFillQueryConditionColumns(queryTree.getHavingList().get(0), queryTree.getRelationNodeList(), queryTree.getProjectionList(), 3, this.commandToExecute.getaQueryTreeTracker(), this.database);
        }
        QueryTreeHandler.FillAllExprDataTypes(queryTree, MetaData.getMetaData().getSysDatabase(this.commandToExecute.getDBName()));
        queryTree.setContainsAggregates(QueryTreeHandler.isAggregateQuery(queryTree));
        this.rebuildAllExpressions(queryTree);
        this.manageFromSubQuery(queryTree);
        QueryTreeHandler.setOwnerShipColumns(queryTree);
        queryTreeTracker.deRegisterCurrentTree();
        return queryTree;
    }

    private String findNonAggregatedColumn(SqlExpression sqlExpression) {
        String string;
        block7: {
            block8: {
                block6: {
                    string = null;
                    if (sqlExpression.getExprType() != 4) break block6;
                    string = sqlExpression.getColumn().columnName;
                    break block7;
                }
                if (sqlExpression.getExprType() != 16) break block8;
                if (sqlExpression.getLeftExpr() != null) {
                    string = this.findNonAggregatedColumn(sqlExpression.getLeftExpr());
                }
                if (string != null || sqlExpression.getRightExpr() == null) break block7;
                string = this.findNonAggregatedColumn(sqlExpression.getRightExpr());
                break block7;
            }
            if (sqlExpression.getExprType() == 256) {
                SqlExpression sqlExpression2;
                Iterator<SqlExpression> iterator = sqlExpression.getCaseConstruct().getSQLExpressions().iterator();
                while (iterator.hasNext() && (string = this.findNonAggregatedColumn(sqlExpression2 = iterator.next())) == null) {
                }
            } else if (sqlExpression.getExprType() == 32 && !sqlExpression.isAggregateExpression()) {
                SqlExpression sqlExpression3;
                Iterator<SqlExpression> iterator = sqlExpression.getFunctionParams().iterator();
                while (iterator.hasNext() && (string = this.findNonAggregatedColumn(sqlExpression3 = iterator.next())) == null) {
                }
            }
        }
        return string;
    }

    private List<SqlExpression> replaceExpressionsFromList(List<SqlExpression> list, List<SqlExpression> list2) throws XDBServerException {
        if (list2 == null) {
            return null;
        }
        if (list2.isEmpty()) {
            boolean bl = false;
            Object object = null;
            for (SqlExpression sqlExpression : list) {
                if (!bl && sqlExpression.containsAggregates()) {
                    bl = true;
                }
                if (object != null) continue;
                object = this.findNonAggregatedColumn(sqlExpression);
            }
            if (bl && object != null) {
                throw new XDBServerException("column " + (String)object + " must appear in the GROUP BY clause or be used in an aggregate function");
            }
        }
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        for (SqlExpression sqlExpression : list2) {
            if (sqlExpression.isConstantExpr()) {
                Integer n;
                try {
                    n = new Integer(sqlExpression.getConstantValue());
                }
                catch (Exception exception) {
                    throw new XDBServerException("ERROR: non-integer constant in list.");
                }
                if (n < 0 || n > list.size()) {
                    throw new XDBServerException("ERROR: position " + n + " is not in select list");
                }
                arrayList.add(list.get(n - 1));
                continue;
            }
            arrayList.add(sqlExpression);
        }
        return arrayList;
    }

    public static void setOwnerShipColumns(QueryTree queryTree) {
    }

    public static void ProcessWhereCondition(QueryCondition queryCondition, QueryTree queryTree, QueryTreeTracker queryTreeTracker, SysDatabase sysDatabase) {
        QueryTreeHandler.processWhereCondition(queryCondition, queryTree, queryTreeTracker, sysDatabase, false);
    }

    public static void processWhereCondition(QueryCondition queryCondition, QueryTree queryTree, QueryTreeTracker queryTreeTracker, SysDatabase sysDatabase, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Vector<QueryCondition> vector;
        queryCondition.setParent(null);
        queryCondition.rebuildString();
        QueryTreeHandler.setBelongsToTree(queryCondition, queryTree);
        CAnalyzeAndCompleteColInfoAndNodeInfo cAnalyzeAndCompleteColInfoAndNodeInfo = QueryTreeHandler.checkAndFillQueryConditionColumns(queryCondition, queryTree.getRelationNodeList(), queryTree.getProjectionList(), 2, queryTreeTracker, sysDatabase);
        queryTree.setWhereOrphans(cAnalyzeAndCompleteColInfoAndNodeInfo.orphanExpressionVector);
        if (cAnalyzeAndCompleteColInfoAndNodeInfo.orphanExpressionVector.size() > 0) {
            vector = queryTree.newRelationNode();
            ((RelationNode)((Object)vector)).setTableName("PsuedoTable");
            ((RelationNode)((Object)vector)).setAlias("PsuedoTable");
            ((RelationNode)((Object)vector)).setNodeType(7);
            queryTree.setPseudoRelationNode((RelationNode)((Object)vector));
            for (SqlExpression object42 : cAnalyzeAndCompleteColInfoAndNodeInfo.orphanExpressionVector) {
                ((RelationNode)((Object)vector)).getCondColumnList().add(object42.getColumn());
                object3 = null;
                object2 = null;
                object = object42.getColumn().getParentQueryCondition();
                if (((QueryCondition)object).getLeftCond().getExpr().containsColumn(object42.getColumn())) {
                    object3 = ((QueryCondition)object).getRightCond();
                    object2 = ((QueryCondition)object).getLeftCond();
                } else {
                    object3 = ((QueryCondition)object).getLeftCond();
                    object2 = ((QueryCondition)object).getRightCond();
                }
                if (((QueryCondition)object3).getExpr().getExprType() == 4) {
                    ((QueryCondition)object3).getExpr().getColumn().relationNode.getProjectionList().add(((QueryCondition)object3).getExpr());
                    queryTree.getHiddenProjectionList().add(((QueryCondition)object3).getExpr());
                } else if (((QueryCondition)object3).getExpr().getExprType() == 16 || ((QueryCondition)object3).getExpr().getExprType() == 32 || ((QueryCondition)object3).getExpr().getExprType() == 256 || ((QueryCondition)object3).getExpr().getExprType() == 64 || ((QueryCondition)object3).getExpr().getExprType() == 128) {
                    for (SqlExpression sqlExpression : SqlExpression.getNodes(((QueryCondition)object3).getExpr(), 4)) {
                        sqlExpression.getColumn().relationNode.getProjectionList().add(sqlExpression);
                        queryTree.getHiddenProjectionList().add(sqlExpression);
                    }
                } else if (((QueryCondition)object3).getExpr().getExprType() == 2 || ((QueryCondition)object3).getExpr().getExprType() == 512 || ((QueryCondition)object3).getExpr().getExprType() == 512) {
                    // empty if block
                }
                if (((QueryCondition)object2).getExpr().getExprType() != 16 && ((QueryCondition)object2).getExpr().getExprType() != 32 && ((QueryCondition)object2).getExpr().getExprType() != 256 && ((QueryCondition)object2).getExpr().getExprType() != 64 && ((QueryCondition)object2).getExpr().getExprType() != 128) continue;
                for (SqlExpression sqlExpression : SqlExpression.getNodes(((QueryCondition)object2).getExpr(), 4)) {
                    if (object42.getColumn().getTableName().equalsIgnoreCase(sqlExpression.getColumn().getTableName())) continue;
                    sqlExpression.getColumn().relationNode.getProjectionList().add(sqlExpression);
                    queryTree.getHiddenProjectionList().add(sqlExpression);
                }
            }
        }
        vector = new Vector();
        if (bl && queryTree.isOuterJoin()) {
            vector.add(queryCondition);
        } else {
            vector = QueryTreeHandler.getTopLevelQueryConditions(queryCondition);
        }
        Enumeration<QueryCondition> enumeration = vector.elements();
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            object3 = (QueryCondition)enumeration.nextElement();
            ((QueryCondition)object3).setRelationNodeList(QueryTreeHandler.getRelationNodes((QueryCondition)object3));
            object2 = QueryTreeHandler.getQueryColumnList((QueryCondition)object3);
            object = ((QCHelperColumnList)object2).getColumnExprListThisTree().elements();
            while (object.hasMoreElements()) {
                AttributeColumn attributeColumn = (AttributeColumn)object.nextElement();
                if (attributeColumn.getMyParentTree() != ((QueryCondition)object3).getParentQueryTree()) continue;
                ((QueryCondition)object3).getColumnList().add(attributeColumn);
            }
        }
        vector.removeAll(vector2);
        object3 = QueryTreeHandler.segregateIntoSimpleAndJoinConditions(vector);
        if (((SegregateJoinHelper)object3).joinQConditionVector != null) {
            queryTree.getConditionList().addAll(((SegregateJoinHelper)object3).joinQConditionVector);
        }
        if (((SegregateJoinHelper)object3).joinQConditionVector != null && ((SegregateJoinHelper)object3).joinQConditionVector.size() > 0) {
            QueryTreeHandler.populateJoinExpressionCrossReference(((SegregateJoinHelper)object3).joinQConditionVector);
        }
        object2 = null;
        if (((SegregateJoinHelper)object3).nonjoinQConditionVector != null && ((SegregateJoinHelper)object3).nonjoinQConditionVector.size() > 0) {
            object2 = ((SegregateJoinHelper)object3).nonjoinQConditionVector;
            object = QueryTreeHandler.getSimpleExprForQueryTree((Vector)object2);
            queryTree.getConditionList().addAll((Collection<QueryCondition>)object);
            ((Vector)object2).removeAll((Collection<?>)object);
            QueryTreeHandler.addToNodesSimpleQueryCondition((Vector)object2, queryTree);
        }
    }

    public static void setBelongsToTree(QueryCondition queryCondition, QueryTree queryTree) {
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 30);
        Enumeration<QueryCondition> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            QueryCondition queryCondition2 = enumeration.nextElement();
            queryCondition2.setParentQueryTree(queryTree);
            if (queryCondition2.getCondType() != 4) continue;
            if (queryCondition2.getExpr().getExprType() == 64) {
                queryCondition2.getExpr().getSubqueryTree().setParentQueryTree(queryTree);
            }
            QueryTreeHandler.SetBelongsToTree(queryCondition2.getExpr(), queryTree);
        }
        for (QueryCondition queryCondition3 : QueryCondition.getNodes(queryCondition, 4)) {
            QueryCondition queryCondition4 = queryCondition3.getParentQueryCondition();
            for (SqlExpression sqlExpression : SqlExpression.getNodes(queryCondition3.getExpr(), 4)) {
                sqlExpression.getColumn().setMyParentTree(queryTree);
                sqlExpression.getColumn().setParentQueryCondition(queryCondition4);
            }
        }
    }

    public static void SetBelongsToTree(SqlExpression sqlExpression, QueryTree queryTree) {
        Vector<SqlExpression> vector = SqlExpression.getNodes(sqlExpression, 958);
        Enumeration<SqlExpression> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SqlExpression sqlExpression2 = enumeration.nextElement();
            SqlExpression sqlExpression3 = sqlExpression2;
            if ((sqlExpression3.getExprType() & 0x40) > 0) {
                sqlExpression3.getSubqueryTree().setParentQueryTree(queryTree);
            }
            sqlExpression3.setBelongsToTree(queryTree);
        }
    }

    void rebuildAllExpressions(QueryTree queryTree) {
        for (SqlExpression object : queryTree.getProjectionList()) {
            object.rebuildExpression();
        }
        for (SqlExpression sqlExpression : queryTree.getGroupByList()) {
            sqlExpression.rebuildExpression();
        }
        if (queryTree.getHavingList().size() > 0) {
            QueryCondition queryCondition = queryTree.getHavingList().get(0);
            Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 4);
            Enumeration<QueryCondition> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                QueryCondition queryCondition2 = enumeration.nextElement();
                SqlExpression sqlExpression = queryCondition2.getExpr();
                sqlExpression.rebuildExpression();
            }
        }
    }

    public static boolean isAggregateQuery(QueryTree queryTree) {
        if (queryTree.getGroupByList().size() > 0) {
            return true;
        }
        for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
            for (SqlExpression sqlExpression2 : SqlExpression.getNodes(sqlExpression, 32)) {
                if (!sqlExpression2.containsAggregates()) continue;
                return true;
            }
        }
        return false;
    }

    public static void FillAllExprDataTypes(QueryTree queryTree, SysDatabase sysDatabase) {
        Object object;
        SysTable sysTable = null;
        SysColumn sysColumn = null;
        for (SqlExpression object2 : queryTree.getProjectionList()) {
            object2.setExprDataType(SqlExpression.setExpressionResultType(object2, sysDatabase));
            if (object2.getColumn() == null || (sysTable = sysDatabase.checkForSysTable(object2.getColumn().getTableName())) == null || (sysColumn = sysTable.getSysColumn(object2.getColumn().getColumnName())) == null || !sysColumn.isWithTimeZone) continue;
            object2.getExprDataType().isWithTimeZone = true;
        }
        for (SqlExpression sqlExpression : queryTree.getGroupByList()) {
            sqlExpression.setExprDataType(SqlExpression.setExpressionResultType(sqlExpression, sysDatabase));
        }
        for (QueryCondition queryCondition : queryTree.getHavingList()) {
            for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                object = queryCondition2.getExpr();
                ((SqlExpression)object).setExprDataType(SqlExpression.setExpressionResultType((SqlExpression)object, sysDatabase));
            }
        }
        for (QueryCondition queryCondition : queryTree.getFromClauseConditions()) {
            for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                object = queryCondition2.getExpr();
                ((SqlExpression)object).setExprDataType(SqlExpression.setExpressionResultType((SqlExpression)object, sysDatabase));
            }
        }
        if (queryTree.getWhereRootCondition() != null) {
            Object object2;
            Object object4;
            if ((queryTree.getWhereRootCondition().getCondType() & 2) == 2 && queryTree.getWhereRootCondition().getACompositeClause().getCompareExpressionQueryCondition() != null) {
                object4 = queryTree.getWhereRootCondition().getACompositeClause();
                QueryCondition queryCondition = ((QueryCondition.CompositeCondition)object4).getCompareExpressionQueryCondition();
                object2 = ((QueryCondition.CompositeCondition)object4).getExpressionConditionList();
                if (queryCondition.getCondType() == 4) {
                    int n = 0;
                    if (queryCondition.getExpr().getExprType() == 4) {
                        queryCondition.getExpr().getColumn().columnType = queryCondition.getExpr().getColumn().getColumnType(sysDatabase);
                        n = queryCondition.getExpr().getColumn().columnType.type;
                    }
                    if (queryCondition.getExpr().getExprDataType() != null) {
                        n = queryCondition.getExpr().getExprDataType().type;
                    }
                    if (n == 91 || n == 92 || n == 93) {
                        object = object2.iterator();
                        while (object.hasNext()) {
                            QueryCondition queryCondition3 = (QueryCondition)object.next();
                            QueryCondition queryCondition4 = queryCondition3;
                            if (queryCondition4.getCondType() != 4 || queryCondition4.getExpr().getExprType() != 2) continue;
                            switch (n) {
                                case 92: {
                                    queryCondition4.getExpr().setConstantValue(SqlExpression.normalizeTime(queryCondition4.getExpr().getConstantValue()));
                                    break;
                                }
                                case 93: {
                                    queryCondition4.getExpr().setConstantValue(SqlExpression.normalizeTimeStamp(queryCondition4.getExpr().getConstantValue()));
                                    break;
                                }
                                case 91: {
                                    queryCondition4.getExpr().setConstantValue(SqlExpression.normalizeDate(queryCondition4.getExpr().getConstantValue()));
                                    break;
                                }
                            }
                            SqlExpression sqlExpression = queryCondition4.getExpr();
                            queryCondition4.getExpr();
                            sqlExpression.setExprDataType(SqlExpression.setExpressionResultType(queryCondition4.getExpr(), sysDatabase));
                        }
                    }
                    SqlExpression sqlExpression = queryCondition.getExpr();
                    queryCondition.getExpr();
                    sqlExpression.setExprDataType(SqlExpression.setExpressionResultType(queryCondition.getExpr(), sysDatabase));
                }
            } else {
                object4 = QueryCondition.getNodes(queryTree.getWhereRootCondition(), 4);
                Enumeration enumeration = ((Vector)object4).elements();
                while (enumeration.hasMoreElements()) {
                    object2 = ((QueryCondition)enumeration.nextElement()).getExpr();
                    if (((SqlExpression)object2).getColumn() != null) {
                        ((SqlExpression)object2).getColumn().columnType = ((SqlExpression)object2).getColumn().getColumnType(sysDatabase);
                        if (((SqlExpression)object2).getColumn().columnType.type == 91 || ((SqlExpression)object2).getColumn().columnType.type == 92 || ((SqlExpression)object2).getColumn().columnType.type == 93) {
                            ((SqlExpression)object2).getColumn().setParentQueryCondition(QueryTreeHandler.normalizeExpr(((SqlExpression)object2).getColumn().getParentQueryCondition(), ((SqlExpression)object2).getColumn().columnType.type));
                        }
                    }
                    ((SqlExpression)object2).setExprDataType(SqlExpression.setExpressionResultType((SqlExpression)object2, sysDatabase));
                }
            }
        }
    }

    protected void analyzeFromAndProjectionList(QueryTree queryTree) {
        List<RelationNode> list = queryTree.getRelationNodeList();
        if (queryTree.getProjectionList() == null || list == null) {
            throw new XDBServerException(ErrorMessageRepository.QUERY_PROJ_LIST_EMPTY, 0, ErrorMessageRepository.QUERY_PROJ_LIST_EMPTY_CODE);
        }
        for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
            Vector<SqlExpression> vector = SqlExpression.getNodes(sqlExpression, 4);
            if (vector == null || vector.size() <= 0) continue;
            Enumeration<SqlExpression> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SqlExpression sqlExpression2 = enumeration.nextElement();
                AttributeColumn attributeColumn = sqlExpression2.getColumn();
                if (attributeColumn.columnName == null) {
                    throw new XDBServerException(ErrorMessageRepository.NULL_COLUMN_NAME, 0, ErrorMessageRepository.NULL_COLUMN_NAME_CODE);
                }
                RelationNode relationNode = QueryTreeHandler.getTableRelationNode(sqlExpression2, list, this.database);
                if (relationNode == null) continue;
                relationNode.getProjectionList().add(sqlExpression2);
                attributeColumn.setTableName(relationNode.getTableName());
            }
        }
    }

    @Override
    public Object visit(NodeToken nodeToken, Object object) {
        QueryTree queryTree = (QueryTree)object;
        switch (nodeToken.kind) {
            case 128: {
                queryTree.setDistinct(false);
                break;
            }
            case 14: {
                queryTree.setDistinct(true);
                break;
            }
            case 129: {
                queryTree.setDistinct(true);
                break;
            }
        }
        return null;
    }

    public static List<SqlExpression> checkAndFillTableNames(List<SqlExpression> list, List<RelationNode> list2, List<SqlExpression> list3, int n, QueryTreeTracker queryTreeTracker, SysDatabase sysDatabase) {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        Iterator<SqlExpression> iterator = list.iterator();
        while (iterator.hasNext()) {
            CAnalyzeAndCompleteColInfoAndNodeInfo cAnalyzeAndCompleteColInfoAndNodeInfo = QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(iterator, list2, list3, n, queryTreeTracker, sysDatabase);
            arrayList.addAll(cAnalyzeAndCompleteColInfoAndNodeInfo.orphanExpressionVector);
        }
        return arrayList;
    }

    public static CAnalyzeAndCompleteColInfoAndNodeInfo analyzeAndCompleteColInfoAndNodeInfo(Iterator<SqlExpression> iterator, List<RelationNode> list, List<SqlExpression> list2, int n, QueryTreeTracker queryTreeTracker, SysDatabase sysDatabase) {
        CAnalyzeAndCompleteColInfoAndNodeInfo cAnalyzeAndCompleteColInfoAndNodeInfo = new CAnalyzeAndCompleteColInfoAndNodeInfo();
        while (iterator.hasNext()) {
            SqlExpression sqlExpression = iterator.next();
            Vector<SqlExpression> vector = SqlExpression.getNodes(sqlExpression, 4);
            Enumeration<SqlExpression> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SqlExpression sqlExpression2;
                Object object;
                IRebuildString iRebuildString;
                Enumeration enumeration2;
                SqlExpression sqlExpression3 = enumeration.nextElement();
                if (sqlExpression3.getColumn() == null) {
                    throw new XDBServerException(ErrorMessageRepository.NULL_COLUMN_NAME, 0, ErrorMessageRepository.NULL_COLUMN_NAME_CODE);
                }
                AttributeColumn attributeColumn = sqlExpression3.getColumn();
                if (attributeColumn.columnName == null || attributeColumn.columnName.equals("")) {
                    throw new XDBServerException(ErrorMessageRepository.NULL_COLUMN_NAME, 0, ErrorMessageRepository.NULL_COLUMN_NAME_CODE);
                }
                try {
                    Object object2;
                    if (n == 4 || n == 5 || n == 3) {
                        object2 = new Vector();
                        enumeration2 = list2.iterator();
                        while (enumeration2.hasNext()) {
                            iRebuildString = (SqlExpression)enumeration2.next();
                            object = ((SqlExpression)iRebuildString).getColumn();
                            if (object == attributeColumn) {
                                ((Vector)object2).clear();
                                break;
                            }
                            if (!((SqlExpression)iRebuildString).getAlias().equals(attributeColumn.columnName) && (object == null || !((AttributeColumn)object).columnName.equalsIgnoreCase(attributeColumn.columnName) || !((AttributeColumn)object).getTableName().equalsIgnoreCase(attributeColumn.getTableName()))) continue;
                            ((Vector)object2).add(iRebuildString);
                        }
                        if (((Vector)object2).size() > 1) {
                            enumeration2 = ((Vector)object2).elements();
                            iRebuildString = null;
                            object = false;
                            while (enumeration2.hasMoreElements()) {
                                sqlExpression2 = (SqlExpression)enumeration2.nextElement();
                                if (sqlExpression2.getExprType() != 4) continue;
                                if (iRebuildString == null) {
                                    iRebuildString = sqlExpression2.getColumn().relationNode;
                                    if (!sqlExpression2.getAlias().equalsIgnoreCase(attributeColumn.columnAlias)) continue;
                                    object = true;
                                    continue;
                                }
                                if (!((RelationNode)iRebuildString).getTableAlis().equals(sqlExpression2.getColumn().relationNode.getTableAlis()) || !((RelationNode)iRebuildString).getTableName().equals(sqlExpression2.getColumn().relationNode.getTableName())) continue;
                                if (!((Boolean)object).booleanValue() && sqlExpression2.getAlias().equalsIgnoreCase(attributeColumn.columnAlias)) {
                                    iRebuildString = sqlExpression2.getColumn().relationNode;
                                    object = true;
                                    continue;
                                }
                                if (((Boolean)object).booleanValue() && !sqlExpression2.getAlias().equalsIgnoreCase(attributeColumn.columnAlias)) continue;
                                throw new XDBServerException(ErrorMessageRepository.AMBIGIOUS_COLUMN_REF + "( " + attributeColumn.columnName + " )", 0, ErrorMessageRepository.AMBIGIOUS_COLUMN_REF_CODE);
                            }
                            if (iRebuildString == null) {
                                sqlExpression2 = null;
                                enumeration2 = ((Vector)object2).elements();
                                while (enumeration2.hasMoreElements()) {
                                    SqlExpression sqlExpression4 = (SqlExpression)enumeration2.nextElement();
                                    if (sqlExpression4.getExprType() != 32) continue;
                                    if (sqlExpression2 == null && sqlExpression4 != sqlExpression3) {
                                        sqlExpression2 = sqlExpression4;
                                        if (sqlExpression4.isAlliasSameAsColumnNameInFunction(attributeColumn)) continue;
                                        attributeColumn.columnType = sqlExpression4.getExprDataType();
                                        attributeColumn.columnGenre |= 4;
                                        SqlExpression.copy(sqlExpression4, sqlExpression3);
                                        sqlExpression3.setMapped(1);
                                        sqlExpression3.setMappedExpression(sqlExpression4);
                                        continue;
                                    }
                                    if (sqlExpression2.isSameFunction(sqlExpression4)) continue;
                                    throw new XDBServerException(ErrorMessageRepository.AMBIGIOUS_COLUMN_REF + "( " + attributeColumn.columnName + " )", 0, ErrorMessageRepository.AMBIGIOUS_COLUMN_REF_CODE);
                                }
                            }
                        } else if (!(((Vector)object2).size() != 1 || ((SqlExpression)((Object)(enumeration2 = (SqlExpression)((Vector)object2).elementAt(0)))).isAlliasSameAsColumnNameInFunction(attributeColumn) && n != 4 || enumeration2 == sqlExpression3)) {
                            attributeColumn.columnType = ((SqlExpression)((Object)enumeration2)).getExprDataType();
                            attributeColumn.columnGenre |= 4;
                            SqlExpression.copy(enumeration2, sqlExpression3);
                            sqlExpression3.setMapped(1);
                            sqlExpression3.setMappedExpression((SqlExpression)((Object)enumeration2));
                        }
                    }
                    if ((attributeColumn.columnGenre & 4) != 0) continue;
                    object2 = QueryTreeHandler.getTableRelationNode(sqlExpression3, list, sysDatabase);
                    if (object2 != null) {
                        if (!cAnalyzeAndCompleteColInfoAndNodeInfo.nodeListInExpression.contains(object2)) {
                            cAnalyzeAndCompleteColInfoAndNodeInfo.nodeListInExpression.add(object2);
                        }
                        if (1 == n || 4 == n) {
                            if (!(((RelationNode)object2).getProjectionList().contains(sqlExpression) || sqlExpression.getExprType() == 4 && (sqlExpression.getColumn().columnGenre & 4) == 4 || ((RelationNode)object2).getProjectionList().contains(sqlExpression3))) {
                                ((RelationNode)object2).getProjectionList().add(sqlExpression3);
                            }
                        } else if (2 == n) {
                            if (!((RelationNode)object2).getCondColumnList().contains(attributeColumn) && !((RelationNode)object2).getCondColumnList().contains(attributeColumn)) {
                                ((RelationNode)object2).getCondColumnList().add(attributeColumn);
                            }
                        } else if (3 == n || 4 == n || 5 == n) {
                            // empty if block
                        }
                        attributeColumn.setTableName(((RelationNode)object2).getTableName());
                        if (attributeColumn.getTableAlias() == null || attributeColumn.getTableAlias().equals("")) {
                            if (((RelationNode)object2).getAlias() == null || ((RelationNode)object2).getAlias().equals("")) {
                                attributeColumn.setTableAlias(((RelationNode)object2).getTableName());
                            } else {
                                attributeColumn.setTableAlias(((RelationNode)object2).getAlias());
                            }
                        }
                        attributeColumn.relationNode = object2;
                        sqlExpression3.rebuildExpression();
                        continue;
                    }
                    if (4 == n || n == 1 || n == 2 || n == 5) {
                        throw new XDBServerException(ErrorMessageRepository.AMBIGIOUS_COLUMN_REF + "( " + attributeColumn.columnName + " )", 0, ErrorMessageRepository.AMBIGIOUS_COLUMN_REF_CODE);
                    }
                    throw new XDBServerException("The Column could not be found " + attributeColumn.columnName);
                }
                catch (ColumnNotFoundException columnNotFoundException) {
                    enumeration2 = columnNotFoundException.getColumnExpression();
                    ((SqlExpression)((Object)enumeration2)).getColumn().setColumnGenere();
                    cAnalyzeAndCompleteColInfoAndNodeInfo.orphanExpressionVector.add(columnNotFoundException.getColumnExpression());
                    try {
                        iRebuildString = queryTreeTracker.getParentTree(columnNotFoundException.getColumnExpression());
                        object = new ArrayList();
                        object.add(columnNotFoundException.getColumnExpression());
                        QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(object.iterator(), ((QueryTree)iRebuildString).getRelationNodeList(), ((QueryTree)iRebuildString).getProjectionList(), n, queryTreeTracker, sysDatabase);
                        sqlExpression2 = (SqlExpression)object.get(0);
                        SqlExpression.setExpressionResultType(sqlExpression2, sysDatabase);
                    }
                    catch (NoParentTreeException noParentTreeException) {
                        throw columnNotFoundException;
                    }
                }
                catch (Exception exception) {
                    throw new XDBServerException(exception.getMessage(), exception);
                }
            }
        }
        return cAnalyzeAndCompleteColInfoAndNodeInfo;
    }

    protected static RelationNode getTableRelationNode(SqlExpression sqlExpression, List<RelationNode> list, SysDatabase sysDatabase) throws IllegalArgumentException, ColumnNotFoundException {
        Enumeration enumeration;
        SqlExpression sqlExpression2 = new SqlExpression();
        String string = "";
        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
            // empty if block
        }
        if (sqlExpression.getExprType() != 4) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
        AttributeColumn attributeColumn = sqlExpression.getColumn();
        if (attributeColumn.relationNode != null) {
            return attributeColumn.relationNode;
        }
        RelationNode relationNode = null;
        Hashtable<RelationNode, Object> hashtable = new Hashtable<RelationNode, Object>();
        for (RelationNode relationNode2 : list) {
            if (relationNode2.getNodeType() == 2) {
                string = string + "Alias" + relationNode2.getAlias() + " Name " + relationNode2.getTableName();
                try {
                    enumeration = sysDatabase.getSysTable(relationNode2.getTableName()).getSysColumn(attributeColumn.columnName);
                    if (enumeration == null) continue;
                    hashtable.put(relationNode2, sqlExpression2);
                    continue;
                }
                catch (Exception exception) {
                    throw new XDBServerException("Table " + relationNode2.getTableName() + " has not been found in database " + sysDatabase.getDbname());
                }
            }
            if (relationNode2.getNodeType() != 4) continue;
            string = string + "Alias" + relationNode2.getAlias() + " Name " + relationNode2.getTableName();
            try {
                enumeration = relationNode2.getMatchingSqlExpression(attributeColumn);
                sqlExpression.setMapped(2);
                sqlExpression.setMappedExpression((SqlExpression)((Object)enumeration));
                if (enumeration == null) continue;
                hashtable.put(relationNode2, enumeration);
            }
            catch (ColumnNotFoundException columnNotFoundException) {}
        }
        Enumeration enumeration2 = hashtable.keys();
        int n = 0;
        while (enumeration2.hasMoreElements()) {
            ++n;
            enumeration2.nextElement();
        }
        if (n > 1) {
            enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                RelationNode relationNode3 = (RelationNode)enumeration.nextElement();
                if (relationNode3.getAlias().equals(relationNode3.getTableName())) {
                    if (relationNode3.isTemporaryTable()) {
                        if (relationNode == null) {
                            relationNode = relationNode3;
                            continue;
                        }
                        throw new XDBServerException(ErrorMessageRepository.AMBIGIOUS_COLUMN_REF + "( " + attributeColumn.columnName + " )", 0, ErrorMessageRepository.AMBIGIOUS_COLUMN_REF_CODE);
                    }
                    if (!sqlExpression.getColumn().getTableAlias().equalsIgnoreCase(relationNode3.getAlias())) continue;
                    if (relationNode == null) {
                        relationNode = relationNode3;
                        sqlExpression.getColumn().setTableAlias(relationNode3.getAlias());
                        continue;
                    }
                    throw new XDBServerException(ErrorMessageRepository.AMBIGIOUS_COLUMN_REF + "( " + attributeColumn.columnName + " )", 0, ErrorMessageRepository.AMBIGIOUS_COLUMN_REF_CODE);
                }
                if (!sqlExpression.getColumn().getTableAlias().equalsIgnoreCase(relationNode3.getAlias())) continue;
                if (relationNode == null) {
                    relationNode = relationNode3;
                    continue;
                }
                throw new XDBServerException(ErrorMessageRepository.AMBIGIOUS_COLUMN_REF + "( " + attributeColumn.columnName + " )", 0, ErrorMessageRepository.AMBIGIOUS_COLUMN_REF_CODE);
            }
        } else {
            if (n == 0) {
                throw new ColumnNotFoundException(sqlExpression);
            }
            enumeration = hashtable.keys();
            if (enumeration.hasMoreElements()) {
                RelationNode relationNode4 = (RelationNode)enumeration.nextElement();
                if (sqlExpression.getColumn() != null && !sqlExpression.getColumn().getTableAlias().equals("")) {
                    if (relationNode4.getAlias().equals(relationNode4.getTableName())) {
                        if (relationNode4.isTemporaryTable()) {
                            sqlExpression.getColumn().setTableAlias(relationNode4.getAlias());
                        } else if (!sqlExpression.getColumn().getTableAlias().equalsIgnoreCase(relationNode4.getAlias())) {
                            throw new ColumnNotFoundException(sqlExpression);
                        }
                    } else if (!sqlExpression.getColumn().getTableAlias().equalsIgnoreCase(relationNode4.getAlias())) {
                        throw new ColumnNotFoundException(sqlExpression);
                    }
                } else {
                    sqlExpression.getColumn().setTableAlias(relationNode4.getAlias());
                }
                SqlExpression sqlExpression3 = (SqlExpression)hashtable.get(relationNode4);
                if (sqlExpression3 != sqlExpression2) {
                    QueryTreeHandler.fillColumnExpression(relationNode4, sqlExpression, sqlExpression3);
                }
                return relationNode4;
            }
        }
        return relationNode;
    }

    public static CAnalyzeAndCompleteColInfoAndNodeInfo checkAndFillQueryConditionColumns(QueryCondition queryCondition, List<RelationNode> list, List<SqlExpression> list2, int n, QueryTreeTracker queryTreeTracker, SysDatabase sysDatabase) {
        Object object;
        QueryCondition queryCondition2 = queryCondition;
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition2, 4);
        Enumeration<QueryCondition> enumeration = vector.elements();
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            arrayList.add(((QueryCondition)object).getExpr());
        }
        object = new Vector();
        for (RelationNode object2 : list) {
            if (object2.getNodeType() != 2 && object2.getNodeType() != 4) continue;
            ((Vector)object).add(object2);
        }
        CAnalyzeAndCompleteColInfoAndNodeInfo cAnalyzeAndCompleteColInfoAndNodeInfo = QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(arrayList.iterator(), (List<RelationNode>)object, list2, n, queryTreeTracker, sysDatabase);
        for (SqlExpression sqlExpression : cAnalyzeAndCompleteColInfoAndNodeInfo.orphanExpressionVector) {
            SqlExpression sqlExpression2 = sqlExpression;
            if (sqlExpression2.getColumn().getParentQueryCondition() != null) continue;
            sqlExpression2.getColumn().setParentQueryCondition(queryCondition);
        }
        return cAnalyzeAndCompleteColInfoAndNodeInfo;
    }

    public static boolean isJoinQueryCondition(QueryCondition queryCondition) throws ColumnNotFoundException {
        if (queryCondition.getCondType() == 2 && queryCondition.getACompositeClause().leadsToJoinCondition()) {
            return true;
        }
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 18);
        Enumeration<QueryCondition> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            QueryCondition queryCondition2 = enumeration.nextElement();
            List<RelationNode> list = QueryTreeHandler.getRelationNodes(queryCondition2);
            if (list.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public static Vector<QueryCondition> getTopLevelQueryConditions(QueryCondition queryCondition) {
        ParamAndOrConditionHelper paramAndOrConditionHelper = QueryTreeHandler.getAndOrNodes(queryCondition);
        Vector<QueryCondition> vector = paramAndOrConditionHelper.orConditionVector;
        Vector<QueryCondition> vector2 = paramAndOrConditionHelper.andConditionVector;
        Vector<QueryCondition> vector3 = new Vector<QueryCondition>();
        Vector<QueryCondition> vector4 = new Vector<QueryCondition>();
        for (QueryCondition object : vector) {
            if (vector4.contains(object)) continue;
            ParamAndOrConditionHelper paramAndOrConditionHelper2 = QueryTreeHandler.getAndOrNodes(object);
            Vector<QueryCondition> vector5 = paramAndOrConditionHelper2.andConditionVector;
            vector2.removeAll(vector5);
            vector4.addAll(paramAndOrConditionHelper2.orConditionVector);
            vector3.removeAll(paramAndOrConditionHelper2.orConditionVector);
            vector3.add(object);
        }
        Vector vector6 = new Vector();
        if (vector2.size() <= 0 && vector.size() <= 0 && vector3.size() <= 0) {
            vector6.add(paramAndOrConditionHelper.singleQueryCondition);
        } else {
            for (QueryCondition queryCondition2 : vector2) {
                if ((queryCondition2.getLeftCond().getCondType() & 2) > 0 || !"AND".equalsIgnoreCase(queryCondition2.getLeftCond().getOperator())) {
                    vector6.add(queryCondition2.getLeftCond());
                }
                if ((queryCondition2.getRightCond().getCondType() & 2) <= 0 && "AND".equalsIgnoreCase(queryCondition2.getRightCond().getOperator())) continue;
                vector6.add(queryCondition2.getRightCond());
            }
            for (QueryCondition queryCondition3 : vector3) {
                if (vector6.contains(queryCondition3)) continue;
                vector6.add(queryCondition3);
            }
            for (QueryCondition queryCondition4 : vector3) {
                if (vector6.contains(queryCondition4)) continue;
                vector6.add(queryCondition4);
            }
        }
        return vector6;
    }

    private static ParamAndOrConditionHelper getAndOrNodes(QueryCondition queryCondition) {
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 8);
        if (vector.isEmpty()) {
            vector = QueryCondition.getNodes(queryCondition, 18);
        }
        if (vector.isEmpty()) {
            vector = new Vector(1);
            vector.add(queryCondition);
        }
        ParamAndOrConditionHelper paramAndOrConditionHelper = new ParamAndOrConditionHelper();
        Vector<QueryCondition> vector2 = new Vector<QueryCondition>();
        Vector<QueryCondition> vector3 = new Vector<QueryCondition>();
        for (QueryCondition queryCondition2 : vector) {
            if ((queryCondition2.getCondType() & 2) == 0) {
                if ("AND".equalsIgnoreCase(queryCondition2.getOperator())) {
                    vector3.addElement(queryCondition2);
                    continue;
                }
                if ("OR".equalsIgnoreCase(queryCondition2.getOperator())) {
                    vector2.addElement(queryCondition2);
                    continue;
                }
                paramAndOrConditionHelper.singleQueryCondition = queryCondition2;
                continue;
            }
            paramAndOrConditionHelper.singleQueryCondition = queryCondition2;
        }
        paramAndOrConditionHelper.orConditionVector = vector2;
        paramAndOrConditionHelper.andConditionVector = vector3;
        return paramAndOrConditionHelper;
    }

    public static SegregateJoinHelper segregateIntoSimpleAndJoinConditions(Vector vector) {
        SegregateJoinHelper segregateJoinHelper = new SegregateJoinHelper();
        Enumeration enumeration = vector.elements();
        Vector<QueryCondition> vector2 = new Vector<QueryCondition>();
        Vector<QueryCondition> vector3 = new Vector<QueryCondition>();
        while (enumeration.hasMoreElements()) {
            QueryCondition queryCondition = (QueryCondition)enumeration.nextElement();
            if (QueryTreeHandler.isJoinQueryCondition(queryCondition)) {
                vector2.add(queryCondition);
                continue;
            }
            vector3.add(queryCondition);
        }
        segregateJoinHelper.joinQConditionVector = vector2;
        segregateJoinHelper.nonjoinQConditionVector = vector3;
        return segregateJoinHelper;
    }

    public static void populateJoinExpressionCrossReference(Vector vector) throws ColumnNotFoundException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            QueryCondition queryCondition = (QueryCondition)enumeration.nextElement();
            queryCondition.setJoin(true);
            Vector<QueryCondition> vector2 = QueryCondition.getNodes(queryCondition, 18);
            Enumeration<QueryCondition> enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                QueryCondition queryCondition2 = enumeration2.nextElement();
                List<RelationNode> list = QueryTreeHandler.getRelationNodes(queryCondition2);
                if (list.size() > 1) {
                    QueryTreeHandler.populateJoinCrossReference(queryCondition2);
                    continue;
                }
                if (queryCondition2.getACompositeClause() == null) continue;
            }
        }
    }

    public static void populateJoinCrossReference(QueryCondition queryCondition) throws ColumnNotFoundException {
        List<RelationNode> list = QueryTreeHandler.getRelationNodes(queryCondition);
        for (RelationNode relationNode : list) {
            if (relationNode.getNodeType() == 6) continue;
            for (RelationNode relationNode2 : list) {
                if (relationNode == relationNode2) continue;
                relationNode2.getJoinList().add(relationNode);
            }
        }
    }

    public static boolean isJoinExpression(SqlExpression sqlExpression) {
        Vector<SqlExpression> vector = SqlExpression.getNodes(sqlExpression, 128);
        Vector<RelationNode> vector2 = new Vector<RelationNode>();
        Enumeration<SqlExpression> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SqlExpression sqlExpression2 = enumeration.nextElement();
            Vector<SqlExpression> vector3 = SqlExpression.getNodes(sqlExpression2, 4);
            Enumeration<SqlExpression> enumeration2 = vector3.elements();
            while (enumeration2.hasMoreElements()) {
                SqlExpression sqlExpression3 = enumeration2.nextElement();
                AttributeColumn attributeColumn = sqlExpression3.getColumn();
                if (vector2.contains(attributeColumn.relationNode)) continue;
                vector2.add(attributeColumn.relationNode);
                if (vector2.size() <= 1) continue;
                return true;
            }
        }
        return false;
    }

    public static Vector getSimpleExprForQueryTree(Vector vector) throws ColumnNotFoundException {
        Enumeration enumeration = vector.elements();
        Vector<QueryCondition> vector2 = new Vector<QueryCondition>();
        while (enumeration.hasMoreElements()) {
            QueryCondition queryCondition = (QueryCondition)enumeration.nextElement();
            List<RelationNode> list = QueryTreeHandler.getRelationNodes(queryCondition);
            if (list.size() <= 1) continue;
            vector2.add(queryCondition);
        }
        return vector2;
    }

    public static List<RelationNode> getRelationNodes(QueryCondition queryCondition) throws ColumnNotFoundException {
        if (queryCondition.getRelationNodeList().size() > 0) {
            return queryCondition.getRelationNodeList();
        }
        QCHelperColumnList qCHelperColumnList = QueryTreeHandler.getQueryColumnList(queryCondition);
        Vector vector = qCHelperColumnList.getColumnExprListThisTree();
        vector.addAll(qCHelperColumnList.getColumnExprListParentTree());
        Enumeration enumeration = vector.elements();
        Vector<RelationNode> vector2 = new Vector<RelationNode>();
        while (enumeration.hasMoreElements()) {
            AttributeColumn attributeColumn = (AttributeColumn)enumeration.nextElement();
            RelationNode relationNode = attributeColumn.relationNode;
            if (attributeColumn.getMyParentTree() == queryCondition.getParentQueryTree()) {
                if ((attributeColumn.columnGenre & 8) == 8) {
                    relationNode = queryCondition.getPseudoRelationNode(attributeColumn);
                }
            } else if ((attributeColumn.columnGenre & 8) == 8) {
                relationNode = queryCondition.getParentQueryTree().getPlaceHodlerNode(attributeColumn.getMyParentTree());
                if (!vector2.contains(attributeColumn.relationNode)) {
                    vector2.add(attributeColumn.relationNode);
                }
            } else {
                relationNode = queryCondition.getParentQueryTree().getPlaceHodlerNode(attributeColumn.getMyParentTree());
            }
            if (vector2.contains(relationNode)) continue;
            vector2.add(relationNode);
        }
        if (queryCondition.getParentQueryTree().getCorrelatedSubqueryList().size() > 0) {
            for (RelationNode relationNode : QueryTreeHandler.getCorrelatedPlaceholder(queryCondition, queryCondition.getParentQueryTree().getCorrelatedSubqueryList())) {
                if (vector2.contains(relationNode)) continue;
                vector2.add(relationNode);
            }
        }
        return vector2;
    }

    private static List<RelationNode> getCorrelatedPlaceholder(QueryCondition queryCondition, List<RelationNode> list) {
        ArrayList<RelationNode> arrayList = new ArrayList<RelationNode>();
        if (queryCondition.getLeftCond() != null) {
            arrayList.addAll(QueryTreeHandler.getCorrelatedPlaceholder(queryCondition.getLeftCond(), list));
        }
        if (queryCondition.getRightCond() != null) {
            arrayList.addAll(QueryTreeHandler.getCorrelatedPlaceholder(queryCondition.getRightCond(), list));
        }
        if (queryCondition.getCondType() == 4) {
            arrayList.addAll(QueryTreeHandler.getCorrelatedPlaceholder(queryCondition.getExpr(), list));
        }
        return arrayList;
    }

    private static List<RelationNode> getCorrelatedPlaceholder(SqlExpression sqlExpression, List<RelationNode> list) {
        Vector<RelationNode> vector = new Vector<RelationNode>();
        if (sqlExpression.getLeftExpr() != null) {
            vector.addAll(QueryTreeHandler.getCorrelatedPlaceholder(sqlExpression.getLeftExpr(), list));
        }
        if (sqlExpression.getRightExpr() != null) {
            vector.addAll(QueryTreeHandler.getCorrelatedPlaceholder(sqlExpression.getRightExpr(), list));
        }
        if (sqlExpression.getExprType() == 64) {
            for (RelationNode relationNode : list) {
                if (sqlExpression.getSubqueryTree() != relationNode.getSubqueryTree()) continue;
                vector.add(relationNode);
            }
        }
        return vector;
    }

    public static QCHelperColumnList getQueryColumnList(QueryCondition queryCondition) {
        Object object;
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 4);
        Enumeration<QueryCondition> enumeration = vector.elements();
        Vector<AttributeColumn> vector2 = new Vector<AttributeColumn>();
        Vector<AttributeColumn> vector3 = new Vector<AttributeColumn>();
        while (enumeration.hasMoreElements()) {
            Object object2;
            Object object3;
            Object object4;
            object = enumeration.nextElement();
            SqlExpression sqlExpression = ((QueryCondition)object).getExpr();
            Vector<SqlExpression> vector4 = new Vector<SqlExpression>();
            if (sqlExpression.getExprType() == 64) {
                object4 = ((QueryCondition)object).getParentQueryCondition();
                object3 = new Vector<SqlExpression>();
                if (((QueryCondition)object4).getCondType() == 2) {
                    ((Vector)object3).addAll(((QueryCondition)object4).getProjectedColumns());
                    vector3.addAll(((QueryCondition)object4).getCorrelatedColumns());
                } else {
                    ((Vector)object3).addAll(((QueryCondition)object).getProjectedColumns());
                    if ((((QueryCondition)object).getExpr().getSubqueryTree().getQueryType() & 4) == 0) {
                        vector3.addAll(((QueryCondition)object).getCorrelatedColumns());
                    }
                }
                if (((Vector)object3).size() >= 1) {
                    object2 = ((Vector)object3).elements();
                    while (object2.hasMoreElements()) {
                        SqlExpression sqlExpression2 = (SqlExpression)object2.nextElement();
                        vector4.addAll(SqlExpression.getNodes(sqlExpression2, 4));
                    }
                }
            } else {
                vector4.addAll(SqlExpression.getNodes(sqlExpression, 4));
            }
            object4 = vector4.elements();
            while (object4.hasMoreElements()) {
                object3 = (SqlExpression)object4.nextElement();
                object2 = ((SqlExpression)object3).getColumn();
                vector2.add((AttributeColumn)object2);
            }
        }
        object = new QCHelperColumnList(vector2, vector3);
        return object;
    }

    public static void addToNodesSimpleQueryCondition(Vector vector, QueryTree queryTree) throws ColumnNotFoundException {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            QueryCondition queryCondition = (QueryCondition)enumeration.nextElement();
            List<RelationNode> list = QueryTreeHandler.getRelationNodes(queryCondition);
            if (list.size() > 1) {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
            if (list.size() == 1) {
                for (RelationNode relationNode : list) {
                    if (!queryCondition.getRelationNodeList().contains(relationNode)) {
                        queryCondition.getRelationNodeList().add(relationNode);
                    }
                    if (relationNode.getConditionList().contains(queryCondition)) continue;
                    relationNode.getConditionList().add(queryCondition);
                }
                continue;
            }
            if (list.size() >= 1) continue;
            queryTree.getConditionList().add(queryCondition);
        }
    }

    protected void manageFromSubQuery(QueryTree queryTree) {
        for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
            Vector<SqlExpression> vector = SqlExpression.getNodes(sqlExpression, 4);
            Enumeration<SqlExpression> enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                SqlExpression sqlExpression2 = enumeration.nextElement();
                if (sqlExpression2.getColumn().relationNode.getNodeType() != 4) continue;
                try {
                    SqlExpression sqlExpression3 = sqlExpression2.getColumn().relationNode.getMatchingSqlExpression(sqlExpression2.getColumn());
                    if (!sqlExpression2.getColumn().relationNode.getProjectionList().contains(sqlExpression3)) {
                        SqlExpression sqlExpression4 = new SqlExpression();
                        if (System.getProperty("TrackSQLExpression") == null || System.getProperty("TrackSQLExpression").equals("1")) {
                            // empty if block
                        }
                        sqlExpression4 = SqlExpression.getSqlColumnExpression(sqlExpression3.getOuterAlias(), sqlExpression2.getColumn().relationNode.getAlias(), sqlExpression2.getColumn().relationNode.getAlias(), sqlExpression3.getOuterAlias(), sqlExpression3.getOperator());
                        sqlExpression4.getColumn().relationNode = sqlExpression2.getColumn().relationNode;
                        sqlExpression4.setExprType(sqlExpression2.getExprType());
                        sqlExpression4.setExprDataType(sqlExpression2.getExprDataType());
                        sqlExpression4.rebuildExpression();
                        sqlExpression2.getColumn().relationNode.getProjectionList().add(sqlExpression4);
                    }
                    if (queryTree.getRelationSubqueryList().contains(sqlExpression2.getColumn().relationNode)) continue;
                    queryTree.getRelationSubqueryList().add(sqlExpression2.getColumn().relationNode);
                }
                catch (Exception exception) {
                    throw new XDBServerException(ErrorMessageRepository.SUBQUERY_MANAGE_ERROR, exception, ErrorMessageRepository.SUBQUERY_MANAGE_ERROR_CODE);
                }
            }
        }
    }

    private static QueryCondition normalizeExpr(QueryCondition queryCondition, int n) {
        if (queryCondition == null || queryCondition.getCondType() != 16) {
            return queryCondition;
        }
        SqlExpression sqlExpression = queryCondition.getLeftCond().getExpr();
        if (!(sqlExpression != null && sqlExpression.getExprType() == 2 || (sqlExpression = queryCondition.getRightCond().getExpr()) != null && sqlExpression.getExprType() == 2)) {
            sqlExpression = null;
        }
        if (sqlExpression != null) {
            try {
                if (n == 91) {
                    sqlExpression.setConstantValue(SqlExpression.normalizeDate(sqlExpression.getConstantValue()));
                } else if (n == 92) {
                    sqlExpression.setConstantValue(SqlExpression.normalizeTime(sqlExpression.getConstantValue()));
                }
            }
            catch (Exception exception) {
                n = 93;
            }
            if (n == 93) {
                sqlExpression.setConstantValue(SqlExpression.normalizeTimeStamp(sqlExpression.getConstantValue()));
            }
        }
        return queryCondition;
    }

    public static class SegregateJoinHelper {
        Vector joinQConditionVector;
        Vector nonjoinQConditionVector;
    }

    public static class ParamAndOrConditionHelper {
        Vector<QueryCondition> orConditionVector;
        Vector<QueryCondition> andConditionVector;
        QueryCondition singleQueryCondition;
    }

    public static class CAnalyzeAndCompleteColInfoAndNodeInfo {
        Vector nodeListInExpression = new Vector();
        public List<SqlExpression> orphanExpressionVector = new Vector<SqlExpression>();
    }
}

