/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.AbstractConstraintChecker;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import com.edb.gridsql.parser.Tuple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertForeignKeyChecker
extends AbstractConstraintChecker {
    private static final XLogger logger = XLogger.getLogger(InsertForeignKeyChecker.class);
    private Tuple tuple;

    public InsertForeignKeyChecker(SysTable sysTable, Tuple tuple, XDBSessionContext xDBSessionContext) {
        super(sysTable, xDBSessionContext);
        this.tuple = tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<SysColumn> scanConstraints(Collection<SysColumn> collection, Collection collection2) {
        try {
            HashSet<SysColumn> hashSet = new HashSet<SysColumn>();
            Vector<SysReference> vector = this.targetTable.getSysFkReferenceList();
            for (SysReference sysReference : vector) {
                if (!sysReference.getDistributedCheck()) continue;
                Vector vector2 = sysReference.getForeignKeys();
                for (SysForeignKey sysForeignKey : vector2) {
                    SysColumn sysColumn = this.targetTable.getSysColumn(sysForeignKey.getColid());
                    if (collection.contains(sysColumn)) continue;
                    hashSet.add(sysColumn);
                }
                collection2.add(sysReference);
            }
            HashSet<SysColumn> hashSet2 = hashSet;
            Object var12_11 = null;
            return hashSet2;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<IExecutable, AbstractConstraintChecker.ViolationCriteria> prepareConstraint(Object object) throws Exception {
        try {
            Object object2;
            Object object3;
            Object object4;
            AbstractConstraintChecker.ViolationCriteria violationCriteria = new AbstractConstraintChecker.ViolationCriteria();
            violationCriteria.message = ((SysReference)object).getConstraint().toString();
            StringBuffer stringBuffer = new StringBuffer("SELECT 1 FROM ");
            SysTable sysTable = this.targetTable.getSysDatabase().getSysTable(((SysReference)object).getRefTableID());
            if (this.tuple == null) {
                violationCriteria.violationType = 2;
                stringBuffer.append(this.tempTable.getTableName()).append(" LEFT JOIN ");
                stringBuffer.append(sysTable.getTableName()).append(" ON (");
                object4 = new StringBuffer();
                object3 = ((SysReference)object).getForeignKeys();
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    SysForeignKey object5 = (SysForeignKey)object2.next();
                    SysColumn sysColumn = this.targetTable.getSysColumn(object5.getColid());
                    SysColumn sysColumn2 = sysTable.getSysColumn(object5.getRefcolid());
                    stringBuffer.append(this.tempTable.getTableName()).append(".");
                    stringBuffer.append(sysColumn.getColName()).append("=");
                    stringBuffer.append(sysTable.getTableName()).append(".");
                    stringBuffer.append(sysColumn2.getColName()).append(", ");
                }
                stringBuffer.append(((StringBuffer)object4).substring(0, ((StringBuffer)object4).length() - 2));
                stringBuffer.append(") WHERE ");
                for (SysColumn sysColumn : this.targetTable.getRowID()) {
                    stringBuffer.append(sysTable.getTableName()).append(".").append(sysColumn.getColName()).append(" IS NULL AND ");
                }
                stringBuffer.setLength(stringBuffer.length() - 5);
            } else {
                violationCriteria.violationType = 1;
                stringBuffer.append(sysTable.getTableName());
                stringBuffer.append(" WHERE ");
                object4 = ((SysReference)object).getForeignKeys();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (SysForeignKey)object3.next();
                    SysColumn sysColumn = this.targetTable.getSysColumn(((SysForeignKey)object2).getColid());
                    SysColumn sysColumn3 = sysTable.getSysColumn(((SysForeignKey)object2).getRefcolid());
                    stringBuffer.append(sysColumn3.getColName());
                    String string = this.tuple.getValue(sysColumn);
                    if ("null".equalsIgnoreCase(string)) {
                        stringBuffer.append(" IS NULL AND ");
                        continue;
                    }
                    stringBuffer.append("=").append(string).append(" AND ");
                }
                stringBuffer.setLength(stringBuffer.length() - 5);
            }
            object4 = new Parser(this.client);
            ((Parser)object4).parseStatement(stringBuffer.toString());
            object3 = (SqlSelect)((Parser)object4).getSqlObject();
            ((SqlSelect)object3).addSkipPermissionCheck(this.targetTable.getTableName());
            ((SqlSelect)object3).addSkipPermissionCheck(sysTable.getTableName());
            ((SqlSelect)object3).prepare();
            object2 = Collections.singletonMap(object3, violationCriteria);
            Object var12_16 = null;
            return object2;
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            throw throwable;
        }
    }
}

