/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.JDBCPool;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.Node;
import java.sql.Connection;
import java.util.HashMap;

public class CoordinatorPools {
    private static final XLogger logger = XLogger.getLogger(CoordinatorPools.class);
    private static final HashMap<String, JDBCPool> connections = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPool(String string, int n) {
        HashMap<String, JDBCPool> hashMap = connections;
        synchronized (hashMap) {
            JDBCPool jDBCPool = connections.get(string);
            if (jDBCPool == null) {
                int n2 = Property.getInt("xdb.jdbc.coordinator.pool.initsize", Props.XDB_DEFAULT_THREADS_POOL_INITSIZE);
                int n3 = Property.getInt("xdb.jdbc.coordinator.pool.maxsize", Math.max((int)Math.round((double)Props.XDB_DEFAULT_THREADS_POOL_MAXSIZE * 0.8), n2));
                Node node = MetaData.getMetaData().getNode(n);
                jDBCPool = new JDBCPool(node.getSJdbcDriver(), node.getJdbcString(string), node.getJdbcUser(), node.getJdbcPassword(), n2, n3);
                jDBCPool.setGetTimeout(-1L);
                jDBCPool.setReleaseTimeout(Property.getInt("xdb.jdbc.pool.idle", Props.XDB_DEFAULT_THREADS_POOL_IDLE));
                jDBCPool.initBuffer();
                connections.put(string, jDBCPool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destoryPool(String string) {
        HashMap<String, JDBCPool> hashMap = connections;
        synchronized (hashMap) {
            JDBCPool jDBCPool = connections.remove(string);
            if (jDBCPool != null) {
                jDBCPool.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String string) {
        block6: {
            try {
                JDBCPool jDBCPool = null;
                Object object = connections;
                synchronized (object) {
                    jDBCPool = connections.get(string);
                }
                if (jDBCPool == null) break block6;
                object = jDBCPool.getConnection();
                Object var5_4 = null;
                return object;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                throw throwable;
            }
        }
        throw new XDBServerException("Coordinator Pool for database " + string + " is not initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(String string, Connection connection) throws Exception {
        try {
            JDBCPool jDBCPool = null;
            HashMap<String, JDBCPool> hashMap = connections;
            synchronized (hashMap) {
                jDBCPool = connections.get(string);
            }
            if (jDBCPool != null) {
                jDBCPool.releaseConnection(connection);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyConnection(String string, Connection connection) {
        try {
            JDBCPool jDBCPool = null;
            HashMap<String, JDBCPool> hashMap = connections;
            synchronized (hashMap) {
                jDBCPool = connections.get(string);
            }
            if (jDBCPool != null) {
                jDBCPool.destroyConnection(connection);
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }
}

