/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.CommandLog;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.scheduler.BatchCost;
import com.edb.gridsql.metadata.scheduler.ILockCost;
import com.edb.gridsql.metadata.scheduler.RequestCost;
import com.edb.gridsql.misc.Timer;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlBeginTransaction;
import com.edb.gridsql.parser.SqlBulkInsert;
import com.edb.gridsql.parser.SqlCommitTransaction;
import com.edb.gridsql.parser.SqlModifyTable;
import com.edb.gridsql.parser.SqlRollbackTransaction;
import com.edb.gridsql.parser.SqlSelect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class ExecutableRequest {
    private static final XLogger logger = XLogger.getLogger(ExecutableRequest.class);
    public static final char STATUS_QUEUED = 'Q';
    public static final char STATUS_PREPARED = 'P';
    public static final char STATUS_EXECUTING = 'E';
    public static final char STATUS_DYING = 'D';
    private static int SYS_REQUEST_ID = 0;
    private int requestID;
    private long submitTime;
    private int fetchSize;
    private RequestCost cost;
    private ILockCost[] subRequests = null;
    private String originalCommand;
    private volatile char status = (char)81;
    private static long nextStatementId = 0L;
    private long statementId = ExecutableRequest.getNextStatementId();

    private static synchronized long getNextStatementId() {
        if (nextStatementId >= Long.MAX_VALUE) {
            nextStatementId = 0L;
        }
        return ++nextStatementId;
    }

    public ExecutableRequest(String string) {
        this.requestID = SYS_REQUEST_ID == Integer.MAX_VALUE ? (SYS_REQUEST_ID = 0) : (SYS_REQUEST_ID = SYS_REQUEST_ID + 1);
        this.submitTime = System.currentTimeMillis();
        this.originalCommand = string;
    }

    public int getRequestID() {
        return this.requestID;
    }

    public RequestCost getCost() {
        if (this.cost == null) {
            this.cost = new RequestCost(null);
        }
        return this.cost;
    }

    public long getSubmitTime() {
        return this.submitTime;
    }

    public String getStatement() {
        return this.originalCommand;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public char getStatus() {
        return this.status;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public void setSQLObject(ILockCost iLockCost) throws XDBServerException {
        if (iLockCost instanceof IPreparable) {
            try {
                ((IPreparable)((Object)iLockCost)).prepare();
            }
            catch (Exception exception) {
                throw new XDBServerException("Can not prepare request: " + exception.getMessage(), exception);
            }
        }
        this.cost = new RequestCost(iLockCost);
        this.status = (char)80;
    }

    public ILockCost[] getSubRequests() {
        return this.subRequests;
    }

    public void setSubRequests(ILockCost[] iLockCostArray) throws XDBServerException {
        BatchCost batchCost = new BatchCost();
        for (ILockCost iLockCost : iLockCostArray) {
            if (iLockCost instanceof SqlModifyTable) {
                ((SqlModifyTable)iLockCost).setBatchMode();
            }
            if (iLockCost instanceof IPreparable) {
                try {
                    ((IPreparable)((Object)iLockCost)).prepare();
                }
                catch (Exception exception) {
                    throw new XDBServerException("Can not add request to batch: " + exception.getMessage());
                }
            }
            batchCost.addElement(iLockCost);
        }
        this.cost = new RequestCost(batchCost);
        this.subRequests = iLockCostArray;
        this.status = (char)80;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ExecutionResult execute(Engine engine, XDBSessionContext xDBSessionContext) {
        boolean bl;
        Object object;
        this.status = (char)69;
        xDBSessionContext.setStatementId(this.statementId);
        ILockCost iLockCost = this.cost.getSqlObject();
        if (iLockCost instanceof IExecutable) {
            boolean bl2;
            object = null;
            if (iLockCost instanceof IXDBSql) {
                object = ((IXDBSql)iLockCost).getNodeList();
            }
            boolean bl3 = bl2 = !(iLockCost instanceof SqlSelect) && !(iLockCost instanceof SqlBulkInsert) && !(iLockCost instanceof SqlBeginTransaction) && !(iLockCost instanceof SqlCommitTransaction) && !(iLockCost instanceof SqlRollbackTransaction);
            if (bl2) {
                xDBSessionContext.setPersistent(true);
            }
            try {
                ExecutionResult executionResult = null;
                Timer timer = new Timer();
                try {
                    timer.startTimer();
                    executionResult = ((IExecutable)((Object)iLockCost)).execute(engine);
                    timer.stopTimer();
                }
                catch (XDBServerException xDBServerException) {
                    if (xDBSessionContext.isInTransaction()) throw xDBServerException;
                    if (xDBSessionContext.isInSubTransaction()) throw xDBServerException;
                    engine.rollbackTransaction(xDBSessionContext, (Collection<DBNode>)object);
                    throw xDBServerException;
                }
                if (!(!bl2 || object == null || object.size() <= 1 || executionResult.hasResultSet() || xDBSessionContext.isInTransaction() || xDBSessionContext.isInSubTransaction() || xDBSessionContext.hasActiveResultSets())) {
                    engine.commitTransaction(xDBSessionContext, (Collection<DBNode>)object);
                }
                CommandLog.checkLongQuery(this.originalCommand, timer.getDurationSeconds(), xDBSessionContext);
                ExecutionResult executionResult2 = executionResult;
                return executionResult2;
            }
            catch (Exception exception) {
                logger.catching(exception);
                if (!xDBSessionContext.isInTransaction() && !xDBSessionContext.isInSubTransaction()) {
                    engine.rollbackTransaction(xDBSessionContext, (Collection<DBNode>)object);
                }
                logger.throwing(exception);
                throw exception;
            }
            finally {
                if (bl2) {
                    xDBSessionContext.setPersistent(false);
                }
            }
        }
        if (this.subRequests == null) throw new XDBServerException("Empty request");
        boolean bl4 = bl = !xDBSessionContext.isInTransaction();
        if (bl) {
            engine.beginTransaction(xDBSessionContext, null);
        }
        try {
            HashMap<Integer, ExecutionResult> hashMap = new HashMap<Integer, ExecutionResult>(this.subRequests.length);
            int n = 0;
            for (ILockCost iLockCost2 : this.subRequests) {
                if (iLockCost2 instanceof SqlModifyTable) {
                    SqlModifyTable sqlModifyTable = (SqlModifyTable)iLockCost2;
                    try {
                        hashMap.put(n++, sqlModifyTable.execute(engine));
                    }
                    catch (Exception exception) {
                        logger.catching(exception);
                        hashMap.put(n++, ExecutionResult.createRowCountResult(sqlModifyTable.getResultType(), -3));
                    }
                    continue;
                }
                logger.warn("Only INSERT, UPDATE and DELETE are allowed in batches");
                hashMap.put(n++, ExecutionResult.createRowCountResult(-1, -3));
            }
            if (!bl) return ExecutionResult.createMultipleResult(42, hashMap);
            List<DBNode> list = Collections.emptyList();
            engine.commitTransaction(xDBSessionContext, list);
            return ExecutionResult.createMultipleResult(42, hashMap);
        }
        catch (Exception exception) {
            try {
                logger.catching(exception);
                if (bl && xDBSessionContext.isInTransaction()) {
                    List<DBNode> list = Collections.emptyList();
                    engine.rollbackTransaction(xDBSessionContext, list);
                }
                logger.throwing(exception);
                throw exception;
            }
            catch (Exception exception2) {
                logger.catching(exception2);
                object = ExecutionResult.createErrorResult(exception2);
                return object;
            }
        }
        finally {
            this.status = (char)80;
        }
    }

    public void cancel() {
        this.status = (char)68;
    }

    public boolean cancelled() {
        return this.status == 'D';
    }

    public long getStatementId() {
        return this.statementId;
    }
}

