/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.ObjectPool;
import com.edb.gridsql.exception.XDBServerException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPool
extends ObjectPool<Connection> {
    private static final XLogger logger = XLogger.getLogger(JDBCPool.class);
    private String url;
    private String user;
    private String passwd;

    public JDBCPool(String string, String string2, String string3, String string4, int n, int n2) {
        super(n, n2);
        this.url = string2;
        this.user = string3;
        this.passwd = string4;
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.catching(classNotFoundException);
        }
    }

    @Override
    protected Connection createEntry() throws XDBServerException {
        Connection connection = null;
        try {
            connection = !(this.user != null && this.user.length() != 0 || this.passwd != null && this.passwd.length() != 0) ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.user, this.passwd);
            connection.setAutoCommit(false);
            connection.setTransactionIsolation(2);
            Connection connection2 = connection;
            Object var4_4 = null;
            return connection2;
        }
        catch (SQLException sQLException) {
            try {
                throw new XDBServerException("Can not establish connection", sQLException);
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyEntry(Connection connection) {
        try {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                logger.catching(sQLException);
                Object var4_3 = null;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws XDBServerException {
        Connection connection = null;
        try {
            Connection connection2 = connection = (Connection)this.getObject();
            Object var4_3 = null;
            return connection2;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Connection connection) throws XDBServerException {
        try {
            this.releaseObject(connection);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConnection(Connection connection) {
        try {
            try {
                this.destroyObject(connection, false);
            }
            catch (Exception exception) {
                logger.catching(exception);
                Object var4_3 = null;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

