/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.ActivityLog;
import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.CoordinatorAgent;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.communication.message.SendRowsMessage;
import com.edb.gridsql.engine.BatchHandler;
import com.edb.gridsql.engine.MessageMonitor;
import com.edb.gridsql.engine.NodeResultSetImpl;
import com.edb.gridsql.engine.NodeThread;
import com.edb.gridsql.engine.ProducerSender;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBMessageMonitorException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.Node;
import com.edb.gridsql.metadata.scheduler.LockManager;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.NodeUsage;
import com.edb.gridsql.planner.StepDetail;
import com.edb.gridsql.queryproc.QueryCombiner;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultinodeExecutor
implements IMessageListener {
    private static final XLogger logger = XLogger.getLogger(MultinodeExecutor.class);
    private Collection<DBNode> nodeList;
    private XDBSessionContext client;
    private SendMessageHelper sendHelper;
    private BatchHandler aBatchHandler;
    private MessageMonitor monitor;
    private LinkedBlockingQueue<NodeMessage> coordinatorQueue = new LinkedBlockingQueue();
    private ProducerSender insertProducerSender;
    private Collection<Integer> currentStepProcesses;
    private LinkedBlockingQueue<NodeMessage> sendDataMessages = new LinkedBlockingQueue();
    private HashMap<String, HashMap<Integer, NodeResultSetImpl>> finalRSs = new HashMap();
    private String currentResultSetID = null;
    private static final long SHORT_TIMEOUT = Property.getLong("xdb.messagemonitor.timeout.short.millis", 600000L);
    private static final long CONNECTION_TIMEOUT = Property.getLong("xdb.messagemonitor.timeout.connection.millis", Props.XDB_DEFAULT_THREADS_POOL_TIMEOUT);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultinodeExecutor(Collection<DBNode> collection, XDBSessionContext xDBSessionContext) throws XDBServerException {
        this.nodeList = new HashSet<DBNode>();
        this.nodeList.addAll(collection);
        this.client = xDBSessionContext;
        this.monitor = new MessageMonitor(xDBSessionContext);
        Integer n = new Integer(xDBSessionContext.getSessionID());
        CoordinatorAgent coordinatorAgent = CoordinatorAgent.getInstance();
        coordinatorAgent.addProcess(n, this);
        this.sendHelper = new SendMessageHelper(0, n, coordinatorAgent);
        this.initNodeThreads(this.nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNeededNodes(Collection<DBNode> collection) {
        Collection<DBNode> collection2 = this.nodeList;
        synchronized (collection2) {
            ArrayList<DBNode> arrayList = new ArrayList<DBNode>();
            HashSet<DBNode> hashSet = new HashSet<DBNode>(this.nodeList);
            for (DBNode dBNode : collection) {
                if (hashSet.remove(dBNode)) continue;
                arrayList.add(dBNode);
            }
            if (arrayList.size() > 0) {
                this.initNodeThreads(arrayList);
            }
            if (!this.client.isPersistent()) {
                this.nodeList.removeAll(hashSet);
            }
            this.nodeList.addAll(arrayList);
            if (!hashSet.isEmpty() && !this.client.isPersistent()) {
                this.releaseNodeThreads(hashSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNodeThreads(Collection collection) {
        try {
            int n = this.client.getRequestId();
            this.monitor.setMonitor(n, collection);
            try {
                this.sendHelper.sendMessageToList(collection, 4, n);
            }
            finally {
                this.monitor.waitForMessages(SHORT_TIMEOUT);
            }
        }
        catch (Throwable throwable) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNodeThreads(Collection collection) throws XDBServerException {
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, collection);
        try {
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(2);
            nodeMessage.setDatabase(this.client.getDBName());
            nodeMessage.setRequestId(n);
            this.sendHelper.sendMessageToList(collection, nodeMessage);
        }
        finally {
            this.monitor.waitForMessages(CONNECTION_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnections() throws XDBServerException {
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, this.nodeList);
        try {
            this.sendHelper.sendMessageToList(this.nodeList, 14, n);
        }
        finally {
            this.monitor.waitForMessages(SHORT_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginSavepoint(String string) throws XDBServerException {
        this.client.setSavepoint(string);
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, this.nodeList);
        try {
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(28);
            nodeMessage.setSavepoint(string);
            nodeMessage.setRequestId(n);
            this.sendHelper.sendMessageToList(this.nodeList, nodeMessage);
        }
        finally {
            this.monitor.waitForMessages(SHORT_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endSavepoint(String string) throws XDBServerException {
        this.checkConnections();
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, this.nodeList);
        try {
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(32);
            nodeMessage.setSavepoint(string);
            nodeMessage.setRequestId(n);
            this.sendHelper.sendMessageToList(this.nodeList, nodeMessage);
        }
        finally {
            this.monitor.waitForMessages(SHORT_TIMEOUT);
        }
        this.client.clearSavepoint(string);
    }

    public int executeCommand(String string, Collection<DBNode> collection) throws XDBServerException {
        return this.executeCommand(string, collection, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String string, Collection<DBNode> collection, boolean bl) throws XDBServerException {
        NodeMessage[] nodeMessageArray;
        int n = 0;
        int n2 = this.client.getRequestId();
        this.monitor.setMonitor(n2, collection);
        try {
            nodeMessageArray = NodeMessage.getNodeMessage(7);
            nodeMessageArray.setSqlCommand(string);
            nodeMessageArray.setRequestId(n2);
            nodeMessageArray.setAutocommit(bl);
            this.sendHelper.sendMessageToList(collection, (NodeMessage)nodeMessageArray);
        }
        finally {
            for (NodeMessage nodeMessage : nodeMessageArray = this.monitor.waitForMessages()) {
                n += nodeMessage.getNumRowsResult();
            }
        }
        int n3 = n;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeMessage> execute(String string, Collection<DBNode> collection, boolean bl) throws XDBServerException {
        List<NodeMessage> list;
        List<NodeMessage> list2;
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, collection);
        try {
            list2 = NodeMessage.getNodeMessage(7);
            ((NodeMessage)((Object)list2)).setSqlCommand(string);
            ((NodeMessage)((Object)list2)).setRequestId(n);
            ((NodeMessage)((Object)list2)).setAutocommit(bl);
            this.sendHelper.sendMessageToList(collection, (NodeMessage)((Object)list2));
        }
        finally {
            list = Arrays.asList(this.monitor.waitForMessages());
        }
        for (NodeMessage nodeMessage : list) {
            if (nodeMessage.getMessageType() != 108) continue;
            this.addFinalResultSet(nodeMessage);
        }
        list2 = list;
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFinalResultSet(NodeMessage nodeMessage) {
        HashMap<String, HashMap<Integer, NodeResultSetImpl>> hashMap = this.finalRSs;
        synchronized (hashMap) {
            HashMap<Integer, NodeResultSetImpl> hashMap2 = this.finalRSs.get(nodeMessage.getResultSetID());
            if (hashMap2 == null) {
                hashMap2 = new HashMap();
                this.finalRSs.put(nodeMessage.getResultSetID(), hashMap2);
            }
            hashMap2.put(nodeMessage.getSourceNodeID(), nodeMessage.getResultSet());
        }
    }

    public int executeCommand(Map<DBNode, String> map) throws XDBServerException {
        return this.executeCommand(map, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(Map<DBNode, String> map, boolean bl) throws XDBServerException {
        int n = 0;
        int n2 = this.client.getRequestId();
        this.monitor.setMonitor(n2, map.keySet());
        try {
            for (Map.Entry<DBNode, String> nodeMessageArray : map.entrySet()) {
                NodeMessage nodeMessage = NodeMessage.getNodeMessage(7);
                nodeMessage.setSqlCommand(nodeMessageArray.getValue());
                nodeMessage.setRequestId(n2);
                nodeMessage.setAutocommit(bl);
                this.sendHelper.sendMessage(nodeMessageArray.getKey().getNodeId(), nodeMessage);
            }
        }
        finally {
            NodeMessage[] nodeMessageArray;
            for (NodeMessage nodeMessage : nodeMessageArray = this.monitor.waitForMessages()) {
                n += nodeMessage.getNumRowsResult();
            }
        }
        int n3 = n;
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() throws XDBServerException {
        try {
            if (this.nodeList.size() > 1) {
                this.checkConnections();
            }
            LockManager lockManager = this.client.getSysDatabase().getLm();
            lockManager.beforeCommit(this.client);
            int n = this.client.getRequestId();
            this.monitor.setMonitor(n, this.nodeList);
            try {
                this.sendHelper.sendMessageToList(this.nodeList, 22, n);
            }
            finally {
                this.monitor.waitForMessages();
            }
        }
        finally {
            this.client.setInTransaction(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() {
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, this.nodeList);
        try {
            this.sendHelper.sendMessageToList(this.nodeList, 24, n);
            this.client.setInTransaction(false);
        }
        finally {
            this.monitor.waitForMessages();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackSavepoint(String string) throws XDBServerException {
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, this.nodeList);
        try {
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(30);
            nodeMessage.setSavepoint(string);
            nodeMessage.setRequestId(n);
            this.sendHelper.sendMessageToList(this.nodeList, nodeMessage);
        }
        finally {
            this.monitor.waitForMessages();
            this.client.clearSavepoint(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseNodeThreads() {
        this.releaseNodeThreads(this.nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dropNodeTempTables(Collection<String> collection) {
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, this.nodeList);
        try {
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(26);
            nodeMessage.setTempTables(collection);
            nodeMessage.setRequestId(n);
            nodeMessage.setAutocommit(!this.client.isInTransaction() && !this.client.isInSubTransaction());
            this.sendHelper.sendMessageToList(this.nodeList, nodeMessage);
        }
        finally {
            this.monitor.waitForMessages(SHORT_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initInserts(String string, Collection<Integer> collection) {
        this.currentStepProcesses = collection;
        int n = this.client.getRequestId();
        NodeMessage nodeMessage = NodeMessage.getNodeMessage(19);
        nodeMessage.setTargetTable(string);
        nodeMessage.setRequestId(n);
        this.sendHelper.sendMessageToList(this.currentStepProcesses, nodeMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishProducerSender(boolean bl) throws XDBServerException {
        if (this.currentStepProcesses != null && this.insertProducerSender != null) {
            if (bl) {
                this.insertProducerSender.finishInserts(1);
            } else {
                this.insertProducerSender.finishInserts(3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInserts() throws XDBServerException {
        block5: {
            if (this.currentStepProcesses == null) break block5;
            int n = this.client.getRequestId();
            this.monitor.setMonitor(n, this.currentStepProcesses);
            try {
                this.sendHelper.sendMessageToList(this.currentStepProcesses, 10, n);
            }
            finally {
                this.monitor.waitForMessages();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeStep(QueryCombiner queryCombiner, StepDetail stepDetail, StepDetail stepDetail2, Map<Integer, NodeUsage> map, int n, int n2) throws XDBServerException {
        try {
            Serializable serializable;
            queryCombiner.sCreateStatement = stepDetail.targetSchema;
            if (stepDetail.getDestType() == 2 || stepDetail.getDestType() == 5 || stepDetail.combineOnCoordFirst || stepDetail2 != null && stepDetail2.getDestType() == 5) {
                queryCombiner.createTempTable();
            }
            this.currentStepProcesses = new HashSet<Integer>();
            ArrayList<Serializable> arrayList = new ArrayList<Serializable>(n);
            HashMap<Serializable, NodeMessage> hashMap = new HashMap<Serializable, NodeMessage>();
            int n3 = this.client.getRequestId();
            for (NodeUsage nodeUsage : map.values()) {
                serializable = new Integer(nodeUsage.nodeId);
                Object object = stepDetail.copy();
                if (nodeUsage.isConsumer) {
                    this.currentStepProcesses.add((Integer)serializable);
                } else {
                    ((StepDetail)object).isConsumer = false;
                }
                if (nodeUsage.isProducer) {
                    this.currentStepProcesses.add((Integer)serializable);
                    arrayList.add(serializable);
                    if (Props.XDB_ENABLE_ACTIVITY_LOG) {
                        ActivityLog.startStep(this.client.getStatementId(), nodeUsage.nodeId);
                    }
                } else {
                    ((StepDetail)object).isProducer = false;
                }
                Object object2 = NodeMessage.getNodeMessage(9);
                if (((StepDetail)object).queryString != null) {
                    Object object3;
                    Object object4;
                    int n4 = ((StepDetail)object).queryString.lastIndexOf("XNODEID");
                    if (n4 > 0) {
                        object4 = ((StepDetail)object).copy();
                        object3 = ((StepDetail)object4).queryString.substring(n4, ((StepDetail)object4).queryString.indexOf(" ", n4));
                        ((StepDetail)object4).queryString = ((StepDetail)object4).queryString.replaceFirst((String)object3, serializable + " AS " + (String)object3);
                        object = object4;
                    } else {
                        object4 = ((StepDetail)object).getOuterNodeIdColumn();
                        if (object4 != null) {
                            object3 = ((StepDetail)object).copy();
                            ((StepDetail)object3).queryString = ((StepDetail)object3).queryString.replaceAll((String)object4, serializable + " AS " + IdentifierHandler.quote((String)object4));
                            object = object3;
                        }
                    }
                }
                if (((StepDetail)object).usesTablespace()) {
                    ((StepDetail)object).targetSchema = ((StepDetail)object).targetSchema + " TABLESPACE " + ((StepDetail)object).getTablespaceClause((Integer)serializable);
                }
                ((NodeMessage)object2).setStepDetail((StepDetail)object);
                ((NodeMessage)object2).setRequestId(n3);
                hashMap.put(serializable, (NodeMessage)object2);
            }
            if (stepDetail.isConsumer) {
                this.monitor.setMonitor(n3, hashMap.keySet());
                try {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        this.sendHelper.sendMessage((Integer)entry.getKey(), (NodeMessage)entry.getValue());
                    }
                }
                finally {
                    this.monitor.waitForMessages(SHORT_TIMEOUT);
                }
                this.sendDataMessages.clear();
            }
            this.monitor.setMonitor(n3, arrayList);
            for (Map.Entry entry : hashMap.entrySet()) {
                serializable = (NodeMessage)entry.getValue();
                ((NodeMessage)serializable).setMessageType(209);
                this.sendHelper.sendMessage((Integer)entry.getKey(), (NodeMessage)serializable);
            }
            if (stepDetail2 != null && stepDetail2.isProducer && stepDetail.isConsumer) {
                try {
                    this.coordinatorQueue.clear();
                    queryCombiner.queryOnCoordAndSendToNodes(stepDetail2.queryString, stepDetail2, new ProducerSender(this.sendHelper, this.coordinatorQueue));
                }
                catch (Exception exception) {
                    logger.catching(exception);
                    this.abortSQLCommand(this.nodeList, n3);
                    XDBServerException xDBServerException = new XDBServerException("Step on coordinator failed " + exception.getMessage(), exception);
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
            }
            Iterator<Object> iterator = null;
            do {
                NodeMessage nodeMessage;
                try {
                    nodeMessage = this.sendDataMessages.poll(20L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                if (nodeMessage == null) {
                    iterator = this.monitor.checkMessages();
                    continue;
                }
                if (nodeMessage.getMessageType() == 16) {
                    for (Serializable serializable2 : serializable = nodeMessage.getRowData()) {
                        queryCombiner.insertFromStatementOnCombiner((String)((Object)serializable2));
                    }
                    Serializable serializable3 = NodeMessage.getNodeMessage(17);
                    ((NodeMessage)serializable3).setDataSeqNo(nodeMessage.getDataSeqNo());
                    ((NodeMessage)serializable3).setRequestId(nodeMessage.getRequestId());
                    this.sendHelper.sendReplyMessage(nodeMessage, (NodeMessage)serializable3);
                    continue;
                }
                if (nodeMessage.getMessageType() == 46) {
                    ActivityLog.startShipRows(this.client.getStatementId(), nodeMessage.getSourceNodeID(), ((SendRowsMessage)nodeMessage).getDestNodeForRows());
                } else if (nodeMessage.getMessageType() == 47) {
                    ActivityLog.endShipRows(this.client.getStatementId(), nodeMessage.getSourceNodeID(), ((SendRowsMessage)nodeMessage).getDestNodeForRows(), ((SendRowsMessage)nodeMessage).getNumRowsSent());
                } else if (nodeMessage.getMessageType() != 1) {
                    this.monitor.register(nodeMessage);
                }
                iterator = this.monitor.checkMessages();
            } while (iterator == null);
            if (stepDetail2 != null && stepDetail2.isConsumer && Props.XDB_DUMPSTEPPATH != null) {
                NodeThread.dumpStepResults(this.client.getAndSetCoordinatorConnection(), stepDetail2.targetTable, 0);
            }
            if (stepDetail.getDestType() == 6) {
                for (Iterator<Object> iterator2 : iterator) {
                    this.addFinalResultSet((NodeMessage)((Object)iterator2));
                    this.currentResultSetID = ((NodeMessage)((Object)iterator2)).getResultSetID();
                }
            }
            if (stepDetail2 != null && stepDetail2.isConsumer) {
                queryCombiner.finishInserts();
            }
            if (stepDetail != null && stepDetail.isConsumer) {
                this.finishInserts();
            }
            if (!Props.XDB_ENABLE_ACTIVITY_LOG) return;
        }
        catch (XDBMessageMonitorException xDBMessageMonitorException) {
            try {
                HashSet<Integer> hashSet = new HashSet<Integer>(xDBMessageMonitorException.getRemainingNodes());
                hashSet.addAll(this.currentStepProcesses);
                this.abortSQLCommand(hashSet, this.monitor.getRequestId());
                throw xDBMessageMonitorException;
            }
            catch (Throwable throwable) {
                if (!Props.XDB_ENABLE_ACTIVITY_LOG) throw throwable;
                for (NodeUsage nodeUsage : map.values()) {
                    if (!nodeUsage.isProducer) continue;
                    ActivityLog.endStep(this.client.getStatementId(), nodeUsage.nodeId);
                }
                throw throwable;
            }
        }
        for (Object object2 : map.values()) {
            if (!((NodeUsage)object2).isProducer) continue;
            ActivityLog.endStep(this.client.getStatementId(), ((NodeUsage)object2).nodeId);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendTableDownDistinct(StepDetail stepDetail, Collection<Integer> collection, QueryCombiner queryCombiner) throws Exception {
        if (stepDetail.getDestType() == 2) {
            return;
        }
        this.initInserts(stepDetail.targetTable, collection);
        String string = "SELECT DISTINCT * FROM " + stepDetail.targetTable;
        this.coordinatorQueue.clear();
        queryCombiner.queryOnCoordAndSendToNodes(string, stepDetail, new ProducerSender(this.sendHelper, this.coordinatorQueue));
        this.finishInserts();
    }

    Collection<DBNode> getNodeList() {
        return Collections.unmodifiableCollection(this.nodeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends ResultSet> getFinalResultSets() {
        HashMap<String, HashMap<Integer, NodeResultSetImpl>> hashMap = this.finalRSs;
        synchronized (hashMap) {
            HashMap<Integer, NodeResultSetImpl> hashMap2 = this.finalRSs.get(this.currentResultSetID);
            this.currentResultSetID = null;
            return hashMap2 == null ? null : new ArrayList<NodeResultSetImpl>(hashMap2.values());
        }
    }

    private void abortSQLCommand(Collection collection, int n) {
        this.sendHelper.sendMessageToList(collection, 1, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean processMessage(NodeMessage nodeMessage) {
        switch (nodeMessage.getMessageType()) {
            case 17: 
            case 41: {
                this.coordinatorQueue.offer(nodeMessage);
                return true;
            }
            case 1: {
                this.coordinatorQueue.offer(nodeMessage);
                boolean bl = this.monitor.abort(nodeMessage);
                HashMap<String, HashMap<Integer, NodeResultSetImpl>> hashMap = this.finalRSs;
                synchronized (hashMap) {
                    Iterator<HashMap<Integer, NodeResultSetImpl>> iterator = this.finalRSs.values().iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            // MONITOREXIT @DISABLED, blocks:[0, 16, 20, 6, 7, 9] lbl16 : MonitorExitStatement: MONITOREXIT : var3_4
                            this.sendDataMessages.offer(nodeMessage);
                            return bl;
                        }
                        HashMap<Integer, NodeResultSetImpl> hashMap2 = iterator.next();
                        Iterator<NodeResultSetImpl> iterator2 = hashMap2.values().iterator();
                        while (iterator2.hasNext()) {
                            if (!iterator2.next().processMessage(nodeMessage)) continue;
                            iterator2.remove();
                            bl = true;
                        }
                        if (!hashMap2.isEmpty()) continue;
                        iterator.remove();
                    }
                }
            }
            case 14: {
                this.sendHelper.sendReplyMessage(nodeMessage, 15);
                return true;
            }
            case 11: 
            case 16: {
                this.sendDataMessages.offer(nodeMessage);
                return true;
            }
            case 43: {
                NodeResultSetImpl nodeResultSetImpl = null;
                HashMap<String, HashMap<Integer, NodeResultSetImpl>> hashMap = this.finalRSs;
                synchronized (hashMap) {
                    HashMap<Integer, NodeResultSetImpl> hashMap3 = this.finalRSs.get(nodeMessage.getResultSetID());
                    if (hashMap3 != null) {
                        nodeResultSetImpl = nodeMessage.isResultSetHasMoreRows() ? hashMap3.get(nodeMessage.getSourceNodeID()) : hashMap3.remove(nodeMessage.getSourceNodeID());
                        if (hashMap3.isEmpty()) {
                            this.finalRSs.remove(nodeMessage.getResultSetID());
                        }
                    }
                }
                if (nodeResultSetImpl == null) return false;
                return nodeResultSetImpl.processMessage(nodeMessage);
            }
            case 142: {
                HashMap<String, HashMap<Integer, NodeResultSetImpl>> hashMap = this.finalRSs;
                synchronized (hashMap) {
                    HashMap<Integer, NodeResultSetImpl> hashMap4 = this.finalRSs.get(nodeMessage.getResultSetID());
                    if (hashMap4 == null) return true;
                    hashMap4.remove(nodeMessage.getSourceNodeID());
                    if (!hashMap4.isEmpty()) return true;
                    this.finalRSs.remove(nodeMessage.getResultSetID());
                    return true;
                }
            }
            default: {
                this.monitor.register(nodeMessage);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addBatchOnNodeList(String string, Collection<DBNode> collection) throws XDBServerException {
        if (this.aBatchHandler == null) {
            this.coordinatorQueue.clear();
            this.aBatchHandler = new BatchHandler(this.sendHelper, this.coordinatorQueue, this.client);
        }
        boolean bl = this.aBatchHandler.addToBatchOnNodeList(string, collection);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addBatchOnNodeList(Map<DBNode, String> map) throws XDBServerException {
        if (this.aBatchHandler == null) {
            this.coordinatorQueue.clear();
            this.aBatchHandler = new BatchHandler(this.sendHelper, this.coordinatorQueue, this.client);
        }
        boolean bl = this.aBatchHandler.addToBatchOnNodes(map);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addBatchOnNode(String string, int n) throws XDBServerException {
        if (this.aBatchHandler == null) {
            this.coordinatorQueue.clear();
            this.aBatchHandler = new BatchHandler(this.sendHelper, this.coordinatorQueue, this.client);
        }
        boolean bl = this.aBatchHandler.addToBatchOnNode(string, n);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] executeBatch(boolean bl) {
        int[] nArray;
        block8: {
            nArray = null;
            if (this.aBatchHandler != null) break block8;
            int[] nArray2 = new int[]{};
            return nArray2;
        }
        try {
            nArray = this.aBatchHandler.executeBatch(bl);
        }
        catch (XDBServerException xDBServerException) {
            this.abortSQLCommand(this.nodeList, this.aBatchHandler.getRequestId());
            throw xDBServerException;
        }
        finally {
            this.aBatchHandler.clearBatch();
        }
        int[] nArray3 = nArray;
        return nArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBatch() {
        if (this.aBatchHandler != null) {
            this.aBatchHandler.clearBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void kill() {
        Collection<DBNode> collection = this.nodeList;
        synchronized (collection) {
            this.sendHelper.sendMessageToList(this.nodeList, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startLoaders(String string, String string2) throws XDBServerException {
        int n = this.client.getRequestId();
        NodeMessage nodeMessage = NodeMessage.getNodeMessage(45);
        nodeMessage.setTargetTable(string);
        nodeMessage.setSqlCommand(string2);
        nodeMessage.setRequestId(n);
        this.monitor.setMonitor(n, this.getNodeList());
        try {
            Iterator<DBNode> iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                DBNode dBNode;
                DBNode dBNode2 = dBNode = iterator.next();
                Node node = dBNode2.getNode();
                NodeMessage nodeMessage2 = (NodeMessage)nodeMessage.clone();
                nodeMessage2.setJdbcString(node.getSHost());
                nodeMessage2.setDatabase(node.getNodeDatabaseString(this.client.getDBName()));
                nodeMessage2.setJdbcUser(node.getJdbcUser());
                nodeMessage2.setJdbcPassword(node.getJdbcPassword());
                this.sendHelper.sendMessage(new Integer(dBNode2.getNodeId()), nodeMessage2);
            }
        }
        finally {
            this.monitor.waitForMessages(SHORT_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareStatement(String string, String string2, int[] nArray, Collection<DBNode> collection) throws XDBServerException {
        String string3 = this.client.registerPreparedStatement(string, collection);
        try {
            Object object;
            int n = this.client.getRequestId();
            this.monitor.setMonitor(n, collection);
            try {
                object = NodeMessage.getNodeMessage(71);
                ((NodeMessage)object).addRowData(string3);
                ((NodeMessage)object).addRowData(string2);
                for (int n2 : nArray) {
                    ((NodeMessage)object).addRowData("" + n2);
                }
                ((NodeMessage)object).setRequestId(n);
                this.sendHelper.sendMessageToList(collection, (NodeMessage)object);
            }
            finally {
                this.monitor.waitForMessages();
            }
            object = string3;
            return object;
        }
        catch (XDBServerException xDBServerException) {
            logger.catching(xDBServerException);
            this.client.unregisterPreparedStatement(string3);
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<NodeMessage> executePreparedStatement(String string, String[] stringArray, Collection<DBNode> collection) throws XDBServerException {
        List<NodeMessage> list;
        List<NodeMessage> list2;
        Collection<DBNode> collection2 = this.client.getPreparedStatementNodes(string);
        if (collection2 == null) {
            throw new XDBServerException("Prepared statement does not exist");
        }
        if (!collection2.containsAll(collection)) {
            throw new XDBServerException("Prepared statement does not exist on requested node(s)");
        }
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, collection);
        try {
            list2 = NodeMessage.getNodeMessage(72);
            ((NodeMessage)((Object)list2)).setRequestId(n);
            ((NodeMessage)((Object)list2)).addRowData(string);
            for (String string2 : stringArray) {
                ((NodeMessage)((Object)list2)).addRowData(string2);
            }
            this.sendHelper.sendMessageToList(collection, (NodeMessage)((Object)list2));
        }
        finally {
            list = Arrays.asList(this.monitor.waitForMessages());
        }
        for (NodeMessage nodeMessage : list) {
            if (nodeMessage.getMessageType() != 108) continue;
            this.addFinalResultSet(nodeMessage);
        }
        list2 = list;
        return list2;
    }

    public int executePreparedCommand(String string, String[] stringArray, Collection<DBNode> collection) throws XDBServerException {
        Collection<NodeMessage> collection2 = this.executePreparedStatement(string, stringArray, collection);
        int n = 0;
        for (NodeMessage nodeMessage : collection2) {
            n += nodeMessage.getNumRowsResult();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePrepared(String string) throws XDBServerException {
        Collection<DBNode> collection = null;
        collection = this.client.getPreparedStatementNodes(string);
        if (collection == null) {
            throw new XDBServerException("Prepared statement is not found");
        }
        int n = this.client.getRequestId();
        this.monitor.setMonitor(n, collection);
        try {
            NodeMessage nodeMessage = NodeMessage.getNodeMessage(73);
            nodeMessage.setSqlCommand(string);
            nodeMessage.setRequestId(n);
            this.sendHelper.sendMessageToList(collection, nodeMessage);
        }
        finally {
            this.monitor.waitForMessages();
        }
    }
}

