/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLevel;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.NodeThread;
import com.edb.gridsql.engine.ProducerSender;
import com.edb.gridsql.engine.copy.CopyManager;
import com.edb.gridsql.engine.io.ResponseMessage;
import com.edb.gridsql.engine.io.ResultSetResponse;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBUnexpectedStateException;
import com.edb.gridsql.exception.XDBWrappedException;
import com.edb.gridsql.exception.XDBWrappedSQLException;
import com.edb.gridsql.misc.Timer;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeProducerThread
implements Runnable {
    private static final XLogger logger = XLogger.getLogger(NodeProducerThread.class);
    public static final XLogger CATEGORY_NODEQUERYTIME = XLogger.getLogger("nodequerytime");
    protected static final int STATEDISCONNECTED = -1;
    protected static final int STATEWAIT = 0;
    protected static final int STATEDONE = 5;
    protected static final int STATESTEP = 7;
    protected static final int STATEDATADOWN = 8;
    private int currentState;
    private volatile int requestIDtoAbort = -1;
    private Connection oConn;
    int iColumnCount;
    private NodeThread parent;
    int nodeId;
    private SendMessageHelper sendHelper;
    int procCount = 0;
    private LinkedBlockingQueue<NodeMessage> producerQueue;
    private HashMap<String, QueryResult> resultTable = new HashMap();
    private HashMap<String, PreparedStatementEx> preparedStatementTable = new HashMap();
    private ProducerSender aProducerSender = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeProducerThread(NodeThread nodeThread, LinkedBlockingQueue<NodeMessage> linkedBlockingQueue) {
        try {
            this.parent = nodeThread;
            this.nodeId = nodeThread.getNodeId();
            this.producerQueue = linkedBlockingQueue;
            this.currentState = -1;
            this.resultTable = new HashMap();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws XDBBaseException {
        try {
            int n;
            if (this.aProducerSender != null) {
                this.aProducerSender.setAbort(true);
            }
            for (n = 0; this.currentState != -1 && this.currentState != 0 && this.currentState != 5 && n <= 20; ++n) {
                try {
                    this.wait(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.catching(interruptedException);
                }
            }
            for (n = 0; this.currentState != -1 && this.currentState != 0 && this.currentState != 5 && n <= 20; ++n) {
                this.kill();
                try {
                    this.wait(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    logger.catching(interruptedException);
                }
            }
            if (this.currentState == 5) {
                XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, 5, new int[]{0, -1});
                logger.throwing(xDBUnexpectedStateException);
                throw xDBUnexpectedStateException;
            }
            this.oConn = this.parent.getConnection();
            this.sendHelper = this.parent.getSendHelper();
            if (this.oConn == null || this.sendHelper == null) {
                this.setState(-1);
                this.closeAllResultSets();
            } else {
                this.setState(0);
            }
            this.requestIDtoAbort = -1;
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setState(int n) {
        try {
            this.currentState = n;
            this.notify();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private synchronized int checkCurrentState(int[] nArray, int n) throws XDBUnexpectedStateException {
        for (int n2 : nArray) {
            if (this.currentState != n2) continue;
            this.setState(n);
            return n2;
        }
        XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, this.currentState, nArray);
        logger.throwing(xDBUnexpectedStateException);
        throw xDBUnexpectedStateException;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void closeAllResultSets() {
        if (this.resultTable != null) {
            for (QueryResult queryResult : this.resultTable.values()) {
                this.closeResultSet(queryResult.aResultSet);
                this.resultTable.remove(queryResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized void closeResultSet(ResultSet resultSet) {
        try {
            try {
                if (this.currentState == -1) {
                    return;
                }
                Connection connection = this.oConn;
                synchronized (connection) {
                    if (resultSet != null) {
                        resultSet.getStatement().close();
                    } else {
                        logger.log(XLevel.TRACE, "For connection: %0% current result set is Null, nothing to do", new Object[]{this.oConn});
                    }
                    this.oConn.notify();
                    return;
                }
            }
            catch (Exception exception) {
                logger.catching(exception);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ResultSet processStep(NodeMessage var1_1) throws XDBBaseException {
        block13: {
            block14: {
                var2_2 = var1_1.getStepDetail();
                var3_3 = null;
                if (!Props.XDB_USE_COPY_OUT_FOR_STEP || var2_2.getDestType() == 6) break block14;
                var4_4 = CopyManager.getCopyManager(this.oConn);
                var5_8 = var4_4.copyOut("copy (" + var2_2.queryString + ") to stdout");
                this.aProducerSender = new ProducerSender(this.sendHelper, this.producerQueue);
                this.aProducerSender.sendToNodes(var5_8, var2_2, (Object)this.oConn, this.nodeId, var1_1.getRequestId());
                ** GOTO lbl37
            }
            try {
                var3_3 = this.executeQuery(var2_2.queryString);
            }
            catch (SQLException var4_5) {
                this.parent.handleSqlException(var4_5, var2_2.queryString);
                try {
                    var3_3 = this.executeQuery(var2_2.queryString);
                }
                catch (SQLException var5_9) {
                    NodeProducerThread.logger.catching(var5_9);
                    var6_12 = new XDBWrappedSQLException(this.nodeId, var5_9);
                    NodeProducerThread.logger.throwing(var6_12);
                    throw var6_12;
                }
            }
            if (var2_2.getDestType() != 6) break block13;
            var4_6 = var3_3;
            var8_14 = null;
            this.aProducerSender = null;
            return var4_6;
        }
        try {
            this.aProducerSender = new ProducerSender(this.sendHelper, this.producerQueue);
            this.aProducerSender.sendToNodes(var3_3, var2_2, (Object)this.oConn, this.nodeId, var1_1.getRequestId());
lbl37:
            // 2 sources

            this.dropTempTables(var2_2.dropList, true);
            {
                catch (Exception var4_7) {
                    NodeProducerThread.logger.catching(var4_7);
                    try {
                        this.dropTempTables(var2_2.dropList, true);
                    }
                    catch (Exception var5_10) {
                        NodeProducerThread.logger.catching(var5_10);
                    }
                    var5_11 = var4_7 instanceof XDBBaseException != false ? (XDBBaseException)var4_7 : (var4_7 instanceof SQLException != false ? new XDBWrappedSQLException(this.nodeId, (SQLException)var4_7) : new XDBWrappedException(this.nodeId, (Throwable)var4_7));
                    if (var2_2.consumerNodeList != null) {
                        this.requestIDtoAbort = var1_1.getRequestId();
                        var6_13 = NodeMessage.getNodeMessage(1);
                        var6_13.setRequestId(this.requestIDtoAbort);
                        var6_13.setCause(var5_11);
                        this.sendHelper.sendMessageToList(var2_2.consumerNodeList, var6_13);
                    }
                    NodeProducerThread.logger.throwing(var5_11);
                    throw var5_11;
                }
            }
            var4_4 = var3_3;
            var8_15 = null;
            this.aProducerSender = null;
            return var4_4;
        }
        catch (Throwable var7_17) {
            var8_16 = null;
            this.aProducerSender = null;
            throw var7_17;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        Object object = this.oConn;
        synchronized (object) {
            statement = this.oConn.createStatement();
            statement.setFetchSize(Props.XDB_NODEFETCHSIZE);
            this.oConn.notify();
        }
        object = new Timer();
        Connection connection = this.oConn;
        synchronized (connection) {
            ((Timer)object).startTimer();
            resultSet = statement.executeQuery(string);
            ((Timer)object).stopTimer();
            this.oConn.notify();
        }
        CATEGORY_NODEQUERYTIME.debug("Node: " + this.nodeId + " Duration: " + object + " : " + string);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(NodeMessage nodeMessage) throws SQLException {
        boolean bl;
        Statement statement = null;
        Object object = this.oConn;
        synchronized (object) {
            statement = this.oConn.createStatement();
            statement.setFetchSize(Props.XDB_NODEFETCHSIZE);
            this.oConn.notify();
        }
        object = new Timer();
        Connection connection = this.oConn;
        synchronized (connection) {
            ((Timer)object).startTimer();
            if (nodeMessage.getAutocommit()) {
                this.oConn.setAutoCommit(true);
            }
            bl = statement.execute(nodeMessage.getSqlCommand());
            if (nodeMessage.getAutocommit()) {
                this.oConn.setAutoCommit(false);
            }
            ((Timer)object).stopTimer();
            this.oConn.notify();
        }
        CATEGORY_NODEQUERYTIME.debug("Node: " + this.nodeId + " Duration: " + object + " : " + nodeMessage.getSqlCommand());
        this.handleExecutionResult(bl, statement, nodeMessage);
    }

    private void handleExecutionResult(boolean bl, Statement statement, NodeMessage nodeMessage) throws SQLException {
        if (bl) {
            ResultSet resultSet = statement.getResultSet();
            String string = String.valueOf(nodeMessage.getRequestId());
            QueryResult queryResult = new QueryResult(new ResultSetResponse(0, "", resultSet));
            queryResult.packNextResultRows(108);
            queryResult.nextMessage.setResultSetID(string);
            if (queryResult.nextMessage.isResultSetHasMoreRows()) {
                this.resultTable.put(string, queryResult);
            } else {
                resultSet.close();
            }
            this.sendHelper.sendReplyMessage(nodeMessage, queryResult.nextMessage);
            if (queryResult.nextMessage.isResultSetHasMoreRows()) {
                queryResult.packNextResultRows(43);
            }
        } else {
            NodeMessage nodeMessage2 = NodeMessage.getNodeMessage(8);
            nodeMessage2.setNumRowsResult(statement.getUpdateCount());
            this.sendHelper.sendReplyMessage(nodeMessage, nodeMessage2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTempTables(Collection collection, boolean bl) {
        try {
            for (String string : collection) {
                try {
                    this.processSqlCommand("DROP TABLE " + IdentifierHandler.quote(string), false);
                    HashSet<String> hashSet = this.parent.tempTableNames;
                    synchronized (hashSet) {
                        this.parent.tempTableNames.remove(string);
                    }
                }
                catch (Exception exception) {
                    Connection connection = this.oConn;
                    synchronized (connection) {
                        try {
                            this.oConn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.oConn.notify();
                    }
                    logger.catching(exception);
                }
            }
            if (bl) {
                try {
                    this.oConn.commit();
                }
                catch (SQLException sQLException) {
                    try {
                        this.oConn.rollback();
                    }
                    catch (SQLException sQLException2) {
                    }
                }
            }
            Object var10_13 = null;
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processSqlCommand(String string, boolean bl) throws XDBBaseException {
        Statement statement = null;
        int n = 0;
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                statement = this.oConn.createStatement();
                try {
                    n = statement.executeUpdate(string);
                    if (bl) {
                        this.oConn.commit();
                    }
                    Object var7_8 = null;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    statement.close();
                    statement = null;
                    throw throwable;
                }
                statement.close();
                statement = null;
                this.oConn.notify();
            }
            int n2 = n;
            Object var10_13 = null;
            return n2;
        }
        catch (SQLException sQLException) {
            try {
                logger.catching(sQLException);
                XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException);
                logger.throwing(xDBWrappedSQLException);
                throw xDBWrappedSQLException;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        try {
            if (this.aProducerSender != null) {
                this.aProducerSender.setAbort(true);
            }
            try {
                for (QueryResult queryResult : this.resultTable.values()) {
                    if (queryResult.aResultSet == null) continue;
                    Statement statement = queryResult.aResultSet.getStatement();
                    if (statement == null) {
                        queryResult.aResultSet.close();
                        continue;
                    }
                    statement.cancel();
                }
                this.resultTable.clear();
            }
            catch (Throwable throwable) {
                logger.catching(throwable);
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            throw throwable;
        }
    }

    protected int getState() {
        return this.currentState;
    }

    private class PreparedStatementEx {
        PreparedStatement ps;
        int[] paramTypes;

        PreparedStatementEx(PreparedStatement preparedStatement, int[] nArray) {
            this.ps = preparedStatement;
            this.paramTypes = nArray;
        }
    }

    class QueryResult {
        ResultSetResponse rsResponse;
        ResultSet aResultSet;
        NodeMessage nextMessage = null;

        public QueryResult(ResultSetResponse resultSetResponse) {
            this.rsResponse = resultSetResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeMessage packNextResultRows(int n) throws SQLException {
            block4: {
                try {
                    if (this.rsResponse != null) break block4;
                    NodeMessage nodeMessage = null;
                    Object var7_4 = null;
                    return nodeMessage;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    throw throwable;
                }
            }
            ResponseMessage responseMessage = this.rsResponse.nextResults(this.rsResponse.getFetchSize());
            byte[] byArray = new byte[responseMessage.getPacketLength()];
            System.arraycopy(responseMessage.getHeaderBytes(), 0, byArray, 0, 8);
            System.arraycopy(responseMessage.getMessage(), 0, byArray, 8, responseMessage.getPacketLength() - 8);
            this.nextMessage = NodeMessage.getNodeMessage(n);
            this.nextMessage.setResultSetData(byArray);
            boolean bl = responseMessage.getMessage()[0] == 1;
            logger.log(Level.INFO, "Node %0% sends new ResultSet packet, size: %1%, last: %2%", new Object[]{new Integer(NodeProducerThread.this.nodeId), new Integer(byArray.length), new Boolean(bl)});
            if (bl) {
                NodeProducerThread.this.closeResultSet(this.aResultSet);
                this.rsResponse = null;
            }
            this.nextMessage.setResultSetHasMoreRows(!bl);
            NodeMessage nodeMessage = this.nextMessage;
            Object var7_5 = null;
            return nodeMessage;
        }
    }
}

