/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.datatypes;

import com.edb.gridsql.common.util.SQLTypeConverter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class XBlob
implements Blob {
    private byte[] val = null;

    protected XBlob() {
    }

    public XBlob(byte[] byArray) {
        this.val = byArray;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.val == null) {
            return null;
        }
        return new ByteArrayInputStream(this.val);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.val == null) {
            return null;
        }
        if (l + (long)n - 1L > (long)this.val.length) {
            n = this.val.length - (int)l + 1;
        }
        if (n > 0) {
            byte[] byArray = new byte[n];
            System.arraycopy(this.val, (int)l - 1, byArray, 0, n);
            return byArray;
        }
        return new byte[0];
    }

    public long length() throws SQLException {
        return this.val == null ? 0L : (long)this.val.length;
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (byArray == null || byArray.length == 0) {
            return l;
        }
        if (l > (long)this.val.length) {
            return -1L;
        }
        block0: for (int i = (int)l - 1; i < this.val.length - byArray.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < byArray.length; ++j) {
                if (this.val[i + j] == byArray[j]) continue;
                bl = false;
                continue block0;
            }
            if (!bl) continue;
            return i;
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        byte[] byArray = blob.getBytes(0L, (int)blob.length());
        if (blob == null) {
            return -1L;
        }
        return this.position(byArray, l);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        return new XBlobOutputStream(l);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        byte[] byArray2 = new byte[(int)l - 1 + n2];
        if (l - 1L > (long)this.val.length) {
            System.arraycopy(this.val, 0, byArray2, 0, this.val.length);
            for (int i = this.val.length; i < (int)l; ++i) {
                byArray2[i] = 0;
            }
            System.arraycopy(byArray, n, byArray2, (int)l, n2);
            this.val = byArray2;
        } else {
            System.arraycopy(this.val, 0, byArray2, 0, (int)l - 1);
            System.arraycopy(byArray, n, this.val, (int)l, n2);
        }
        return n2;
    }

    public void truncate(long l) throws SQLException {
        byte[] byArray = new byte[(int)l];
        System.arraycopy(this.val, 0, byArray, 0, (int)l);
        this.val = byArray;
    }

    public String toString() {
        if (this.val == null) {
            return null;
        }
        return SQLTypeConverter.getHexString(this.val);
    }

    public void free() throws SQLException {
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        return null;
    }

    private class XBlobOutputStream
    extends ByteArrayOutputStream {
        private long pos;

        private XBlobOutputStream(long l) {
            this.pos = l;
        }

        public void flush() throws IOException {
            try {
                XBlob.this.setBytes(this.pos, this.toByteArray());
            }
            catch (SQLException sQLException) {
                throw new IOException("Can not write data to BLOB field: " + sQLException.getMessage());
            }
            super.flush();
        }

        public void close() throws IOException {
            this.flush();
            super.close();
        }
    }
}

