/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.copy.CopyIn;
import com.edb.gridsql.engine.copy.CopyManager;
import com.edb.gridsql.engine.loader.INodeWriter;
import com.edb.gridsql.engine.loader.LoaderConnectionPool;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgresWriter
implements INodeWriter {
    private static final XLogger logger = XLogger.getLogger(PostgresWriter.class);
    private String writerID;
    private NodeDBConnectionInfo connectionInfo;
    private String copyQuery;
    private Connection conn = null;
    private CopyIn copyIn;
    private long rowCount = 0L;
    private byte[] ROW_VALUES_DELIMITER = Props.XDB_LOADER_NODEWRITER_ROW_DELIMITER.getBytes();

    public PostgresWriter(NodeDBConnectionInfo nodeDBConnectionInfo, String string, Map<String, String> map) {
        this.connectionInfo = nodeDBConnectionInfo;
        this.writerID = nodeDBConnectionInfo.getDbName() + "@" + nodeDBConnectionInfo.getDbHost();
        map.put("dbhost", nodeDBConnectionInfo.getDbHost());
        if (nodeDBConnectionInfo.getDbPort() > 0) {
            map.put("dbport", "" + nodeDBConnectionInfo.getDbPort());
        }
        map.put("database", nodeDBConnectionInfo.getDbName());
        map.put("dbusername", nodeDBConnectionInfo.getDbUser());
        map.put("dbpassword", nodeDBConnectionInfo.getDbPassword());
        this.copyQuery = ParseCmdLine.substitute(string, map);
    }

    @Override
    public void start() throws IOException {
        try {
            this.conn = LoaderConnectionPool.getConnectionPool().getConnection(this.connectionInfo);
            this.conn.createStatement().executeUpdate("BEGIN");
        }
        catch (Exception exception) {
            throw new IOException("Can not start Writer " + this.writerID + ":" + exception.getMessage());
        }
    }

    @Override
    public synchronized void writeRow(byte[] byArray) throws IOException {
        this.writeRow(byArray, 0, byArray.length);
    }

    @Override
    public synchronized void writeRow(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.copyIn == null) {
                this.copyIn = CopyManager.getCopyManager(this.conn).copyIn(this.copyQuery);
            }
            this.copyIn.writeToCopy(byArray, n, n2);
            this.copyIn.writeToCopy(this.ROW_VALUES_DELIMITER, 0, this.ROW_VALUES_DELIMITER.length);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    @Override
    public void commit() throws SQLException {
        this.conn.createStatement().executeUpdate("COMMIT");
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.createStatement().executeUpdate("ROLLBACK");
    }

    @Override
    public void close() throws SQLException {
        LoaderConnectionPool.getConnectionPool().releaseConnection(this.connectionInfo, this.conn);
    }

    @Override
    public synchronized void finish(boolean bl) throws IOException {
        block3: {
            if (this.copyIn != null) {
                try {
                    this.rowCount += this.copyIn.endCopy();
                    this.copyIn = null;
                }
                catch (SQLException sQLException) {
                    this.copyIn = null;
                    logger.catching(sQLException);
                    if (!bl) break block3;
                    throw new IOException(this.writerID + ": " + sQLException.getMessage());
                }
            }
        }
    }

    @Override
    public String getStatistics() {
        return "";
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }
}

