/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.MetaUtils;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.scheduler.Scheduler;
import com.edb.gridsql.parser.SqlCreateIndexKey;
import com.edb.gridsql.parser.SqlCreateTable;
import com.edb.gridsql.parser.SqlCreateTableColumn;
import com.edb.gridsql.parser.handler.ForeignKeyHandler;
import java.sql.ResultSet;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncCreateTable
implements IMetaDataUpdate {
    private XDBSessionContext client;
    private SysDatabase database;
    private int tableid;
    private Hashtable<String, String> colNameColid = new Hashtable();
    private String tableName;
    private short partScheme;
    private String partColumn;
    private PartitionMap partMap;
    private SysTable parentTable;
    private int parentTableID = -1;
    private int tableSpaceID = -1;
    private List<SqlCreateTableColumn> columnDefinitions;
    private boolean possibleCreateIndex;
    private String rowidIndexName;
    private SqlCreateTableColumn serialCol;
    private List<String> pkList;
    private String pkConstraintName;
    private List<ForeignKeyHandler> fkDefinitions;
    private List<String> checkList;
    private List<String> checkConstraintNames;

    public SyncCreateTable(SqlCreateTable sqlCreateTable) {
        this.tableName = sqlCreateTable.getReferenceName();
        this.partScheme = sqlCreateTable.getPartScheme();
        this.partMap = sqlCreateTable.getPartitionMap();
        this.partColumn = sqlCreateTable.partColumn;
        this.parentTable = sqlCreateTable.getParentTable();
        if (this.parentTable != null) {
            this.parentTableID = this.parentTable.getTableId();
        }
        if (sqlCreateTable.getTablespace() != null) {
            this.tableSpaceID = sqlCreateTable.getTablespace().getTablespaceID();
        }
        this.columnDefinitions = sqlCreateTable.columnDefinitions;
        this.possibleCreateIndex = sqlCreateTable.isPossibleToCreateIndex();
        if (this.possibleCreateIndex) {
            this.rowidIndexName = sqlCreateTable.getRowidIndexName();
        }
        this.serialCol = sqlCreateTable.getSerialColumnDef();
        this.pkList = sqlCreateTable.getPrimaryKeyNameColList();
        this.pkConstraintName = sqlCreateTable.getPKConstraintName();
        this.fkDefinitions = sqlCreateTable.getForeignKeyDefs();
        this.checkList = sqlCreateTable.getChecks();
        this.checkConstraintNames = sqlCreateTable.getCheckConstraintName();
    }

    public SyncCreateTable(SysTable sysTable, List<SqlCreateTableColumn> list) {
        this.tableName = sysTable.getTableName();
        this.partScheme = sysTable.getPartitionScheme();
        this.partMap = sysTable.getPartitionMap();
        this.partColumn = sysTable.getPartitionColumn();
        this.columnDefinitions = list;
        boolean bl = this.possibleCreateIndex = !sysTable.isTemporary();
        if (this.possibleCreateIndex) {
            this.rowidIndexName = null;
        }
        this.tableSpaceID = sysTable.getTablespaceID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void execute(XDBSessionContext xDBSessionContext) throws Exception {
        SqlCreateIndexKey[] sqlCreateIndexKeyArray;
        String string11;
        String string2;
        Object object;
        this.client = xDBSessionContext;
        this.database = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        String string3 = "SELECT max(tableid) FROM xsystables";
        ResultSet resultSet = MetaData.getMetaData().executeQuery(string3);
        try {
            resultSet.next();
            this.tableid = resultSet.getInt(1) + 1;
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        string3 = "insert into xsystables(tableid,dbid,tablename, numrows,partscheme, partcol, parthash, owner,parentid,tablespaceid) values (" + this.tableid + "," + this.database.getDbid() + "," + "'" + this.tableName + "'," + "0," + this.partScheme + "," + (this.partColumn == null ? "null," : "'" + this.partColumn + "',") + "256, " + xDBSessionContext.getCurrentUser().getUserID() + "," + (this.parentTableID == -1 ? "null" : "" + this.parentTableID) + "," + (this.tableSpaceID == -1 ? "null" : "" + this.tableSpaceID) + ")";
        MetaData.getMetaData().executeUpdate(string3);
        if (this.parentTable == null) {
            this.partMap.storeMapToMetadataDB(MetaData.getMetaData(), this.database, this.tableid);
        }
        int[] nArray = MetaUtils.addTableColumns(0, this.columnDefinitions, this.tableid);
        for (int i = 0; i < nArray.length; ++i) {
            String object22 = "" + nArray[i];
            object = this.columnDefinitions.get((int)i).columnName;
            this.colNameColid.put(((String)object).toUpperCase(), object22);
        }
        if (this.parentTable != null) {
            for (SysColumn string4 : this.parentTable.getColumns()) {
                this.colNameColid.put(string4.getColName().toUpperCase(), "" + string4.getColID());
            }
        }
        if (this.possibleCreateIndex) {
            if (this.rowidIndexName != null) {
                SqlCreateIndexKey[] sqlCreateIndexKeyArray2 = new SqlCreateIndexKey[]{new SqlCreateIndexKey(Integer.parseInt(this.colNameColid.get("xrowid".toUpperCase()).toString()), "xrowid", null, null)};
                n = MetaUtils.createIndex(n, this.rowidIndexName, this.tableid, true, sqlCreateIndexKeyArray2, this.tableSpaceID, null, null);
                if (n4 == -1) {
                    String string4 = "SELECT max(constid) FROM xsysconstraints";
                    object = MetaData.getMetaData().executeQuery(string4);
                    try {
                        object.next();
                        n4 = object.getInt(1);
                        string2 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_37 = null;
                        object.close();
                        throw throwable;
                    }
                    object.close();
                    {
                    }
                }
                String string5 = "INSERT INTO xsysconstraints (constid, tableid, consttype, Idxid, issoft) VALUES (" + ++n4 + "," + this.tableid + "," + "'U'" + "," + n++ + "," + "0)";
                MetaData.getMetaData().executeUpdate(string5);
            }
            if (this.serialCol != null) {
                SqlCreateIndexKey[] sqlCreateIndexKeyArray3 = new SqlCreateIndexKey[]{new SqlCreateIndexKey(Integer.parseInt(this.colNameColid.get(this.serialCol.columnName.toUpperCase()).toString()), this.serialCol.columnName, null, null)};
                n = MetaUtils.createIndex(n, SqlCreateTableColumn.IDX_SERIAL_NAME, this.tableid, true, sqlCreateIndexKeyArray3, this.tableSpaceID, null, null) + 1;
            }
        }
        if (this.parentTable == null && this.pkList != null && !this.pkList.isEmpty()) {
            void var10_27;
            SqlCreateIndexKey[] sqlCreateIndexKeyArray4 = new SqlCreateIndexKey[this.pkList.size()];
            boolean bl = false;
            while (var10_27 < sqlCreateIndexKeyArray4.length) {
                object = this.pkList.get((int)var10_27);
                sqlCreateIndexKeyArray4[var10_27] = new SqlCreateIndexKey(Integer.parseInt(this.colNameColid.get(((String)object).toUpperCase()).toString()), (String)object, null, null);
                ++var10_27;
            }
            n = MetaUtils.createIndex(n, "PK_IDX_" + this.tableName, this.tableid, true, sqlCreateIndexKeyArray4, this.tableSpaceID, null, null);
            if (n4 == -1) {
                String string6 = "SELECT max(constid) FROM xsysconstraints";
                object = MetaData.getMetaData().executeQuery(string6);
                try {
                    object.next();
                    n4 = object.getInt(1);
                    string11 = null;
                }
                catch (Throwable throwable) {
                    Object var15_43 = null;
                    object.close();
                    throw throwable;
                }
                object.close();
                {
                }
            }
            String string7 = "INSERT INTO xsysconstraints (constid, tableid, consttype, Idxid, issoft, constname) VALUES (" + ++n4 + "," + this.tableid + "," + "'P'" + "," + n++ + "," + "0" + "," + "'" + this.pkConstraintName + "'" + ")";
            MetaData.getMetaData().executeUpdate(string7);
        }
        if (this.parentTable == null && this.fkDefinitions != null && this.fkDefinitions.size() > 0) {
            for (ForeignKeyHandler foreignKeyHandler : this.fkDefinitions) {
                Object object2;
                int n5;
                Object object3;
                Object object4;
                block38: {
                    object = foreignKeyHandler.getLocalColumnNames();
                    sqlCreateIndexKeyArray = new SqlCreateIndexKey[object.size()];
                    for (int i = 0; i < sqlCreateIndexKeyArray.length; ++i) {
                        object4 = (String)object.get(i);
                        sqlCreateIndexKeyArray[i] = new SqlCreateIndexKey(Integer.parseInt(this.colNameColid.get(((String)object4).toUpperCase()).toString()), (String)object4, null, null);
                    }
                    n = MetaUtils.createIndex(n, foreignKeyHandler.getConstraintName(), this.tableid, true, sqlCreateIndexKeyArray, this.tableSpaceID, null, null);
                    string2 = foreignKeyHandler.getConstraintName();
                    object4 = foreignKeyHandler.getForeignTable();
                    if (n4 == -1) {
                        string11 = "SELECT max(constid) FROM xsysconstraints";
                        ResultSet resultSet2 = MetaData.getMetaData().executeQuery(string11);
                        try {
                            resultSet2.next();
                            n4 = resultSet2.getInt(1);
                            object3 = null;
                        }
                        catch (Throwable throwable) {
                            object3 = null;
                            resultSet2.close();
                            throw throwable;
                        }
                        resultSet2.close();
                        {
                        }
                    }
                    string11 = "INSERT INTO xsysconstraints (constid, constname, tableid, consttype, idxid, issoft) VALUES (" + ++n4 + "," + "'" + string2 + "'," + this.tableid + "," + "'R'" + "," + n++ + ", " + (foreignKeyHandler.isSoft(this.partColumn, this.partMap) ? "1" : "0") + ")";
                    MetaData.getMetaData().executeUpdate(string11);
                    SysIndex sysIndex = ((SysTable)object4).getPrimaryOrUniqueIndex(foreignKeyHandler.getForeignColumnNames());
                    if (sysIndex == null || (n5 = sysIndex.idxid) == -1) {
                        throw new XDBServerException(ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX + "( " + ((SysTable)object4).getTableName() + " ) ", 0, ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX_CODE);
                    }
                    if (n2 < 0) {
                        string3 = "SELECT max(refid) FROM xsysreferences";
                        object3 = MetaData.getMetaData().executeQuery(string3);
                        try {
                            object3.next();
                            n2 = object3.getInt(1) + 1;
                            Object var20_54 = null;
                        }
                        catch (Throwable throwable) {
                            Object var20_55 = null;
                            object3.close();
                            throw throwable;
                        }
                        object3.close();
                        {
                            break block38;
                        }
                    }
                    ++n2;
                }
                object3 = "INSERT INTO xsysreferences (refid, constid, reftableid, refidxid) VALUES (" + n2 + "," + n4 + "," + ((SysTable)object4).getTableId() + "," + n5 + ")";
                MetaData.getMetaData().executeUpdate((String)object3);
                if (n3 < 0) {
                    Object var22_58;
                    string3 = "SELECT max(fkeyid) FROM xsysforeignkeys";
                    object2 = MetaData.getMetaData().executeQuery(string3);
                    try {
                        object2.next();
                        n3 = object2.getInt(1) + 1;
                        var22_58 = null;
                    }
                    catch (Throwable throwable) {
                        var22_58 = null;
                        object2.close();
                        throw throwable;
                    }
                    object2.close();
                    {
                    }
                }
                object2 = "INSERT INTO xsysforeignkeys (fkeyid, Refid, FKeyseq, Colid, Refcolid ) VALUES ";
                for (int i = 0; i < foreignKeyHandler.getForeignColumnNames().size(); ++i) {
                    SysColumn sysColumn = ((SysTable)object4).getSysColumn(foreignKeyHandler.getForeignColumnNames().get(i));
                    int n6 = sysColumn.getColID();
                    String string8 = this.colNameColid.get(foreignKeyHandler.getLocalColumnNames().get(i).toUpperCase());
                    String string9 = (String)object2 + "(" + n3++ + "," + n2 + "," + (i + 1) + "," + string8 + "," + n6 + ")";
                    MetaData.getMetaData().executeUpdate(string9);
                }
            }
        }
        if (this.checkList != null && this.checkList.size() > 0) {
            int n7;
            String string7 = "INSERT INTO xsysconstraints (constid, tableid, consttype, idxid, issoft,constname) VALUES ";
            String string10 = "INSERT INTO xsyschecks (checkid, constid, seqno, checkstmt) VALUES ";
            if (n4 == -1) {
                sqlCreateIndexKeyArray = MetaData.getMetaData().executeQuery("select max(constid) from xsysconstraints");
                try {
                    sqlCreateIndexKeyArray.next();
                    n4 = sqlCreateIndexKeyArray.getInt(1);
                    Object var26_62 = null;
                }
                catch (Throwable throwable) {
                    Object var26_63 = null;
                    sqlCreateIndexKeyArray.close();
                    throw throwable;
                }
                sqlCreateIndexKeyArray.close();
                {
                }
            }
            sqlCreateIndexKeyArray = MetaData.getMetaData().executeQuery("select max(checkid) from xsyschecks");
            try {
                sqlCreateIndexKeyArray.next();
                n7 = sqlCreateIndexKeyArray.getInt(1);
                Object var28_65 = null;
            }
            catch (Throwable throwable) {
                Object var28_66 = null;
                sqlCreateIndexKeyArray.close();
                throw throwable;
            }
            sqlCreateIndexKeyArray.close();
            int n8 = 0;
            for (String string11 : this.checkList) {
                string3 = string7 + "(" + ++n4 + ", " + this.tableid + ", 'C', null, 0 ," + "'" + this.checkConstraintNames.get(n8) + "'" + ")";
                MetaData.getMetaData().executeUpdate(string3);
                string3 = string10 + "(" + ++n7 + ", " + n4 + ", 1, '" + string11.replaceAll("'", "''") + "')";
                MetaData.getMetaData().executeUpdate(string3);
                ++n8;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh() throws Exception {
        SysTable sysTable = new SysTable(this.database, this.tableid, this.tableName, 0L, this.partScheme, this.partColumn, this.client.getCurrentUser(), this.parentTableID, this.tableSpaceID, null);
        Scheduler scheduler = this.database.getScheduler();
        synchronized (scheduler) {
            this.database.getLm().add(sysTable, this.client);
        }
        this.database.addSysTable(sysTable);
        sysTable.readTableInfo();
        if (this.fkDefinitions != null) {
            for (ForeignKeyHandler foreignKeyHandler : this.fkDefinitions) {
                sysTable = foreignKeyHandler.getForeignTable();
                sysTable.updateCrossReferences();
            }
        }
    }
}

