/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysConstraint;
import com.edb.gridsql.metadata.SysForeignKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class SysReference {
    private int refid;
    private SysConstraint constraint;
    private int reftableid;
    private int refidxid;
    private Vector foreignKeys;

    public SysReference(SysConstraint sysConstraint, int n, int n2, int n3) {
        this.constraint = sysConstraint;
        this.refid = n;
        this.reftableid = n2;
        this.refidxid = n3;
    }

    public Vector getForeignKeys() {
        return this.foreignKeys;
    }

    public void readForeignKeysInfo() throws XDBServerException {
        if (this.refid == -1) {
            throw new XDBServerException(ErrorMessageRepository.SYSREFKEYS_CORRUPT + "(" + this.refid + ")", 0, ErrorMessageRepository.SYSREFKEYS_CORRUPT_CODE);
        }
        try {
            ResultSet resultSet = MetaData.getMetaData().executeQuery("SELECT * FROM xsysforeignkeys WHERE refid = " + this.refid + " ORDER BY fkeyseq");
            this.foreignKeys = new Vector();
            int n = 0;
            while (resultSet.next()) {
                SysForeignKey sysForeignKey = new SysForeignKey();
                sysForeignKey.fkeyid = resultSet.getInt("fkeyid");
                sysForeignKey.refid = resultSet.getInt("refid");
                sysForeignKey.fkeyseq = resultSet.getInt("fkeyseq");
                sysForeignKey.colid = resultSet.getInt("colid");
                sysForeignKey.refcolid = resultSet.getInt("refcolid");
                ++n;
                this.foreignKeys.addElement(sysForeignKey);
            }
            if (n == 0) {
                throw new SQLException("No Foreign keys defined for " + this.refid);
            }
        }
        catch (SQLException sQLException) {
            String string = ErrorMessageRepository.REFERENCE_FAILURE + " ( " + this.refid + " )";
            throw new XDBServerException(string, sQLException, 8);
        }
    }

    public SysConstraint getConstraint() {
        return this.constraint;
    }

    public int getRefID() {
        return this.refid;
    }

    public int getRefTableID() {
        return this.reftableid;
    }

    public int getRefIdxID() {
        return this.refidxid;
    }

    public boolean getDistributedCheck() {
        return this.constraint.getIsSoft() == 1;
    }
}

