/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysLogin;
import java.util.HashSet;

public class SysUser {
    private static final XLogger logger = XLogger.getLogger(SysUser.class);
    private int id;
    private SysLogin login;
    private SysDatabase database;
    private HashSet ownerOf;
    private HashSet permissionsOn;

    public SysUser(int n, SysLogin sysLogin, SysDatabase sysDatabase) {
        this.id = n;
        this.login = sysLogin;
        this.database = sysDatabase;
        this.ownerOf = new HashSet();
        this.permissionsOn = new HashSet();
    }

    public int getUserID() {
        return this.id;
    }

    void setUserID(int n) {
        if (this.id == -1) {
            this.id = n;
        }
    }

    public SysLogin getLogin() {
        return this.login;
    }

    public String getName() {
        return this.login.getName();
    }

    public int getUserClass() {
        return this.login.getUserClass();
    }

    void addOwned(Object object) {
        this.ownerOf.add(object);
    }

    void removeOwned(Object object) {
        this.ownerOf.remove(object);
    }

    public String getOwnedStr() {
        if (this.ownerOf.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : this.ownerOf) {
            stringBuffer.append(e).append(", ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 2);
    }

    void addGranted(Object object) {
        this.permissionsOn.add(object);
    }

    void removeGranted(Object object) {
        this.permissionsOn.remove(object);
    }

    public String getGrantedStr() {
        if (this.permissionsOn.isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : this.permissionsOn) {
            stringBuffer.append(e).append(", ");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 2);
    }

    public String toString() {
        return this.login + "@" + this.database.getDbname();
    }
}

