/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysCheck;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.misc.SortedLongVector;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryNode;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Optimizer {
    private static final XLogger logger = XLogger.getLogger(Optimizer.class);
    private static final float PROC_FACTOR = 0.001f;
    private static final int OUTER_PARTED_NO = 0;
    private static final int OUTER_PARTED_LEVEL_0 = 1;
    private static final int OUTER_PARTED_SAME_ONE = 2;
    private static final int OUTER_PARTED_DIFFERENT = 3;
    private static final int MAX_TREES = 5;
    private static final int MIN_TREES = 5;
    private static final int STEP_TRIM_AMOUNT = 3;
    XDBSessionContext client;
    private final SysDatabase database;
    SortedLongVector candidateTreeList;

    public Optimizer(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = MetaData.getMetaData().getSysDatabase(xDBSessionContext.getDBName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean containsOnlyLookupsAndParChilds(RelationNode relationNode) {
        try {
            int n = 0;
            if (relationNode.getSubqueryTree().getUnionQueryTreeList() != null && relationNode.getSubqueryTree().getUnionQueryTreeList().size() > 0) {
                return false;
            }
            if (relationNode.getSubqueryTree().getNoncorSubqueryList() != null && relationNode.getSubqueryTree().getUnionQueryTreeList().size() > 0) {
                return false;
            }
            for (RelationNode relationNode2 : relationNode.getSubqueryTree().getRelationNodeList()) {
                if (relationNode2.isCorrelatedPlaceholder() || relationNode2.isCorrelatedSubquery() || relationNode2.getNodeType() != 2 || relationNode2.getSysTable(this.database).isLookup() || ++n < 2) continue;
                return false;
            }
            if (n == 0) {
                return true;
            }
            Object object = null;
            for (QueryCondition queryCondition : relationNode.getSubqueryTree().getConditionList()) {
                if (!queryCondition.isTwoRelationJoin()) {
                    return false;
                }
                RelationNode relationNode3 = queryCondition.getRelationNodeList().get(0);
                RelationNode relationNode4 = queryCondition.getRelationNodeList().get(1);
                if (relationNode3.isSubquery()) return false;
                if (relationNode4.isSubquery()) {
                    return false;
                }
                if (relationNode3.isCorrelatedPlaceholder() ? relationNode4.getSysTable(this.database).isLookup() : (relationNode4.isCorrelatedPlaceholder() ? relationNode3.getSysTable(this.database).isLookup() : relationNode3.getSysTable(this.database).isLookup() && relationNode4.getSysTable(this.database).isLookup())) continue;
                boolean bl = false;
                if (relationNode3.isCorrelatedPlaceholder()) {
                    bl = true;
                    RelationNode relationNode5 = relationNode3;
                    relationNode3 = relationNode4;
                    relationNode4 = relationNode5;
                }
                if (relationNode4.isCorrelatedPlaceholder()) {
                    bl = true;
                }
                if (!bl) {
                    return false;
                }
                String string = relationNode3.getSysTable(this.database).getPartitionColumn();
                if (string == null || string.length() <= 0) continue;
                object = this.isCorrelatedPartitionedJoin(queryCondition.getLeftCond(), queryCondition.getRightCond(), relationNode3, string);
                if (object != null) break;
                object = this.isCorrelatedPartitionedJoin(queryCondition.getRightCond(), queryCondition.getLeftCond(), relationNode3, string);
            }
            if (object == null) {
                return false;
            }
            Iterator<RelationNode> iterator = relationNode.getSubqueryTree().getRelationNodeList().iterator();
            while (iterator.hasNext()) {
                RelationNode relationNode6 = iterator.next();
                if (relationNode6.isCorrelatedPlaceholder() || relationNode6 == object) continue;
                if (!relationNode6.isTable()) {
                    return false;
                }
                if (!relationNode6.getSysTable(this.database).isLookup()) return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            Object var12_18 = null;
            throw throwable;
        }
    }

    private RelationNode isCorrelatedPartitionedJoin(QueryCondition queryCondition, QueryCondition queryCondition2, RelationNode relationNode, String string) {
        SysTable sysTable;
        SysTable sysTable2;
        String string2;
        AttributeColumn attributeColumn;
        AttributeColumn attributeColumn2;
        RelationNode relationNode2 = null;
        if (queryCondition.getExpr().isColumn() && (attributeColumn2 = queryCondition.getExpr().getColumn()).getTableName().equalsIgnoreCase(relationNode.getTableName()) && attributeColumn2.columnName.equalsIgnoreCase(string) && queryCondition2.getExpr().isColumn() && attributeColumn.columnName.equalsIgnoreCase(string2 = (attributeColumn = queryCondition2.getExpr().getColumn()).getSysTable(this.database).getPartitionColumn()) && ((sysTable2 = attributeColumn2.getSysTable(this.database)) != (sysTable = attributeColumn.getSysTable(this.database)) || !Props.XDB_AVOID_CORRELATED_SELF_JOINS) && sysTable2.onSameNodes(sysTable)) {
            relationNode2 = relationNode;
        }
        return relationNode2;
    }

    private boolean checkParentChildInCondition(QueryCondition queryCondition) {
        AttributeColumn attributeColumn;
        if (queryCondition == null) {
            return false;
        }
        if (queryCondition.getOperator().compareTo("IN") != 0) {
            return false;
        }
        if (queryCondition.getLeftCond().getCondType() == 4 && queryCondition.getLeftCond().getExpr().isColumn() && queryCondition.getLeftCond().getExpr().getMapped() == 3 && (attributeColumn = queryCondition.getLeftCond().getExpr().getColumn()).getSysTable(this.database).isPartitionedColumn(attributeColumn.columnName) && queryCondition.getRightCond().getCondType() == 4 && queryCondition.getRightCond().getExpr().getExprType() == 64) {
            SqlExpression sqlExpression = queryCondition.getRightCond().getExpr().getSubqueryTree().getProjectionList().get(0);
            if (!sqlExpression.isColumn()) {
                return false;
            }
            AttributeColumn attributeColumn2 = sqlExpression.getColumn();
            String string = attributeColumn2.getTableName();
            if (attributeColumn2.getSysTable(this.database).isPartitionedColumn(attributeColumn2.columnName)) {
                if (!attributeColumn2.getSysTable(this.database).onSameNodes(attributeColumn.getSysTable(this.database))) {
                    return false;
                }
                if (queryCondition.getRightCond().getExpr().getSubqueryTree().getUnionQueryTreeList() != null && queryCondition.getRightCond().getExpr().getSubqueryTree().getUnionQueryTreeList().size() > 0) {
                    return false;
                }
                if (queryCondition.getRightCond().getExpr().getSubqueryTree().getNoncorSubqueryList() != null && queryCondition.getRightCond().getExpr().getSubqueryTree().getNoncorSubqueryList().size() > 0) {
                    return false;
                }
                for (RelationNode relationNode : queryCondition.getRightCond().getExpr().getSubqueryTree().getRelationNodeList()) {
                    if (!relationNode.isTable()) {
                        return false;
                    }
                    if (relationNode.getTableName().compareToIgnoreCase(string) == 0 || relationNode.getSysTable(this.database).isLookup()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryTree determineQueryPath(QueryTree queryTree) throws XDBServerException {
        try {
            Object object;
            if (queryTree.getQueryNodeTable().isEmpty()) {
                for (RelationNode object3 : queryTree.getRelationNodeList()) {
                    object = queryTree.newQueryNode(object3);
                    queryTree.addToQueryNodeTable((QueryNode)object);
                }
            }
            for (QueryNode queryNode : queryTree.getQueryNodeTable().values()) {
                for (RelationNode relationNode : queryNode.getRelationNode().getJoinList()) {
                    queryNode.getJoinList().add(relationNode.getNodeId());
                }
            }
            for (QueryNode queryNode : queryTree.getQueryNodeTable().values()) {
                for (QueryCondition queryCondition : queryNode.getRelationNode().getConditionList()) {
                    for (RelationNode relationNode : queryCondition.getRelationNodeList()) {
                        queryCondition.getNodeIdList().add(relationNode.getNodeId());
                    }
                }
            }
            for (QueryCondition queryCondition : queryTree.getConditionList()) {
                for (RelationNode relationNode : queryCondition.getRelationNodeList()) {
                    queryCondition.getNodeIdList().add(relationNode.getNodeId());
                }
            }
            for (RelationNode relationNode : queryTree.getRelationSubqueryList()) {
                object = this.determineQueryPath(relationNode.getSubqueryTree());
                relationNode.setSubqueryTree((QueryTree)object);
                QueryNode queryNode = queryTree.getNodeById(relationNode.getNodeId());
                queryNode.setEstRowsReturned(((QueryTree)object).getRootNode().getEstRowsReturned());
                queryNode.setEstCost(((QueryTree)object).getRootNode().getEstCost());
                queryNode.setRowsize(((QueryTree)object).getRootNode().getRowsize());
                queryNode.setSelectRowSize(((QueryTree)object).getRootNode().getSelectRowSize());
                relationNode.setEstRowsReturned(((QueryTree)object).getRootNode().getEstRowsReturned());
            }
            for (SqlExpression sqlExpression : queryTree.getScalarSubqueryList()) {
                object = this.determineQueryPath(sqlExpression.getSubqueryTree());
                sqlExpression.setSubqueryTree((QueryTree)object);
            }
            Object object5 = queryTree.getNoncorSubqueryList().iterator();
            while (object5.hasNext()) {
                RelationNode relationNode = (RelationNode)object5.next();
                boolean bl = relationNode.getSubqueryTree().containsOnlyLookups(this.database);
                object = this.determineQueryPath(relationNode.getSubqueryTree());
                relationNode.setSubqueryTree((QueryTree)object);
                QueryNode queryNode = queryTree.getNodeById(relationNode.getNodeId());
                queryNode.setEstRowsReturned(((QueryTree)object).getRootNode().getEstRowsReturned());
                queryNode.setEstCost(((QueryTree)object).getRootNode().getEstCost());
                queryNode.setRowsize(((QueryTree)object).getRootNode().getRowsize());
                queryNode.setSelectRowSize(((QueryTree)object).getRootNode().getSelectRowSize());
                relationNode.setEstRowsReturned(((QueryTree)object).getRootNode().getEstRowsReturned());
                Object object2 = null;
                block13: for (QueryCondition queryCondition : queryTree.getConditionList()) {
                    for (RelationNode relationNode2 : queryCondition.getRelationNodeList()) {
                        if (relationNode.getNodeId() != relationNode2.getNodeId()) continue;
                        queryCondition.getRelationNodeList().remove(relationNode2);
                        object2 = queryCondition;
                        break;
                    }
                    for (Integer n : queryCondition.getNodeIdList()) {
                        if (relationNode.getNodeId() != n.intValue()) continue;
                        queryCondition.getNodeIdList().remove(n);
                        continue block13;
                    }
                }
                boolean bl2 = this.checkParentChildInCondition((QueryCondition)object2);
                if (!bl && !bl2) continue;
                relationNode.getParentNoncorExpr().setExprString(relationNode.getSubqueryTree().rebuildString());
                relationNode.getParentNoncorExpr().setTempExpr(true);
                object5.remove();
            }
            this.getInitialCost(queryTree);
            this.checkSpecialRelations(queryTree);
            this.candidateTreeList = new SortedLongVector();
            QueryTree queryTree2 = this.buildAndEvaluateTrees(queryTree, this.candidateTreeList);
            for (RelationNode relationNode : queryTree.getNoncorSubqueryList()) {
                object = this.findConditionNode(queryTree2.getRootNode(), relationNode.getParentNoncorExpr());
                if (object == null) continue;
                ((QueryNode)object).getUncorrelatedCondTreeList().add(relationNode);
            }
            for (QueryTree queryTree3 : queryTree.getUnionQueryTreeList()) {
                object = this.determineQueryPath(queryTree3);
                queryTree2.getUnionQueryTreeList().add((QueryTree)object);
            }
            object5 = queryTree2;
            Object var14_41 = null;
            return object5;
        }
        catch (Throwable throwable) {
            Object var14_42 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private QueryNode findConditionNode(QueryNode queryNode, SqlExpression sqlExpression) {
        try {
            QueryNode queryNode2 = null;
            for (QueryCondition queryCondition : queryNode.getConditionList()) {
                if (!queryCondition.containsSqlExpression(sqlExpression)) continue;
                return queryNode;
            }
            if (queryNode.getLeftNode() == null) return queryNode2;
            queryNode2 = this.findConditionNode(queryNode.getLeftNode(), sqlExpression);
            if (queryNode2 != null) return queryNode2;
            if (queryNode.getRightNode() == null) return queryNode2;
            queryNode2 = this.findConditionNode(queryNode.getRightNode(), sqlExpression);
            return queryNode2;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            throw throwable;
        }
    }

    private AttributeColumn checkConditionMatch(QueryCondition queryCondition, String string) {
        AttributeColumn attributeColumn = null;
        if (queryCondition.getExpr() != null && queryCondition.getExpr().isColumn() && !string.equalsIgnoreCase((attributeColumn = queryCondition.getExpr().getColumn()).getTableName())) {
            attributeColumn = null;
        }
        return attributeColumn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSpecialRelations(QueryTree queryTree) throws XDBServerException {
        short s = 0;
        try {
            Object object;
            RelationNode relationNode;
            RelationNode relationNode2;
            QueryCondition queryCondition;
            ArrayList arrayList = new ArrayList();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (int i = 0; i < queryTree.getConditionList().size(); ++i) {
                queryCondition = queryTree.getConditionList().get(i);
                if (!queryCondition.isTwoRelationJoin()) continue;
                relationNode2 = queryCondition.getRelationNodeList().get(0);
                relationNode = queryCondition.getRelationNodeList().get(1);
                if (relationNode2.getTableName().equalsIgnoreCase(relationNode.getTableName()) || arrayList2.contains(relationNode2.getAlias()) && arrayList2.contains(relationNode.getAlias()) || relationNode2.isSubquery() || relationNode.isSubquery() || relationNode2.isCorrelatedPlaceholder() || relationNode.isCorrelatedPlaceholder()) continue;
                if (relationNode2.getSysTable(this.database).getPartitionScheme() == 3 && relationNode.getSysTable(this.database).getPartitionScheme() == 3) {
                    String string;
                    if (!queryCondition.getLeftCond().getExpr().isColumn()) continue;
                    AttributeColumn attributeColumn = queryCondition.getLeftCond().getExpr().getColumn();
                    if (!queryCondition.getRightCond().getExpr().isColumn()) continue;
                    AttributeColumn attributeColumn2 = queryCondition.getRightCond().getExpr().getColumn();
                    if (!relationNode2.getSysTable(this.database).onSameNodes(relationNode.getSysTable(this.database)) || (string = relationNode2.getSysTable(this.database).getPartitionColumn()) == null || string.length() <= 0 || this.checkAndMergePartitionedColumns(relationNode2, relationNode, queryTree, string, arrayList2, attributeColumn, attributeColumn2) || !this.checkAndMergePartitionedColumns(relationNode2, relationNode, queryTree, string, arrayList2, attributeColumn2, attributeColumn)) continue;
                    continue;
                }
                if (relationNode2.getSysTable(this.database).getPartitionScheme() != 1 || relationNode.getSysTable(this.database).getPartitionScheme() != 1 || !relationNode2.getSysTable(this.database).getPartitionMap().equals(relationNode.getSysTable(this.database).getPartitionMap()) || (s = this.preMergeOuterCheck(relationNode2, relationNode, queryTree)) == 0) continue;
                this.mergeNodes(queryTree, relationNode, relationNode2, s);
            }
            HashMap<RelationNode, List<Object>> hashMap = new HashMap<RelationNode, List<Object>>();
            for (int i = 0; i < queryTree.getConditionList().size(); ++i) {
                Object object2;
                queryCondition = queryTree.getConditionList().get(i);
                if (!queryCondition.isTwoRelationJoin()) continue;
                relationNode2 = queryCondition.getRelationNodeList().get(0);
                relationNode = queryCondition.getRelationNodeList().get(1);
                if (relationNode2.isSubquery() || relationNode.isSubquery() || relationNode2.isCorrelatedPlaceholder() || relationNode.isCorrelatedPlaceholder()) continue;
                if (relationNode2.getSysTable(this.database).isLookup() && !arrayList.contains(relationNode2.getAlias())) {
                    s = this.preMergeOuterCheck(relationNode2, relationNode, queryTree);
                    if (s == 0 || s == 3 && relationNode2.getOuterLevel() < relationNode.getOuterLevel()) continue;
                    object2 = (List)hashMap.get(relationNode2);
                    if (object2 == null) {
                        object2 = new ArrayList();
                    }
                    object = new LookupCandidate(relationNode2, relationNode, queryCondition, s);
                    object2.add(object);
                    hashMap.put(relationNode2, (List<Object>)object2);
                    continue;
                }
                if (!relationNode.getSysTable(this.database).isLookup() || arrayList.contains(relationNode.getAlias()) || (s = this.preMergeOuterCheck(relationNode2, relationNode, queryTree)) == 0 || s == 3 && relationNode.getOuterLevel() < relationNode2.getOuterLevel()) continue;
                object2 = (List)hashMap.get(relationNode);
                if (object2 == null) {
                    object2 = new ArrayList();
                }
                object = new LookupCandidate(relationNode2, relationNode, queryCondition, s);
                object2.add(object);
                hashMap.put(relationNode, (List<Object>)object2);
            }
            for (Object object2 : hashMap.keySet()) {
                LookupCandidate lookupCandidate;
                object = (List)hashMap.get(object2);
                if (object.size() == 1) {
                    lookupCandidate = (LookupCandidate)object.get(0);
                    this.mergeNodes(queryTree, lookupCandidate.otherRelationNode, lookupCandidate.relationNode, lookupCandidate.outerType);
                    continue;
                }
                lookupCandidate = null;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    LookupCandidate lookupCandidate2 = (LookupCandidate)iterator.next();
                    double d = -1.0;
                    AttributeColumn attributeColumn = null;
                    SysTable sysTable = ((RelationNode)object2).getSysTable(this.database);
                    attributeColumn = this.checkConditionMatch(lookupCandidate2.queryCondition.getLeftCond(), sysTable.getTableName());
                    if (attributeColumn == null) {
                        attributeColumn = this.checkConditionMatch(lookupCandidate2.queryCondition.getRightCond(), sysTable.getTableName());
                    }
                    if (attributeColumn == null) continue;
                    if (sysTable.isPrimaryKey(attributeColumn.columnName) || sysTable.isUniqueIndex(attributeColumn.columnName)) {
                        this.mergeNodes(queryTree, lookupCandidate2.otherRelationNode, lookupCandidate2.relationNode, lookupCandidate2.outerType);
                        lookupCandidate = null;
                        break;
                    }
                    double d2 = attributeColumn.getSysColumn(this.database).getSelectivity();
                    if (d != -1.0 && !(d2 < d)) continue;
                    lookupCandidate = lookupCandidate2;
                    d = d2;
                }
                if (lookupCandidate == null) continue;
                this.mergeNodes(queryTree, lookupCandidate.otherRelationNode, lookupCandidate.relationNode, lookupCandidate.outerType);
            }
            Object var25_24 = null;
        }
        catch (Throwable throwable) {
            Object var25_25 = null;
            throw throwable;
        }
    }

    private boolean checkAndMergePartitionedColumns(RelationNode relationNode, RelationNode relationNode2, QueryTree queryTree, String string, List<String> list, AttributeColumn attributeColumn, AttributeColumn attributeColumn2) {
        if (attributeColumn.getTableName().equalsIgnoreCase(relationNode.getTableName()) && attributeColumn.columnName.equalsIgnoreCase(string)) {
            short s;
            String string2 = relationNode2.getSysTable(this.database).getPartitionColumn();
            if (attributeColumn2.getTableName().equalsIgnoreCase(relationNode2.getTableName()) && attributeColumn2.columnName.equalsIgnoreCase(string2) && (s = this.preMergeOuterCheck(relationNode, relationNode2, queryTree)) != 0) {
                this.mergeNodes(queryTree, relationNode2, relationNode, s);
                list.add(relationNode.getAlias());
                list.add(relationNode2.getAlias());
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNodes(QueryTree queryTree, RelationNode relationNode, RelationNode relationNode2, short s) throws XDBServerException {
        try {
            QueryNode queryNode = queryTree.getNodeById(relationNode.getNodeId());
            QueryNode queryNode2 = queryTree.getNodeById(relationNode2.getNodeId());
            while (queryNode.getParent() != null) {
                queryNode = queryNode.getParent();
            }
            while (queryNode2.getParent() != null) {
                queryNode2 = queryNode2.getParent();
            }
            if (queryNode != queryNode2) {
                this.mergeNodes(queryTree, queryNode, queryNode2, s);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeNodes(QueryTree queryTree, QueryNode queryNode, QueryNode queryNode2, short s) throws XDBServerException {
        try {
            QueryNode queryNode3 = queryTree.newQueryNode();
            this.estimateJoinCost(queryTree, queryNode, queryNode2, queryNode3);
            QueryNode queryNode4 = queryTree.newQueryNode();
            this.estimateJoinCost(queryTree, queryNode2, queryNode, queryNode4);
            if (queryNode4.getEstCost() < queryNode3.getEstCost() && queryNode.getOuterLevel() <= queryNode2.getOuterLevel()) {
                queryNode3.setEstCost(queryNode4.getEstCost());
                queryNode3.setEstRowsReturned(queryNode4.getEstRowsReturned());
                queryNode3.setRightNode(queryNode2);
                queryNode3.setLeftNode(queryNode);
            } else {
                queryNode3.setRightNode(queryNode);
                queryNode3.setLeftNode(queryNode2);
            }
            queryNode3.getLeftNode().setParent(queryNode3);
            queryNode3.getRightNode().setParent(queryNode3);
            queryNode3.setNodeType(1);
            queryNode3.setPreserveSubtree(true);
            if (s == 2) {
                queryNode3.setSubtreeOuter(true);
                queryNode3.setOuterLevel(queryNode.getOuterLevel());
                queryNode3.setOuterGroup(queryNode.getOuterGroup());
            }
            if (s == 3) {
                if (queryNode3.getLeftNode().getOuterLevel() > queryNode3.getRightNode().getOuterLevel()) {
                    queryNode3.setRightNode(queryNode2);
                    queryNode3.setLeftNode(queryNode);
                }
                queryNode3.getRightNode().setSubtreeOuter(true);
                queryNode3.getLeftNode().setSubtreeOuter(true);
                queryNode3.setOuterLevel(queryNode3.getLeftNode().getOuterLevel());
                queryNode3.setOuterGroup(queryNode3.getLeftNode().getOuterGroup());
            }
            this.adjustSubtreeJoins(queryNode3, queryTree);
            queryTree.addToQueryNodeTable(queryNode3);
            if (queryNode.getLeftNode() != null) {
                queryTree.getQueryNodeTable().remove(queryNode.getNodeId());
            }
            if (queryNode2.getLeftNode() != null) {
                queryTree.getQueryNodeTable().remove(queryNode2.getNodeId());
            }
            queryNode3.setRowReductionFactor(queryNode3.getRightNode().getRowReductionFactor() * queryNode3.getLeftNode().getRowReductionFactor());
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private short preMergeOuterCheck(RelationNode relationNode, RelationNode relationNode2, QueryTree queryTree) {
        try {
            if (relationNode.getOuterLevel() == 0 && relationNode2.getOuterLevel() == 0) {
                return 1;
            }
            if (relationNode.getOuterLevel() == relationNode2.getOuterLevel()) {
                RelationNode relationNode3;
                short s;
                int n = 0;
                for (s = 0; s < relationNode.getJoinList().size() && (relationNode3 = relationNode.getJoinList().get(s)) != relationNode2; ++s) {
                    if (relationNode3.getOuterLevel() == relationNode.getOuterLevel() || relationNode.getOuterLevel() - relationNode3.getOuterLevel() != 1 || n != 0) continue;
                    n = 1;
                    break;
                }
                for (s = 0; s < relationNode2.getJoinList().size() && (relationNode3 = relationNode2.getJoinList().get(s)) != relationNode; ++s) {
                    if (relationNode3.getOuterLevel() == relationNode2.getOuterLevel() || relationNode2.getOuterLevel() - relationNode3.getOuterLevel() != 1) continue;
                    if (n == 1) {
                        return 0;
                    }
                    if (n != 0) continue;
                    n = 2;
                }
                if (n == true) return 2;
                if (n == 2) {
                    return 2;
                }
                if (n != 0) return 0;
                return 0;
            }
            if (Math.abs(relationNode.getOuterLevel() - relationNode2.getOuterLevel()) != 1) return 0;
            int n = 0;
            while (n < queryTree.getRelationNodeList().size()) {
                RelationNode relationNode4 = queryTree.getRelationNodeList().get(n);
                if (relationNode4.getOuterLevel() == relationNode.getOuterLevel()) {
                    if (relationNode4 != relationNode) return 0;
                } else if (relationNode4.getOuterLevel() == relationNode2.getOuterLevel()) {
                    if (relationNode4 != relationNode2) return 0;
                }
                ++n;
            }
            return (short)3;
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSubtreeJoins(QueryNode queryNode, QueryTree queryTree) throws XDBServerException {
        try {
            this.adjustSubtreeJoinsDetail(queryNode, queryNode.getLeftNode(), queryNode.getRightNode(), queryTree);
            this.adjustSubtreeJoinsDetail(queryNode, queryNode.getRightNode(), queryNode.getLeftNode(), queryTree);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    private void adjustSubtreeJoinsDetail(QueryNode queryNode, QueryNode queryNode2, QueryNode queryNode3, QueryTree queryTree) throws XDBServerException {
        boolean bl = false;
        for (int i = 0; i < queryNode2.getJoinList().size(); ++i) {
            int n = queryNode2.getJoinList().get(i);
            if (n == queryNode3.getNodeId()) continue;
            queryNode.getJoinList().add(n);
            bl = false;
            QueryNode queryNode4 = queryTree.getNodeById(n);
            for (int j = 0; j < queryNode4.getJoinList().size(); ++j) {
                int n2 = queryNode4.getJoinList().get(j);
                if (n2 != queryNode2.getNodeId()) continue;
                queryNode4.getJoinList().remove(j);
                queryNode4.getJoinList().add(queryNode.getNodeId());
                bl = true;
                break;
            }
            if (bl) continue;
            String string = ErrorMessageRepository.REFERENCE_NODE_NOTFOUND;
            throw new XDBServerException(string + " :" + queryNode2.getNodeId(), 0, ErrorMessageRepository.REFERENCE_NODE_NOTFOUND_CODE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getInitialCost(QueryTree queryTree) {
        try {
            for (QueryNode queryNode : queryTree.getQueryNodeTable().values()) {
                int n;
                if (!queryNode.isTable()) continue;
                RelationNode relationNode = queryNode.getRelationNode();
                SysTable sysTable = relationNode.getSysTable(this.database);
                long l = sysTable.getRowCount();
                sysTable.getSubtableCount();
                double d = 1.0;
                long l2 = 0L;
                if (sysTable.getEstRowsPerPage() > 0.0f) {
                    l2 = Math.round((float)l / sysTable.getEstRowsPerPage());
                }
                if (l2 == 0L) {
                    l2 = 1L;
                }
                long l3 = l2 + (long)Math.round(0.001f * (float)l);
                for (n = 0; n < relationNode.getConditionList().size(); ++n) {
                    QueryCondition queryCondition = relationNode.getConditionList().get(n);
                    if (queryCondition.isAtomic()) {
                        AttributeColumn attributeColumn;
                        if (queryCondition.getLeftCond().getExpr().isColumn()) {
                            attributeColumn = queryCondition.getLeftCond().getExpr().getColumn();
                        } else {
                            if (!queryCondition.getRightCond().getExpr().isColumn()) continue;
                            attributeColumn = queryCondition.getRightCond().getExpr().getColumn();
                        }
                        SysColumn sysColumn = attributeColumn.getSysColumn(this.database);
                        long l4 = this.calculateIndexCost(sysColumn, l);
                        double d2 = 1.0;
                        for (SysCheck sysCheck : sysTable.getSysChecks()) {
                            if (sysCheck.getCheckDef().indexOf(attributeColumn.columnName) < 0) continue;
                            d2 = 1.0 / Math.sqrt(sysTable.getSubtableCount());
                        }
                        if ((l4 = (long)((double)l4 * d2)) >= 0L && l4 < l3) {
                            l3 = l4;
                        }
                        if (sysColumn.getSelectivity() > 0.0) {
                            d *= sysColumn.getSelectivity();
                            continue;
                        }
                        if (d == 1.0) {
                            d *= 0.1 * d2;
                            continue;
                        }
                        d *= 0.1 * d2;
                        continue;
                    }
                    if (queryCondition.getOperator() == "=") {
                        d /= 10.0;
                        continue;
                    }
                    d /= 3.0;
                }
                long l5 = (long)((double)l * d);
                if (l5 == 0L) {
                    l5 = 1L;
                }
                int n2 = 1;
                for (n = 0; n < relationNode.getProjectionList().size(); ++n) {
                    SqlExpression sqlExpression = relationNode.getProjectionList().get(n);
                    n2 += sqlExpression.getExprDataType().getByteLength();
                }
                long l6 = l3;
                relationNode.setRowsize(sysTable.getRowSize());
                relationNode.setEstCost(l6);
                relationNode.setEstRowsReturned(l5);
                queryNode.setRowsize(relationNode.getRowsize());
                queryNode.setSelectRowSize(n2);
                queryNode.setBaseNumRows(l);
                queryNode.setEstCost(relationNode.getEstCost());
                queryNode.setEstRowsReturned(relationNode.getEstRowsReturned());
                queryNode.setRowReductionFactor(d);
            }
            Object var31_22 = null;
        }
        catch (Throwable throwable) {
            Object var31_23 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateIndexCost(SysColumn sysColumn, long l) {
        try {
            long l2 = -1L;
            if (sysColumn.bestIndex != null) {
                long l3 = l / (long)sysColumn.bestIndex.estRowsPerPage;
                l2 = sysColumn.bestIndexColPos == 1 ? (sysColumn.getSelectivity() > 0.0 ? Math.round((double)l3 * sysColumn.getSelectivity()) + (long)Math.round(0.001f * (float)l) : Math.round((double)l3 * 0.1) + (long)Math.round(0.001f * (float)l)) : (sysColumn.getSelectivity() > 0.0 ? l3 + Math.round((double)l * sysColumn.getSelectivity()) + (long)Math.round(0.001f * (float)l) : l3 + Math.round((double)l * 0.1) + (long)Math.round(0.001f * (float)l));
            }
            long l4 = l2;
            Object var11_6 = null;
            return l4;
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long calculateIndexJoinCost(QueryNode queryNode, String string, String string2, long l, long l2, long l3) {
        try {
            long l4;
            long l5 = -1L;
            double d = 1.0;
            SysTable sysTable = this.database.getSysTable(string);
            SysColumn sysColumn = sysTable.getSysColumn(string2);
            double d2 = sysColumn.getSelectivity();
            if (sysColumn == sysTable.getPartitionedColumn()) {
                d = 1.0 / (double)sysTable.getNodeList().size();
            }
            if (d2 == 0.0) {
                l4 = l3 > l2 ? l3 : l2;
                d2 = 0.1;
            } else {
                l4 = Math.round((double)(l3 * l2) * d2);
            }
            if (sysColumn.bestIndex != null) {
                long l6 = l2 / (long)sysColumn.bestIndex.estRowsPerPage;
                long l7 = Math.round(l3 * (long)queryNode.getRowsize() / 8096L);
                l5 = sysColumn.bestIndexColPos == 1 ? (sysColumn.bestIndex.idxtype == 'U' || sysColumn.bestIndex.idxtype == 'P' ? l7 + Math.round((double)(2L * l3) * d) + Math.round((double)(0.001f * (float)l4) * d) : Math.round((double)(4L * l3) * d) + Math.round((double)(0.001f * (float)l4) * d)) : l7 + Math.round((double)(l3 * l6) * d) + Math.round((double)l3 * d2 * d) + Math.round((double)(0.001f * (float)l4) * d);
                long l8 = l7 + Math.round((double)(queryNode.getEstRowsReturned() * l) * d) + Math.round((double)(0.001f * (float)l4) * d);
                if (l8 < l5) {
                    l5 = l8;
                }
            }
            long l9 = l5;
            Object var29_17 = null;
            return l9;
        }
        catch (Throwable throwable) {
            Object var29_18 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void estimateJoinCost(QueryTree queryTree, QueryNode queryNode, QueryNode queryNode2, QueryNode queryNode3) {
        try {
            long l;
            int n = 0;
            float f = 0.0f;
            SysColumn sysColumn = null;
            QueryNode queryNode4 = null;
            boolean bl = false;
            if (queryNode.getNodeType() == 2) {
                // empty if block
            }
            if (queryNode2.getNodeType() == 2) {
                // empty if block
            }
            if (queryNode2.getRowsize() <= 0) {
                queryNode2.setRowsize(4);
            }
            f = 8096 / queryNode2.getRowsize();
            int n2 = Math.round((float)queryNode2.getBaseNumRows() / f);
            if (n2 == 0) {
                n2 = 1;
            }
            long l2 = 0L;
            long l3 = 0L;
            for (int i = 0; i < queryTree.getConditionList().size(); ++i) {
                long l4 = 0L;
                QueryCondition queryCondition = queryTree.getConditionList().get(i);
                if (!queryCondition.isJoin() || queryCondition.getLeftCond() == null || queryCondition.getLeftCond().getCondType() != 4 || !queryCondition.getLeftCond().getExpr().isColumn()) continue;
                AttributeColumn attributeColumn = queryCondition.getLeftCond().getExpr().getColumn();
                if (queryCondition.getRightCond() == null || queryCondition.getRightCond().getCondType() != 4 || !queryCondition.getRightCond().getExpr().isColumn()) continue;
                AttributeColumn attributeColumn2 = queryCondition.getRightCond().getExpr().getColumn();
                if ((attributeColumn.columnGenre & 4) != 0 || (attributeColumn2.columnGenre & 4) != 0) continue;
                sysColumn = null;
                bl = false;
                if (queryNode2.subtreeFind(attributeColumn.getTableName(), attributeColumn.getTableAlias()) != null && (queryNode4 = queryNode.subtreeFind(attributeColumn2.getTableName(), attributeColumn2.getTableAlias())) != null && !attributeColumn.relationNode.isRelationSubquery()) {
                    sysColumn = attributeColumn.getSysColumn(this.database);
                    l4 = this.calculateIndexJoinCost(queryNode, attributeColumn.getTableName(), attributeColumn.columnName, n2, queryNode2.getEstRowsReturned(), queryNode.getEstRowsReturned());
                }
                if (queryNode2.subtreeFind(attributeColumn2.getTableName(), attributeColumn2.getTableAlias()) != null && (queryNode4 = queryNode.subtreeFind(attributeColumn.getTableName(), attributeColumn.getTableAlias())) != null) {
                    bl = true;
                    if (!attributeColumn2.relationNode.isRelationSubquery()) {
                        sysColumn = attributeColumn2.getSysColumn(this.database);
                        l4 = this.calculateIndexJoinCost(queryNode, attributeColumn2.getTableName(), attributeColumn2.columnName, n2, queryNode2.getEstRowsReturned(), queryNode.getEstRowsReturned());
                    }
                }
                if (sysColumn == null) continue;
                if (l4 == -1L) {
                    if (l2 <= 0L) continue;
                    l3 = (long)((double)l3 * sysColumn.getSelectivity());
                    continue;
                }
                if (l4 > l2 && l2 != 0L) continue;
                l2 = l4;
                l3 = 0L;
                if (sysColumn.bestIndex != null && (sysColumn.bestIndex.idxtype == 'U' || sysColumn.bestIndex.idxtype == 'P') && sysColumn.bestIndex.keycnt == 1 && queryNode2.getNodeType() == 2) {
                    l3 = bl ? queryNode2.getEstRowsReturned() : queryNode.getEstRowsReturned();
                }
                if (l3 != 0L) continue;
                l = Math.round((double)queryNode2.getEstRowsReturned() * queryNode.getRowReductionFactor());
                l3 = queryNode.getEstRowsReturned() > l ? queryNode.getEstRowsReturned() : l;
            }
            if (l3 == 0L) {
                l = Math.round((double)queryNode2.getEstRowsReturned() * queryNode.getRowReductionFactor());
                long l5 = l3 = queryNode.getEstRowsReturned() > l ? queryNode.getEstRowsReturned() : l;
            }
            if (l3 == 0L) {
                l3 = 1L;
            }
            if (queryNode.getRowsize() == 0) {
                queryNode.setRowsize(1);
            }
            long l6 = 0L;
            if (l2 == 0L) {
                long l7 = Math.round((double)queryNode.getEstRowsReturned() / (8096.0 / (double)queryNode.getRowsize()));
                l2 = l7 + queryNode.getEstRowsReturned() * (long)n2 + (long)Math.round(0.001f * (float)l3);
            }
            n = 1;
            n += this.setJoinNodeProjections(queryNode, queryNode3);
            queryNode3.setRowsize(n += this.setJoinNodeProjections(queryNode2, queryNode3));
            queryNode3.setSelectRowSize(n);
            queryNode3.setEstCost(l6 += l2);
            queryNode3.setEstRowsReturned(l3);
            if (queryNode.getNodeType() == 2) {
                // empty if block
            }
            if (queryNode2.getNodeType() == 2) {
                // empty if block
            }
            Object var27_21 = null;
        }
        catch (Throwable throwable) {
            Object var27_22 = null;
            throw throwable;
        }
    }

    private int setJoinNodeProjections(QueryNode queryNode, QueryNode queryNode2) {
        int n = 0;
        if (!queryNode.isUncorrelatedSubquery()) {
            for (SqlExpression sqlExpression : queryNode.getProjectionList()) {
                n += sqlExpression.getExprDataType().getByteLength();
                queryNode2.getProjectionList().add(sqlExpression);
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean estimateDownJoinCost(QueryTree queryTree, QueryNode queryNode, QueryNode queryNode2, QueryNode queryNode3) {
        long l;
        long l2;
        int n;
        block15: {
            int n2;
            n = 0;
            float f = 0.0f;
            SysColumn sysColumn = null;
            QueryNode queryNode4 = null;
            boolean bl = false;
            f = 8096 / queryNode2.getRowsize();
            int n3 = Math.round((float)queryNode2.getBaseNumRows() / f);
            if (n3 == 0) {
                n3 = 1;
            }
            l2 = 0L;
            l = 0L;
            for (n2 = 0; n2 < queryTree.getConditionList().size() && !bl; ++n2) {
                QueryCondition queryCondition = queryTree.getConditionList().get(n2);
                if (!queryCondition.isJoin() || queryCondition.getLeftCond() == null || queryCondition.getLeftCond().getCondType() != 4 || !queryCondition.getLeftCond().getExpr().isColumn()) continue;
                AttributeColumn attributeColumn = queryCondition.getLeftCond().getExpr().getColumn();
                if (queryCondition.getRightCond() == null || queryCondition.getRightCond().getCondType() != 4 || !queryCondition.getLeftCond().getExpr().isColumn()) continue;
                AttributeColumn attributeColumn2 = queryCondition.getRightCond().getExpr().getColumn();
                if (attributeColumn == null || attributeColumn2 == null) continue;
                sysColumn = null;
                if (queryNode2.getRightNode() != null && queryNode2.getRightNode().subtreeFind(attributeColumn.getTableName(), attributeColumn.getTableAlias()) != null && (queryNode4 = queryNode.subtreeFind(attributeColumn2.getTableName(), attributeColumn2.getTableAlias())) != null) {
                    bl = true;
                    sysColumn = attributeColumn.getSysColumn(this.database);
                }
                if (queryNode2.getRightNode() != null && queryNode2.getRightNode().subtreeFind(attributeColumn2.getTableName(), attributeColumn2.getTableAlias()) != null && (queryNode4 = queryNode.subtreeFind(attributeColumn.getTableName(), attributeColumn.getTableAlias())) != null) {
                    bl = true;
                    sysColumn = attributeColumn2.getSysColumn(this.database);
                }
                if (sysColumn != null) continue;
            }
            if (bl) break block15;
            n2 = 0;
            Object var28_21 = null;
            return n2 != 0;
        }
        try {
            SqlExpression sqlExpression;
            if (l == 0L) {
                long l3 = Math.round((double)queryNode2.getEstRowsReturned() * queryNode.getRowReductionFactor());
                long l4 = l = queryNode.getEstRowsReturned() > l3 ? queryNode.getEstRowsReturned() : l3;
            }
            if (l == 0L) {
                l = 1L;
            }
            if (queryNode.getRowsize() == 0) {
                queryNode.setRowsize(1);
            }
            long l5 = 0L;
            if (l2 == 0L) {
                long l6 = Math.round((double)queryNode.getEstRowsReturned() / (8096.0 / (double)queryNode.getRowsize()));
                l6 = l6 <= 0L ? 1L : l6;
                double d = Math.log(l6);
                l2 = l6 + Math.round((double)queryNode2.getEstRowsReturned() * d) + (long)Math.round(0.001f * (float)l);
            }
            l5 += l2;
            n = 1;
            if (!queryNode.isUncorrelatedSubquery()) {
                for (int i = 0; i < queryNode.getProjectionList().size(); ++i) {
                    sqlExpression = queryNode.getProjectionList().get(i);
                    n += sqlExpression.getExprDataType().getByteLength();
                    queryNode3.getProjectionList().add(sqlExpression);
                }
            }
            if (!queryNode2.isUncorrelatedSubquery()) {
                for (int i = 0; i < queryNode2.getProjectionList().size(); ++i) {
                    sqlExpression = queryNode2.getProjectionList().get(i);
                    n += sqlExpression.getExprDataType().getByteLength();
                    queryNode3.getProjectionList().add(sqlExpression);
                }
            }
            queryNode3.setRowsize(n);
            queryNode3.setSelectRowSize(n);
            queryNode3.setEstCost(l5);
            queryNode3.setEstRowsReturned(l);
            boolean bl = true;
            Object var28_22 = null;
            return bl;
        }
        catch (Throwable throwable) {
            Object var28_23 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUsedNodes(QueryNode queryNode, List<Integer> list) {
        try {
            list.remove((Object)queryNode.getNodeId());
            if (queryNode.getNodeType() == 1) {
                this.markUsedNodes(queryNode.getLeftNode(), list);
                this.markUsedNodes(queryNode.getRightNode(), list);
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryTree buildAndEvaluateTrees(QueryTree queryTree, SortedLongVector sortedLongVector) throws XDBServerException {
        try {
            QueryTree queryTree2;
            boolean bl = false;
            SortedLongVector sortedLongVector2 = new SortedLongVector();
            for (QueryNode queryNode : queryTree.getQueryNodeTable().values()) {
                if (queryNode.getParent() != null || queryNode.isUncorrelatedSubquery()) continue;
                queryTree.getUnusedQueryNodeList().add(queryNode.getNodeId());
                if (queryNode.getNodeType() == 2 && (queryNode.isUncorrelatedSubquery() || queryNode.isCorrelatedSubquery()) || bl) continue;
                if ((queryNode.getNodeType() == 1 || !queryNode.isCorrelatedSubquery()) && queryNode.getNodeType() == 2 && queryNode.isCorrelatedPlaceholder()) {
                    bl = true;
                    sortedLongVector2 = new SortedLongVector();
                }
                sortedLongVector2.addElement(queryNode.getEstCost(), queryNode);
            }
            int n = sortedLongVector2.size();
            if (5 < n) {
                n = 5;
            }
            for (int i = 0; i < n; ++i) {
                QueryNode queryNode;
                queryNode = (QueryNode)sortedLongVector2.get(i);
                if (queryNode.getOuterLevel() != 0) continue;
                queryTree.setRootNode(queryNode);
                queryTree2 = queryTree.copy();
                this.markUsedNodes(queryTree2.getRootNode(), queryTree2.getUnusedQueryNodeList());
                sortedLongVector.addElement(queryTree2);
            }
            QueryTree queryTree3 = queryTree2 = this.buildTrees(sortedLongVector);
            Object var10_11 = null;
            return queryTree3;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryTree buildTrees(SortedLongVector sortedLongVector) throws XDBServerException {
        try {
            int n;
            boolean bl = false;
            for (n = 2; n < 1000 && !bl; ++n) {
                int n2;
                SortedLongVector sortedLongVector2 = new SortedLongVector();
                for (n2 = 0; n2 < sortedLongVector.size(); ++n2) {
                    QueryTree queryTree = (QueryTree)sortedLongVector.get(n2);
                    if (queryTree.getUnusedQueryNodeList().size() - queryTree.getCorrelatedSubqueryList().size() <= 0) {
                        sortedLongVector2.addElement(queryTree);
                        bl = true;
                        continue;
                    }
                    List list = this.getNextTreeSet(queryTree);
                    for (int i = 0; i < list.size(); ++i) {
                        QueryTree queryTree2 = (QueryTree)list.get(i);
                        sortedLongVector2.addElement(queryTree2.getCost(), queryTree2);
                    }
                }
                int n3 = sortedLongVector2.size() / (n + 1);
                if (n3 < 5 && (n3 = 5) >= sortedLongVector2.size()) {
                    n3 = sortedLongVector2.size();
                }
                for (n2 = sortedLongVector2.size() - 1; n2 > n3 - 1 && n2 != 0; --n2) {
                    QueryTree queryTree = (QueryTree)sortedLongVector2.get(n2);
                    sortedLongVector2.removeElementAt(n2);
                }
                sortedLongVector = sortedLongVector2;
            }
            for (n = 1; n < sortedLongVector.size(); ++n) {
                QueryTree queryTree = (QueryTree)sortedLongVector.get(n);
            }
            QueryTree queryTree = (QueryTree)sortedLongVector.get(0);
            QueryTree queryTree3 = queryTree = this.finishTree(queryTree);
            Object var13_16 = null;
            return queryTree3;
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getNextTreeSet(QueryTree queryTree) throws XDBServerException {
        try {
            QueryNode queryNode;
            Integer n;
            int n2;
            int n3 = 0;
            short s = -1;
            SortedLongVector sortedLongVector = new SortedLongVector();
            SortedLongVector sortedLongVector2 = new SortedLongVector();
            QueryNode queryNode2 = queryTree.getRootNode();
            QueryNode queryNode3 = null;
            List<Integer> list = queryNode2.getJoinList().size() == 0 ? queryTree.getUnusedQueryNodeList() : queryNode2.getJoinList();
            for (n2 = 0; n2 < list.size(); ++n2) {
                n = list.get(n2);
                queryNode = queryTree.getNodeById(n);
                if (s != -1) continue;
                s = queryNode.getOuterLevel();
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                n = list.get(n2);
                queryNode = queryTree.getNodeById(n);
                if (queryNode.getOuterLevel() != s) continue;
                QueryTree queryTree2 = queryTree.copy();
                queryNode3 = queryTree2.newQueryNode();
                QueryNode queryNode4 = queryTree2.getNodeById(n);
                if (queryNode4.getNodeType() == 2) {
                    if (queryNode4.isCorrelatedSubquery()) {
                        ++n3;
                        continue;
                    }
                    if (queryNode4.isUncorrelatedSubquery()) continue;
                }
                this.addNormalJoinAtTop(queryTree2, queryNode3, queryNode4);
                QueryTree queryTree3 = queryTree.copy();
                queryNode3 = queryTree3.newQueryNode();
                queryNode4 = queryTree3.getNodeById(n);
                if (this.addTreeDownJoin(queryTree3, queryNode3, queryNode4)) {
                    if (queryTree3.getCost() < queryTree2.getCost() || 4L * queryTree3.getRootNode().getRightNode().getEstRowsReturned() < queryTree2.getRootNode().getLeftNode().getEstRowsReturned()) {
                        if (queryTree3.getCost() > queryTree2.getCost()) {
                            queryTree3.getRootNode().setEstCost(queryTree2.getRootNode().getEstCost());
                        }
                        sortedLongVector2.addElement(queryTree3.getRootNode().getEstCost(), queryTree3);
                    } else {
                        sortedLongVector2.addElement(queryTree2.getRootNode().getEstCost(), queryTree2);
                    }
                } else {
                    sortedLongVector2.addElement(queryTree2.getRootNode().getEstCost(), queryTree2);
                }
                sortedLongVector2.addElement(queryTree2.getRootNode().getEstCost(), queryTree2);
            }
            int n4 = 3;
            if (sortedLongVector2.size() < n4) {
                n4 = sortedLongVector.size();
            }
            for (n2 = sortedLongVector2.size() - 1; n2 > n4; --n2) {
                sortedLongVector2.removeElementAt(n2);
            }
            SortedLongVector sortedLongVector3 = sortedLongVector2;
            Object var17_17 = null;
            return sortedLongVector3;
        }
        catch (Throwable throwable) {
            Object var17_18 = null;
            throw throwable;
        }
    }

    private void addNormalJoinAtTop(QueryTree queryTree, QueryNode queryNode, QueryNode queryNode2) throws XDBServerException {
        QueryNode queryNode3 = queryTree.getRootNode();
        this.estimateJoinCost(queryTree, queryNode3, queryNode2, queryNode);
        queryTree.setRootNode(queryNode);
        queryNode.setRightNode(queryNode2);
        queryNode.setLeftNode(queryNode3);
        queryNode.getLeftNode().setParent(queryNode);
        queryNode.getRightNode().setParent(queryNode);
        queryNode.setNodeType(1);
        this.adjustSubtreeJoins(queryNode, queryTree);
        queryTree.addToQueryNodeTable(queryNode);
        this.markUsedNodes(queryNode.getRightNode(), queryTree.getUnusedQueryNodeList());
        if (queryNode2.getNodeType() == 2) {
            // empty if block
        }
        if (queryNode.getRightNode().getNodeType() == 2 && queryNode.getRightNode().getRelationNode().getOuterLevel() > queryTree.getLastOuterLevel()) {
            queryNode.getRightNode().setSubtreeOuter(true);
            queryTree.setLastOuterLevel(queryNode.getRightNode().getRelationNode().getOuterLevel());
        }
        queryNode.setOuterLevel(queryNode.getRightNode().getOuterLevel());
    }

    private boolean addTreeDownJoin(QueryTree queryTree, QueryNode queryNode, QueryNode queryNode2) throws XDBServerException {
        if (!Props.XDB_ALLOW_DOWN_JOIN) {
            return false;
        }
        QueryNode queryNode3 = queryTree.getRootNode();
        if (queryNode3.getNodeType() == 2 || queryNode3.isPreserveSubtree() || queryNode3.isTreeDownJoin()) {
            return false;
        }
        if (queryTree.getCorrelatedSubqueryList().size() > 1) {
            return false;
        }
        if (!this.estimateDownJoinCost(queryTree, queryNode2, queryNode3, queryNode)) {
            return false;
        }
        queryTree.setRootNode(queryNode);
        queryNode.setRightNode(queryNode2);
        queryNode.setLeftNode(queryNode3);
        queryNode.getLeftNode().setParent(queryNode);
        queryNode.getRightNode().setParent(queryNode);
        queryNode.setNodeType(1);
        queryNode.setTreeDownJoin(true);
        this.adjustSubtreeJoins(queryNode, queryTree);
        queryTree.addToQueryNodeTable(queryNode);
        this.markUsedNodes(queryNode.getRightNode(), queryTree.getUnusedQueryNodeList());
        if (queryNode2.getNodeType() == 2) {
            // empty if block
        }
        if (queryNode.getRightNode().getNodeType() == 2 && queryNode.getRightNode().getRelationNode().getOuterLevel() > queryTree.getLastOuterLevel()) {
            queryNode.getRightNode().setSubtreeOuter(true);
            queryTree.setLastOuterLevel(queryNode.getRightNode().getRelationNode().getOuterLevel());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private QueryTree finishTree(QueryTree queryTree) throws XDBServerException {
        try {
            boolean bl = false;
            queryTree.relabel();
            for (RelationNode relationNode : queryTree.getCorrelatedSubqueryList()) {
                QueryNode queryNode;
                QueryNode queryNode2 = null;
                boolean bl2 = false;
                if (this.containsOnlyLookupsAndParChilds(relationNode)) {
                    block3: for (QueryCondition queryCondition : queryTree.getConditionList()) {
                        for (RelationNode relationNode2 : queryCondition.getRelationNodeList()) {
                            if (relationNode.getNodeId() != relationNode2.getNodeId()) continue;
                            queryCondition.getRelationNodeList().remove(relationNode2);
                            bl2 = true;
                            break;
                        }
                        if (!bl2) continue;
                        for (Integer n : queryCondition.getNodeIdList()) {
                            if (relationNode.getNodeId() != n.intValue()) continue;
                            queryCondition.getNodeIdList().remove(n);
                            continue block3;
                        }
                    }
                    if (bl2) {
                        for (RelationNode relationNode3 : relationNode.getSubqueryTree().getRelationNodeList()) {
                            if (!relationNode3.isCorrelatedPlaceholder()) continue;
                            for (RelationNode relationNode4 : relationNode3.getJoinList()) {
                                relationNode4.getJoinList().remove(relationNode3);
                            }
                            for (QueryCondition queryCondition : relationNode.getSubqueryTree().getConditionList()) {
                                queryCondition.getRelationNodeList().remove(relationNode3);
                            }
                            relationNode.getSubqueryTree().getRelationNodeList().remove(relationNode3);
                            break;
                        }
                    }
                }
                if (bl2) continue;
                Iterator<RelationNode> iterator = this.determineQueryPath(relationNode.getSubqueryTree());
                ((QueryTree)((Object)iterator)).setCorrelatedSubtree(true);
                QueryNode queryNode3 = queryTree.getNodeById(relationNode.getNodeId());
                queryNode3.setEstRowsReturned(((QueryTree)((Object)iterator)).getRootNode().getEstRowsReturned());
                queryNode3.setEstCost(((QueryTree)((Object)iterator)).getRootNode().getEstCost());
                queryNode3.setRowsize(((QueryTree)((Object)iterator)).getRootNode().getRowsize());
                relationNode.setEstRowsReturned(((QueryTree)((Object)iterator)).getRootNode().getEstRowsReturned());
                relationNode.setSubqueryTree((QueryTree)((Object)iterator));
                queryNode2 = queryTree.getNodeById(relationNode.getNodeId());
                Object object = queryTree.getRootNode();
                bl = false;
                String string = "";
                while (object != null && !bl) {
                    if (((QueryNode)object).getNodeType() == 1) {
                        if (((QueryNode)object).isPreserveSubtree()) {
                            String string2 = ((QueryNode)object).getLabel();
                        } else {
                            String string3 = ((QueryNode)object).getRightNode().getLabel();
                        }
                    } else if (((QueryNode)object).isPreserveSubtree() || ((QueryNode)object).getNodeType() == 2) {
                        String string4 = ((QueryNode)object).getLabel();
                    }
                    for (int i = 0; i < queryNode2.getJoinList().size() && !bl; ++i) {
                        void var10_19;
                        queryNode = queryTree.getNodeById(queryNode2.getJoinList().get(i));
                        if (queryNode.getLabel().substring(0, var10_19.length()).compareTo((String)var10_19) != 0) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    object = ((QueryNode)object).getLeftNode();
                }
                if (bl) {
                    if (((QueryNode)object).getParent() != null && ((QueryNode)object).getParent().isTreeDownJoin()) {
                        object = ((QueryNode)object).getParent();
                    }
                    while (((QueryNode)object).getParent() != null && !((QueryNode)object).getParent().getRightNode().isCorrelatedSubquery()) {
                        object = ((QueryNode)object).getParent();
                    }
                    QueryNode queryNode4 = queryTree.newQueryNode();
                    this.estimateJoinCost(queryTree, (QueryNode)object, queryNode2, queryNode4);
                    queryNode = queryNode4;
                    if (((QueryNode)object).getParent() != null) {
                        queryNode.setParent(((QueryNode)object).getParent());
                        ((QueryNode)object).getParent().setLeftNode(queryNode);
                    } else {
                        queryTree.setRootNode(queryNode);
                    }
                    queryNode.setRightNode(queryNode2);
                    queryNode.setLeftNode((QueryNode)object);
                    queryNode.getLeftNode().setParent(queryNode);
                    queryNode.getRightNode().setParent(queryNode);
                    queryNode.setNodeType(1);
                    queryTree.relabel();
                    continue;
                }
                if (object != null) continue;
                throw new XDBServerException(ErrorMessageRepository.CORELATED_QUERY_ERROR, 0, ErrorMessageRepository.CORELATED_QUERY_ERROR_CODE);
            }
            queryTree.relabel();
            this.adjustConditions(queryTree);
            this.adjustProjections(queryTree);
            QueryTree queryTree2 = queryTree;
            Object var14_26 = null;
            return queryTree2;
        }
        catch (Throwable throwable) {
            Object var14_27 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustConditions(QueryTree queryTree) throws XDBServerException {
        try {
            boolean bl = false;
            String string = "";
            for (QueryCondition queryCondition : queryTree.getConditionList()) {
                QueryNode queryNode;
                if (queryCondition.getNodeIdList().size() == 0) {
                    queryNode = queryTree.getRootNode();
                    while (queryNode.getLeftNode() != null && !queryNode.isPreserveSubtree()) {
                        queryNode = queryNode.getLeftNode();
                    }
                    this.setConditionAtJoinNode(queryTree, queryNode.getLabel(), queryCondition);
                    continue;
                }
                if (queryCondition.isAtomic()) continue;
                int n = -1;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < queryCondition.getNodeIdList().size(); ++i) {
                    queryNode = queryTree.getNodeById(queryCondition.getNodeIdList().get(i));
                    if (queryNode.getLabel().length() < n || n == -1) {
                        n = queryNode.getLabel().length();
                    }
                    arrayList.add(queryNode.getLabel());
                }
                if (arrayList.size() == 1) {
                    this.setConditionAtJoinNode(queryTree, (String)arrayList.get(0), queryCondition);
                    continue;
                }
                string = "";
                bl = false;
                String string2 = (String)arrayList.get(0);
                for (int i = 0; i < n; ++i) {
                    char c = string2.charAt(i);
                    for (String string3 : arrayList) {
                        if (string3.charAt(i) == c) continue;
                        bl = true;
                        break;
                    }
                    if (bl) {
                        this.setConditionAtJoinNode(queryTree, string, queryCondition);
                        break;
                    }
                    string = string + c;
                }
                if (bl) continue;
                throw new XDBServerException(ErrorMessageRepository.MOVINGCONDITION_NOTFOUND, 4, ErrorMessageRepository.MOVINGCONDITION_NOTFOUND_CODE);
            }
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConditionAtJoinNode(QueryTree queryTree, String string, QueryCondition queryCondition) {
        try {
            QueryNode queryNode = queryTree.getRootNode();
            for (int i = 1; i < string.length(); ++i) {
                queryNode = string.charAt(i) == 'L' ? queryNode.getLeftNode() : queryNode.getRightNode();
            }
            queryNode.getConditionList().add(queryCondition);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustProjections(QueryTree queryTree) {
        try {
            this.traverseProjections(queryTree.getRootNode(), queryTree);
            this.addHavingProjections(queryTree);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseProjections(QueryNode queryNode, QueryTree queryTree) throws XDBServerException {
        try {
            if (queryNode.getNodeType() == 1) {
                this.traverseProjections(queryNode.getLeftNode(), queryTree);
                this.traverseProjections(queryNode.getRightNode(), queryTree);
            } else {
                ArrayList<AttributeColumn> arrayList = new ArrayList<AttributeColumn>();
                block2: for (int i = 0; i < queryNode.getRelationNode().getCondColumnList().size(); ++i) {
                    AttributeColumn attributeColumn = queryNode.getRelationNode().getCondColumnList().get(i);
                    for (int j = 0; j < i; ++j) {
                        AttributeColumn attributeColumn2 = queryNode.getRelationNode().getCondColumnList().get(j);
                        if (!attributeColumn2.getTableName().equals(attributeColumn.getTableName()) || !attributeColumn2.columnName.equals(attributeColumn.columnName)) continue;
                        arrayList.add(attributeColumn2);
                        attributeColumn = attributeColumn2;
                        continue block2;
                    }
                }
                if (!arrayList.isEmpty()) {
                    QueryCondition.equateConditionsWithColumns(queryTree.getConditionList(), arrayList);
                }
                for (AttributeColumn attributeColumn : queryNode.getRelationNode().getCondColumnList()) {
                    this.updateSegmentProjections(queryNode, attributeColumn, queryTree);
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSegmentProjections(QueryNode queryNode, AttributeColumn attributeColumn, QueryTree queryTree) throws XDBServerException {
        try {
            QueryNode queryNode2 = queryNode;
            QueryNode queryNode3 = queryNode;
            for (queryNode2 = queryNode2.getParent(); queryNode2 != null; queryNode2 = queryNode2.getParent()) {
                for (QueryCondition queryCondition : queryNode2.getConditionList()) {
                    for (AttributeColumn attributeColumn2 : queryCondition.getColumnList()) {
                        if (attributeColumn2 != attributeColumn || queryNode2.isPreserveSubtree() || queryNode2.isTreeDownJoin() && !queryNode2.getRightNode().subtreeContains(queryNode3)) continue;
                        this.addColumnProjection(queryNode3, queryNode2, attributeColumn);
                        queryNode3 = queryNode2;
                    }
                }
                if (queryNode2.getRightNode() != null && queryNode2.getRightNode().isCorrelatedSubquery()) {
                    for (AttributeColumn attributeColumn3 : queryNode2.getRightNode().getRelationNode().getCorrelatedColumnList()) {
                        if (attributeColumn3 != attributeColumn || queryNode2.isPreserveSubtree() || queryNode2.isTreeDownJoin() && !queryNode2.subtreeContains(queryNode3)) continue;
                        this.addColumnProjection(queryNode3, queryNode2, attributeColumn);
                        queryNode3 = queryNode2;
                    }
                }
                if (queryNode2 == queryTree.getRootNode()) break;
                if (queryNode2.getParent() != null) continue;
                throw new XDBServerException(ErrorMessageRepository.NOPARENTNODE_FOUND, 4, ErrorMessageRepository.NOPARENTNODE_FOUND_CODE);
            }
            Object var11_12 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnProjection(QueryNode queryNode, QueryNode queryNode2, AttributeColumn attributeColumn) {
        try {
            SqlExpression sqlExpression = new SqlExpression();
            sqlExpression.setExprType(4);
            sqlExpression.setColumn(attributeColumn);
            sqlExpression.setExprString(attributeColumn.getTableName() + "." + attributeColumn.columnName);
            sqlExpression.setExprDataType(attributeColumn.columnType);
            this.addColumnProjection(queryNode, queryNode2, sqlExpression);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnProjection(QueryNode queryNode, QueryNode queryNode2, SqlExpression sqlExpression) {
        try {
            for (QueryNode queryNode3 = queryNode; queryNode3 != queryNode2; queryNode3 = queryNode3.getParent()) {
                boolean bl = false;
                for (SqlExpression sqlExpression2 : queryNode3.getProjectionList()) {
                    sqlExpression2.rebuildString();
                    if (sqlExpression2.getExprString().compareTo(sqlExpression.getExprString()) != 0) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                queryNode3.getProjectionList().add(sqlExpression);
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            throw throwable;
        }
    }

    private void addHavingProjections(QueryTree queryTree) {
        for (QueryCondition queryCondition : queryTree.getHavingList()) {
            this.processHavingCondition(queryCondition, queryTree);
        }
    }

    private void processHavingCondition(QueryCondition queryCondition, QueryTree queryTree) {
        if (queryCondition.getLeftCond() != null) {
            this.processHavingCondition(queryCondition.getLeftCond(), queryTree);
        }
        if (queryCondition.getRightCond() != null) {
            this.processHavingCondition(queryCondition.getRightCond(), queryTree);
        }
        if (queryCondition.getCondType() == 4) {
            this.projectExpressions(queryCondition.getExpr(), queryTree);
        }
    }

    private void projectExpressions(SqlExpression sqlExpression, QueryTree queryTree) {
        for (SqlExpression sqlExpression2 : SqlExpression.getNodes(sqlExpression, 4)) {
            QueryNode queryNode = queryTree.getNodeById(sqlExpression2.getColumn().relationNode.getNodeId());
            this.addColumnProjection(queryNode, queryTree.getRootNode(), sqlExpression2);
        }
    }

    private class LookupCandidate {
        RelationNode relationNode;
        RelationNode otherRelationNode;
        QueryCondition queryCondition;
        short outerType;

        LookupCandidate(RelationNode relationNode, RelationNode relationNode2, QueryCondition queryCondition, short s) {
            this.relationNode = relationNode;
            this.otherRelationNode = relationNode2;
            this.queryCondition = queryCondition;
            this.outerType = s;
        }
    }
}

