/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableModifyColumn;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.SqlCreateTableColumn;
import com.edb.gridsql.parser.core.syntaxtree.AlterDefOperationSet;
import com.edb.gridsql.parser.core.syntaxtree.AlterDefOperationType;
import com.edb.gridsql.parser.core.syntaxtree.DropDefaultNotNull;
import com.edb.gridsql.parser.core.syntaxtree.IntervalLiterals;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.DataTypeHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.ArrayList;
import java.util.HashMap;

public class SqlAlterModifyColumn
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterModifyColumn.class);
    private static final int KIND_UNKNOWN = -1;
    private static final int KIND_CHANGE_TYPE = 0;
    private static final int KIND_SET_DEFAULT = 1;
    private static final int KIND_SET_NOT_NULL = 2;
    private static final int KIND_DROP_DEFAULT = 3;
    private static final int KIND_DROP_NOT_NULL = 4;
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private SysColumn sysColumn;
    private SqlCreateTableColumn aSqlCreateTableColumn;
    private String usingExp;
    private int kind = -1;
    private String[] commands;

    public SqlAlterModifyColumn(SqlAlterTable sqlAlterTable, String string, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
        this.sysColumn = sqlAlterTable.getTable().getSysColumn(string);
        if (this.sysColumn == null) {
            throw new XDBServerException("The Table Has Not A Column Named " + string);
        }
        if (sqlAlterTable.getTable() != this.sysColumn.getSysTable()) {
            throw new XDBServerException("Can not modify inherited column");
        }
        this.aSqlCreateTableColumn = new SqlCreateTableColumn(string, new DataTypeHandler(this.sysColumn.getColType(), this.sysColumn.getColLength(), this.sysColumn.getColPrecision(), this.sysColumn.getColScale()), this.sysColumn.isNullable(), this.sysColumn.getDefaultExpr());
    }

    public Object visit(AlterDefOperationType alterDefOperationType, Object object) {
        Object var3_3 = null;
        this.aSqlCreateTableColumn.setTypeHandler(new DataTypeHandler());
        this.kind = 0;
        alterDefOperationType.f1.accept(this.aSqlCreateTableColumn.getTypeHandler(), object);
        if (alterDefOperationType.f2.present()) {
            NodeSequence nodeSequence = (NodeSequence)alterDefOperationType.f2.node;
            NodeChoice nodeChoice = (NodeChoice)nodeSequence.nodes.elementAt(1);
            if (nodeChoice.which == 7) {
                this.usingExp = ((IntervalLiterals)nodeChoice.choice).f0.tokenImage;
                return var3_3;
            }
            if (nodeChoice.which != 5) {
                this.usingExp = ((NodeToken)nodeChoice.choice).tokenImage;
            } else {
                NodeSequence nodeSequence2 = (NodeSequence)nodeChoice.choice;
                this.usingExp = "";
                for (Object e : nodeSequence2.nodes) {
                    this.usingExp = this.usingExp + ((NodeToken)e).tokenImage;
                }
            }
        }
        return var3_3;
    }

    public Object visit(AlterDefOperationSet alterDefOperationSet, Object object) {
        Object var3_3 = null;
        switch (alterDefOperationSet.f1.which) {
            case 0: {
                this.kind = 1;
                alterDefOperationSet.f1.accept(this.aSqlCreateTableColumn, object);
                break;
            }
            case 1: {
                this.kind = 2;
                this.aSqlCreateTableColumn.isnullable = 0;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        return var3_3;
    }

    public Object visit(DropDefaultNotNull dropDefaultNotNull, Object object) {
        Object var3_3 = null;
        if (dropDefaultNotNull.f1.which == 0) {
            this.kind = 3;
            this.aSqlCreateTableColumn.defaultValue = null;
        } else {
            this.kind = 4;
            this.aSqlCreateTableColumn.isnullable = 1;
        }
        return var3_3;
    }

    public SqlCreateTableColumn getColDef() {
        return this.aSqlCreateTableColumn;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            SysTable sysTable = this.parent.getTable();
            sysTable.ensurePermission(this.client.getCurrentUser(), (short)6);
            if (this.kind == 0 && this.aSqlCreateTableColumn.isSerial() && sysTable.getSerialColumn() != null) {
                throw new XDBServerException("The Table Already Has A Serial Column");
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("table", IdentifierHandler.quote(sysTable.getTableName()));
            hashMap.put("column", IdentifierHandler.quote(this.aSqlCreateTableColumn.columnName));
            hashMap.put("column_type", this.aSqlCreateTableColumn.getTypeHandlerString());
            hashMap.put("default_expr", this.aSqlCreateTableColumn.getDefaultValue());
            hashMap.put("null_expr", this.aSqlCreateTableColumn.isnullable == 1 ? "NULL" : "NOT NULL");
            if (this.kind == 0) {
                this.aSqlCreateTableColumn.rebuildString();
                string = Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN;
                string = ParseCmdLine.substitute(string, hashMap);
                if (this.usingExp != null) {
                    String string2 = Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_USING;
                    hashMap = new HashMap();
                    hashMap.put("using_expr", this.usingExp);
                    string2 = ParseCmdLine.substitute(string2, hashMap);
                    string = string + " " + string2;
                }
                if (Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_TO_PARENT) {
                    this.parent.addCommonCommand(string);
                } else {
                    arrayList.add(string);
                }
            }
            if (this.kind == 1) {
                string = Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_SETDEFAULT;
                string = ParseCmdLine.substitute(string, hashMap);
                if (Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_SETDEFAULT_TO_PARENT) {
                    this.parent.addCommonCommand(string);
                } else {
                    arrayList.add(string);
                }
            }
            if (this.kind == 2) {
                string = Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_SETNOTNULL;
                string = ParseCmdLine.substitute(string, hashMap);
                if (Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_SETNOTNULL_TO_PARENT) {
                    this.parent.addCommonCommand(string);
                } else {
                    arrayList.add(string);
                }
            }
            if (this.kind == 3) {
                string = Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_DROPDEFAULT;
                string = ParseCmdLine.substitute(string, hashMap);
                if (Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_DROPDEFAULT_TO_PARENT) {
                    this.parent.addCommonCommand(string);
                } else {
                    arrayList.add(string);
                }
            }
            if (this.kind == 4) {
                string = Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_DROPNOTNULL;
                string = ParseCmdLine.substitute(string, hashMap);
                if (Props.XDB_SQLCOMMAND_ALTERTABLE_MODIFYCOLUMN_DROPNOTNULL_TO_PARENT) {
                    this.parent.addCommonCommand(string);
                } else {
                    arrayList.add(string);
                }
            }
            if (this.aSqlCreateTableColumn.isSerial()) {
                string = "create index " + IdentifierHandler.quote(SqlCreateTableColumn.IDX_SERIAL_NAME) + " on " + IdentifierHandler.quote(sysTable.getTableName()) + " ( " + IdentifierHandler.quote(this.aSqlCreateTableColumn.columnName) + " ) ";
                arrayList.add(string);
            }
            this.commands = arrayList.toArray(new String[arrayList.size()]);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableModifyColumn(this), this.client);
            ExecutionResult executionResult = null;
            Object var4_3 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            throw throwable;
        }
    }
}

