/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.util.OutputFormatter;
import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.copy.CopyManager;
import com.edb.gridsql.engine.loader.Loader;
import com.edb.gridsql.engine.loader.LoaderConnectionPool;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.OrderByElement;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.CopyData;
import com.edb.gridsql.parser.core.syntaxtree.FormatDefCSV;
import com.edb.gridsql.parser.core.syntaxtree.FormatDefDelimiter;
import com.edb.gridsql.parser.core.syntaxtree.FormatDefNull;
import com.edb.gridsql.parser.core.syntaxtree.FormatDefOIDS;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.Select;
import com.edb.gridsql.parser.core.syntaxtree.TableName;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.OrderByClauseHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.planner.NodeUsage;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCopyData
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCopyData.class);
    private XDBSessionContext client;
    private boolean prepared = false;
    private boolean copyIn;
    private String tableName;
    private List<String> columnNameList;
    private QueryTree aQueryTree = null;
    private SysTable table;
    private QueryProcessor qProcessor;
    private String copyCommand = null;
    private String filename;
    private boolean binary;
    private boolean header;
    private boolean oids;
    private String delimiter = null;
    private String nulls = null;
    private boolean csv;
    private String quote = "\"";
    private String quoteEscape = null;
    private List<String> forceQuoteColumns = null;
    private Loader loader;
    private OutputFormatter formatter;
    LockSpecification<SysTable> lockSpec;
    private InputStream consoleIn = null;
    private OutputStream consoleOut = null;

    public SqlCopyData(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        if (this.lockSpec == null) {
            if (this.qProcessor == null) {
                List list = Collections.emptyList();
                this.lockSpec = new LockSpecification<SysTable>(Collections.singleton(this.getSysTable()), list);
            } else {
                this.lockSpec = this.qProcessor.getLockSpecs();
            }
        }
        return this.lockSpec;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    public void setStdOut(OutputStream outputStream) {
        this.consoleOut = outputStream;
    }

    public void setStdIn(InputStream inputStream) {
        this.consoleIn = inputStream;
    }

    public boolean isCopyIn() {
        return this.copyIn;
    }

    public boolean isConsole() {
        return this.filename == null;
    }

    public ColumnMetaData[] getColumnMeta() {
        if (this.getSysTable() == null) {
            if (this.qProcessor != null) {
                return this.qProcessor.getMetaData();
            }
        } else {
            if (this.columnNameList == null) {
                ArrayList<ColumnMetaData> arrayList = new ArrayList<ColumnMetaData>(this.table.getColumns().size());
                for (SysColumn sysColumn : this.table.getColumns()) {
                    if (sysColumn.getColName().equals("xrowid")) continue;
                    arrayList.add(new ColumnMetaData(sysColumn.getColName(), null, sysColumn.getColLength(), sysColumn.getColType(), sysColumn.getColPrecision(), sysColumn.getColScale(), this.tableName, 0, false));
                }
                return arrayList.toArray(new ColumnMetaData[arrayList.size()]);
            }
            ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[this.columnNameList.size()];
            int n = 0;
            for (String string : this.columnNameList) {
                SysColumn sysColumn = this.table.getSysColumn(string);
                if (sysColumn == null) {
                    throw new XDBServerException("Column " + string + " is not found");
                }
                columnMetaDataArray[n++] = new ColumnMetaData(sysColumn.getColName(), null, sysColumn.getColLength(), sysColumn.getColType(), sysColumn.getColPrecision(), sysColumn.getColScale(), this.tableName, 0, false);
            }
            return columnMetaDataArray;
        }
        return null;
    }

    private SysTable getSysTable() {
        if (this.table == null && this.tableName != null) {
            this.table = this.client.getSysDatabase().getSysTable(this.tableName);
        }
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            this.prepared = true;
            if (this.copyIn) {
                if (this.aQueryTree != null) {
                    throw new XDBServerException("\"TO\" is expected but \"FROM\" is found");
                }
                if (this.delimiter == null) {
                    String string = this.delimiter = this.csv ? "," : Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER;
                }
                if (this.nulls == null) {
                    this.nulls = this.csv ? "" : Props.XDB_LOADER_NODEWRITER_DEFAULT_NULL;
                }
                this.loader = new Loader(this.delimiter, this.nulls);
                this.getSysTable();
                this.loader.setLocalTableInfo(this.table, this.client, this.columnNameList, this.oids);
                if (this.binary) {
                    // empty if block
                }
                if (this.header) {
                    // empty if block
                }
                if (this.csv) {
                    char c = this.quote == null || this.quote.length() == 0 ? (char)'\"' : (char)this.quote.charAt(0);
                    char c2 = this.quoteEscape == null || this.quoteEscape.length() == 0 ? c : (char)this.quoteEscape.charAt(0);
                    this.loader.setQuotes(c, c2);
                    if (this.forceQuoteColumns != null) {
                        this.loader.setForceNotNullColumns(this.forceQuoteColumns);
                    }
                }
                this.loader.prepareLoad();
                this.loader.setVerbose(false);
            } else {
                if (this.aQueryTree != null) {
                    this.qProcessor = new QueryProcessor(this.client, this.aQueryTree);
                    this.qProcessor.prepare();
                }
                if (this.aQueryTree == null || this.qProcessor != null && this.qProcessor.getExecPlan().isSingleStep()) {
                    if (Props.XDB_USE_COPY_OUT_FOR_STEP) {
                        StringBuffer stringBuffer = new StringBuffer("COPY ");
                        if (this.qProcessor != null) {
                            stringBuffer.append("(");
                            stringBuffer.append(this.qProcessor.getExecPlan().stepList.get((int)0).aStepDetail.queryString);
                        } else {
                            this.table = this.client.getSysDatabase().getSysTable(this.tableName);
                            stringBuffer.append(this.table.getTableName());
                            stringBuffer.append("(");
                            if (this.columnNameList == null) {
                                for (SysColumn object : this.table.getColumns()) {
                                    if (!this.oids && object.getColName().equalsIgnoreCase("xrowid")) continue;
                                    stringBuffer.append(object.getColName());
                                    stringBuffer.append(", ");
                                }
                            } else {
                                Iterator<String> iterator = this.columnNameList.iterator();
                                while (iterator.hasNext()) {
                                    String sysColumn = (String)iterator.next();
                                    SysColumn sysColumn2 = this.table.getSysColumn(sysColumn);
                                    if (sysColumn2 == null) {
                                        throw new XDBServerException("Column " + sysColumn + " is not found");
                                    }
                                    stringBuffer.append(sysColumn2.getColName());
                                    stringBuffer.append(", ");
                                }
                                if (this.oids && (iterator = this.table.getSysColumn("xrowid")) != null) {
                                    stringBuffer.append(((SysColumn)((Object)iterator)).getColName());
                                    stringBuffer.append(", ");
                                }
                            }
                            stringBuffer.setLength(stringBuffer.length() - 2);
                        }
                        stringBuffer.append(") TO STDOUT");
                        if (this.delimiter != null) {
                            stringBuffer.append(" DELIMITER '");
                            stringBuffer.append(this.delimiter.replaceAll("'", "''"));
                            stringBuffer.append("'");
                        }
                        if (this.nulls != null) {
                            stringBuffer.append(" NULL '");
                            stringBuffer.append(this.nulls.replaceAll("'", "''"));
                            stringBuffer.append("'");
                        }
                        if (this.csv) {
                            stringBuffer.append(" CSV");
                            if (this.quote != null) {
                                stringBuffer.append(" QUOTE '");
                                stringBuffer.append(this.quote.replaceAll("'", "''"));
                                stringBuffer.append("'");
                            }
                            if (this.quoteEscape != null) {
                                stringBuffer.append(" ESCAPE '");
                                stringBuffer.append(this.quoteEscape.replaceAll("'", "''"));
                                stringBuffer.append("'");
                            }
                            if (this.forceQuoteColumns != null) {
                                stringBuffer.append(" FORCE QUOTE ");
                                for (String string : this.forceQuoteColumns) {
                                    stringBuffer.append(string);
                                    stringBuffer.append(", ");
                                }
                                stringBuffer.setLength(stringBuffer.length() - 2);
                            }
                        }
                        this.copyCommand = stringBuffer.toString();
                        Object var6_17 = null;
                        return;
                    }
                    this.table = this.client.getSysDatabase().getSysTable(this.tableName);
                    this.aQueryTree = new QueryTree();
                    RelationNode relationNode = this.aQueryTree.newRelationNode();
                    relationNode.setNodeType(2);
                    relationNode.setTableName(this.tableName);
                    relationNode.setTemporaryTable(this.client.getTempTableName(this.tableName) != null);
                    relationNode.setClient(this.client);
                    relationNode.setAlias("");
                    if (this.columnNameList == null) {
                        for (SysColumn sysColumn : this.table.getColumns()) {
                            if (!this.oids && sysColumn.getColName().equalsIgnoreCase("xrowid")) continue;
                            this.createColumnExpression(relationNode, sysColumn);
                        }
                    } else {
                        for (String string : this.columnNameList) {
                            SysColumn sysColumn = this.table.getSysColumn(string);
                            if (sysColumn == null) {
                                throw new XDBServerException("Column " + string + " is not found");
                            }
                            this.createColumnExpression(relationNode, sysColumn);
                        }
                        if (this.oids) {
                            this.createColumnExpression(relationNode, this.table.getSysColumn("xrowid"));
                        }
                    }
                }
                this.formatter = new OutputFormatter(null);
                if (this.delimiter == null) {
                    String string = this.delimiter = this.csv ? "," : Props.XDB_LOADER_NODEWRITER_DEFAULT_DELIMITER;
                }
                if (this.nulls == null) {
                    this.nulls = this.csv ? "" : Props.XDB_LOADER_NODEWRITER_DEFAULT_NULL;
                }
                this.formatter.setSFieldSep(this.delimiter);
                this.formatter.setNullValue(this.nulls);
                if (this.binary) {
                    // empty if block
                }
                if (this.header) {
                    // empty if block
                }
                if (this.csv) {
                    this.formatter.setQuoteInfo(this.quote, this.quoteEscape, this.forceQuoteColumns);
                }
            }
        }
        catch (Throwable throwable) {
            Object var6_19 = null;
            throw throwable;
        }
        Object var6_18 = null;
    }

    private void createColumnExpression(RelationNode relationNode, SysColumn sysColumn) {
        ExpressionType expressionType = new ExpressionType();
        expressionType.type = sysColumn.getColType();
        expressionType.length = sysColumn.getColumnLength();
        AttributeColumn attributeColumn = new AttributeColumn();
        attributeColumn.setTableName(this.tableName);
        attributeColumn.columnName = sysColumn.getColName();
        attributeColumn.relationNode = relationNode;
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.setExprType(4);
        sqlExpression.setColumn(attributeColumn);
        sqlExpression.setExprDataType(expressionType);
        relationNode.getProjectionList().add(sqlExpression);
        this.aQueryTree.getProjectionList().add(sqlExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            OutputStream outputStream;
            long l;
            block21: {
                ExecutionResult executionResult;
                if (!this.isPrepared()) {
                    this.prepare();
                }
                if (this.copyIn) {
                    if (this.filename == null) {
                        this.loader.setDataSource(this.consoleIn);
                    } else {
                        this.loader.setDataSource(this.filename);
                    }
                    boolean bl = false;
                    try {
                        this.loader.runWriters();
                        bl = true;
                        Object var4_4 = null;
                        this.loader.finishLoad(bl);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.loader.finishLoad(bl);
                        throw throwable;
                    }
                    long l2 = this.loader.getRowCount();
                    if (!this.table.isLookup()) return ExecutionResult.createRowCountResult(45, (int)l2);
                    l2 /= (long)this.table.getNodeList().size();
                    return ExecutionResult.createRowCountResult(45, (int)l2);
                }
                l = 0L;
                outputStream = this.isConsole() ? this.consoleOut : new FileOutputStream(this.filename);
                try {
                    if (this.copyCommand == null) break block21;
                    LinkedList<NodeDBConnectionInfo> linkedList = new LinkedList<NodeDBConnectionInfo>();
                    if (this.table == null) {
                        for (NodeUsage nodeUsage : this.qProcessor.getExecPlan().stepList.get((int)0).nodeUsageTable.values()) {
                            if (!nodeUsage.isProducer) continue;
                            linkedList.add(this.client.getSysDatabase().getDBNode(nodeUsage.nodeId).getNodeDBConnectionInfo());
                        }
                    } else {
                        for (DBNode dBNode : this.table.getJoinNodeList()) {
                            linkedList.add(dBNode.getNodeDBConnectionInfo());
                        }
                    }
                    Iterator<NodeUsage> iterator = LoaderConnectionPool.getConnectionPool();
                    for (NodeDBConnectionInfo nodeDBConnectionInfo : linkedList) {
                        Object var11_26;
                        Connection connection = ((LoaderConnectionPool)((Object)iterator)).getConnection(nodeDBConnectionInfo);
                        try {
                            l += CopyManager.getCopyManager(connection).copyOut(this.copyCommand, outputStream);
                            var11_26 = null;
                            ((LoaderConnectionPool)((Object)iterator)).releaseConnection(nodeDBConnectionInfo, connection);
                        }
                        catch (Throwable throwable) {
                            var11_26 = null;
                            ((LoaderConnectionPool)((Object)iterator)).releaseConnection(nodeDBConnectionInfo, connection);
                            throw throwable;
                        }
                    }
                    executionResult = ExecutionResult.createRowCountResult(46, (int)l);
                    Object var15_28 = null;
                }
                catch (Throwable throwable) {
                    Object var15_30 = null;
                    outputStream.close();
                    throw throwable;
                }
                outputStream.close();
                return executionResult;
            }
            ExecutionResult executionResult = this.qProcessor.execute(engine);
            ResultSet resultSet = executionResult.getResultSet();
            try {
                if (this.isConsole()) {
                    this.formatter.setSTerminator("\n");
                }
                l = this.formatter.printRS(resultSet, outputStream);
                Object var13_31 = null;
                resultSet.close();
            }
            catch (Throwable throwable) {
                Object var13_32 = null;
                resultSet.close();
                throw throwable;
            }
            ExecutionResult executionResult2 = ExecutionResult.createRowCountResult(46, (int)l);
            Object var15_29 = null;
            outputStream.close();
            return executionResult2;
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            throw throwable;
        }
    }

    @Override
    public Object visit(CopyData copyData, Object object) {
        copyData.f1.accept(this, object);
        this.copyIn = copyData.f2.which == 0;
        NodeSequence nodeSequence = (NodeSequence)copyData.f2.choice;
        NodeChoice nodeChoice = (NodeChoice)nodeSequence.nodes.get(1);
        if (nodeChoice.which == 1) {
            NodeToken nodeToken = (NodeToken)nodeChoice.choice;
            this.filename = nodeToken.tokenImage;
            this.filename = this.filename.substring(1, this.filename.length() - 1).replaceAll("''", "'");
        }
        copyData.f3.accept(this, object);
        return null;
    }

    @Override
    public Object visit(FormatDefCSV formatDefCSV, Object object) {
        this.csv = true;
        for (NodeChoice nodeChoice : formatDefCSV.f1.nodes) {
            switch (nodeChoice.which) {
                case 0: {
                    NodeSequence nodeSequence = (NodeSequence)nodeChoice.choice;
                    NodeToken nodeToken = (NodeToken)nodeSequence.nodes.get(2);
                    this.quote = this.getTokenImage(nodeToken.tokenImage);
                    break;
                }
                case 1: {
                    NodeSequence nodeSequence = (NodeSequence)nodeChoice.choice;
                    NodeToken nodeToken = (NodeToken)nodeSequence.nodes.get(2);
                    this.quoteEscape = this.getTokenImage(nodeToken.tokenImage);
                    break;
                }
                case 2: {
                    if (this.copyIn) {
                        throw new XDBServerException("FORCE QUOTE is not allowed in COPY FROM mode");
                    }
                    ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
                    nodeChoice.accept(columnNameListHandler, object);
                    this.forceQuoteColumns = columnNameListHandler.getColumnNameList();
                    break;
                }
                case 3: {
                    if (!this.copyIn) {
                        throw new XDBServerException("FORCE NOT NULL is not allowed in COPY TO mode");
                    }
                    ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
                    nodeChoice.accept(columnNameListHandler, object);
                    this.forceQuoteColumns = columnNameListHandler.getColumnNameList();
                }
            }
        }
        return null;
    }

    @Override
    public Object visit(FormatDefDelimiter formatDefDelimiter, Object object) {
        this.delimiter = this.getTokenImage(formatDefDelimiter.f2.tokenImage);
        return null;
    }

    @Override
    public Object visit(FormatDefNull formatDefNull, Object object) {
        this.nulls = this.getTokenImage(formatDefNull.f2.tokenImage);
        return null;
    }

    @Override
    public Object visit(FormatDefOIDS formatDefOIDS, Object object) {
        this.oids = true;
        return null;
    }

    @Override
    public Object visit(TableName tableName, Object object) {
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        tableName.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        return null;
    }

    @Override
    public Object visit(ColumnNameList columnNameList, Object object) {
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        columnNameList.accept(columnNameListHandler, object);
        this.columnNameList = columnNameListHandler.getColumnNameList();
        return null;
    }

    @Override
    public Object visit(Select select, Object object) {
        Command command = new Command(3, this, new QueryTreeTracker(), this.client);
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(command);
        this.aQueryTree = new QueryTree();
        select.f0.accept(queryTreeHandler, this.aQueryTree);
        OrderByClauseHandler orderByClauseHandler = new OrderByClauseHandler(command);
        select.f1.accept(orderByClauseHandler, this.aQueryTree);
        this.aQueryTree.setOrderByList(orderByClauseHandler.orderByList);
        this.preProcessOrderByList();
        this.FillSQLExpressionInformation(this.aQueryTree.getOrderByList(), command);
        select.f2.accept(queryTreeHandler, this.aQueryTree);
        select.f3.accept(queryTreeHandler, this.aQueryTree);
        if (this.aQueryTree.isHasUnion()) {
            for (int i = 0; i < this.aQueryTree.getUnionQueryTreeList().size(); ++i) {
                this.aQueryTree.getUnionQueryTreeList().get(i).checkExpressionTypes(this.aQueryTree.getProjectionList());
            }
        }
        return null;
    }

    private void preProcessOrderByList() {
        for (OrderByElement orderByElement : this.aQueryTree.getOrderByList()) {
            SqlExpression sqlExpression = orderByElement.orderExpression;
            String string = sqlExpression.rebuildString();
            try {
                int n = Integer.parseInt(string);
                int n2 = n - 1;
                if (n2 >= this.aQueryTree.getProjectionList().size() || n2 < 0) {
                    throw new XDBServerException(ErrorMessageRepository.ORDERBY_CLAUSE_POINTS_TO_ILLEGAL_PROJ_COLUMN, 0, ErrorMessageRepository.ORDERBY_CLAUSE_POINTS_TO_ILLEGAL_PROJ_COLUMN_CODE);
                }
                SqlExpression sqlExpression2 = this.aQueryTree.getProjectionList().get(n2);
                orderByElement.orderExpression = new SqlExpression();
                SqlExpression.copy(sqlExpression2, orderByElement.orderExpression);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void FillSQLExpressionInformation(List<OrderByElement> list, Command command) throws ColumnNotFoundException {
        Vector<SqlExpression> vector = new Vector<SqlExpression>();
        for (OrderByElement object : list) {
            vector.add(object.orderExpression);
        }
        QueryTreeHandler.checkAndExpand(vector, this.aQueryTree.getRelationNodeList(), this.client.getSysDatabase(), command);
        List<SqlExpression> list2 = QueryTreeHandler.checkAndFillTableNames(vector, this.aQueryTree.getRelationNodeList(), this.aQueryTree.getProjectionList(), 4, command.getaQueryTreeTracker(), this.client.getSysDatabase());
        this.aQueryTree.getOrderByOrphans().addAll((Collection<SqlExpression>)list2);
        for (SqlExpression sqlExpression : vector) {
            sqlExpression.rebuildExpression();
            SqlExpression.setExpressionResultType(sqlExpression, this.client.getSysDatabase());
        }
    }

    private String getTokenImage(String string) {
        string = ParseCmdLine.stripEscapes(string);
        return string.substring(1, string.length() - 1).replaceAll("''", "'");
    }
}

