/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateIndexKey {
    private int keyColumnId;
    private SqlExpression keyExpression;
    private List<String> keyColumnNames;
    private String keySequence;
    private String colOperator;

    public SqlCreateIndexKey(int n, String string, String string2, String string3) {
        this.keyColumnId = n;
        this.keyExpression = null;
        this.keyColumnNames = Collections.singletonList(string);
        this.keySequence = string2;
        this.colOperator = string3;
    }

    public SqlCreateIndexKey(SqlExpression sqlExpression, String string, String string2) {
        this.keyColumnId = -1;
        this.keyExpression = sqlExpression;
        this.keyColumnNames = new LinkedList<String>();
        for (SqlExpression sqlExpression2 : SqlExpression.getNodes(sqlExpression, 4)) {
            this.keyColumnNames.add(sqlExpression2.getColumn().columnName);
        }
        this.keySequence = string;
        this.colOperator = string2;
    }

    public SqlCreateIndexKey(String string, String string2, String string3) {
        this(-1, string, string2, string3);
    }

    public int getKeyColumnId() {
        return this.keyColumnId;
    }

    public String rebuildString() {
        String string = this.keyExpression == null ? IdentifierHandler.quote(this.keyColumnNames.get(0)) : "(" + this.keyExpression.rebuildString() + ")";
        if (Props.XDB_INDEX_USEASCDESC && this.keySequence != null) {
            string = string + " " + this.keySequence;
        }
        if (this.getColOperator() != null) {
            string = string + " " + this.getColOperator();
        }
        return string;
    }

    public boolean isAscending() {
        return this.keySequence == null || "ASC".equalsIgnoreCase(this.keySequence);
    }

    public List<String> getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public String getColOperator() {
        return this.colOperator;
    }

    public void setColOperator(String string) {
        this.colOperator = string;
    }
}

