/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncGrant;
import com.edb.gridsql.metadata.SyncRevoke;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Grant;
import com.edb.gridsql.parser.core.syntaxtree.Grantee;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeListOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.Privilege;
import com.edb.gridsql.parser.core.syntaxtree.PrivilegeList;
import com.edb.gridsql.parser.core.syntaxtree.Revoke;
import com.edb.gridsql.parser.core.syntaxtree.TableListForGrant;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlGrant
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlGrant.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private boolean grant;
    private boolean hasSelect = false;
    private boolean hasInsert = false;
    private boolean hasUpdate = false;
    private boolean hasDelete = false;
    private boolean hasReferences = false;
    private boolean hasIndex = false;
    private boolean hasAlter = false;
    private Collection<String> tableList = null;
    private Collection<String> granteeList = new HashSet<String>();
    private Collection<SysTable> iTableList;
    private Collection<SysUser> iGranteeList = new HashSet<SysUser>();
    private boolean prepared = false;

    public SqlGrant(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    @Override
    public Object visit(Revoke revoke, Object object) {
        Object var3_3 = null;
        this.grant = false;
        revoke.f1.accept(this, object);
        revoke.f4.accept(this, object);
        revoke.f6.accept(this, object);
        return var3_3;
    }

    @Override
    public Object visit(Grant grant, Object object) {
        Object var3_3 = null;
        this.grant = true;
        grant.f1.accept(this, object);
        grant.f4.accept(this, object);
        grant.f6.accept(this, object);
        return var3_3;
    }

    @Override
    public Object visit(PrivilegeList privilegeList, Object object) {
        Object var3_3 = null;
        if (privilegeList.f0.which == 0) {
            this.hasSelect = true;
            this.hasInsert = true;
            this.hasUpdate = true;
            this.hasDelete = true;
            this.hasReferences = true;
            this.hasIndex = true;
            this.hasAlter = true;
        } else {
            privilegeList.f0.accept(this, object);
        }
        return var3_3;
    }

    @Override
    public Object visit(Privilege privilege, Object object) {
        Object var3_3 = null;
        switch (privilege.f0.which) {
            case 0: {
                this.hasSelect = true;
                break;
            }
            case 1: {
                this.hasInsert = true;
                break;
            }
            case 2: {
                this.hasUpdate = true;
                break;
            }
            case 3: {
                this.hasDelete = true;
                break;
            }
            case 4: {
                this.hasReferences = true;
                break;
            }
            case 5: {
                this.hasIndex = true;
                break;
            }
            case 6: {
                this.hasAlter = true;
            }
        }
        return var3_3;
    }

    @Override
    public Object visit(Grantee grantee, Object object) {
        if (grantee.f0.which == 0) {
            this.granteeList.add(null);
        } else {
            IdentifierHandler identifierHandler = new IdentifierHandler();
            grantee.f0.choice.accept(identifierHandler, object);
            this.granteeList.add(identifierHandler.getIdentifier());
        }
        return null;
    }

    @Override
    public Object visit(TableListForGrant tableListForGrant, Object object) {
        if (tableListForGrant.f0.which == 1) {
            this.tableList = new LinkedList<String>();
            IdentifierHandler identifierHandler = new IdentifierHandler();
            NodeSequence nodeSequence = (NodeSequence)tableListForGrant.f0.choice;
            ((Node)nodeSequence.nodes.get(0)).accept(identifierHandler, object);
            this.tableList.add(identifierHandler.getIdentifier());
            NodeListOptional nodeListOptional = (NodeListOptional)nodeSequence.nodes.get(1);
            for (Object e : nodeListOptional.nodes) {
                ((Node)e).accept(identifierHandler, object);
                this.tableList.add(identifierHandler.getIdentifier());
            }
        }
        return null;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    public boolean hasAlter() {
        return this.hasAlter;
    }

    public boolean hasDelete() {
        return this.hasDelete;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean hasInsert() {
        return this.hasInsert;
    }

    public boolean hasReferences() {
        return this.hasReferences;
    }

    public boolean hasSelect() {
        return this.hasSelect;
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public Collection<SysUser> getGranteeList() {
        return this.iGranteeList;
    }

    public Collection<SysTable> getTableList() {
        return this.iTableList;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() throws Exception {
        if (!this.prepared) {
            this.iTableList = new HashSet<SysTable>();
            if (this.tableList != null) {
                for (String object : this.tableList) {
                    SysTable sysTable = this.database.getSysTable(object);
                    if (sysTable == null) {
                        throw new XDBServerException("Table not found: " + object);
                    }
                    if (sysTable.getParentTable() != null) {
                        throw new XDBServerException("Permissions on child table \"" + sysTable.getTableName() + "\" can not be changed");
                    }
                    if (sysTable.isTemporary()) {
                        throw new XDBServerException("Permissions on temporary table \"" + sysTable.getTableName() + "\" can not be changed");
                    }
                    if (this.client.getCurrentUser().getUserClass() != 0 && sysTable.getOwner() != null && sysTable.getOwner() != this.client.getCurrentUser()) {
                        XDBSecurityException xDBSecurityException = new XDBSecurityException("You do not have privilege to change permissions on " + sysTable.getTableName());
                        logger.throwing(xDBSecurityException);
                        throw xDBSecurityException;
                    }
                    this.iTableList.add(sysTable);
                }
            } else {
                for (SysTable sysTable : this.database.getSysTables()) {
                    if (sysTable.getParentTable() != null || sysTable.isTemporary() || this.client.getCurrentUser().getUserClass() != 0 && sysTable.getOwner() != null && sysTable.getOwner() != this.client.getCurrentUser()) continue;
                    this.iTableList.add(sysTable);
                }
            }
            for (String string : this.granteeList) {
                this.iGranteeList.add(string == null ? null : this.database.getSysUser(string));
            }
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            IMetaDataUpdate iMetaDataUpdate = this.grant ? new SyncGrant(this) : new SyncRevoke(this);
            MetaData metaData = MetaData.getMetaData();
            metaData.beginTransaction();
            try {
                iMetaDataUpdate.execute(this.client);
                metaData.commitTransaction(iMetaDataUpdate);
            }
            catch (Exception exception) {
                logger.catching(exception);
                metaData.rollbackTransaction();
                throw exception;
            }
            ExecutionResult executionResult = ExecutionResult.createSuccessResult(24);
            Object var6_6 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

