/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.IConstraintChecker;
import com.edb.gridsql.constraintchecker.InsertForeignKeyChecker;
import com.edb.gridsql.constraintchecker.InsertPrimaryKeyChecker;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.metadata.scheduler.LockType;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.Lexer;
import com.edb.gridsql.parser.ParserHelper;
import com.edb.gridsql.parser.SqlModifyTable;
import com.edb.gridsql.parser.Tuple;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.InsertTable;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.SQLExpressionListItem;
import com.edb.gridsql.parser.core.syntaxtree.Select;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.SQLExpressionHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlInsertTable
extends SqlModifyTable {
    public static final String GROUP_ROW_ID = "group__id";
    private static final XLogger logger = XLogger.getLogger(SqlInsertTable.class);
    private Tuple tuple;
    private Vector<String> columnList = new Vector();
    private Collection<SysColumn> sysColumnList;
    private Vector<SqlExpression> valueList = new Vector();
    private QueryTree aQueryTree = null;
    private Collection<DBNode> executionNodes = null;
    private boolean hasAutoincrement = false;

    public SqlInsertTable(XDBSessionContext xDBSessionContext) {
        super(xDBSessionContext);
        this.commandToExecute = new Command(3, this, new QueryTreeTracker(), xDBSessionContext);
    }

    @Override
    public Object visit(InsertTable insertTable, Object object) {
        Object var3_3 = null;
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        insertTable.f2.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        insertTable.f3.accept(this, object);
        if (insertTable.f4.which == 0) {
            insertTable.f4.accept(this, object);
            this.tuple = new Tuple(this.getTableName(), new ArrayList<SysColumn>(this.getColumnsInvolved()), this.valueList, this.client);
        } else {
            QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
            this.aQueryTree = new QueryTree();
            insertTable.f4.choice.accept(queryTreeHandler, this.aQueryTree);
            this.addProjColsIfFoundNullColumn(this.aQueryTree, this.getColumnsInvolved().size());
        }
        return var3_3;
    }

    void addProjColsIfFoundNullColumn(QueryTree queryTree, int n) {
        List<SqlExpression> list = queryTree.getProjectionList();
        if (list.size() == 1 && list.get(0).getExprString() == null) {
            if (n > 1) {
                SqlExpression sqlExpression = list.get(0);
                list.clear();
                for (int i = 0; i < n; ++i) {
                    list.add(sqlExpression.copy());
                }
            }
        } else if (n == 0) {
            throw new XDBServerException("INSERT has more expressions than target columns");
        }
    }

    @Override
    public Object visit(ColumnNameList columnNameList, Object object) {
        Object var3_3 = null;
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.columnList.add((String)columnNameList.f0.accept(identifierHandler, object));
        for (Object e : columnNameList.f1.nodes) {
            NodeSequence nodeSequence = (NodeSequence)e;
            this.columnList.add((String)nodeSequence.elementAt(1).accept(identifierHandler, object));
        }
        return var3_3;
    }

    @Override
    public Object visit(SQLExpressionListItem sQLExpressionListItem, Object object) {
        Object var3_3 = null;
        SQLExpressionHandler sQLExpressionHandler = new SQLExpressionHandler(this.commandToExecute);
        SqlExpression sqlExpression = (SqlExpression)sQLExpressionListItem.f0.accept(sQLExpressionHandler, object);
        this.valueList.add(sqlExpression);
        return var3_3;
    }

    @Override
    public Object visit(Select select, Object object) {
        Object var3_3 = null;
        select.f0.accept(this, object);
        select.f1.accept(this, object);
        return var3_3;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        if (this.lockSpecs == null) {
            List list = Collections.emptyList();
            this.lockSpecs = new LockSpecification<SysTable>(this.getReadTables(), list);
            this.lockSpecs.add(this.getTargetTable(), LockType.get(1, false));
        }
        return this.lockSpecs;
    }

    @Override
    protected Collection<SysColumn> getColumnsInvolved() {
        block5: {
            if (this.sysColumnList != null) break block5;
            this.sysColumnList = new LinkedHashSet<SysColumn>();
            if (this.columnList.size() == 0) {
                for (SysColumn sysColumn : this.getTargetTable().getColumns()) {
                    if ("xrowid".equals(sysColumn.getColName())) continue;
                    this.sysColumnList.add(sysColumn);
                    this.columnList.add(sysColumn.getColName());
                }
            } else {
                for (String string : this.columnList) {
                    SysColumn sysColumn = this.getTargetTable().getSysColumn(string);
                    if (sysColumn == null) {
                        throw new XDBServerException("Column " + string + " is not found in table " + this.tableName);
                    }
                    this.sysColumnList.add(sysColumn);
                }
            }
        }
        return this.sysColumnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IConstraintChecker getPKChecker(SysTable sysTable, Collection<SysColumn> collection) {
        try {
            InsertPrimaryKeyChecker insertPrimaryKeyChecker = new InsertPrimaryKeyChecker(this.getTargetTable(), this.tuple, this.client);
            collection.addAll(insertPrimaryKeyChecker.scanConstraints(this.getColumnsInvolved()));
            InsertPrimaryKeyChecker insertPrimaryKeyChecker2 = insertPrimaryKeyChecker;
            Object var6_5 = null;
            return insertPrimaryKeyChecker2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IConstraintChecker getFKChecker(SysTable sysTable, Collection<SysColumn> collection) {
        try {
            InsertForeignKeyChecker insertForeignKeyChecker = new InsertForeignKeyChecker(this.getTargetTable(), this.tuple, this.client);
            collection.addAll(insertForeignKeyChecker.scanConstraints(this.getColumnsInvolved()));
            InsertForeignKeyChecker insertForeignKeyChecker2 = insertForeignKeyChecker;
            Object var6_5 = null;
            return insertForeignKeyChecker2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    @Override
    protected IConstraintChecker getFRChecker(SysTable sysTable, Collection<SysColumn> collection) {
        return null;
    }

    @Override
    protected SysTable createTempTableMetadata(SysTable sysTable, Collection<SysColumn> collection) throws Exception {
        if (this.tuple == null) {
            for (SysColumn sysColumn : sysTable.getColumns()) {
                SysColumn sysColumn2 = sysColumn;
                if (collection.contains(sysColumn2) || sysColumn2.getDefaultExpr() == null && !"xrowid".equals(sysColumn2.getColName()) && !sysColumn2.isSerial()) continue;
                collection.add(sysColumn2);
                this.hasAutoincrement = true;
            }
            SysTable sysTable2 = super.createTempTableMetadata(sysTable, collection);
            sysTable2.setTableTemporary(!Props.XDB_USE_LOAD_FOR_STEP);
            return sysTable2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareDataSource(SysTable sysTable, SysTable sysTable2) throws Exception {
        block4: {
            try {
                if (this.tuple != null) break block4;
                if (!(this.validators == null || this.validators.size() != 0 || this.aQueryTree.getUnionQueryTreeList().size() != 0 || this.aQueryTree.isDistinct() || sysTable2.getPartitionScheme() != 3 && sysTable2.getPartitionScheme() != 5 || this.hasAutoincrement)) {
                    this.aQueryTree.setIntoTable(sysTable2.getTableName(), sysTable2.getTableName(), true);
                    this.aQueryTree.setIntoTablePartitioning(sysTable2.getPartitionScheme(), sysTable2.getPartitionedColumn() != null ? sysTable2.getPartitionedColumn().getColName() : null, sysTable2.getPartitionMap());
                    this.aQueryTree.setIsInsertSelect(true);
                }
                QueryProcessor queryProcessor = new QueryProcessor(this.client, this.aQueryTree);
                queryProcessor.prepare(false);
                QueryProcessor queryProcessor2 = queryProcessor;
                Object var6_6 = null;
                return queryProcessor2;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                throw throwable;
            }
        }
        Tuple tuple = this.tuple;
        Object var6_7 = null;
        return tuple;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareFinalStatements(SysTable sysTable, SysTable sysTable2) throws Exception {
        block5: {
            if (this.tuple == null) break block5;
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(IdentifierHandler.quote(this.getTableName())).append(" (");
            StringBuffer stringBuffer2 = new StringBuffer(") VALUES (");
            for (SysColumn sysColumn : this.getTargetTable().getColumns()) {
                String string = sysColumn.getColName();
                stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
                String string2 = this.tuple.getValue(sysColumn);
                stringBuffer2.append(string2).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer2.setLength(stringBuffer2.length() - 2);
            stringBuffer.append(stringBuffer2).append(")");
            String string = stringBuffer.toString();
            Object var10_14 = null;
            return string;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
            stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(" (");
            StringBuffer stringBuffer3 = new StringBuffer(") SELECT ");
            for (SysColumn sysColumn : sysTable.getColumns()) {
                if (!this.sysColumnList.contains(sysColumn)) continue;
                String string = sysColumn.getColName();
                stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
                stringBuffer3.append(IdentifierHandler.quote(string)).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer3.setLength(stringBuffer3.length() - 2);
            stringBuffer.append(stringBuffer3);
            stringBuffer.append(" FROM ").append(IdentifierHandler.quote(sysTable2.getTableName()));
            String string = stringBuffer.toString();
            Object var10_15 = null;
            return string;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected long fillTable(Object var1_1, SysTable var2_2, Engine var3_3) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected Collection<DBNode> getExecutionNodes() {
        if (this.executionNodes == null) {
            SqlExpression sqlExpression = null;
            if (this.tuple == null) {
                this.executionNodes = this.getTargetTable().getNodeList();
            } else {
                SysColumn sysColumn = this.getTargetTable().getPartitionedColumn();
                if (sysColumn != null) {
                    try {
                        sqlExpression = Engine.getInstance().evaluate(this.client, this.tuple.getExpression(sysColumn));
                    }
                    catch (SQLException sQLException) {
                        logger.catching(sQLException);
                        throw new XDBServerException("Can not determine partitioning value", sQLException);
                    }
                }
                this.executionNodes = this.getTargetTable().getNode(sqlExpression == null ? null : sqlExpression.getNormalizedValue());
            }
        }
        return this.executionNodes;
    }

    @Override
    protected short getPrivilege() {
        return 1;
    }

    public boolean manualParse(String string) {
        Lexer lexer = new Lexer(string);
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("INSERT")) {
            return false;
        }
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("INTO")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        this.tableName = lexer.nextToken();
        this.client.getSysDatabase().getSysTable(this.tableName);
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        String string2 = lexer.nextToken();
        if (string2.equals("(")) {
            while (lexer.hasMoreTokens()) {
                if (!lexer.hasMoreTokens()) {
                    return false;
                }
                string2 = lexer.nextToken();
                this.columnList.add(string2);
                if (!lexer.hasMoreTokens()) {
                    return false;
                }
                string2 = lexer.nextToken();
                if (string2.equals(")")) break;
                if (string2.equals(",")) continue;
                return false;
            }
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
        }
        if (!string2.equalsIgnoreCase("VALUES")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        string2 = lexer.nextToken();
        if (!string2.equals("(")) {
            return false;
        }
        XDBSessionContext xDBSessionContext = this.commandToExecute.getClientContext();
        int n = 0;
        while (true) {
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            SqlExpression sqlExpression = ParserHelper.createSimpleSqlExpression(lexer, xDBSessionContext.getSysDatabase().getSysTable(this.tableName), null, xDBSessionContext);
            if (sqlExpression == null) {
                return false;
            }
            this.valueList.add(sqlExpression);
            if (!lexer.hasMoreTokens()) {
                return false;
            }
            string2 = lexer.nextToken();
            if (string2.equals(")")) break;
            if (!string2.equals(",")) {
                return false;
            }
            ++n;
        }
        if (lexer.hasMoreTokens()) {
            string2 = lexer.nextToken();
            if (!string2.equals(";")) {
                return false;
            }
            if (lexer.hasMoreTokens()) {
                return false;
            }
        }
        this.tuple = new Tuple(this.getTableName(), new ArrayList<SysColumn>(this.getColumnsInvolved()), this.valueList, xDBSessionContext);
        return true;
    }

    @Override
    public int getResultType() {
        return 16;
    }

    @Override
    public void setParamValues(String[] stringArray) throws ArrayIndexOutOfBoundsException, XDBServerException {
        super.setParamValues(stringArray);
        this.executionNodes = null;
    }

    @Override
    public void setParamValue(int n, String string) throws ArrayIndexOutOfBoundsException, XDBServerException {
        super.setParamValue(n, string);
        this.executionNodes = null;
    }
}

