/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.StartDatabase;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStartDatabase
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlStartDatabase.class);
    private XDBSessionContext client;
    private boolean prepared = false;
    private int timeout = 60;
    private String[] dbListStr;

    public SqlStartDatabase(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            if (!this.prepared && this.client.getCurrentUser().getLogin().getUserClass() != 0) {
                throw new XDBSecurityException("You are not allowed to start database");
            }
            this.prepared = true;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            XDBSessionContext xDBSessionContext = XDBSessionContext.createSession();
            try {
                for (String string : this.dbListStr) {
                    xDBSessionContext.useDB(string, "A");
                    xDBSessionContext.login(this.client.getCurrentUser().getLogin());
                    xDBSessionContext.startDatabase(this.timeout);
                }
                Object var8_7 = null;
                xDBSessionContext.logout();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                xDBSessionContext.logout();
                throw throwable;
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            throw throwable;
        }
        return ExecutionResult.createSuccessResult(35);
    }

    @Override
    public Object visit(StartDatabase startDatabase, Object object) {
        Object object2;
        Object var3_3 = null;
        this.dbListStr = new String[startDatabase.f2.size() + 1];
        String string = (String)startDatabase.f1.accept(new IdentifierHandler(), object);
        int n = 0;
        this.dbListStr[n++] = string;
        Enumeration enumeration = startDatabase.f2.elements();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            Node node = (Node)((NodeSequence)object2).nodes.elementAt(1);
            this.dbListStr[n++] = (String)node.accept(new IdentifierHandler(), object);
        }
        if (startDatabase.f3.present()) {
            object2 = (NodeSequence)startDatabase.f3.node;
            try {
                this.timeout = Integer.parseInt(((NodeSequence)object2).nodes.get(1).toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return var3_3;
    }
}

