/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.parser.core.syntaxtree.BLOBDataType;
import com.edb.gridsql.parser.core.syntaxtree.BigIntDataType;
import com.edb.gridsql.parser.core.syntaxtree.BigSerialDataType;
import com.edb.gridsql.parser.core.syntaxtree.BitDataType;
import com.edb.gridsql.parser.core.syntaxtree.BooleanDataType;
import com.edb.gridsql.parser.core.syntaxtree.CharachterDataType;
import com.edb.gridsql.parser.core.syntaxtree.CidrDataType;
import com.edb.gridsql.parser.core.syntaxtree.DateDataType;
import com.edb.gridsql.parser.core.syntaxtree.DecimalDataType;
import com.edb.gridsql.parser.core.syntaxtree.DoublePrecision;
import com.edb.gridsql.parser.core.syntaxtree.FixedDataType;
import com.edb.gridsql.parser.core.syntaxtree.FloatDataType;
import com.edb.gridsql.parser.core.syntaxtree.InetDataType;
import com.edb.gridsql.parser.core.syntaxtree.IntegerDataType;
import com.edb.gridsql.parser.core.syntaxtree.IntervalDataType;
import com.edb.gridsql.parser.core.syntaxtree.IntervalQualifier;
import com.edb.gridsql.parser.core.syntaxtree.LengthSpec;
import com.edb.gridsql.parser.core.syntaxtree.MacAddrDataType;
import com.edb.gridsql.parser.core.syntaxtree.NationalCharDataType;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeOptional;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.NumericDataType;
import com.edb.gridsql.parser.core.syntaxtree.PrecisionSpec;
import com.edb.gridsql.parser.core.syntaxtree.RealDataType;
import com.edb.gridsql.parser.core.syntaxtree.SerialDataType;
import com.edb.gridsql.parser.core.syntaxtree.SmallIntDataType;
import com.edb.gridsql.parser.core.syntaxtree.TextDataType;
import com.edb.gridsql.parser.core.syntaxtree.TimeDataType;
import com.edb.gridsql.parser.core.syntaxtree.TimeStampDataType;
import com.edb.gridsql.parser.core.syntaxtree.UnsignedZeroFillSpecs;
import com.edb.gridsql.parser.core.syntaxtree.VarBitDataType;
import com.edb.gridsql.parser.core.syntaxtree.VarCharDataType;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.TypeConstants;
import java.util.HashMap;

public class DataTypeHandler
extends ObjectDepthFirst
implements TypeConstants {
    private static final String[] INTERVAL_QUALIFIERS = new String[]{"YEAR", "QUARTER", "MONTH", "WEEK", "DAY", "HOUR", "MINUTE", "SECOND"};
    private int sqlType;
    private boolean isSerial;
    private boolean isWithTimeZone;
    private int length = -1;
    private int precision = -1;
    private int scale = -1;
    private boolean isUserSuppliedLength;
    private boolean isUserSuppliedScale;
    private boolean unsigned;
    private boolean zerofill;

    public DataTypeHandler(int n, int n2, int n3, int n4) {
        this.sqlType = n;
        this.length = n2;
        this.precision = n3;
        this.scale = n4;
    }

    public DataTypeHandler() {
    }

    public Object visit(SerialDataType serialDataType, Object object) {
        this.sqlType = 4;
        this.isSerial = true;
        return null;
    }

    public Object visit(BigSerialDataType bigSerialDataType, Object object) {
        this.sqlType = -5;
        this.isSerial = true;
        return null;
    }

    public Object visit(SmallIntDataType smallIntDataType, Object object) {
        this.sqlType = 5;
        switch (smallIntDataType.f0.which) {
            case 0: {
                if (!((NodeOptional)((NodeSequence)smallIntDataType.f0.choice).elementAt(1)).present()) break;
                this.isSerial = true;
            }
        }
        smallIntDataType.f0.accept(this, object);
        return null;
    }

    public Object visit(BigIntDataType bigIntDataType, Object object) {
        this.sqlType = -5;
        if (bigIntDataType.f1.present()) {
            this.isSerial = true;
        }
        bigIntDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(IntegerDataType integerDataType, Object object) {
        this.sqlType = 4;
        if (integerDataType.f1.present()) {
            this.isSerial = true;
        }
        integerDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(RealDataType realDataType, Object object) {
        this.sqlType = 7;
        this.length = 24;
        realDataType.f0.accept(this, object);
        return null;
    }

    public Object visit(FloatDataType floatDataType, Object object) {
        this.sqlType = 6;
        this.length = 32;
        floatDataType.f1.accept(this, object);
        floatDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(DoublePrecision doublePrecision, Object object) {
        this.sqlType = 8;
        this.length = 48;
        return null;
    }

    public Object visit(NumericDataType numericDataType, Object object) {
        this.sqlType = 2;
        switch (numericDataType.f0.which) {
            case 1: {
                this.precision = 19;
                this.scale = 4;
                break;
            }
            case 2: {
                this.precision = 10;
                this.scale = 4;
                break;
            }
            case 3: {
                this.precision = 4;
                this.scale = 0;
            }
        }
        numericDataType.f0.accept(this, object);
        return null;
    }

    public Object visit(BitDataType bitDataType, Object object) {
        this.sqlType = -2;
        this.length = 1;
        this.scale = 0;
        bitDataType.f1.accept(this, object);
        return null;
    }

    public Object visit(VarBitDataType varBitDataType, Object object) {
        this.sqlType = -3;
        this.scale = 1;
        if (varBitDataType.f1.present()) {
            varBitDataType.f1.accept(this, object);
        } else {
            this.length = -1;
        }
        return null;
    }

    public Object visit(DecimalDataType decimalDataType, Object object) {
        this.sqlType = 3;
        decimalDataType.f0.accept(this, object);
        decimalDataType.f1.accept(this, object);
        decimalDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(FixedDataType fixedDataType, Object object) {
        this.sqlType = 2;
        this.precision = 5;
        this.scale = 0;
        fixedDataType.f1.accept(this, object);
        fixedDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(TimeStampDataType timeStampDataType, Object object) {
        this.sqlType = 93;
        switch (timeStampDataType.f0.which) {
            case 0: {
                if (!((NodeOptional)((NodeSequence)timeStampDataType.f0.choice).elementAt(2)).present() || ((NodeChoice)((NodeOptional)((NodeSequence)timeStampDataType.f0.choice).elementAt((int)2)).node).which != 0) break;
                this.isWithTimeZone = true;
                break;
            }
            case 1: {
                this.length = 3;
                break;
            }
            case 2: {
                this.length = 0;
            }
        }
        timeStampDataType.f0.accept(this, object);
        return null;
    }

    public Object visit(TimeDataType timeDataType, Object object) {
        this.sqlType = 92;
        if (timeDataType.f2.present() && ((NodeChoice)timeDataType.f2.node).which == 0) {
            this.isWithTimeZone = true;
        }
        timeDataType.f1.accept(this, object);
        return null;
    }

    public Object visit(DateDataType dateDataType, Object object) {
        String string = Props.XDB_EDB_REDWOOD_DATE;
        this.sqlType = string.equalsIgnoreCase("true") ? 93 : 91;
        return null;
    }

    public Object visit(BooleanDataType booleanDataType, Object object) {
        this.sqlType = 16;
        return null;
    }

    public Object visit(IntervalQualifier intervalQualifier, Object object) {
        this.precision = intervalQualifier.f0.f0.which;
        this.scale = intervalQualifier.f2.f0.which;
        return null;
    }

    public Object visit(IntervalDataType intervalDataType, Object object) {
        this.sqlType = 122;
        if (intervalDataType.f1.present()) {
            intervalDataType.f1.accept(this, object);
        }
        return null;
    }

    public Object visit(TextDataType textDataType, Object object) {
        this.sqlType = 2005;
        return null;
    }

    public Object visit(BLOBDataType bLOBDataType, Object object) {
        this.sqlType = 2004;
        return null;
    }

    public Object visit(CharachterDataType charachterDataType, Object object) {
        this.sqlType = charachterDataType.f1.present() ? 12 : 1;
        this.length = 1;
        charachterDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(VarCharDataType varCharDataType, Object object) {
        this.sqlType = 12;
        switch (varCharDataType.f0.which) {
            case 1: {
                this.length = 255;
            }
        }
        varCharDataType.f0.accept(this, object);
        return null;
    }

    public Object visit(NationalCharDataType nationalCharDataType, Object object) {
        this.sqlType = nationalCharDataType.f1.present() ? 12 : 1;
        this.length = 1;
        nationalCharDataType.f2.accept(this, object);
        return null;
    }

    public Object visit(LengthSpec lengthSpec, Object object) {
        try {
            this.length = Integer.parseInt(lengthSpec.f1.tokenImage);
            this.isUserSuppliedLength = true;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
        return null;
    }

    public Object visit(PrecisionSpec precisionSpec, Object object) {
        try {
            this.precision = Integer.parseInt(precisionSpec.f1.tokenImage);
            this.isUserSuppliedLength = true;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
        }
        if (precisionSpec.f2.present()) {
            NodeSequence nodeSequence = (NodeSequence)precisionSpec.f2.node;
            NodeToken nodeToken = (NodeToken)nodeSequence.elementAt(1);
            try {
                this.scale = Integer.parseInt(nodeToken.tokenImage);
                this.isUserSuppliedScale = true;
            }
            catch (Exception exception) {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_PARAMETER, 0, ErrorMessageRepository.ILLEGAL_PARAMETER_CODE);
            }
        }
        return null;
    }

    public Object visit(UnsignedZeroFillSpecs unsignedZeroFillSpecs, Object object) {
        this.unsigned = unsignedZeroFillSpecs.f0.present();
        this.zerofill = unsignedZeroFillSpecs.f1.present();
        return null;
    }

    public Object visit(MacAddrDataType macAddrDataType, Object object) {
        this.sqlType = 119;
        return null;
    }

    public Object visit(CidrDataType cidrDataType, Object object) {
        this.sqlType = 120;
        return null;
    }

    public Object visit(InetDataType inetDataType, Object object) {
        this.sqlType = 121;
        return null;
    }

    public boolean isSerial() {
        return this.isSerial;
    }

    public int getLength() {
        return this.length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public String getTypeString() {
        String string = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("length", "" + this.length);
        hashMap.put("precision", "" + this.precision);
        hashMap.put("scale", "" + this.scale);
        switch (this.sqlType) {
            case 4: {
                string = INTEGER_TEMPLATE;
                break;
            }
            case -2: {
                if (this.scale == 0) {
                    string = BIT_TEMPLATE;
                    break;
                }
                if (this.length == -1) {
                    string = VARBIT_TEMPLATE_WITHOUT_LENGTH;
                    break;
                }
                string = VARBIT_TEMPLATE;
                break;
            }
            case -3: {
                if (this.length == -1) {
                    string = VARBIT_TEMPLATE_WITHOUT_LENGTH;
                    break;
                }
                string = VARBIT_TEMPLATE;
                break;
            }
            case -5: {
                string = BIGINTEGER_TEMPLATE;
                break;
            }
            case 5: {
                string = SMALLINT_TEMPLATE;
                break;
            }
            case 3: {
                if (this.precision != -1 || this.isUserSuppliedLength) {
                    if (this.scale == -1 && !this.isUserSuppliedScale) {
                        this.scale = 0;
                        hashMap.put("scale", "" + this.scale);
                    }
                    string = DECIMAL_TEMPLATE;
                    break;
                }
                string = DECIMAL_TEMPLATE_EDB_EXTENSION;
                break;
            }
            case 7: {
                string = REAL_TEMPLATE;
                break;
            }
            case 6: {
                string = FLOAT_TEMPLATE;
                break;
            }
            case 8: {
                string = DOUBLE_TEMPLATE;
                break;
            }
            case 2: {
                if (this.precision != -1 || this.isUserSuppliedLength) {
                    if (this.scale == -1 && !this.isUserSuppliedScale) {
                        this.scale = 0;
                        hashMap.put("scale", "" + this.scale);
                    }
                    string = NUMERIC_TEMPLATE;
                    break;
                }
                string = NUMERIC_TEMPLATE_EDB_EXTENSION;
                break;
            }
            case 93: {
                if (this.length != -1 || this.isUserSuppliedLength) {
                    if (this.isWithTimeZone) {
                        string = TIMESTAMPWITHLENGTH_WITH_TIMEZONE_TEMPLATE;
                        break;
                    }
                    string = TIMESTAMP_TEMPLATE_EDB_EXTENSION;
                    break;
                }
                if (this.isWithTimeZone) {
                    string = TIMESTAMPWITHOUTLENGTH_WITH_TIMEZONE_TEMPLATE;
                    break;
                }
                string = TIMESTAMP_TEMPLATE;
                break;
            }
            case 92: {
                if (this.length != -1 || this.isUserSuppliedLength) {
                    if (this.isWithTimeZone) {
                        string = TIMEWITHLENGTH_WITH_TIMEZONE_TEMPLATE;
                        break;
                    }
                    string = TIME_TEMPLATE_EDB_EXTENSION;
                    break;
                }
                if (this.isWithTimeZone) {
                    string = TIMEWITHOUTLENGTH_WITH_TIMEZONE_TEMPLATE;
                    break;
                }
                string = TIME_TEMPLATE;
                break;
            }
            case 91: {
                string = DATE_TEMPLATE;
                break;
            }
            case 16: {
                string = BOOLEAN_TEMPLATE;
                break;
            }
            case 12: {
                if (this.length != -1 || this.isUserSuppliedLength) {
                    string = VARCHAR_TEMPLATE;
                    break;
                }
                string = VARCHAR_TEMPLATE_EDB_EXTENSION;
                break;
            }
            case 1: {
                string = CHAR_TEMPLATE;
                break;
            }
            case 2005: {
                string = TEXT_TEMPLATE;
                break;
            }
            case 2004: {
                string = BLOB_TEMPLATE;
                break;
            }
            case 0: {
                string = "NULL";
                break;
            }
            case 119: {
                string = MACADDR_TEMPLATE;
                break;
            }
            case 120: {
                string = CIDR_TEMPLATE;
                break;
            }
            case 121: {
                string = INET_TEMPLATE;
                break;
            }
            case 122: {
                if (this.precision > -1 && this.scale > -1) {
                    string = INTERVAL_TEMPLATE_QUALIFIED;
                    hashMap.put("from", INTERVAL_QUALIFIERS[this.precision]);
                    hashMap.put("to", INTERVAL_QUALIFIERS[this.scale]);
                    break;
                }
                string = INTERVAL_TEMPLATE;
            }
        }
        return ParseCmdLine.substitute(string, hashMap);
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public boolean isZerofill() {
        return this.zerofill;
    }

    public boolean canBePartitioningKey() {
        if (Props.XDB_ALLOW_PARTITION_INTEGER && (this.sqlType == 4 || this.sqlType == -5 || this.sqlType == 5 || this.sqlType == -6)) {
            return true;
        }
        if (Props.XDB_ALLOW_PARTITION_CHAR && (this.sqlType == 1 || this.sqlType == 12)) {
            return true;
        }
        if (Props.XDB_ALLOW_PARTITION_DECIMAL && (this.sqlType == 3 || this.sqlType == 2)) {
            return true;
        }
        if (Props.XDB_ALLOW_PARTITION_FLOAT && (this.sqlType == 6 || this.sqlType == 7 || this.sqlType == 8)) {
            return true;
        }
        if (Props.XDB_ALLOW_PARTITION_DATETIME && (this.sqlType == 91 || this.sqlType == 92 || this.sqlType == 93)) {
            return true;
        }
        if (Props.XDB_ALLOW_PARTITION_MACADDR && this.sqlType == 119) {
            return true;
        }
        return Props.XDB_ALLOW_PARTITION_INET && (this.sqlType == 121 || this.sqlType == 120);
    }
}

