/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SyncCreateTable;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.misc.SortedVector;
import com.edb.gridsql.misc.combinedresultset.SortCriteria;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.FunctionAnalysis;
import com.edb.gridsql.optimizer.OrderByElement;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryNode;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.ExecutionPlan;
import com.edb.gridsql.planner.Leaf;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryPlan {
    private static final XLogger logger = XLogger.getLogger(QueryPlan.class);
    public static final XLogger CATEGORY_QUERYFLOW = XLogger.getLogger("queryflow");
    private final XDBSessionContext client;
    private final List<Leaf> leaves;
    private int iLeafNumber;
    public static final int NORMAL = 0;
    public static final int RELATION = 1;
    public static final int SCALAR = 2;
    public static final int NONCORRELATED = 3;
    public static final int CORRELATED = 4;
    protected boolean isUnion = false;
    public int planType = 0;
    public static final int UNIONTYPE_NONE = 0;
    public static final int UNIONTYPE_UNION = 1;
    public static final int UNIONTYPE_UNIONALL = 2;
    public int unionType = 0;
    public boolean isDistinct = false;
    private static final AtomicInteger QUERY_ID = new AtomicInteger();
    private final int queryId;
    public int tempIdCounter = 0;
    public int currentLeafStepNo = 0;
    private int colGenCount = 0;
    private final Map<SqlExpression, String> colMappings;
    public String finalTableName;
    public String orderByClause = "";
    private List<Integer> orderByProjPos;
    public List<SortCriteria> sortInfo;
    public int placeHolderNo = 0;
    public Leaf scalarLeaf;
    public List<QueryPlan> subplanList;
    public List<QueryPlan> unionSubplanList;
    private String lastJoinTableName = "";
    private boolean correlatedStart = false;
    private QueryNode correlatedNode = null;
    private int levelStatus;
    private Leaf aLeaf2;
    private Map<String, Leaf> tempTableLastUsedAt;
    private SysDatabase database;
    public Map<Integer, DBNode> queryNodeTable;
    public String finalProjString = "";
    private final List<Leaf.Projection> extraStepGroupByList;
    public boolean isTopLevelPlan = false;
    public boolean isFinalUnionPart = false;
    public String addedFinalProjections = "";
    protected QueryPlan topQueryPlan;
    private boolean useSlowAggregation = false;
    private List<Leaf.Projection> projectedGroupBy = new ArrayList<Leaf.Projection>();
    private boolean useAllNodes = false;
    private ColumnMetaData[] columnMetaData = null;
    private long limit = -1L;
    private long offset = -1L;
    private SysTable intoTable = null;
    private SyncCreateTable syncCreateTable = null;
    private String intoTableRefName = null;
    private int outerCounter = 0;
    private boolean isExistingInto = false;

    public QueryPlan(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.queryId = QUERY_ID.incrementAndGet();
        this.leaves = new ArrayList<Leaf>();
        this.colMappings = new HashMap<SqlExpression, String>();
        this.subplanList = new ArrayList<QueryPlan>();
        this.unionSubplanList = new ArrayList<QueryPlan>();
        this.tempTableLastUsedAt = new HashMap<String, Leaf>(10);
        this.queryNodeTable = new HashMap<Integer, DBNode>(10);
        this.extraStepGroupByList = new ArrayList<Leaf.Projection>();
        this.topQueryPlan = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLeaf(Leaf leaf) {
        this.leaves.add(leaf);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(512);
        for (QueryPlan queryPlan : this.unionSubplanList) {
            stringBuffer.append("\n UNION subplan\n");
            stringBuffer.append(" -------\n");
            stringBuffer.append(queryPlan);
            stringBuffer.append(" end UNION subplan\n");
            stringBuffer.append(" -----------\n");
        }
        for (QueryPlan queryPlan : this.subplanList) {
            stringBuffer.append("\n subplan\n");
            stringBuffer.append(" -------\n");
            stringBuffer.append(queryPlan);
            stringBuffer.append(" end subplan\n");
            stringBuffer.append(" -----------\n");
        }
        for (int i = 0; i < this.leaves.size(); ++i) {
            Leaf leaf = this.leaves.get(i);
            if (leaf.subplan != null) {
                stringBuffer.append('\n');
                stringBuffer.append(" Correlated subplan\n");
                stringBuffer.append(" -------\n");
                stringBuffer.append(leaf.subplan);
                stringBuffer.append('\n');
            }
            for (QueryPlan queryPlan : leaf.uncorrelatedSubplanList) {
                stringBuffer.append('\n');
                stringBuffer.append(" Uncorrelated subplan\n");
                stringBuffer.append(" -------\n");
                stringBuffer.append(queryPlan);
                stringBuffer.append('\n');
            }
            if (leaf.outerSubplan != null) {
                stringBuffer.append('\n');
                stringBuffer.append(" Extra Outer Step\n");
                stringBuffer.append(" ----------------\n");
                stringBuffer.append(leaf.outerSubplan);
                stringBuffer.append('\n');
            }
            stringBuffer.append("\n Step: " + i + "\n");
            stringBuffer.append(" -------\n");
            if (this.isTopLevelPlan && i < this.leaves.size() - 1) {
                stringBuffer.append(" Target: " + leaf.getTempTargetCreateStmt() + "\n");
            }
            stringBuffer.append(" Select: " + leaf.getSelect() + "\n");
            for (int j = 0; j < leaf.tempTableDropList.size(); ++j) {
                if (j == 0) {
                    stringBuffer.append("  Drop:\n");
                }
                stringBuffer.append(' ').append(leaf.tempTableDropList.get(j)).append('\n');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public void initLeafIteration() {
        this.iLeafNumber = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Leaf nextLeaf() {
        block3: {
            if (this.iLeafNumber < this.leaves.size()) break block3;
            Leaf leaf = null;
            return leaf;
        }
        Leaf leaf = this.leaves.get(this.iLeafNumber);
        ++this.iLeafNumber;
        Leaf leaf2 = leaf;
        return leaf2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignSteps(QueryTree queryTree) {
        Object object = this.leaves.iterator();
        while (object.hasNext()) {
            Leaf leaf = object.next();
            if (leaf.getSelectStatement() != null) continue;
            leaf.determineSelectStatement(this);
        }
        if (this.leaves != null && !this.leaves.isEmpty() && ((Leaf)(object = this.leaves.get(this.leaves.size() - 1))).getSelectStatement() == null) {
            ((Leaf)object).setOffset(queryTree.getOffset());
            ((Leaf)object).setLimit(queryTree.getLimit());
            ((Leaf)object).determineSelectStatement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void determineOrderByClause(QueryTree queryTree) {
        int n = 0;
        this.orderByClause = "";
        if (queryTree.getOrderByList().size() > 0) {
            this.sortInfo = new ArrayList<SortCriteria>();
        }
        for (int i = 0; i < queryTree.getOrderByList().size(); ++i) {
            Object object;
            OrderByElement orderByElement = queryTree.getOrderByList().get(i);
            SqlExpression sqlExpression = orderByElement.orderExpression;
            String string = sqlExpression.getAlias().length() > 0 ? IdentifierHandler.quote(sqlExpression.getAlias()) : (queryTree.getParentQueryTree() != null ? sqlExpression.getExprString().replaceAll("\".*\"\\.", "") : sqlExpression.getExprString());
            String string2 = new String(string);
            string = string + " " + orderByElement.getDirectionString();
            if (this.orderByClause.length() > 0) {
                this.orderByClause = this.orderByClause + ", ";
            }
            this.orderByClause = this.orderByClause + string;
            boolean bl = true;
            int n2 = orderByElement.orderDirection == 1 ? 1 : 2;
            if (orderByElement.orderExpression.isAdded()) {
                bl = false;
                this.addedFinalProjections = this.addedFinalProjections + ", " + orderByElement.orderExpression.rebuildString();
                if (orderByElement.orderExpression.getAlias().length() > 0) {
                    this.addedFinalProjections = this.addedFinalProjections + " as " + IdentifierHandler.quote(orderByElement.orderExpression.getAlias());
                }
            }
            int n3 = 0;
            int n4 = 1;
            for (SqlExpression sqlExpression2 : queryTree.getProjectionList()) {
                if (sqlExpression2 == orderByElement.orderExpression) {
                    n3 = n4;
                }
                ++n4;
            }
            if (n3 == 0) {
                int n5;
                object = new ArrayList();
                int n6 = 0;
                boolean bl2 = false;
                StringBuffer stringBuffer = new StringBuffer();
                for (int j = 0; j < this.finalProjString.length(); ++j) {
                    char c = this.finalProjString.charAt(j);
                    if (c == ',' && n6 == 0 && !bl2) {
                        ((ArrayList)object).add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                        continue;
                    }
                    if (c == '(') {
                        ++n6;
                    }
                    if (c == ')') {
                        --n6;
                    }
                    if (c == '\'') {
                        bl2 = !bl2;
                    }
                    stringBuffer.append(c);
                }
                if (stringBuffer.length() > 0) {
                    ((ArrayList)object).add(stringBuffer.toString());
                }
                String[] stringArray = ((ArrayList)object).toArray(new String[((ArrayList)object).size()]);
                String string3 = string2;
                if (Props.XDB_TEMPTABLEPREFIX.length() > 0 && string3.indexOf(Props.XDB_TEMPTABLEPREFIX) == 0) {
                    n5 = Props.XDB_TEMPTABLEPREFIX.length() + 1;
                    string3 = string3.substring(n5);
                }
                if ((n5 = string3.indexOf(46) + 1) > 0) {
                    string3 = string3.substring(n5);
                }
                for (int j = 0; j < stringArray.length; ++j) {
                    int n7 = stringArray[j].indexOf(" as ");
                    String string4 = n7 > 0 ? stringArray[j].substring(n7 += 4) : stringArray[j];
                    if (string4.compareToIgnoreCase(orderByElement.orderExpression.getAlias()) == 0) {
                        n3 = j + 1;
                        break;
                    }
                    if (string4.compareToIgnoreCase(string3) != 0) continue;
                    n3 = j + 1;
                    break;
                }
                if (n3 == 0) {
                    n3 = ++n + stringArray.length;
                    bl = false;
                    this.addedFinalProjections = this.addedFinalProjections + ", " + orderByElement.orderExpression.getExprString();
                    if (orderByElement.orderExpression.getAlias().length() > 0) {
                        this.addedFinalProjections = this.addedFinalProjections + " as " + IdentifierHandler.quote(orderByElement.orderExpression.getAlias());
                    }
                }
            }
            object = new SortCriteria(n3, bl, n2, orderByElement.orderExpression.getExprDataType().type);
            this.sortInfo.add((SortCriteria)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createMainPlanFromTree(QueryTree queryTree) throws XDBServerException {
        block14: {
            int n = 0;
            this.createPlan(queryTree, false);
            ArrayList<ColumnMetaData> arrayList = new ArrayList<ColumnMetaData>();
            for (SqlExpression object : queryTree.getProjectionList()) {
                if (object.isAdded()) continue;
                arrayList.add(this.getColumnMetaData(object));
            }
            this.columnMetaData = new ColumnMetaData[arrayList.size()];
            for (ColumnMetaData columnMetaData : arrayList) {
                this.columnMetaData[n++] = columnMetaData;
            }
            if (this.orderByClause.length() == 0) {
                this.determineOrderByClause(queryTree);
            }
            this.isTopLevelPlan = true;
            if (this.useAllNodes) {
                Iterator<DBNode> iterator = this.database.getDBNodeList();
                Iterator iterator2 = iterator.iterator();
                while (iterator2.hasNext()) {
                    DBNode dBNode = (DBNode)iterator2.next();
                    this.queryNodeTable.put(dBNode.getNodeId(), dBNode);
                }
            }
            if (queryTree.getIntoTableName() == null) break block14;
            try {
                this.intoTable = this.database.getSysTable(queryTree.getIntoTableName());
                this.isExistingInto = true;
            }
            catch (Exception exception) {
                this.isExistingInto = false;
            }
            if (this.intoTable != null) break block14;
            try {
                this.intoTable = queryTree.createIntoTable(this.client);
                if (this.intoTable.isTemporary()) {
                    this.intoTableRefName = queryTree.getIntoTableRefName();
                } else {
                    this.syncCreateTable = new SyncCreateTable(this.intoTable, queryTree.getColumnDefinitions());
                }
                for (DBNode dBNode : this.intoTable.getNodeList()) {
                    this.queryNodeTable.put(dBNode.getNodeId(), dBNode);
                }
            }
            catch (Exception exception) {
                throw new XDBServerException("Can not create target table: " + exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlan(QueryTree queryTree, boolean bl) {
        this.generateProjectionAliases(queryTree.getProjectionList());
        this.equateProjectionAttributeColumns(queryTree);
        this.equateOrderByWithProjections(queryTree);
        this.equateConditionsWithProjections(queryTree);
        this.equateGroupByWithProjections(queryTree);
        if (queryTree.isDistinct()) {
            this.updateOrderByForDistinct(queryTree);
        }
        this.createPlanSegmentFromTree(queryTree, bl, "", 1);
        for (String string : this.topQueryPlan.tempTableLastUsedAt.keySet()) {
            Leaf leaf = this.topQueryPlan.tempTableLastUsedAt.get(string);
            leaf.tempTableDropList.add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void equateConditionsWithProjections(QueryTree queryTree) {
        ArrayList<AttributeColumn> arrayList = new ArrayList<AttributeColumn>();
        for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
            for (SqlExpression sqlExpression2 : SqlExpression.getNodes(sqlExpression, 4)) {
                arrayList.add(sqlExpression2.getColumn());
            }
        }
        QueryCondition.equateConditionsWithColumns(queryTree.getConditionList(), arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void equateProjectionAttributeColumns(QueryTree queryTree) {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        HashMap<String, AttributeColumn> hashMap = new HashMap<String, AttributeColumn>();
        for (SqlExpression object : queryTree.getProjectionList()) {
            arrayList.addAll(SqlExpression.getNodes(object, 4));
        }
        for (SqlExpression sqlExpression : arrayList) {
            String string = sqlExpression.getColumn().rebuildString();
            if (hashMap.containsKey(string)) {
                sqlExpression.setColumn((AttributeColumn)hashMap.get(string));
                continue;
            }
            hashMap.put(string, sqlExpression.getColumn());
        }
        ArrayList arrayList2 = new ArrayList();
        for (SqlExpression sqlExpression : arrayList) {
            arrayList2.add(sqlExpression.getColumn());
        }
        QueryCondition.equateConditionsWithColumns(queryTree.getConditionList(), arrayList2);
    }

    private void createPlanSegmentFromTree(QueryTree queryTree, boolean bl, String string, int n) throws XDBServerException {
        if (queryTree.getUnionQueryTreeList().size() > 0) {
            this.createPlanSegmentFromTreeUnion(queryTree, bl, string, n);
        } else {
            this.createPlanSegmentFromTreeDetail(queryTree, string, n);
        }
    }

    private void createPlanSegmentFromTreeUnion(QueryTree queryTree, boolean bl, String string, int n) throws XDBServerException {
        Iterator<SqlExpression> iterator;
        Object object;
        int n2 = 1;
        this.topQueryPlan.useAllNodes = true;
        this.changeUnionAllToUnion(queryTree);
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(this.handleFirstUnionPlan(queryTree, string, n));
        stringBuilder.append(this.handleOtherUnionPlans(queryTree, bl, string, n));
        if (n == 2 && !this.topQueryPlan.orderByProjPos.isEmpty()) {
            stringBuilder.append(" ORDER BY ");
            object = queryTree;
            for (int i = 0; i < this.topQueryPlan.orderByProjPos.size(); ++i) {
                iterator = ((QueryTree)object).getProjectionList().get(this.topQueryPlan.orderByProjPos.get(i));
                int n3 = ((QueryTree)object).getOrderByList().get((int)i).orderDirection;
                if (i > 0) {
                    stringBuilder.append(",");
                }
                if (((SqlExpression)((Object)iterator)).getAlias() != null && ((SqlExpression)((Object)iterator)).getAlias().length() > 0) {
                    stringBuilder.append(((SqlExpression)((Object)iterator)).getAlias());
                } else {
                    stringBuilder.append(((SqlExpression)((Object)iterator)).getExprString());
                }
                if (n3 != 2) continue;
                stringBuilder.append(" DESC");
            }
        }
        object = stringBuilder.toString().replaceAll("[A-Za-z]+[A-Za-z0-9_]*\\.", "");
        this.tempIdCounter = n2;
        this.isUnion = true;
        this.finalTableName = this.generateTempTableName();
        this.finalProjString = "*";
        if (this != this.topQueryPlan) {
            Leaf leaf = new Leaf();
            leaf.setSelectStatement((String)object);
            leaf.setTargetTableName(this.finalTableName);
            leaf.queryNodeList = new ArrayList<DBNode>(this.database.getDBNodeList());
            iterator = queryTree.getFinalProjList() != null && queryTree.getFinalProjList().size() > 0 ? queryTree.getFinalProjList().iterator() : queryTree.getProjectionList().iterator();
            while (iterator.hasNext()) {
                SqlExpression sqlExpression = iterator.next();
                leaf.appendProjection(sqlExpression.getAlias(), sqlExpression.getAlias(), sqlExpression.getExprDataType(), false);
            }
            this.leaves.add(leaf);
        }
    }

    private void changeUnionAllToUnion(QueryTree queryTree) {
        QueryTree queryTree2;
        int n;
        int n2 = 0;
        for (n = 0; n < queryTree.getUnionQueryTreeList().size(); ++n) {
            queryTree2 = queryTree.getUnionQueryTreeList().get(n);
            if (queryTree2.getUnionType() != 1) continue;
            n2 = n;
        }
        for (n = 0; n < n2; ++n) {
            queryTree2 = queryTree.getUnionQueryTreeList().get(n);
            if (queryTree2.getUnionType() != 2) continue;
            queryTree2.setUnionType(1);
        }
    }

    private String handleFirstUnionPlan(QueryTree queryTree, String string, int n) throws XDBServerException {
        QueryPlan queryPlan = new QueryPlan(this.client);
        queryPlan.topQueryPlan = this.topQueryPlan;
        queryPlan.unionType = queryTree.getUnionType();
        QueryTree queryTree2 = queryTree.getUnionQueryTreeList().get(0);
        if (queryTree2.getUnionType() != 2) {
            queryTree.setDistinct(true);
            int n2 = 0;
            if (this.orderByProjPos != null) {
                int n3 = this.orderByProjPos.size();
                for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
                    boolean bl = false;
                    for (int i = 0; i < n3; ++i) {
                        if (n2 != this.orderByProjPos.get(i)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        OrderByElement orderByElement = new OrderByElement();
                        orderByElement.orderExpression = sqlExpression;
                        orderByElement.orderDirection = 1;
                        queryTree.getOrderByList().add(orderByElement);
                        this.orderByProjPos.add(n2);
                    }
                    ++n2;
                }
            }
        }
        queryPlan.createPlanSegmentFromTreeDetail(queryTree, string, n + 1);
        if (queryPlan.topQueryPlan == this) {
            queryPlan.isFinalUnionPart = true;
            this.limit = queryTree.getLimit();
            this.offset = queryTree.getOffset();
        }
        this.unionSubplanList.add(queryPlan);
        String string2 = this == this.topQueryPlan ? "SELECT " + queryPlan.finalProjString + " FROM " + IdentifierHandler.quote(queryPlan.finalTableName) : "SELECT * FROM " + IdentifierHandler.quote(queryPlan.finalTableName);
        this.updateQueryNodeTempTableName(queryTree.getRootNode(), queryPlan.finalTableName);
        return string2;
    }

    private String handleOtherUnionPlans(QueryTree queryTree, boolean bl, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(256);
        int n2 = 1;
        for (int i = 0; i < queryTree.getUnionQueryTreeList().size(); ++i) {
            QueryTree queryTree2 = queryTree.getUnionQueryTreeList().get(i);
            QueryPlan queryPlan = new QueryPlan(this.client);
            queryPlan.topQueryPlan = this.topQueryPlan;
            if (n2 > -1) {
                queryPlan.tempIdCounter = n2;
            }
            if (queryTree2.getUnionType() != 2) {
                queryTree2.setDistinct(true);
            }
            if (queryTree.getOrderByList() != null && this.orderByProjPos != null) {
                for (int j = 0; j < this.orderByProjPos.size(); ++j) {
                    OrderByElement orderByElement = new OrderByElement();
                    orderByElement.orderExpression = queryTree2.getProjectionList().get(this.orderByProjPos.get(j));
                    orderByElement.orderDirection = queryTree.getOrderByList().get((int)j).orderDirection;
                    queryTree2.getOrderByList().add(orderByElement);
                }
            }
            queryPlan.createPlanSegmentFromTree(queryTree2, bl, string, n + 1);
            if (queryPlan.topQueryPlan == this) {
                queryPlan.isFinalUnionPart = true;
            }
            queryPlan.unionType = queryTree2.getUnionType();
            this.unionSubplanList.add(queryPlan);
            n2 = queryPlan.tempIdCounter;
            stringBuilder.append(" UNION ");
            if (queryPlan.unionType == 2) {
                stringBuilder.append("ALL ");
            }
            if (this == this.topQueryPlan) {
                stringBuilder.append("SELECT ").append(queryPlan.finalProjString).append(" FROM ").append(IdentifierHandler.quote(queryPlan.finalTableName));
            } else {
                stringBuilder.append("SELECT * FROM ").append(IdentifierHandler.quote(queryPlan.finalTableName));
            }
            this.updateQueryNodeTempTableName(queryTree.getRootNode(), queryPlan.finalTableName);
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanSegmentFromTreeDetail(QueryTree queryTree, String string, int n) throws XDBServerException {
        this.lastJoinTableName = string;
        this.createRelationSubplans(queryTree, n);
        this.createScalarSubplans(queryTree, n);
        this.isDistinct = queryTree.isDistinct();
        this.limit = queryTree.getLimit();
        this.offset = queryTree.getOffset();
        this.createPlanStep(queryTree, queryTree.getRootNode());
        if (queryTree.isContainsAggregates() && !queryTree.isPartitionedGroupBy() && !queryTree.usesSingleDBNode(this.database) && this.planType != 4) {
            this.createFinalPlanStep(queryTree);
        }
        if (this.planType == 4) {
            this.determineFinalCorrelatedProjections(queryTree.getProjectionList());
        }
        this.determineOrderByClause(queryTree);
        this.assignSteps(queryTree);
    }

    private void createRelationSubplans(QueryTree queryTree, int n) throws XDBServerException {
        for (int i = 0; i < queryTree.getRelationSubqueryList().size(); ++i) {
            this.topQueryPlan.useAllNodes = true;
            RelationNode relationNode = queryTree.getRelationSubqueryList().get(i);
            QueryTree queryTree2 = relationNode.getSubqueryTree();
            QueryPlan queryPlan = new QueryPlan(this.client);
            queryPlan.topQueryPlan = this.topQueryPlan;
            queryPlan.tempIdCounter = this.tempIdCounter;
            queryPlan.planType = 1;
            if (queryTree2.isDistinct() && (queryTree2.getGroupByList() == null || queryTree2.getGroupByList().size() == 0)) {
                queryTree2.setGroupByList(queryTree2.getProjectionList());
                queryTree2.setContainsAggregates(true);
            }
            queryPlan.createPlanSegmentFromTree(queryTree2, true, "", n);
            this.tempIdCounter = queryPlan.tempIdCounter;
            relationNode.setTableName(queryPlan.finalTableName);
            relationNode.setAlias("");
            relationNode.setCurrentTempTableName(queryPlan.finalTableName);
            this.subplanList.add(queryPlan);
        }
    }

    private void createScalarSubplans(QueryTree queryTree, int n) throws XDBServerException {
        for (int i = 0; i < queryTree.getScalarSubqueryList().size(); ++i) {
            SqlExpression sqlExpression = queryTree.getScalarSubqueryList().get(i);
            QueryTree queryTree2 = sqlExpression.getSubqueryTree();
            QueryPlan queryPlan = new QueryPlan(this.client);
            queryPlan.topQueryPlan = this.topQueryPlan;
            queryPlan.tempIdCounter = this.tempIdCounter;
            queryPlan.planType = 2;
            if (queryTree2.isDistinct() && (queryTree2.getGroupByList() == null || queryTree2.getGroupByList().size() == 0)) {
                queryTree2.setGroupByList(queryTree2.getProjectionList());
                queryTree2.setContainsAggregates(true);
            }
            queryPlan.createPlanSegmentFromTree(queryTree2, true, "", n);
            this.tempIdCounter = queryPlan.tempIdCounter;
            sqlExpression.setExprType(64);
            ++this.placeHolderNo;
            sqlExpression.setConstantValue("&x" + this.placeHolderNo + "x&");
            sqlExpression.setExprString(sqlExpression.getConstantValue());
            sqlExpression.setTempExpr(true);
            queryPlan.placeHolderNo = this.placeHolderNo;
            this.subplanList.add(queryPlan);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateProjectionAliases(List<SqlExpression> list) {
        HashMap hashMap = new HashMap();
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            SqlExpression sqlExpression = list.get(i);
            if (sqlExpression.getAlias() == null || sqlExpression.getAlias().length() == 0) {
                if (sqlExpression.getExprType() != 4) {
                    sqlExpression.setAlias("EXPRESSION" + ++n);
                    if (sqlExpression.getExprType() == 32) {
                        sqlExpression.setProjectionLabel(sqlExpression.getFunctionName());
                    } else if (sqlExpression.getExprType() == 256) {
                        sqlExpression.setProjectionLabel("case");
                    }
                } else if (sqlExpression.getColumn().columnAlias != "") {
                    if (hashMap.containsKey(sqlExpression.getColumn().columnAlias)) {
                        sqlExpression.setAlias("EXPRESSION" + ++n);
                    } else {
                        sqlExpression.setAlias(sqlExpression.getColumn().columnAlias);
                    }
                } else if (hashMap.containsKey(sqlExpression.getColumn().columnName)) {
                    sqlExpression.setAlias("EXPRESSION" + ++n);
                } else {
                    sqlExpression.setAlias(sqlExpression.getColumn().columnName);
                }
            } else if (hashMap.containsKey(sqlExpression.getAlias())) {
                sqlExpression.setAlias("EXPRESSION" + ++n);
            }
            hashMap.put(sqlExpression.getAlias(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void equateOrderByWithProjections(QueryTree queryTree) {
        int n = 0;
        this.orderByProjPos = new ArrayList<Integer>();
        block2: for (OrderByElement orderByElement : queryTree.getOrderByList()) {
            orderByElement.orderExpression.rebuildExpression();
            String string = orderByElement.orderExpression.getExprString();
            n = -1;
            for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
                sqlExpression.rebuildExpression();
                ++n;
                if (!string.equalsIgnoreCase(sqlExpression.getExprString())) continue;
                orderByElement.orderExpression = sqlExpression;
                this.orderByProjPos.add(n);
                continue block2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void equateGroupByWithProjections(QueryTree queryTree) {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        for (SqlExpression sqlExpression : queryTree.getGroupByList()) {
            sqlExpression.rebuildExpression();
            if (sqlExpression.getMappedExpression() != null && sqlExpression.getExprType() == 2) {
                sqlExpression.setConstantValue(sqlExpression.getAlias());
            }
            arrayList.add(sqlExpression);
        }
        queryTree.setGroupByList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrderByForDistinct(QueryTree queryTree) {
        for (SqlExpression sqlExpression : queryTree.getProjectionList()) {
            if (sqlExpression.getExprType() == 2) continue;
            sqlExpression.rebuildExpression();
            boolean bl = false;
            for (OrderByElement orderByElement : queryTree.getOrderByList()) {
                orderByElement.orderExpression.rebuildExpression();
                String string = orderByElement.orderExpression.getExprString();
                if (!string.equalsIgnoreCase(sqlExpression.getExprString())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            OrderByElement orderByElement = new OrderByElement();
            orderByElement.orderExpression = sqlExpression;
            queryTree.getOrderByList().add(orderByElement);
            orderByElement.orderDirection = 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateTempTableName() {
        ++this.tempIdCounter;
        String string = Props.XDB_TEMPTABLEPREFIX + "T" + this.queryId + "_" + this.tempIdCounter;
        return string;
    }

    private String getSingleCorrelatedBaseTable(RelationNode relationNode) {
        String string = null;
        boolean bl = false;
        block4: for (RelationNode relationNode2 : relationNode.getSubqueryTree().getRelationNodeList()) {
            switch (relationNode2.getNodeType()) {
                case 7: {
                    continue block4;
                }
                case 2: {
                    String string2 = relationNode2.getTableName();
                    SysTable sysTable = this.database.getSysTable(string2);
                    if (sysTable.getPartitionScheme() == 2) {
                        if (string != null) continue block4;
                        string = string2;
                        continue block4;
                    }
                    if (!bl) {
                        string = string2;
                        bl = true;
                        continue block4;
                    }
                    return null;
                }
            }
            return null;
        }
        return string;
    }

    private String getSingleCorrelatedHashColumn(RelationNode relationNode, String string) {
        SysTable sysTable = this.database.getSysTable(string);
        if (sysTable.getPartitionScheme() != 3) {
            return null;
        }
        String string2 = sysTable.getPartitionColumn();
        for (QueryCondition queryCondition : relationNode.getSubqueryTree().getConditionList()) {
            if (queryCondition.getCondType() != 16 || queryCondition.getLeftCond() == null || queryCondition.getLeftCond().getCondType() != 4 || queryCondition.getLeftCond().getExpr().getExprType() != 4 || queryCondition.getRightCond() == null || queryCondition.getRightCond().getCondType() != 4 || queryCondition.getRightCond().getExpr().getExprType() != 4) continue;
            String string3 = this.checkCorrelatedHashString(queryCondition.getLeftCond().getExpr().getColumn(), string, string2, queryCondition.getRightCond().getExpr());
            if (string3 != null) {
                return IdentifierHandler.stripQuotes(string3);
            }
            string3 = this.checkCorrelatedHashString(queryCondition.getRightCond().getExpr().getColumn(), string, string2, queryCondition.getLeftCond().getExpr());
            if (string3 == null) continue;
            return IdentifierHandler.stripQuotes(string3);
        }
        return null;
    }

    public String checkCorrelatedHashString(AttributeColumn attributeColumn, String string, String string2, SqlExpression sqlExpression) {
        String string3 = null;
        if (attributeColumn.getTableName().compareToIgnoreCase(string) == 0 && attributeColumn.columnName.compareToIgnoreCase(string2) == 0) {
            sqlExpression.rebuildExpression();
            string3 = sqlExpression.getExprString();
            if (string3.lastIndexOf(46) > 0) {
                string3 = string3.substring(string3.lastIndexOf(46) + 1);
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStep(QueryTree queryTree, QueryNode queryNode) throws XDBServerException {
        Object object;
        List<QueryCondition> list = null;
        List<QueryCondition> list2 = null;
        if (queryNode.getNodeType() == 1 && queryNode.getLeftNode() != null && !queryNode.isPreserveSubtree()) {
            this.createPlanStep(queryTree, queryNode.getLeftNode());
        }
        if (queryNode.getParent() != null && queryNode.getParent().isTreeDownJoin() && queryNode.getParent().getRightNode() != queryNode) {
            this.createPlanStep(queryTree, queryNode.getParent().getRightNode());
        }
        if (queryNode.getNodeType() == 2 && queryNode.getRelationNode().getNodeType() == 7) {
            this.correlatedStart = true;
            this.correlatedNode = queryNode;
            return;
        }
        Leaf leaf = this.getStepToProcess(queryNode, this.isDistinct);
        if (queryTree.isContainsAggregates() && queryNode.getParent() == null && !queryTree.isCorrelatedSubtree()) {
            if (queryNode.isTreeDownJoin()) {
                leaf.resetProjections();
            }
            this.updateAggProjections(queryTree, leaf);
            if (queryTree.isPartitionedGroupBy() || queryTree.usesSingleDBNode(this.database)) {
                this.addHavingConditions(queryTree, leaf);
            }
        }
        if (queryNode.getNodeType() == 2 && (queryNode.getRelationNode().isSubquery() || queryNode.getRelationNode().getNodeType() == 2) || queryNode.getNodeType() == 1 && queryNode.isPreserveSubtree()) {
            this.createPlanStepSubtree(queryNode, leaf);
        } else if (queryNode.getNodeType() == 2 && queryNode.getRelationNode().getNodeType() == 1) {
            this.createPlanStepFake(leaf);
        } else {
            object = this.lastJoinTableName;
            this.createPlanStepCheckCorrelated(queryNode, leaf);
            if (!queryNode.isTreeDownJoin()) {
                this.createPlanStepSubtree(queryNode.getRightNode(), leaf);
            }
            this.lastJoinTableName = object;
        }
        this.determineJoinTable(queryNode, leaf);
        this.levelStatus = 0;
        this.aLeaf2 = null;
        if (queryNode.getConditionList().size() > 0) {
            this.createPlanStepDoConditions(queryNode, leaf, list, list2);
        }
        if (this.correlatedNode != null) {
            this.updateCorrelatedConditions(leaf);
        }
        this.createPlanStepDoProjections(queryTree, queryNode, leaf);
        this.createPlanStepDoGroupByList(queryTree, queryNode, leaf);
        this.finalTableName = leaf.getTargetTableName();
        this.checkForCartesianProduct(queryNode, leaf);
        leaf.updateTempAliases();
        this.checkOuterCase(leaf, list2);
        this.determineExecutionNodes(leaf, this.aLeaf2);
        if (queryNode.getParent() == null && (!queryTree.isContainsAggregates() || queryTree.isPartitionedGroupBy() || queryTree.usesSingleDBNode(this.database))) {
            object = leaf;
            if (this.levelStatus == 3) {
                object = this.aLeaf2;
            }
            this.adjustNonAggOrderBy((Leaf)object, queryTree.getOrderByList());
        }
        if (queryNode.getParent() == null || !queryNode.getParent().isTreeDownJoin() || queryNode.getParent().getLeftNode() != queryNode) {
            this.updateQueryNodeTempTableName(queryNode, leaf.getTargetTableName());
        }
        if (this.levelStatus == 3) {
            this.updateQueryNodeTempTableName(queryNode, this.aLeaf2.getTargetTableName());
        }
        if (this.levelStatus == 2 && leaf.getHashColumn() == null) {
            this.handleOuter(leaf, queryNode.getLeftNode().getOuterLevel(), queryTree);
        }
    }

    private Leaf getStepToProcess(QueryNode queryNode, boolean bl) {
        Leaf leaf;
        if (queryNode.isTreeDownJoin()) {
            leaf = this.leaves.get(this.leaves.size() - 1);
            Leaf leaf2 = this.leaves.get(this.leaves.size() - 2);
            leaf.setTableName(leaf.getTableName() + "," + leaf2.getTargetTableName());
            leaf.addUsedTable(leaf2.getTargetTableName());
            leaf.extendedTableList.add(leaf2.getTargetTableName());
            leaf.extendedAliasList.add(leaf2.getTargetTableName());
            leaf.extendedOuterLevel.add(Integer.valueOf(queryNode.getRightNode().getOuterLevel()));
            leaf.extendedOuter.add(Boolean.FALSE);
            leaf2 = this.leaves.get(this.leaves.size() - 3);
            leaf.setJoinTableName(leaf2.getTargetTableName());
        } else {
            leaf = new Leaf();
            this.addLeaf(leaf);
            leaf.setLeafStepNo(++this.currentLeafStepNo);
            if (queryNode.getLeftNode() != null) {
                leaf.lastOuterLevel = queryNode.getLeftNode().getOuterLevel();
            }
            if (bl) {
                leaf.setDistinct(true);
            }
        }
        return leaf;
    }

    private void createPlanStepCheckCorrelated(QueryNode queryNode, Leaf leaf) {
        if (queryNode.getRightNode().getNodeType() == 2 && queryNode.getRightNode().getRelationNode().getNodeType() == 6) {
            String string = this.getSingleCorrelatedBaseTable(queryNode.getRightNode().getRelationNode());
            if (string != null) {
                leaf.setSingleCorrelatedHash(this.getSingleCorrelatedHashColumn(queryNode.getRightNode().getRelationNode(), string));
            }
            if (leaf.getSingleCorrelatedHash() == null) {
                leaf.correlatedJoinTableName = this.lastJoinTableName + "A";
                this.topQueryPlan.useAllNodes = true;
                this.createPlanStepCorrelated(queryNode, leaf);
                this.lastJoinTableName = leaf.correlatedJoinTableName;
            } else {
                leaf.setSingleStepCorrelated(true);
                leaf.setTableName(string);
            }
        }
    }

    private void determineJoinTable(QueryNode queryNode, Leaf leaf) {
        boolean bl = false;
        if (queryNode.getNodeType() == 2 && queryNode.getRelationNode().isSubquery()) {
            bl = true;
        }
        if (bl) {
            // empty if block
        }
        if (!queryNode.isTreeDownJoin()) {
            if (this.tempIdCounter > 0 && !bl && queryNode.getLeftNode() != null && (queryNode.getParent() == null || !queryNode.getParent().isTreeDownJoin()) && this.lastJoinTableName != null && this.lastJoinTableName.length() > 0 || this.correlatedStart) {
                leaf.setJoinTableName(this.lastJoinTableName);
            }
            leaf.setTargetTableName(this.generateTempTableName());
            this.lastJoinTableName = leaf.getTargetTableName();
        }
    }

    private void updateCorrelatedConditions(Leaf leaf) {
        if (this.correlatedNode != null) {
            for (int i = 0; i < this.correlatedNode.getConditionList().size(); ++i) {
                QueryCondition queryCondition = this.correlatedNode.getConditionList().get(i);
                if (!queryCondition.isJoin() || queryCondition.isInPlan()) continue;
                queryCondition.rebuildCondString();
                leaf.addJoin(queryCondition, queryCondition.getCondString());
                queryCondition.setInPlan(true);
            }
            leaf.setLeafType(3);
            this.correlatedStart = false;
            this.correlatedNode = null;
        }
    }

    private void checkForCartesianProduct(QueryNode queryNode, Leaf leaf) {
        if (!leaf.hasProjections() && queryNode.getParent() != null) {
            SqlExpression sqlExpression = new SqlExpression();
            ExpressionType expressionType = new ExpressionType();
            expressionType.type = 1;
            expressionType.length = 1;
            sqlExpression.setExprType(2);
            sqlExpression.setConstantValue("'1'");
            sqlExpression.setExprString("'1'");
            sqlExpression.setExprDataType(expressionType);
            sqlExpression.setAlias("XDUMMY");
            sqlExpression.setTempExpr(true);
            leaf.appendProjectionFromExpr(sqlExpression, false);
        }
    }

    private void checkOuterCase(Leaf leaf, List<QueryCondition> list) {
        if (this.levelStatus == 3) {
            for (QueryCondition queryCondition : list) {
                for (int i = 0; i < queryCondition.getColumnList().size(); ++i) {
                    AttributeColumn attributeColumn = queryCondition.getColumnList().get(i);
                    SqlExpression sqlExpression = new SqlExpression();
                    sqlExpression.setExprType(4);
                    sqlExpression.setColumn(attributeColumn);
                    sqlExpression.setExprDataType(attributeColumn.columnType);
                    if (attributeColumn.columnAlias != null) {
                        sqlExpression.setAlias(attributeColumn.columnAlias);
                    } else {
                        sqlExpression.setAlias(attributeColumn.columnName);
                    }
                    sqlExpression.rebuildExpression();
                    if (leaf.isProjection(sqlExpression.getExprString())) continue;
                    leaf.appendProjectionFromExpr(sqlExpression, false);
                }
            }
            this.addLeaf(this.aLeaf2);
        }
    }

    private void determineExecutionNodes(Leaf leaf, Leaf leaf2) {
        if (!leaf.isCombineOnMain()) {
            try {
                if (leaf.queryNodeList.size() == 0) {
                    SysTable sysTable = SysTable.getPartitionTable(leaf.getTableName(), this.database);
                    if (sysTable.isLookup()) {
                        leaf.setLookupStep(true);
                    }
                    leaf.queryNodeList = new ArrayList<DBNode>(sysTable.getJoinNodeList());
                }
            }
            catch (XDBServerException xDBServerException) {
                leaf.queryNodeList = new ArrayList<DBNode>(this.database.getDBNodeList());
            }
            if (this.levelStatus == 3) {
                leaf2.queryNodeList = leaf.queryNodeList;
            }
            for (int i = 0; i < leaf.queryNodeList.size(); ++i) {
                DBNode dBNode = leaf.queryNodeList.get(i);
                this.topQueryPlan.queryNodeTable.put(dBNode.getNodeId(), dBNode);
            }
        }
    }

    private boolean needToGenerateSerialForOuter(Leaf leaf) {
        if (leaf.extendedTableList.size() <= 1) {
            try {
                SysTable sysTable = this.database.getSysTable(leaf.getTableName());
                sysTable.getRowID();
                if (sysTable.isTrueRowID()) {
                    return false;
                }
            }
            catch (Exception exception) {
                return true;
            }
        }
        return true;
    }

    private boolean isSpecialOuterAggregateCase(QueryTree queryTree) {
        boolean bl = false;
        if (queryTree.getQueryNodeTable().size() == 3 && queryTree.isContainsAggregates()) {
            bl = true;
            for (int i = 0; i < queryTree.getProjectionList().size(); ++i) {
                SqlExpression sqlExpression = queryTree.getProjectionList().get(i);
                if (!sqlExpression.contains(queryTree.getRootNode().getRightNode().getRelationNode())) continue;
                if (!sqlExpression.containsAggregates()) {
                    bl = false;
                    break;
                }
                if (!sqlExpression.contains(queryTree.getRootNode().getLeftNode().getRelationNode())) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private void handleOuter(Leaf leaf, int n, QueryTree queryTree) {
        if (this.leaves.size() < 2) {
            return;
        }
        if (this.isSpecialOuterAggregateCase(queryTree)) {
            return;
        }
        Leaf leaf2 = this.leaves.get(this.leaves.size() - 2);
        if (leaf2 == this.leaves.get(0) && !this.needToGenerateSerialForOuter(leaf2)) {
            leaf2.updateSelectForOuter(this, true);
        } else {
            leaf2.addOuterIdSerial(this);
            leaf2.setSerialColumnPosition((short)leaf2.selectColumns.size());
            leaf2.updateSelectForOuter(this, false);
        }
        Leaf leaf3 = leaf.createDerivedOuterLeaf();
        leaf3.lastOuterLevel = n;
        for (SqlExpression iRebuildString2 : leaf2.createSqlExprFromOuterIdColumns(leaf.getJoinTableName())) {
            leaf3.appendProjectionFromExpr(iRebuildString2, false);
        }
        ExpressionType expressionType = new ExpressionType();
        expressionType.setExpressionType(4, 0, 0, 0);
        AttributeColumn attributeColumn = new AttributeColumn();
        attributeColumn.setColumnName(leaf2.getOuterNodeIdColumn());
        attributeColumn.setTableAlias(leaf.getJoinTableName());
        attributeColumn.setTableName(leaf.getJoinTableName());
        attributeColumn.columnType = expressionType;
        SqlExpression sqlExpression = new SqlExpression();
        sqlExpression.setExprType(4);
        sqlExpression.setColumn(attributeColumn);
        sqlExpression.setExprDataType(expressionType);
        leaf3.appendProjectionFromExpr(sqlExpression, false);
        leaf.outerSubplan = new QueryPlan(this.client);
        leaf.outerSubplan.topQueryPlan = this.topQueryPlan;
        leaf3.determineSelectStatement(leaf.outerSubplan);
        if (leaf3.getSelectStatement().indexOf(" WHERE ") > 0) {
            leaf3.setSelectStatement(leaf3.getSelectStatement() + " AND " + leaf3.getOuterTestString());
        } else {
            leaf3.setSelectStatement(leaf3.getSelectStatement() + " WHERE " + leaf3.getOuterTestString());
        }
        leaf3.setSelectStatement(leaf3.getSelectStatement().replaceAll(leaf.getTargetTableName(), leaf.getJoinTableName()));
        leaf.outerSubplan.leaves.add(leaf3);
        String string = new String();
        for (Leaf.Projection projection : leaf2.selectColumns) {
            String string2 = projection.getCreateColumnName();
            if (projection.projectString.startsWith("XONODEID")) continue;
            if (string.length() > 0) {
                string = string + ", ";
            }
            if (string2 != null && string2.length() > 0) {
                string = string + string2;
                continue;
            }
            string = string + projection.projectString;
        }
        leaf.determineSelectStatement(this);
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("(SELECT " + leaf2.getOuterColumnSelectString()).append(", ").append(IdentifierHandler.quote(leaf2.getOuterNodeIdColumn())).append(", COUNT(*)").append(" FROM ").append(IdentifierHandler.quote(leaf3.getTargetTableName())).append(" GROUP BY ").append(leaf2.getOuterColumnSelectString()).append(", ").append(IdentifierHandler.quote(leaf2.getOuterNodeIdColumn())).append(" HAVING COUNT(*) = &xnodecount&) as xsubselect ");
        String string3 = stringBuilder.toString();
        int n2 = leaf.getSelectStatement().toUpperCase().indexOf(" FROM ");
        String string4 = leaf.getSelectStatement().substring(0, n2);
        int n3 = leaf.getSelectStatement().toUpperCase().indexOf(" GROUP BY ");
        String string5 = null;
        if (n3 > 0) {
            string5 = leaf.getSelectStatement().substring(n3 + 10);
        }
        String string6 = leaf.getWhereClause();
        for (String string7 : leaf.extendedAliasList) {
            string4 = this.replaceColumnsBasedOnTable(string4, IdentifierHandler.quote(string7), "NULL");
            string6 = this.replaceColumnsBasedOnTable(string6, IdentifierHandler.quote(string7), "NULL");
            string4 = string4.replaceAll("sum\\(NULL\\)", "NULL");
            string4 = string4.replaceAll("avg\\(NULL\\)", "NULL");
            string4 = string4.replaceAll("sum\\( NULL\\)", "NULL");
            string4 = string4.replaceAll("avg\\( NULL\\)", "NULL");
            if (n3 <= 0) continue;
            string5 = this.replaceColumnsBasedOnTable(string5, IdentifierHandler.quote(string7) + ",", "");
            string5 = this.replaceColumnsBasedOnTable(string5, IdentifierHandler.quote(string7), "");
            if ((string5 = string5.replaceAll("NULL,", "")).toUpperCase().indexOf(" HAVING") < 0) continue;
            string5 = string5.replaceAll("sum\\(NULL\\)", "NULL");
            string5 = string5.replaceAll("avg\\(NULL\\)", "NULL");
            string5 = string5.replaceAll("sum\\( NULL\\)", "NULL");
            string5 = string5.replaceAll("avg\\( NULL\\)", "NULL");
        }
        Object object = string4 + " FROM " + IdentifierHandler.quote(leaf2.getTargetTableName()) + " INNER JOIN " + string3 + " ON " + IdentifierHandler.quote(leaf2.getTargetTableName()) + "." + IdentifierHandler.quote(leaf2.getOuterNodeIdColumn()) + " = xsubselect." + IdentifierHandler.quote(leaf2.getOuterNodeIdColumn());
        for (String string8 : leaf2.getOuterColumnSelectString().split(",")) {
            object = (String)object + " AND " + IdentifierHandler.quote(leaf2.getTargetTableName()) + "." + string8 + " = xsubselect." + string8;
        }
        object = (String)object + string6;
        if (n3 > 0 && string5.trim().length() > 0) {
            object = (String)object + " GROUP BY " + string5;
        }
        leaf.setSelectStatement(leaf.getSelectStatement().replaceFirst("LEFT OUTER", "INNER"));
        leaf.setNonProjectionSelectPart(leaf.getNonProjectionSelectPart().replaceFirst("LEFT OUTER", "INNER"));
        if (leaf.isDistinct()) {
            leaf.setSelectStatement(leaf.getSelectStatement() + " UNION " + (String)object);
            leaf.setNonProjectionSelectPart(leaf.getNonProjectionSelectPart() + " UNION " + (String)object);
        } else {
            leaf.setSelectStatement(leaf.getSelectStatement() + " UNION ALL " + (String)object);
            leaf.setNonProjectionSelectPart(leaf.getNonProjectionSelectPart() + " UNION ALL " + (String)object);
        }
    }

    public String replaceColumnsBasedOnTable(String string, String string2, String string3) {
        int n = 0;
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0) {
            return string;
        }
        String string4 = new String(string);
        int n2 = string4.toUpperCase().indexOf(string2.toUpperCase());
        while (n2 >= 0) {
            int n3;
            if (n2 <= 0 || (n3 = (int)string4.charAt(n2 - 1)) == 32 || n3 == 40 || n3 == 44) {
                n3 = string4.length();
                int n4 = string4.indexOf(" ", n2 + 1);
                if (n4 > -1 && n4 < n3) {
                    n3 = n4;
                }
                if ((n4 = string4.indexOf(")", n2 + 1)) > -1 && n4 < n3) {
                    n3 = n4;
                }
                if ((n4 = string4.indexOf(",", n2 + 1)) > -1 && n4 < n3) {
                    n3 = n4;
                }
                string4 = n3 < string4.length() ? string4.substring(0, n2) + string3 + string4.substring(n3) : string4.substring(0, n2) + string3;
            }
            n = n2 + 1;
            n2 = string4.toUpperCase().indexOf(string2.toUpperCase(), n2 + 1);
        }
        return string4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStepCorrelated(QueryNode queryNode, Leaf leaf) throws XDBServerException {
        String string = "";
        String string2 = "";
        leaf.setCorrelatedSelectString("");
        HashMap hashMap = new HashMap();
        for (AttributeColumn attributeColumn : queryNode.getRightNode().getRelationNode().getCorrelatedColumnList()) {
            String string3 = attributeColumn.columnName;
            if (attributeColumn.tempColumnAlias != null && attributeColumn.tempColumnAlias.length() > 0) {
                string3 = attributeColumn.tempColumnAlias;
            }
            if (hashMap.containsKey(string3)) continue;
            hashMap.put(string3, null);
            if (string2.length() > 0) {
                string2 = string2 + ", ";
                string = string + ", ";
            }
            try {
                string2 = string2 + IdentifierHandler.quote(string3) + " " + attributeColumn.columnType.getTypeString();
            }
            catch (Exception exception) {
                throw new XDBServerException(ErrorMessageRepository.ILLEGAL_COLUMN_TYPE + attributeColumn.columnName, exception, 8);
            }
            string = string + IdentifierHandler.quote(string3);
        }
        leaf.setCorrelatedSelectString("SELECT DISTINCT " + string + " FROM " + IdentifierHandler.quote(this.lastJoinTableName));
        if (queryNode.getLeftNode() != null) {
            this.updateQueryNodeTempTableName(queryNode.getLeftNode(), leaf.correlatedJoinTableName);
        }
        if (Props.XDB_USE_LOAD_FOR_STEP) {
            leaf.setCreateCorrelatedTableString(Props.XDB_SQLCOMMAND_CREATEGLOBALTEMPTABLE_START + " " + IdentifierHandler.quote(leaf.correlatedJoinTableName) + " (" + string2 + ") " + Props.XDB_SQLCOMMAND_CREATEGLOBALTEMPTABLE_SUFFIX);
        } else {
            leaf.setCreateCorrelatedTableString(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_START + " " + IdentifierHandler.quote(leaf.correlatedJoinTableName) + " (" + string2 + ") " + Props.XDB_SQLCOMMAND_CREATETEMPTABLE_SUFFIX);
        }
        QueryNode queryNode2 = queryNode.getRightNode();
        QueryTree queryTree = queryNode2.getRelationNode().getSubqueryTree();
        QueryPlan queryPlan = new QueryPlan(this.client);
        queryPlan.topQueryPlan = this.topQueryPlan;
        queryPlan.tempIdCounter = this.tempIdCounter;
        queryPlan.planType = 4;
        super.createPlanSegmentFromTree(queryTree, true, leaf.correlatedJoinTableName, 0);
        this.trackTable(queryPlan.finalTableName, leaf);
        if (queryNode.getLeftNode() != null) {
            this.updateQueryNodeTempTableName(queryNode.getLeftNode(), this.lastJoinTableName);
        }
        queryNode2.getRelationNode().setTableName(queryPlan.finalTableName);
        leaf.subplan = queryPlan;
        this.createPlanStepSubtree(queryNode2, leaf);
        this.tempIdCounter = queryPlan.tempIdCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStepDoConditions(QueryNode queryNode, Leaf leaf, List<QueryCondition> list, List<QueryCondition> object) {
        Object object2;
        QueryCondition queryCondition;
        int n;
        SortedVector sortedVector = new SortedVector();
        list = new ArrayList<QueryCondition>();
        object = new ArrayList<QueryCondition>();
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        for (n = 0; n < queryNode.getConditionList().size(); ++n) {
            queryCondition = queryNode.getConditionList().get(n);
            arrayList.addAll(queryCondition.getAndedConditions());
        }
        queryNode.setConditionList(arrayList);
        for (n = 0; n < queryNode.getConditionList().size(); ++n) {
            queryCondition = queryNode.getConditionList().get(n);
            if (queryCondition.isJoin() && queryCondition.getRelationNodeList().size() > 0) {
                short s = 0;
                queryCondition.rebuildCondString();
                try {
                    Object object3;
                    object2 = queryCondition.getRelationNodeList().get(0);
                    s = ((RelationNode)object2).getOuterLevel();
                    if (queryCondition.getRelationNodeList().size() != 2 || queryNode.getRightNode() == null) {
                        list.add(queryCondition);
                        continue;
                    }
                    if (queryCondition.getRelationNodeList().size() != 2) continue;
                    Object object4 = queryCondition.getRelationNodeList().get(1);
                    if (queryNode.getRightNode().subtreeContains((RelationNode)object2)) {
                        object3 = object2;
                        object2 = object4;
                        object4 = object3;
                        s = ((RelationNode)object2).getOuterLevel();
                    } else if (queryNode.getRightNode().subtreeContains((RelationNode)object4)) {
                        s = ((RelationNode)object2).getOuterLevel();
                    }
                    sortedVector.addElement(s, queryCondition);
                    if (queryCondition.isSimpleTableJoin() && queryCondition.getOperator() == "=" && queryCondition.getLeftCond().getExpr().getMappedExpression() == null && !queryNode.isTreeDownJoin()) {
                        object3 = queryCondition.getLeftCond().getExpr().getColumn();
                        SysTable sysTable = null;
                        try {
                            sysTable = ((AttributeColumn)object3).getSysTable(this.database);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (queryNode.getRightNode().subtreeContains(((AttributeColumn)object3).relationNode) && sysTable != null && sysTable.getPartitionScheme() == 3 && sysTable.getPartitionColumn().equalsIgnoreCase(((AttributeColumn)object3).columnName)) {
                            leaf.setHashInfo(((AttributeColumn)object3).getTableName(), queryCondition.getRightCond().getExpr().getExprString());
                        } else {
                            object3 = queryCondition.getRightCond().getExpr().getColumn();
                            try {
                                sysTable = ((AttributeColumn)object3).getSysTable(this.database);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (queryNode.getRightNode().subtreeContains(((AttributeColumn)object3).relationNode) && sysTable != null && sysTable.getPartitionScheme() == 3 && sysTable.getPartitionColumn().equalsIgnoreCase(((AttributeColumn)object3).columnName)) {
                                leaf.setHashInfo(((AttributeColumn)object3).getTableName(), queryCondition.getLeftCond().getExpr().getExprString());
                            }
                        }
                    }
                    if (((RelationNode)object2).getOuterLevel() == ((RelationNode)object4).getOuterLevel() || leaf.getHashColumn() != null) continue;
                    boolean bl = false;
                    if (queryCondition.getLeftCond().getExpr() != null && queryCondition.getRightCond().getExpr() != null) {
                        if (queryCondition.getLeftCond().getExpr().contains((RelationNode)object2) && queryCondition.getRightCond().getExpr().contains((RelationNode)object4)) {
                            if (leaf.outerExprList == null) {
                                leaf.outerExprList = new ArrayList<SqlExpression>();
                                leaf.innerExprList = new ArrayList<SqlExpression>();
                            }
                            leaf.outerExprList.add(queryCondition.getLeftCond().getExpr());
                            leaf.innerExprList.add(queryCondition.getRightCond().getExpr());
                            bl = true;
                        } else if (queryCondition.getLeftCond().getExpr().contains((RelationNode)object4) && queryCondition.getRightCond().getExpr().contains((RelationNode)object2)) {
                            if (leaf.outerExprList == null) {
                                leaf.outerExprList = new ArrayList<SqlExpression>();
                                leaf.innerExprList = new ArrayList<SqlExpression>();
                            }
                            leaf.outerExprList.add(queryCondition.getRightCond().getExpr());
                            leaf.innerExprList.add(queryCondition.getLeftCond().getExpr());
                            bl = true;
                        }
                    }
                    if (bl) continue;
                    throw new XDBServerException("This outer join condition too complex and is currently not supported. Try simplifying the outer or using temp tables over multiple steps.");
                }
                catch (Exception exception) {
                    throw new XDBServerException(ErrorMessageRepository.INVALID_JOIN, exception, ErrorMessageRepository.INVALID_JOIN_CODE);
                }
            }
            Collection<DBNode> collection = queryCondition.getPartitionedNode(this.client);
            if (collection != null) {
                leaf.queryNodeList = new ArrayList<DBNode>(collection);
                continue;
            }
            leaf.setPartitionParameterExpression(queryCondition.getPartitionParameterExpression(this.database));
        }
        int n2 = -1;
        for (n = 0; n < sortedVector.size(); ++n) {
            QueryCondition queryCondition2 = (QueryCondition)sortedVector.get(n);
            if (n2 == -1) {
                this.levelStatus = sortedVector.getKeyAt(n) == queryNode.getRightNode().getOuterLevel() ? 1 : 2;
                list.add(queryCondition2);
            } else if (this.levelStatus == 1) {
                if (sortedVector.getKeyAt(n) == queryNode.getRightNode().getOuterLevel()) {
                    list.add(queryCondition2);
                } else {
                    this.levelStatus = 2;
                    list.add(queryCondition2);
                }
            } else {
                list.add(queryCondition2);
            }
            if (this.levelStatus == 3) {
                object2 = list;
                list = object;
                object = object2;
            }
            n2 = sortedVector.getKeyAt(n);
        }
        if (!queryNode.isPreserveSubtree()) {
            for (n = 0; n < list.size(); ++n) {
                queryCondition = list.get(n);
                if (!queryCondition.isJoin() || queryCondition.isInPlan()) continue;
                queryCondition.rebuildCondString();
                String string = queryCondition.getCondString();
                leaf.addJoin(queryCondition, string);
                queryCondition.setInPlan(true);
            }
        }
        if (this.levelStatus == 3) {
            this.aLeaf2 = new Leaf();
            this.aLeaf2.setLeafStepNo(++this.currentLeafStepNo);
            this.aLeaf2.setDistinct(leaf.isDistinct());
            this.aLeaf2.setJoinTableName(leaf.getJoinTableName());
            this.aLeaf2.setTableName(leaf.getTargetTableName());
            this.trackTable(this.aLeaf2.getJoinTableName(), this.aLeaf2);
            this.trackTable(this.aLeaf2.getTableName(), this.aLeaf2);
            this.aLeaf2.extendedTableList.add(leaf.getTargetTableName());
            this.aLeaf2.extendedAliasList.add(leaf.getTargetTableName());
            this.aLeaf2.extendedOuter.add(Boolean.TRUE);
            this.aLeaf2.extendedOuterLevel.add(new Integer(queryNode.getRightNode().getOuterLevel() + 1));
            this.aLeaf2.setTargetTableName(this.generateTempTableName());
            this.aLeaf2.setExtraStep(true);
            for (n = 0; n < object.size(); ++n) {
                queryCondition = (QueryCondition)object.get(n);
                if (!queryCondition.isJoin() || queryCondition.isInPlan()) continue;
                queryCondition.rebuildCondString();
                String string = queryCondition.getCondString();
                if (string.indexOf(leaf.getTableName() + ".") >= 0) {
                    string = ParseCmdLine.replace(string, leaf.getTableName(), leaf.getTargetTableName());
                }
                this.aLeaf2.addJoin(queryCondition, string);
                queryCondition.setInPlan(true);
            }
        }
        for (n = 0; n < queryNode.getConditionList().size(); ++n) {
            queryCondition = queryNode.getConditionList().get(n);
            if (queryCondition.isJoin() || queryCondition.isInPlan()) continue;
            if (Props.XDB_CONSTANT_EXPRESSION_THRESHOLD >= 0 && queryNode.getBaseNumRows() > (long)Props.XDB_CONSTANT_EXPRESSION_THRESHOLD) {
                this.evaluateConstantExpressions(queryCondition);
            }
            queryCondition.rebuildCondString();
            leaf.addCondition(queryCondition.getCondString());
            queryCondition.setInPlan(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStepDoProjections(QueryTree queryTree, QueryNode queryNode, Leaf leaf) {
        if (queryNode.getParent() == null && (!queryTree.isContainsAggregates() || queryTree.isPartitionedGroupBy() || queryTree.usesSingleDBNode(this.database)) && !queryTree.isCorrelatedSubtree()) {
            this.adjustFinalProjections(leaf, queryTree.getProjectionList(), (queryTree.getQueryType() & 0x14) > 0);
            if (this.levelStatus == 3) {
                this.aLeaf2.setCombineOnMain(true);
                for (SqlExpression sqlExpression : queryNode.getProjectionList()) {
                    sqlExpression.rebuildExpression();
                    String string = sqlExpression.getExprString();
                    if (string.indexOf(leaf.getJoinTableName() + ".") < 0) {
                        int n = string.indexOf(".");
                        sqlExpression.setExprString(leaf.getTargetTableName() + "." + string.substring(n + 1));
                        sqlExpression.setTempExpr(true);
                        if (sqlExpression.getAlias().length() == 0) {
                            sqlExpression.setAlias(string.substring(n + 1));
                        }
                    }
                    this.aLeaf2.appendProjectionFromExpr(sqlExpression, false);
                }
            }
        } else {
            for (SqlExpression sqlExpression : queryNode.getProjectionList()) {
                if (sqlExpression.isConstantExpr() && queryNode.getParent() != null) continue;
                sqlExpression.rebuildExpression();
                if (!leaf.isProjection(sqlExpression.getExprString()) || sqlExpression.containsAggregates() || sqlExpression.isTempExpr()) {
                    leaf.appendProjectionFromExpr(sqlExpression, false);
                }
                if (this.levelStatus != 3) continue;
                String string = sqlExpression.getExprString();
                if (string.indexOf(leaf.getJoinTableName() + ".") < 0) {
                    int n = string.indexOf(".");
                    sqlExpression.setExprString(leaf.getTargetTableName() + "." + string.substring(n + 1));
                    string = sqlExpression.getExprString();
                }
                this.aLeaf2.appendProjectionFromExpr(sqlExpression, false);
                this.aLeaf2.setCombineOnMain(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStepDoGroupByList(QueryTree queryTree, QueryNode queryNode, Leaf leaf) {
        for (int i = 0; i < queryNode.getGroupByList().size(); ++i) {
            String string;
            SqlExpression sqlExpression = queryNode.getGroupByList().get(i);
            sqlExpression.rebuildExpression();
            if (!this.subplanList.isEmpty()) {
                this.checkScalarExpression(sqlExpression.getExprString(), leaf);
            }
            if (leaf.isGroupByColumn(sqlExpression.getExprString())) continue;
            Leaf leaf2 = leaf;
            leaf2.getClass();
            Leaf.Projection projection = new Leaf.Projection(leaf2, sqlExpression.getExprString());
            if (this.useSlowAggregation && !queryTree.isPartitionedGroupBy()) {
                leaf.setSuppressedGroupBy(true);
            }
            if (sqlExpression.isTempExpr() && sqlExpression.getExprType() == 4) {
                projection.forceGroupQuote = true;
            }
            leaf.groupByColumns.add(projection);
            if (!leaf.isProjection(sqlExpression.getExprString())) {
                string = leaf.appendProjectionFromExpr(sqlExpression, false);
                projection.setCreateColumnName(string);
                projection.groupByPosition = leaf.selectColumns.size();
            } else {
                string = "";
                int n = 0;
                for (Leaf.Projection projection2 : leaf.selectColumns) {
                    ++n;
                    if (projection2.projectString.compareToIgnoreCase(sqlExpression.getExprString()) != 0) continue;
                    string = projection2.getCreateColumnName();
                    projection.setCreateColumnName(string);
                    projection.groupByPosition = n;
                    break;
                }
                if (string.length() == 0) {
                    throw new XDBServerException(ErrorMessageRepository.LOOKUP_ERROR + "( GroupByList " + sqlExpression.getExprString() + " )", 8, ErrorMessageRepository.LOOKUP_ERROR_CODE);
                }
            }
            if (!sqlExpression.isDistinctExtraGroup()) {
                Leaf leaf3 = leaf;
                leaf3.getClass();
                projection = new Leaf.Projection(leaf3, string);
                projection.forceGroupQuote = true;
                this.extraStepGroupByList.add(projection);
                continue;
            }
            leaf.incrementAddedGroupCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQueryNodeTempTableName(QueryNode queryNode, String string) {
        if (queryNode.getNodeType() == 1) {
            this.updateQueryNodeTempTableName(queryNode.getLeftNode(), string);
            this.updateQueryNodeTempTableName(queryNode.getRightNode(), string);
        } else if (queryNode.getRelationNode().getNodeType() == 2) {
            queryNode.getRelationNode().setCurrentTempTableName(string);
        } else if (queryNode.getRelationNode().getNodeType() == 4) {
            queryNode.getRelationNode().setCurrentTempTableName(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStepUncorrelated(RelationNode relationNode, Leaf leaf, boolean bl, String string, String string2) {
        Leaf leaf2;
        QueryTree queryTree = relationNode.getSubqueryTree();
        QueryPlan queryPlan = new QueryPlan(this.client);
        queryPlan.topQueryPlan = this.topQueryPlan;
        queryPlan.tempIdCounter = this.tempIdCounter;
        queryPlan.planType = 3;
        queryPlan.createPlanSegmentFromTree(queryTree, true, "", 0);
        this.tempIdCounter = queryPlan.tempIdCounter;
        relationNode.setTableName(queryPlan.finalTableName);
        if (queryPlan.unionSubplanList.isEmpty()) {
            leaf2 = queryPlan.leaves.get(queryPlan.leaves.size() - 1);
        } else {
            QueryPlan queryPlan2 = queryPlan.unionSubplanList.get(0);
            leaf2 = queryPlan2.leaves.get(queryPlan2.leaves.size() - 1);
        }
        queryPlan.determineSubqueryProjections(leaf2, queryTree.getProjectionList());
        if (bl) {
            if (!leaf2.isDistinct()) {
                queryPlan.isDistinct = true;
                leaf2.setDistinct(true);
                leaf2.setSelectStatement("select distinct" + leaf2.getSelectStatement().substring(6));
            }
            leaf2.finalInClausePartitioningTable = string;
        }
        leaf.uncorrelatedSubplanList.add(queryPlan);
        relationNode.getParentNoncorExpr().setExprString(" (SELECT " + queryPlan.finalProjString + " FROM " + IdentifierHandler.quote(relationNode.getTableName()) + ")");
        relationNode.getParentNoncorExpr().setTempExpr(true);
        this.trackTable(queryPlan.finalTableName, leaf);
    }

    private void createPlanStepSubtreeCorrelated(QueryNode queryNode, Leaf leaf) {
        String string = "";
        leaf.setLeafType(2);
        if (leaf.isSingleStepCorrelated()) {
            queryNode.getRelationNode().getParentCorrelatedExpr().rebuildExpression();
        } else {
            for (QueryNode object : queryNode.getRelationNode().getSubqueryTree().getQueryNodeTable().values()) {
                if (object.getNodeType() != 2 || object.getRelationNode().getNodeType() != 7) continue;
                this.correlatedNode = object;
                break;
            }
            if (this.correlatedNode == null) {
                throw new XDBServerException(ErrorMessageRepository.CORRELATED_NODE_LOST, 8, ErrorMessageRepository.CORRELATED_NODE_LOST_CODE);
            }
            for (QueryCondition queryCondition : queryNode.getRelationNode().getSubqueryTree().getConditionList()) {
                for (RelationNode relationNode : queryCondition.getRelationNodeList()) {
                    if (relationNode != this.correlatedNode.getRelationNode()) continue;
                    if (string.length() > 0) {
                        string = string + " AND ";
                    }
                    queryCondition.rebuildCondString();
                    string = string + queryCondition.getCondString();
                    String string2 = leaf.correlatedJoinTableName.substring(0, leaf.correlatedJoinTableName.length() - 1);
                    QueryCondition queryCondition2 = queryCondition.getLeftCond();
                    QueryCondition queryCondition3 = queryCondition.getRightCond();
                    SqlExpression sqlExpression = queryCondition2.getSqlExpressionExclusiveFromTable(string2);
                    if (sqlExpression == null) {
                        queryCondition2 = queryCondition.getRightCond();
                        queryCondition3 = queryCondition.getLeftCond();
                        sqlExpression = queryCondition2.getSqlExpressionExclusiveFromTable(string2);
                    }
                    if (sqlExpression == null) continue;
                    SqlExpression sqlExpression2 = sqlExpression;
                    sqlExpression = queryCondition3.getSqlExpressionExclusiveFromTable(queryNode.getRelationNode().getTableName());
                    if (sqlExpression == null) continue;
                    leaf.addCorrelatedColumn(sqlExpression);
                    if (leaf.isCorrelatedHashable()) continue;
                    leaf.setCorrelatedHashable(true);
                    leaf.correlatedChildHashableExpression = sqlExpression;
                    leaf.correlatedParentHashableExpression = sqlExpression2;
                }
            }
            queryNode.getRelationNode().getParentCorrelatedExpr().setExprString(" (SELECT " + leaf.subplan.finalProjString + " FROM " + IdentifierHandler.quote(queryNode.getRelationNode().getTableName()));
            if (string.length() > 0) {
                queryNode.getRelationNode().getParentCorrelatedExpr().setExprString(queryNode.getRelationNode().getParentCorrelatedExpr().getExprString() + " WHERE " + string);
            }
            queryNode.getRelationNode().getParentCorrelatedExpr().setExprString(queryNode.getRelationNode().getParentCorrelatedExpr().getExprString() + ")");
        }
        queryNode.getRelationNode().getParentCorrelatedExpr().setTempExpr(true);
        this.trackTable(queryNode.getRelationNode().getTableName(), leaf);
    }

    private void createPlanStepFake(Leaf leaf) {
        leaf.setCombineOnMain(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPlanStepSubtree(QueryNode queryNode, Leaf leaf) {
        for (RelationNode relationNode : queryNode.getUncorrelatedCondTreeList()) {
            String string = null;
            boolean bl = false;
            AttributeColumn attributeColumn = null;
            for (QueryCondition queryCondition : queryNode.getConditionList()) {
                SysTable sysTable;
                if (queryCondition.getCondType() != 2 && queryCondition.getCondType() != 10 || queryCondition.getOperator() == null || queryCondition.getOperator().compareToIgnoreCase("IN") != 0) continue;
                bl = true;
                if (queryCondition.getRightCond().getCondType() != 4 || queryCondition.getRightCond().getExpr().getExprType() != 64 || !queryCondition.getRightCond().getCondString().equalsIgnoreCase(relationNode.getParentNoncorExpr().getExprString()) || queryCondition.getLeftCond().getCondType() != 4 || queryCondition.getLeftCond().getExpr().getExprType() != 4 || (sysTable = (attributeColumn = queryCondition.getLeftCond().getExpr().getColumn()).getSysTable(this.database)).getPartitionScheme() != 3 || !sysTable.getPartitionColumn().equalsIgnoreCase(attributeColumn.columnName)) continue;
                string = attributeColumn.getTableName();
            }
            this.createPlanStepUncorrelated(relationNode, leaf, bl, string, null);
        }
        if (queryNode.getNodeType() == 1) {
            this.createPlanStepSubtree(queryNode.getLeftNode(), leaf);
            this.createPlanStepSubtree(queryNode.getRightNode(), leaf);
            for (int i = 0; i < queryNode.getConditionList().size(); ++i) {
                QueryCondition queryCondition = queryNode.getConditionList().get(i);
                queryCondition.rebuildCondString();
                leaf.addJoin(queryCondition, queryCondition.getCondString());
                queryCondition.setInPlan(true);
            }
            if (queryNode.isSubtreeOuter()) {
                leaf.extendedOuter.set(0, Boolean.TRUE);
            }
        } else {
            if (queryNode.getNodeType() == 2 && queryNode.getRelationNode().getNodeType() == 6) {
                this.createPlanStepSubtreeCorrelated(queryNode, leaf);
            }
            if (queryNode.getRelationNode().getNodeType() == 7) {
                queryNode.getRelationNode().setTableName(this.lastJoinTableName);
                this.trackTable(queryNode.getRelationNode().getTableName(), leaf);
            }
            if (queryNode.getRelationNode().getNodeType() != 5 && queryNode.getRelationNode().getNodeType() != 6) {
                if (leaf.getTableName().length() > 0) {
                    leaf.setTableName(leaf.getTableName() + ",");
                }
                leaf.extendedOuterLevel.add(Integer.valueOf(queryNode.getOuterLevel()));
                if (queryNode.isSubtreeOuter()) {
                    leaf.extendedOuter.add(Boolean.TRUE);
                } else {
                    leaf.extendedOuter.add(Boolean.FALSE);
                }
                leaf.setTableName(leaf.getTableName() + queryNode.getRelationNode().getTableName());
                leaf.extendedTableList.add(queryNode.getRelationNode().getTableName());
                if (queryNode.getRelationNode().getAlias() != null && queryNode.getRelationNode().getAlias().length() > 0) {
                    leaf.extendedAliasList.add(queryNode.getRelationNode().getAlias());
                } else {
                    leaf.extendedAliasList.add(queryNode.getRelationNode().getTableName());
                }
                leaf.addUsedTable(queryNode.getRelationNode().getTableName());
                if (queryNode.getRelationNode().getNodeType() != 2) {
                    this.trackTable(queryNode.getRelationNode().getTableName(), leaf);
                }
            }
            for (int i = 0; i < queryNode.getConditionList().size(); ++i) {
                QueryCondition queryCondition = queryNode.getConditionList().get(i);
                if (Props.XDB_CONSTANT_EXPRESSION_THRESHOLD >= 0 && queryNode.getBaseNumRows() > (long)Props.XDB_CONSTANT_EXPRESSION_THRESHOLD) {
                    this.evaluateConstantExpressions(queryCondition);
                }
                queryCondition.rebuildCondString();
                if (!this.subplanList.isEmpty()) {
                    this.checkScalarExpression(queryCondition.getCondString(), leaf);
                }
                leaf.addCondition(queryCondition.getCondString());
                queryCondition.setInPlan(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void evaluateConstantExpressions(QueryCondition queryCondition) {
        Vector<QueryCondition> vector = QueryCondition.getNodes(queryCondition, 4);
        for (QueryCondition queryCondition2 : vector) {
            SqlExpression sqlExpression = queryCondition2.getExpr();
            if (!sqlExpression.isConstantExpr() || sqlExpression.getExprType() == 2) continue;
            Engine engine = Engine.getInstance();
            ArrayList<DBNode> arrayList = new ArrayList<DBNode>();
            arrayList.add(this.database.getDBNode(this.database.getCoordinatorNodeID()));
            Map<Integer, ResultSet> map = engine.executeQueryOnMultipleNodes("select " + sqlExpression.getExprString(), arrayList, this.client);
            Iterator<ResultSet> iterator = map.values().iterator();
            ResultSet resultSet = iterator.next();
            try {
                if (!resultSet.next()) continue;
                if (sqlExpression.getExprDataType().isNumeric()) {
                    sqlExpression.setConstantValue(resultSet.getString(1));
                } else {
                    sqlExpression.setConstantValue("'" + resultSet.getString(1) + "'");
                }
                sqlExpression.setExprType(2);
                sqlExpression.setLeftExpr(null);
                sqlExpression.setRightExpr(null);
            }
            catch (SQLException sQLException) {}
            continue;
            finally {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkScalarExpression(String string, Leaf leaf) {
        int n = string.indexOf("&x");
        while (n >= 0) {
            int n2 = string.indexOf("x&", n + 1);
            if (n2 < 0) {
                n = string.indexOf("&x", n + 1);
                continue;
            }
            int n3 = Integer.parseInt(string.substring(n + 2, n2));
            for (QueryPlan queryPlan : this.subplanList) {
                if (queryPlan.placeHolderNo != n3) continue;
                queryPlan.scalarLeaf = leaf;
                break;
            }
            n = string.indexOf("&x", n2 + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustFinalProjections(Leaf leaf, List<SqlExpression> list, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        leaf.resetProjections();
        for (int i = 0; i < list.size(); ++i) {
            SqlExpression sqlExpression = list.get(i);
            sqlExpression.rebuildExpression();
            String string = "";
            if (!this.subplanList.isEmpty()) {
                this.checkScalarExpression(sqlExpression.getExprString(), leaf);
            }
            String string2 = sqlExpression.getExprString();
            boolean bl2 = leaf.isProjection(sqlExpression.getExprString());
            if (!bl2 || sqlExpression.isAdded() || sqlExpression.containsAggregates() || sqlExpression.isTempExpr()) {
                if (sqlExpression.isAdded() && !bl) continue;
                string = leaf.appendProjectionFromExpr(sqlExpression, true);
                if (!ExecutionPlan.TRANSFORM_PROJECTIONS) {
                    string = string2;
                }
            } else if (bl2) {
                string = sqlExpression.getExprString();
            }
            if (sqlExpression.isAdded()) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            if (sqlExpression.isConstantExpr()) {
                stringBuffer.append(sqlExpression.getExprString());
            } else if (string.length() > 0) {
                stringBuffer.append(string);
            } else {
                stringBuffer.append(sqlExpression.getExprString().substring(sqlExpression.getExprString().indexOf(".") + 1));
            }
            if (sqlExpression.getAlias().length() <= 0) continue;
            stringBuffer.append(" as ").append(IdentifierHandler.quote(sqlExpression.getAlias()));
        }
        this.finalProjString = stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineSubqueryProjections(Leaf leaf, List<SqlExpression> list) {
        leaf.resetProjections();
        this.finalProjString = "";
        for (int i = 0; i < list.size(); ++i) {
            SqlExpression sqlExpression = list.get(i);
            sqlExpression.rebuildExpression();
            String string = "";
            if (!this.subplanList.isEmpty()) {
                this.checkScalarExpression(sqlExpression.getExprString(), leaf);
            }
            string = leaf.appendProjectionFromExpr(sqlExpression, true);
            if (this.finalProjString.length() > 0) {
                this.finalProjString = this.finalProjString + ", ";
            }
            this.finalProjString = this.finalProjString + IdentifierHandler.quote(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void determineFinalCorrelatedProjections(List<SqlExpression> list) {
        this.finalProjString = "";
        for (int i = 0; i < list.size(); ++i) {
            SqlExpression sqlExpression = list.get(i);
            if (sqlExpression.isAdded()) continue;
            sqlExpression.rebuildExpression();
            if (this.finalProjString.length() > 0) {
                this.finalProjString = this.finalProjString + ", ";
            }
            this.finalProjString = this.finalProjString + sqlExpression.getExprString().replaceAll("[A-Za-z]+[A-Za-z0-9_]*\\.", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustNonAggOrderBy(Leaf leaf, List<OrderByElement> list) {
        for (int i = 0; i < list.size(); ++i) {
            OrderByElement orderByElement = list.get(i);
            SqlExpression sqlExpression = orderByElement.orderExpression;
            sqlExpression.rebuildExpression();
            String string = "";
            if (leaf.isProjection(sqlExpression.getExprString())) continue;
            boolean bl = false;
            String string2 = leaf.getCreateTableColumns();
            if (sqlExpression.getAlias().length() > 0 && string2.indexOf(" " + sqlExpression.getAlias() + " ") >= 0) {
                bl = true;
            }
            if (sqlExpression.getColumn() != null) {
                if (string2.indexOf(" " + sqlExpression.getColumn().columnName) >= 0) {
                    bl = true;
                }
            } else {
                this.replaceColumnExpression(sqlExpression);
                if (string2.indexOf(" " + sqlExpression.getExprString() + " ") >= 0) {
                    bl = true;
                }
            }
            if (bl) continue;
            string = leaf.appendProjectionFromExpr(sqlExpression, false);
            sqlExpression.setAlias(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFinalPlanStep(QueryTree queryTree) {
        Collection<DBNode> collection;
        Leaf leaf = new Leaf();
        leaf.setLeafStepNo(++this.currentLeafStepNo);
        leaf.setCombinerStep(true);
        leaf.setCombineOnMain(true);
        leaf.setTableName(Props.XDB_TEMPTABLEPREFIX + "T" + this.queryId + "_" + this.tempIdCounter);
        leaf.extendedTableList.add(leaf.getTableName());
        leaf.extendedAliasList.add(leaf.getTableName());
        leaf.extendedOuter.add(Boolean.FALSE);
        leaf.extendedOuterLevel.add(1);
        leaf.setTargetTableName(this.generateTempTableName());
        this.adjustFinalProjections(leaf, queryTree.getFinalProjList(), (queryTree.getQueryType() & 0x14) > 0);
        if (!leaf.hasProjections()) {
            collection = new SqlExpression();
            ExpressionType iterator = new ExpressionType();
            iterator.type = 1;
            iterator.length = 1;
            ((SqlExpression)((Object)collection)).setExprType(2);
            ((SqlExpression)((Object)collection)).setConstantValue("'1'");
            ((SqlExpression)((Object)collection)).setExprString("'1'");
            ((SqlExpression)((Object)collection)).setExprDataType(iterator);
            ((SqlExpression)((Object)collection)).setAlias("XDUMMY");
            ((SqlExpression)((Object)collection)).setTempExpr(true);
            leaf.appendProjectionFromExpr((SqlExpression)((Object)collection), false);
        }
        leaf.groupByColumns = this.extraStepGroupByList;
        for (Leaf.Projection projection : this.projectedGroupBy) {
            boolean bl = false;
            for (Leaf.Projection projection2 : leaf.groupByColumns) {
                if (!projection2.projectString.equalsIgnoreCase(projection.projectString)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            leaf.groupByColumns.add(projection);
        }
        if (leaf.groupByColumns.size() > 0) {
            collection = this.database.getDBNodeList();
            leaf.queryNodeList = new ArrayList<DBNode>(collection.size());
            for (DBNode dBNode : collection) {
                leaf.queryNodeList.add(dBNode);
                this.topQueryPlan.queryNodeTable.put(dBNode.getNodeId(), dBNode);
            }
        }
        for (int i = 0; i < queryTree.getHavingList().size(); ++i) {
            QueryCondition queryCondition = queryTree.getHavingList().get(i);
            this.replaceHavingColumns(queryCondition);
            this.markConditionExpressionsAsTemp(queryCondition);
            queryCondition.rebuildCondString();
            if (!this.subplanList.isEmpty()) {
                this.checkScalarExpression(queryCondition.getCondString(), leaf);
            }
            leaf.addHavingCondition(queryCondition.getCondString());
        }
        this.finalTableName = leaf.getTargetTableName();
        this.trackTable(leaf.getTableName(), leaf);
        this.addLeaf(leaf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markConditionExpressionsAsTemp(QueryCondition queryCondition) {
        if (queryCondition.getLeftCond() != null) {
            this.markConditionExpressionsAsTemp(queryCondition.getLeftCond());
        }
        if (queryCondition.getRightCond() != null) {
            this.markConditionExpressionsAsTemp(queryCondition.getRightCond());
        }
        if (queryCondition.getCondType() == 4) {
            queryCondition.getExpr().setTempExpr(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceHavingColumns(QueryCondition queryCondition) {
        if (queryCondition.getCondType() == 8 || queryCondition.getCondType() == 16) {
            if (queryCondition.getLeftCond() != null) {
                this.replaceHavingColumns(queryCondition.getLeftCond());
            }
            if (queryCondition.getRightCond() != null) {
                this.replaceHavingColumns(queryCondition.getRightCond());
            }
        } else {
            this.replaceColumnExpression(queryCondition.getExpr());
            queryCondition.getExpr().rebuildExpression();
        }
        queryCondition.rebuildCondString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceMappedColumns(SqlExpression sqlExpression) {
        this.replaceColumnExpression(sqlExpression);
        sqlExpression.rebuildExpression();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceColumnExpression(SqlExpression sqlExpression) {
        String string;
        if (sqlExpression.getLeftExpr() != null) {
            this.replaceColumnExpression(sqlExpression.getLeftExpr());
        }
        if (sqlExpression.getRightExpr() != null) {
            this.replaceColumnExpression(sqlExpression.getRightExpr());
        }
        if ((sqlExpression.getExprType() == 4 || sqlExpression.getExprType() == 32) && (string = this.getMappedExpression(sqlExpression)) != null) {
            sqlExpression.setTempExpr(true);
            sqlExpression.setExprString(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateColumnName(String string) {
        String string2;
        String string3 = string2 = "XCOL" + ++this.colGenCount;
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHavingConditions(QueryTree queryTree, Leaf leaf) {
        for (int i = 0; i < queryTree.getHavingList().size(); ++i) {
            QueryCondition queryCondition = queryTree.getHavingList().get(i);
            queryCondition.rebuildCondString();
            if (!this.subplanList.isEmpty()) {
                this.checkScalarExpression(queryCondition.getCondString(), leaf);
            }
            this.replaceHavingColumns(queryCondition);
            leaf.addHavingCondition(queryCondition.getCondString());
        }
    }

    SqlExpression getInProjectionList(QueryTree queryTree, SqlExpression sqlExpression) {
        for (SqlExpression sqlExpression2 : queryTree.getProjectionList()) {
            if (sqlExpression.getAlias().compareTo(sqlExpression2.getAlias()) != 0) continue;
            return sqlExpression2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAggProjections(QueryTree queryTree, Leaf leaf) {
        Object object;
        SqlExpression sqlExpression;
        Object object2;
        SqlExpression sqlExpression2;
        int n;
        queryTree.getRootNode().setGroupByList(queryTree.getGroupByList());
        queryTree.determinePartitionedGroupBy(this.database);
        if (queryTree.isPartitionedGroupBy() || queryTree.usesSingleDBNode(this.database)) {
            return;
        }
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        for (n = 0; n < queryTree.getProjectionList().size(); ++n) {
            sqlExpression2 = queryTree.getProjectionList().get(n);
            if (!this.subplanList.isEmpty()) {
                sqlExpression2.rebuildExpression();
                this.checkScalarExpression(sqlExpression2.getExprString(), leaf);
            }
            if (sqlExpression2.isConstantExpr()) {
                queryTree.getFinalProjList().add(sqlExpression2);
                continue;
            }
            sqlExpression2.rebuildExpression();
            if (!sqlExpression2.containsAggregates()) {
                String string;
                String string2;
                String string3 = this.getMappedExpression(sqlExpression2);
                if (string3 != null) {
                    string2 = string3;
                    string = string3;
                } else {
                    string = this.generateColumnName(sqlExpression2.getExprString());
                    this.colMappings.put(sqlExpression2, string);
                    string2 = string;
                    SqlExpression sqlExpression3 = sqlExpression2.copy();
                    sqlExpression3.setAlias(string);
                    sqlExpression3.setTempExpr(true);
                    arrayList.add(sqlExpression3);
                }
                SqlExpression sqlExpression4 = new SqlExpression();
                sqlExpression4.setExprType(4);
                sqlExpression4.setExprString(string2);
                sqlExpression4.setAlias(sqlExpression2.getAlias());
                sqlExpression4.setExprDataType(sqlExpression2.getExprDataType());
                if (sqlExpression2.getAlias().length() == 0) {
                    if (sqlExpression2.getExprType() == 4) {
                        sqlExpression2.setAlias(sqlExpression2.getColumn().columnName);
                    } else {
                        sqlExpression2.setAlias(string);
                    }
                    sqlExpression4.setAlias(sqlExpression2.getAlias());
                }
                sqlExpression4.setTempExpr(true);
                queryTree.getFinalProjList().add(sqlExpression4);
                Leaf leaf2 = leaf;
                leaf2.getClass();
                object2 = new Leaf.Projection(leaf2, IdentifierHandler.quote(sqlExpression4.getExprString()));
                this.projectedGroupBy.add((Leaf.Projection)object2);
                continue;
            }
            sqlExpression = sqlExpression2.copy();
            this.handleProjections(sqlExpression2, sqlExpression, arrayList);
            sqlExpression.rebuildExpression();
            if (sqlExpression.getAlias().length() == 0) {
                sqlExpression.setAlias(this.generateColumnName(""));
            }
            sqlExpression2.setAggAlias(sqlExpression.getAlias());
            queryTree.getFinalProjList().add(sqlExpression);
            if (this.useSlowAggregation) continue;
            for (SqlExpression sqlExpression5 : sqlExpression.getDeferredExpressions()) {
                object = sqlExpression5.getFunctionParams().get(0).copy();
                ((SqlExpression)object).setDistinctExtraGroup(true);
                queryTree.getRootNode().getGroupByList().add((SqlExpression)object);
            }
        }
        for (n = 0; n < queryTree.getOrderByList().size(); ++n) {
            object2 = queryTree.getOrderByList().get(n);
            ((OrderByElement)object2).orderExpression.rebuildExpression();
            sqlExpression2 = null;
            boolean bl = false;
            sqlExpression2 = this.getInProjectionList(queryTree, ((OrderByElement)object2).orderExpression);
            if (sqlExpression2 != null) {
                if (sqlExpression2 == ((OrderByElement)object2).orderExpression) continue;
                object = this.getMappedExpression(sqlExpression2);
                if (object != null) {
                    ((OrderByElement)object2).orderExpression.setAlias((String)object);
                    continue;
                }
                ((OrderByElement)object2).orderExpression.setAlias(sqlExpression2.getAggAlias());
                continue;
            }
            queryTree.getProjectionList().add(((OrderByElement)object2).orderExpression);
            sqlExpression2 = ((OrderByElement)object2).orderExpression;
            sqlExpression = sqlExpression2.copy();
            this.handleProjections(sqlExpression2, sqlExpression, arrayList);
            sqlExpression.rebuildExpression();
            if (sqlExpression.getAlias().length() == 0) {
                sqlExpression.setAlias(this.generateColumnName(""));
            }
            ((OrderByElement)object2).orderExpression.setAlias(sqlExpression.getAlias());
            ((OrderByElement)object2).orderExpression.setAdded(true);
            sqlExpression.setAdded(true);
            queryTree.getFinalProjList().add(sqlExpression);
        }
        for (n = 0; n < queryTree.getHavingList().size(); ++n) {
            object2 = queryTree.getHavingList().get(n);
            this.handleHavingCond((QueryCondition)object2, arrayList);
        }
        queryTree.getRootNode().setProjectionList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHavingCond(QueryCondition queryCondition, List<SqlExpression> list) {
        if (queryCondition.getLeftCond() != null) {
            this.handleHavingCond(queryCondition.getLeftCond(), list);
        }
        if (queryCondition.getRightCond() != null) {
            this.handleHavingCond(queryCondition.getRightCond(), list);
        }
        if (queryCondition.getCondType() == 4) {
            this.handleHavingProj(queryCondition.getExpr(), list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHavingProj(SqlExpression sqlExpression, List<SqlExpression> list) {
        if (sqlExpression.getLeftExpr() != null) {
            this.handleHavingProj(sqlExpression.getLeftExpr(), list);
        }
        if (sqlExpression.getRightExpr() != null) {
            this.handleHavingProj(sqlExpression.getRightExpr(), list);
        }
        if (sqlExpression.getExprType() == 32 && sqlExpression.getFunctionId() > 0) {
            sqlExpression.rebuildExpression();
            SqlExpression sqlExpression2 = sqlExpression.copy();
            this.handleProjections(sqlExpression, sqlExpression2, list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleProjections(SqlExpression sqlExpression, SqlExpression sqlExpression2, List<SqlExpression> list) {
        if (sqlExpression.getExprType() == 16 || sqlExpression.getExprType() == 8) {
            SqlExpression sqlExpression3;
            if (sqlExpression.getLeftExpr() != null) {
                sqlExpression3 = sqlExpression.getLeftExpr().copy();
                sqlExpression2.setLeftExpr(sqlExpression3);
                sqlExpression3.rebuildExpression();
                this.handleProjections(sqlExpression.getLeftExpr(), sqlExpression3, list);
            }
            if (sqlExpression.getRightExpr() != null) {
                sqlExpression3 = sqlExpression.getRightExpr().copy();
                sqlExpression2.setRightExpr(sqlExpression3);
                sqlExpression3.rebuildExpression();
                this.handleProjections(sqlExpression.getRightExpr(), sqlExpression3, list);
            }
        } else if (sqlExpression.getExprType() == 128) {
            for (QueryCondition queryCondition : QueryCondition.getNodes(sqlExpression.getQueryCondition(), 4)) {
                SqlExpression sqlExpression4 = queryCondition.getExpr().copy();
                queryCondition.setExpr(sqlExpression4);
                sqlExpression4.rebuildExpression();
                this.handleProjections(queryCondition.getExpr(), sqlExpression4, list);
            }
            sqlExpression2.setQueryCondition(sqlExpression.getQueryCondition());
        } else if (sqlExpression.getExprType() == 256) {
            SqlExpression.SCase sCase = sqlExpression2.new SqlExpression.SCase();
            for (Map.Entry<QueryCondition, SqlExpression> object : sqlExpression.getCaseConstruct().getCases().entrySet()) {
                for (QueryCondition queryCondition : QueryCondition.getNodes(object.getKey(), 4)) {
                    SqlExpression sqlExpression3 = queryCondition.getExpr().copy();
                    sqlExpression3.rebuildExpression();
                    this.handleProjections(queryCondition.getExpr(), sqlExpression3, list);
                    queryCondition.setExpr(sqlExpression3);
                }
                SqlExpression sqlExpression4 = object.getValue().copy();
                sqlExpression4.rebuildExpression();
                this.handleProjections(object.getValue(), sqlExpression4, list);
                sCase.addCase(object.getKey(), sqlExpression4);
            }
            SqlExpression sqlExpression7 = sqlExpression.getCaseConstruct().getDefaultexpr();
            if (sqlExpression7 != null) {
                SqlExpression sqlExpression9 = sqlExpression7.copy();
                sCase.setDefaultexpr(sqlExpression9);
                sqlExpression9.rebuildExpression();
                this.handleProjections(sqlExpression7, sqlExpression9, list);
            }
            sqlExpression2.setCaseConstruct(sCase);
        } else if (sqlExpression.getExprType() == 32) {
            if (sqlExpression.getFunctionId() == 76 || sqlExpression.getFunctionId() == 77) {
                if (sqlExpression.isDistinctGroupFunction() && !sqlExpression.isDistinctGroupFunctionOnPartitionedCol(this.database)) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 77, "COUNT", true);
                } else {
                    this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 82, "SUM");
                }
            } else if (sqlExpression.getFunctionId() == 82) {
                if (sqlExpression.isDistinctGroupFunction() && !sqlExpression.isDistinctGroupFunctionOnPartitionedCol(this.database)) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 82, "SUM", true);
                } else {
                    this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 82, "SUM");
                }
            } else if (sqlExpression.getFunctionId() == 75) {
                if (sqlExpression.isDistinctGroupFunction() && !sqlExpression.isDistinctGroupFunctionOnPartitionedCol(this.database)) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 75, "AVG", true);
                } else {
                    this.makeAvgExpression(sqlExpression, list, sqlExpression2);
                }
                this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
            } else if (sqlExpression.getFunctionId() == 78) {
                if (sqlExpression.isDistinctGroupFunction()) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 75, "STDDEV", true);
                    this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
                } else {
                    this.makeStddevExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString());
                }
            } else if (sqlExpression.getFunctionId() == 79) {
                if (sqlExpression.isDistinctGroupFunction()) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 75, "VARIANCE", true);
                    this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
                } else {
                    this.makeVarianceExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString());
                }
            } else if (sqlExpression.getFunctionId() == 174) {
                this.makeRegrCountExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 172) {
                this.makeRegrAvgxExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 173) {
                this.makeRegrAvgxExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(1).getExprString(), sqlExpression.getFunctionParams().get(0).getExprString());
            } else if (sqlExpression.getFunctionId() == 178) {
                this.makeRegrSxxExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 180) {
                this.makeRegrSxxExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(1).getExprString(), sqlExpression.getFunctionParams().get(0).getExprString());
            } else if (sqlExpression.getFunctionId() == 179) {
                this.makeRegrSxyExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 176) {
                this.makeRegrR2Expression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 177) {
                this.makeRegrSlopeExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 175) {
                this.makeRegrInterceptExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 183) {
                this.makeVarPopExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString());
            } else if (sqlExpression.getFunctionId() == 170) {
                this.makeCovarPopExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 171) {
                this.makeCovarSampExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 169) {
                this.makeCorrExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString(), sqlExpression.getFunctionParams().get(1).getExprString());
            } else if (sqlExpression.getFunctionId() == 181) {
                this.makeStddevPopExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString());
            } else if (sqlExpression.getFunctionId() == 184) {
                this.makeVarSampExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString());
            } else if (sqlExpression.getFunctionId() == 182) {
                this.makeStddevSampExpression(sqlExpression, list, sqlExpression2, sqlExpression.getFunctionParams().get(0).getExprString());
            } else if (sqlExpression.getFunctionId() == 80) {
                this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 80, "MAX");
            } else if (sqlExpression.getFunctionId() == 81) {
                this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 81, "MIN");
            } else if (sqlExpression.getFunctionId() == 165) {
                this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 165, "BIT_OR");
            } else if (sqlExpression.getFunctionId() == 164) {
                if (sqlExpression.isDistinctGroupFunction() && !sqlExpression.isDistinctGroupFunctionOnPartitionedCol(this.database)) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 164, "BIT_AND", true);
                } else {
                    this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 164, "BIT_AND");
                }
            } else if (sqlExpression.getFunctionId() == 167) {
                this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 167, "BOOL_OR");
            } else if (sqlExpression.getFunctionId() == 166) {
                if (sqlExpression.isDistinctGroupFunction()) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 166, "BOOL_AND", true);
                } else {
                    this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 166, "BOOL_AND");
                }
            } else if (sqlExpression.getFunctionId() == 168) {
                if (sqlExpression.isDistinctGroupFunction()) {
                    this.handleProjectionAddStepDeferred(sqlExpression, sqlExpression2, list, 168, "EVERY", true);
                } else {
                    this.handleProjectionAddStep(sqlExpression, sqlExpression2, list, 168, "EVERY");
                }
            } else {
                for (int i = 0; i < sqlExpression.getFunctionParams().size(); ++i) {
                    SqlExpression sqlExpression8 = sqlExpression.getFunctionParams().get(i);
                    SqlExpression sqlExpression5 = sqlExpression8.copy();
                    sqlExpression2.getFunctionParams().set(i, sqlExpression5);
                    sqlExpression5.rebuildExpression();
                    this.handleProjections(sqlExpression8, sqlExpression5, list);
                }
            }
        } else if (sqlExpression.getExprType() != 2) {
            list.add(sqlExpression);
        }
    }

    private void handleProjectionAddStep(SqlExpression sqlExpression, SqlExpression sqlExpression2, List<SqlExpression> list, int n, String string) {
        SqlExpression sqlExpression3 = sqlExpression.copy();
        String string2 = this.generateColumnName(sqlExpression3.getExprString());
        sqlExpression3.setExprString(sqlExpression.getExprString());
        sqlExpression3.setAlias(string2);
        sqlExpression3.setTempExpr(true);
        list.add(sqlExpression3);
        sqlExpression2.setFunctionId(n);
        sqlExpression2.setFunctionName(string);
        sqlExpression2.setExprString(string + "(" + IdentifierHandler.quote(string2) + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void handleProjectionAddStepDeferred(SqlExpression sqlExpression, SqlExpression sqlExpression2, List<SqlExpression> list, int n, String string, boolean bl) {
        SqlExpression sqlExpression3 = sqlExpression.getFunctionParams().get(0);
        String string2 = this.generateColumnName(sqlExpression3.getExprString());
        sqlExpression3.setAlias(string2);
        sqlExpression3.setTempExpr(true);
        list.add(sqlExpression3);
        sqlExpression2.setFunctionId(n);
        sqlExpression2.setFunctionName(string);
        sqlExpression2.setExprString(string + "(" + (bl ? "DISTINCT " : "") + IdentifierHandler.quote(string2) + ")");
        sqlExpression2.setTempExpr(true);
        sqlExpression2.setDeferredGroup(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void trackTable(String string, Leaf leaf) {
        if (string != null && string.indexOf(Props.XDB_TEMPTABLEPREFIX) == 0) {
            this.topQueryPlan.tempTableLastUsedAt.put(string, leaf);
        }
    }

    private String getMappedExpression(SqlExpression sqlExpression) {
        sqlExpression.rebuildExpression();
        String string = ParseCmdLine.replace(sqlExpression.getExprString(), " ", "");
        for (Map.Entry<SqlExpression, String> entry : this.colMappings.entrySet()) {
            SqlExpression sqlExpression2 = entry.getKey();
            sqlExpression2.rebuildExpression();
            String string2 = ParseCmdLine.replace(sqlExpression2.getExprString(), " ", "");
            if (string.compareTo(string2) != 0) continue;
            return entry.getValue();
        }
        return null;
    }

    private ColumnMetaData getColumnMetaData(SqlExpression sqlExpression) {
        String string;
        if (sqlExpression.getMappedExpression() != null) {
            return this.getColumnMetaData(sqlExpression.getMappedExpression());
        }
        String string2 = null;
        String string3 = string = sqlExpression.getAggAlias() == null || sqlExpression.getAggAlias().length() == 0 ? sqlExpression.getAlias() : sqlExpression.getAggAlias();
        if (sqlExpression.getProjectionLabel() != null) {
            string = sqlExpression.getProjectionLabel();
        }
        int n = sqlExpression.getExprDataType().type;
        int n2 = sqlExpression.getExprDataType().length;
        int n3 = sqlExpression.getExprDataType().precision;
        int n4 = sqlExpression.getExprDataType().scale;
        String string4 = null;
        short s = 0;
        s = 193;
        if (n == -5 || n == 3 || n == 8 || n == 6 || n == 4 || n == 2 || n == 7 || n == 5 || n == -6) {
            s = (short)(s | 8);
        }
        if (sqlExpression.getExprType() == 4) {
            try {
                SysColumn sysColumn = sqlExpression.getColumn().getSysColumn(this.database);
                if (!sysColumn.isNullable()) {
                    s = (short)(s & 0xFFFFFFFE);
                }
                if (sysColumn.isSerial()) {
                    s = (short)(s | 0x20);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new ColumnMetaData(string2, string, n2, n, n3, n4, string4, s, true);
    }

    public ColumnMetaData[] getMetaData() {
        return this.columnMetaData;
    }

    public void setSingleQueryNode(int n) {
        DBNode dBNode = this.database.getDBNode(n);
        this.queryNodeTable = new HashMap<Integer, DBNode>();
        this.queryNodeTable.put(n, dBNode);
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    public SysTable getIntoTable() {
        return this.intoTable;
    }

    public SyncCreateTable getSyncCreateTable() {
        return this.syncCreateTable;
    }

    public String getIntoTableReferenceName() {
        return this.intoTableRefName;
    }

    public int getCurrentOuterCounter() {
        return this.topQueryPlan.outerCounter;
    }

    public int incrementOuterCounter() {
        return this.topQueryPlan.outerCounter++;
    }

    protected SysDatabase getSysDatabase() {
        return this.database;
    }

    private void makeVarPopExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string) {
        SqlExpression sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string + ") END)");
        sqlExpression3.setTempExpr(true);
        String string2 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string2);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE " + string + " END)");
        sqlExpression3.setTempExpr(true);
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string3);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE " + 1 + " END)");
        sqlExpression3.setTempExpr(true);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string4);
        list.add(sqlExpression3);
        sqlExpression2.setExprType(16);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string2) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression6.setExprString("CASE WHEN SUM(" + IdentifierHandler.quote(string4) + ") = 0 THEN NULL " + "ELSE SUM(" + IdentifierHandler.quote(string4) + ") END");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression7.setExprString("POWER(SUM(" + IdentifierHandler.quote(string3) + "), 2)");
        sqlExpression3 = SqlExpression.createNewTempOpExpression("/", sqlExpression7, sqlExpression6);
        sqlExpression3.setExprString("(" + sqlExpression7.getExprString() + " / " + sqlExpression6.getExprString() + ")");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("-", sqlExpression4, sqlExpression3);
        sqlExpression8.setExprString("(" + sqlExpression4.getExprString() + " - " + sqlExpression3.getExprString() + ")");
        sqlExpression2.setLeftExpr(sqlExpression8);
        sqlExpression2.setRightExpr(sqlExpression6);
        sqlExpression2.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression6.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeVarPopExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        SqlExpression sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string + ") END)");
        sqlExpression3.setTempExpr(true);
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string3);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE " + string + " END)");
        sqlExpression3.setTempExpr(true);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string4);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE " + 1 + " END)");
        sqlExpression3.setTempExpr(true);
        String string5 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string5);
        list.add(sqlExpression3);
        sqlExpression2.setExprType(16);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string4) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression6.setExprString("CASE WHEN SUM(" + IdentifierHandler.quote(string5) + ") = 0 THEN NULL " + "ELSE SUM(" + IdentifierHandler.quote(string5) + ") END");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression7.setExprString("POWER(SUM(" + IdentifierHandler.quote(string4) + "), 2)");
        sqlExpression3 = SqlExpression.createNewTempOpExpression("/", sqlExpression7, sqlExpression6);
        sqlExpression3.setExprString("(" + sqlExpression7.getExprString() + " / " + sqlExpression6.getExprString() + ")");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("-", sqlExpression4, sqlExpression3);
        sqlExpression8.setExprString("(" + sqlExpression4.getExprString() + " - " + sqlExpression3.getExprString() + ")");
        sqlExpression2.setLeftExpr(sqlExpression8);
        sqlExpression2.setRightExpr(sqlExpression6);
        sqlExpression2.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression6.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeCovarPopExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string2 + " ) END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string3);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " ) END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string4);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        String string5 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " ) END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string5);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        String string6 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string6);
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string4) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression6.setExprString("SUM(" + IdentifierHandler.quote(string5) + ")");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression7.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string6) + ") = 0 THEN NULL ELSE SUM(" + IdentifierHandler.quote(string6) + ") END)");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("*", sqlExpression5, sqlExpression6);
        sqlExpression8.setExprString("(" + sqlExpression5.getExprString() + " * " + sqlExpression6.getExprString() + ")");
        SqlExpression sqlExpression9 = SqlExpression.createNewTempOpExpression("/", sqlExpression8, sqlExpression7);
        sqlExpression9.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression10 = SqlExpression.createNewTempOpExpression("-", sqlExpression6, sqlExpression9);
        sqlExpression10.setExprString("(" + sqlExpression4.getExprString() + " - (" + sqlExpression9.getExprString() + "))");
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setLeftExpr(sqlExpression10);
        sqlExpression2.setRightExpr(sqlExpression7);
        sqlExpression2.setExprString("((" + sqlExpression10.getExprString() + ") / " + sqlExpression7.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeCorrExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string2 + " ) END)");
        sqlExpression3.setAlias(string3);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " ) END)");
        sqlExpression3.setAlias(string4);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string5 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " ) END)");
        sqlExpression3.setAlias(string5);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string6 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setAlias(string6);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        String string7 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string + " ) END)");
        sqlExpression3.setAlias(string7);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        String string8 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " * " + string2 + " ) END)");
        sqlExpression3.setAlias(string8);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string4) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression6.setExprString("SUM(" + IdentifierHandler.quote(string5) + ")");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression7.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string6) + ") = 0 THEN NULL ELSE SUM(" + IdentifierHandler.quote(string6) + ") END)");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("*", sqlExpression5, sqlExpression6);
        sqlExpression8.setExprString("(" + sqlExpression5.getExprString() + " * " + sqlExpression6.getExprString() + ")");
        SqlExpression sqlExpression9 = SqlExpression.createNewTempOpExpression("/", sqlExpression8, sqlExpression7);
        sqlExpression9.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression10 = SqlExpression.createNewTempOpExpression("-", sqlExpression9, sqlExpression6);
        sqlExpression10.setExprString("(" + sqlExpression4.getExprString() + " - (" + sqlExpression9.getExprString() + "))");
        SqlExpression sqlExpression11 = SqlExpression.createNewTempOpExpression("/", sqlExpression10, sqlExpression7);
        sqlExpression11.setExprString("(" + sqlExpression10.getExprString() + ") / " + sqlExpression7.getExprString());
        SqlExpression sqlExpression12 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression12.setExprString("SUM(" + IdentifierHandler.quote(string7) + ")");
        SqlExpression sqlExpression13 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression13.setExprString("POWER(SUM(" + IdentifierHandler.quote(string5) + "), 2)");
        sqlExpression3 = SqlExpression.createNewTempOpExpression("/", sqlExpression13, sqlExpression7);
        sqlExpression3.setExprString("(" + sqlExpression13.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression14 = SqlExpression.createNewTempOpExpression("-", sqlExpression12, sqlExpression3);
        sqlExpression14.setExprString("(" + sqlExpression12.getExprString() + " - " + sqlExpression3.getExprString() + ")");
        SqlExpression sqlExpression15 = SqlExpression.createNewTempOpExpression("/", sqlExpression14, sqlExpression7);
        sqlExpression15.setExprString("(" + sqlExpression14.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression16 = SqlExpression.createNewTempFunction("SQRT", 90);
        sqlExpression16.setExprString("SQRT(" + sqlExpression15.getExprString() + ")");
        SqlExpression sqlExpression17 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression17.setExprString("SUM(" + IdentifierHandler.quote(string8) + ")");
        sqlExpression13 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression13.setExprString("POWER(SUM(" + IdentifierHandler.quote(string4) + "), 2)");
        sqlExpression3 = SqlExpression.createNewTempOpExpression("/", sqlExpression13, sqlExpression7);
        sqlExpression3.setExprString("(" + sqlExpression13.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        sqlExpression14 = SqlExpression.createNewTempOpExpression("-", sqlExpression17, sqlExpression3);
        sqlExpression14.setExprString("(" + sqlExpression17.getExprString() + " - " + sqlExpression3.getExprString() + ")");
        SqlExpression sqlExpression18 = SqlExpression.createNewTempOpExpression("/", sqlExpression14, sqlExpression7);
        sqlExpression18.setExprString("(" + sqlExpression14.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression19 = SqlExpression.createNewTempFunction("SQRT", 90);
        sqlExpression19.setExprString("SQRT(" + sqlExpression18.getExprString() + ")");
        SqlExpression sqlExpression20 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression20.setExprString("CASE WHEN (" + sqlExpression16.getExprString() + " * " + sqlExpression19.getExprString() + ") = 0 THEN NULL ELSE " + "(" + sqlExpression16.getExprString() + " * " + sqlExpression19.getExprString() + ") END");
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setLeftExpr(sqlExpression11);
        sqlExpression2.setRightExpr(sqlExpression20);
        sqlExpression2.setExprString("(" + sqlExpression11.getExprString() + "/" + sqlExpression20.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeStddevPopExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string) {
        SqlExpression sqlExpression3 = new SqlExpression();
        this.makeVarPopExpression(sqlExpression, list, sqlExpression3, string);
        sqlExpression2.setExprType(32);
        sqlExpression2.setExprString("SQRT(" + sqlExpression3.getExprString() + ")");
        sqlExpression2.getFunctionParams().add(sqlExpression3);
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrCountExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string3);
        list.add(sqlExpression3);
        sqlExpression2.setExprType(32);
        sqlExpression2.setFunctionId(256);
        sqlExpression2.setFunctionName("CASE");
        sqlExpression2.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string3) + ") IS NULL THEN 0 " + "ELSE SUM(" + IdentifierHandler.quote(string3) + ") END)");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrSxxExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        SqlExpression sqlExpression3 = new SqlExpression();
        this.makeRegrCountExpression(sqlExpression, list, sqlExpression3, string, string2);
        SqlExpression sqlExpression4 = new SqlExpression();
        this.makeVarPopExpression(sqlExpression, list, sqlExpression4, string2, string);
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("*");
        sqlExpression2.setLeftExpr(sqlExpression3);
        sqlExpression2.setRightExpr(sqlExpression4);
        sqlExpression2.setExprString("(" + sqlExpression3.getExprString() + " * " + sqlExpression4.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrSxyExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string3);
        list.add(sqlExpression3);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3 = sqlExpression.copy();
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string2 + " ) END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string4);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        String string5 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " ) END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string5);
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        String string6 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprType(32);
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " ) END)");
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setAlias(string6);
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression4.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string3) + ") = 0 THEN NULL ELSE SUM(" + IdentifierHandler.quote(string3) + ") END)");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string4) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression6.setExprString("SUM(" + IdentifierHandler.quote(string5) + ")");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression7.setExprString("SUM(" + IdentifierHandler.quote(string6) + ")");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("*", sqlExpression6, sqlExpression7);
        sqlExpression8.setExprString("(" + sqlExpression6.getExprString() + " * " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression9 = SqlExpression.createNewTempOpExpression("/", sqlExpression8, sqlExpression4);
        sqlExpression9.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression4.getExprString() + ")");
        SqlExpression sqlExpression10 = SqlExpression.createNewTempOpExpression("-", sqlExpression5, sqlExpression9);
        sqlExpression10.setExprString("(" + sqlExpression5.getExprString() + " - (" + sqlExpression9.getExprString() + "))");
        SqlExpression sqlExpression11 = SqlExpression.createNewTempOpExpression("/", sqlExpression10, sqlExpression4);
        sqlExpression11.setExprString("(" + sqlExpression10.getExprString() + ") / " + sqlExpression4.getExprString());
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("*");
        sqlExpression2.setLeftExpr(sqlExpression4);
        sqlExpression2.setRightExpr(sqlExpression11);
        sqlExpression2.setExprString("(" + sqlExpression4.getExprString() + " * " + sqlExpression11.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrR2Expression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        SqlExpression sqlExpression3 = new SqlExpression();
        this.makeVarPopExpression(sqlExpression, list, sqlExpression3, string2, string);
        SqlExpression sqlExpression4 = new SqlExpression();
        this.makeVarPopExpression(sqlExpression, list, sqlExpression4, string, string2);
        SqlExpression sqlExpression5 = new SqlExpression();
        this.makeCorrExpression(sqlExpression, list, sqlExpression5, string, string2);
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression6.setExprString("POWER(" + sqlExpression5.getExprString() + ", 2)");
        sqlExpression2.setExprType(256);
        sqlExpression2.setFunctionName("CASE");
        sqlExpression2.setFunctionId(86);
        sqlExpression2.setExprString("(CASE WHEN " + sqlExpression3.getExprString() + " = 0 THEN NULL " + "WHEN " + sqlExpression3.getExprString() + " != 0 AND " + sqlExpression4.getExprString() + " = 0 THEN 1 " + "ELSE " + sqlExpression6.getExprString() + " END)");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrSlopeExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string2 + " ) END)");
        sqlExpression3.setAlias(string3);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " ) END)");
        sqlExpression3.setAlias(string4);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string5 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " ) END)");
        sqlExpression3.setAlias(string5);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string6 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setAlias(string6);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        String string7 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " * " + string2 + " ) END)");
        sqlExpression3.setAlias(string7);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string4) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression6.setExprString("SUM(" + IdentifierHandler.quote(string5) + ")");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression7.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string6) + ") = 0 THEN NULL ELSE SUM(" + IdentifierHandler.quote(string6) + ") END)");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("*", sqlExpression5, sqlExpression6);
        sqlExpression8.setExprString("(" + sqlExpression5.getExprString() + " * " + sqlExpression6.getExprString() + ")");
        SqlExpression sqlExpression9 = SqlExpression.createNewTempOpExpression("/", sqlExpression8, sqlExpression7);
        sqlExpression9.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression10 = SqlExpression.createNewTempOpExpression("-", sqlExpression6, sqlExpression9);
        sqlExpression10.setExprString("(" + sqlExpression4.getExprString() + " - (" + sqlExpression9.getExprString() + "))");
        SqlExpression sqlExpression11 = SqlExpression.createNewTempOpExpression("/", sqlExpression10, sqlExpression7);
        sqlExpression11.setExprString("(" + sqlExpression10.getExprString() + ") / " + sqlExpression7.getExprString());
        SqlExpression sqlExpression12 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression12.setExprString("SUM(" + IdentifierHandler.quote(string7) + ")");
        SqlExpression sqlExpression13 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression13.setExprString("POWER(SUM(" + IdentifierHandler.quote(string4) + "), 2)");
        sqlExpression3 = SqlExpression.createNewTempOpExpression("/", sqlExpression13, sqlExpression7);
        sqlExpression3.setExprString("(" + sqlExpression13.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression14 = SqlExpression.createNewTempOpExpression("-", sqlExpression12, sqlExpression3);
        sqlExpression14.setExprString("(" + sqlExpression12.getExprString() + " - " + sqlExpression3.getExprString() + ")");
        SqlExpression sqlExpression15 = SqlExpression.createNewTempOpExpression("/", sqlExpression14, sqlExpression7);
        sqlExpression15.setExprString("(" + sqlExpression14.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setLeftExpr(sqlExpression11);
        sqlExpression2.setRightExpr(sqlExpression15);
        sqlExpression2.setExprString("(" + sqlExpression11.getExprString() + "/" + "(CASE WHEN SUM(" + IdentifierHandler.quote(string7) + ") = " + "((SUM(" + IdentifierHandler.quote(string4) + ") * SUM(" + IdentifierHandler.quote(string4) + "))/(CASE WHEN SUM(" + IdentifierHandler.quote(string6) + ") = 0 THEN NULL " + "ELSE SUM(" + IdentifierHandler.quote(string6) + ") END)) THEN NULL ELSE " + sqlExpression15.getExprString() + " END ))");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeAvgExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2) {
        SqlExpression sqlExpression3 = sqlExpression.copy();
        String string = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setFunctionId(82);
        sqlExpression3.setFunctionName("SUM");
        sqlExpression3.setExprString(ParseCmdLine.replace(sqlExpression3.getExprString(), "AVG", "SUM"));
        sqlExpression3.setAlias(string);
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setExprDataType(FunctionAnalysis.analyzeSumParameter(sqlExpression, this.database));
        list.add(sqlExpression3);
        sqlExpression3 = sqlExpression.copy();
        String string2 = this.generateColumnName(sqlExpression3.getExprString());
        sqlExpression3.setFunctionId(76);
        sqlExpression3.setFunctionName("COUNT");
        sqlExpression3.setExprString(ParseCmdLine.replace(sqlExpression3.getExprString(), "AVG", "COUNT"));
        sqlExpression3.setAlias(string2);
        sqlExpression3.setTempExpr(true);
        sqlExpression3.setExprDataType(FunctionAnalysis.analyzeCountParameter(sqlExpression));
        list.add(sqlExpression3);
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setExprString("(SUM(" + IdentifierHandler.quote(string) + ") / SUM(" + IdentifierHandler.quote(string2) + "))");
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(" + IdentifierHandler.quote(string) + ")");
        sqlExpression2.setLeftExpr(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(" + IdentifierHandler.quote(string2) + ")");
        sqlExpression2.setRightExpr(sqlExpression3);
        sqlExpression2.setTempExpr(true);
    }

    private void makeAvgExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " ) END)");
        sqlExpression3.setAlias(string3);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string4 = this.generateColumnName(sqlExpression3.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setAlias(string4);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression5.setExprString("CASE WHEN SUM(" + IdentifierHandler.quote(string4) + ") = 0 THEN NULL " + "ELSE SUM(" + IdentifierHandler.quote(string4) + ") END");
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setLeftExpr(sqlExpression4);
        sqlExpression2.setRightExpr(sqlExpression5);
        sqlExpression2.setExprString("(" + sqlExpression4.getExprString() + "/" + sqlExpression5.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrInterceptExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        SqlExpression sqlExpression3 = new SqlExpression();
        this.makeAvgExpression(sqlExpression, list, sqlExpression3, string, string2);
        SqlExpression sqlExpression4 = new SqlExpression();
        this.makeAvgExpression(sqlExpression, list, sqlExpression4, string2, string);
        SqlExpression sqlExpression5 = new SqlExpression();
        this.makeRegrSlopeExpression(sqlExpression, list, sqlExpression5, string, string2);
        SqlExpression sqlExpression6 = SqlExpression.createNewTempOpExpression("*", sqlExpression5, sqlExpression4);
        sqlExpression6.setExprString(sqlExpression5.getExprString() + " * " + sqlExpression4.getExprString());
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("-");
        sqlExpression2.setLeftExpr(sqlExpression3);
        sqlExpression2.setRightExpr(sqlExpression6);
        sqlExpression2.setExprString("(" + sqlExpression3.getExprString() + "-" + sqlExpression6.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeVarSampExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string) {
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string + ") END)");
        String string2 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string2);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE " + string + " END)");
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string3);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE " + 1 + " END)");
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string4);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression2.setExprType(16);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string2) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression6.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string4) + ") = 0 OR (SUM(" + IdentifierHandler.quote(string4) + ") - 1) = 0 THEN NULL ELSE SUM(" + IdentifierHandler.quote(string4) + ") END)");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("POWER", 49);
        sqlExpression7.setExprString("POWER(SUM(" + IdentifierHandler.quote(string3) + "), 2)");
        sqlExpression3 = SqlExpression.createNewTempOpExpression("/", sqlExpression7, sqlExpression6);
        sqlExpression3.setExprString("(" + sqlExpression7.getExprString() + " / " + sqlExpression6.getExprString() + ")");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("-", sqlExpression4, sqlExpression3);
        sqlExpression8.setExprString("(" + sqlExpression4.getExprString() + " - " + sqlExpression3.getExprString() + ")");
        SqlExpression sqlExpression9 = new SqlExpression();
        sqlExpression9.setExprType(2);
        sqlExpression9.setConstantValue("1");
        SqlExpression sqlExpression10 = SqlExpression.createNewTempOpExpression("-", sqlExpression6, sqlExpression9);
        sqlExpression10.setExprString("(" + sqlExpression6.getExprString() + " - " + sqlExpression9.getConstantValue() + ")");
        sqlExpression2.setLeftExpr(sqlExpression8);
        sqlExpression2.setRightExpr(sqlExpression10);
        sqlExpression2.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression10.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeVarianceExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string) {
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE " + 1 + " END)");
        String string2 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setAlias(string2);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string2) + ")");
        SqlExpression sqlExpression5 = new SqlExpression();
        this.makeVarSampExpression(sqlExpression, list, sqlExpression5, string);
        sqlExpression2.setFunctionId(86);
        sqlExpression2.setFunctionName("CASE");
        sqlExpression2.setExprString("(CASE WHEN " + sqlExpression4.getExprString() + " = 1 " + "THEN 0 ELSE " + sqlExpression5.getExprString() + " END)");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeStddevSampExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string) {
        SqlExpression sqlExpression3 = new SqlExpression();
        this.makeVarSampExpression(sqlExpression, list, sqlExpression3, string);
        sqlExpression2.setExprString("SQRT(" + sqlExpression3.getExprString() + ")");
        sqlExpression2.getFunctionParams().add(sqlExpression3);
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeStddevExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string) {
        SqlExpression sqlExpression3 = new SqlExpression();
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(CASE WHEN " + string + " IS NULL THEN 0 " + "ELSE " + 1 + " END)");
        sqlExpression4.setExprDataType(sqlExpression.getExprDataType());
        String string2 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression4.setAlias(string2);
        list.add(sqlExpression4);
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string2) + ")");
        this.makeVarianceExpression(sqlExpression, list, sqlExpression3, string);
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("SQRT", 90);
        sqlExpression6.setExprString("SQRT(" + sqlExpression3.getExprString() + ")");
        sqlExpression2.setFunctionId(86);
        sqlExpression2.setFunctionName("CASE");
        sqlExpression2.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string2) + ") = 1 " + "THEN 0 ELSE " + sqlExpression6.getExprString() + " END)");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeCovarSampExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " * " + string2 + " ) END)");
        sqlExpression3.setAlias(string3);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string2 + " ) END)");
        sqlExpression3.setAlias(string4);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string5 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE (" + string + " ) END)");
        sqlExpression3.setAlias(string5);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        String string6 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setAlias(string6);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression5.setExprString("SUM(" + IdentifierHandler.quote(string4) + ")");
        SqlExpression sqlExpression6 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression6.setExprString("SUM(" + IdentifierHandler.quote(string5) + ")");
        SqlExpression sqlExpression7 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression7.setExprString("(CASE WHEN SUM(" + IdentifierHandler.quote(string6) + ") = 0 OR (SUM(" + IdentifierHandler.quote(string6) + ") - 1) = 0 THEN NULL ELSE SUM(" + IdentifierHandler.quote(string6) + ") END)");
        SqlExpression sqlExpression8 = SqlExpression.createNewTempOpExpression("*", sqlExpression5, sqlExpression6);
        sqlExpression8.setExprString(sqlExpression5.getExprString() + " * " + sqlExpression6.getExprString());
        SqlExpression sqlExpression9 = SqlExpression.createNewTempOpExpression("/", sqlExpression8, sqlExpression7);
        sqlExpression9.setExprString("(" + sqlExpression8.getExprString() + " / " + sqlExpression7.getExprString() + ")");
        SqlExpression sqlExpression10 = SqlExpression.createNewTempOpExpression("-", sqlExpression4, sqlExpression9);
        sqlExpression10.setExprString("(" + sqlExpression4.getExprString() + " - " + sqlExpression9.getExprString() + ")");
        SqlExpression sqlExpression11 = new SqlExpression();
        sqlExpression11.setExprType(16);
        sqlExpression11.setOperator("-");
        sqlExpression11.setExprString("(" + sqlExpression7.getExprString() + " - 1)");
        sqlExpression11.setTempExpr(true);
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setLeftExpr(sqlExpression10);
        sqlExpression2.setRightExpr(sqlExpression11);
        sqlExpression2.setExprString("(" + sqlExpression10.getExprString() + " / " + sqlExpression11.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    private void makeRegrAvgxExpression(SqlExpression sqlExpression, List<SqlExpression> list, SqlExpression sqlExpression2, String string, String string2) {
        String string3 = this.generateColumnName(sqlExpression.getExprString());
        SqlExpression sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE " + string2 + " END)");
        sqlExpression3.setAlias(string3);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        String string4 = this.generateColumnName(sqlExpression.getExprString());
        sqlExpression3 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression3.setExprString("SUM(CASE WHEN " + string + " IS NULL OR " + string2 + " IS NULL THEN 0 " + "ELSE 1 END)");
        sqlExpression3.setAlias(string4);
        sqlExpression3.setExprDataType(sqlExpression.getExprDataType());
        list.add(sqlExpression3);
        SqlExpression sqlExpression4 = SqlExpression.createNewTempFunction("SUM", 82);
        sqlExpression4.setExprString("SUM(" + IdentifierHandler.quote(string3) + ")");
        SqlExpression sqlExpression5 = SqlExpression.createNewTempFunction("CASE", 86);
        sqlExpression5.setExprString("CASE WHEN SUM(" + IdentifierHandler.quote(string4) + ") = 0 THEN NULL " + "ELSE SUM(" + IdentifierHandler.quote(string4) + ") END");
        sqlExpression2.setExprType(16);
        sqlExpression2.setOperator("/");
        sqlExpression2.setLeftExpr(sqlExpression4);
        sqlExpression2.setRightExpr(sqlExpression5);
        sqlExpression2.setExprString("(" + sqlExpression4.getExprString() + "/" + sqlExpression5.getExprString() + ")");
        sqlExpression2.setTempExpr(true);
        this.colMappings.put(sqlExpression, sqlExpression2.getExprString());
    }

    public Leaf getLastLeaf() {
        if (this.leaves == null) {
            return null;
        }
        return this.leaves.get(this.leaves.size() - 1);
    }

    public Leaf getFirstLeaf() {
        if (this.leaves == null) {
            return null;
        }
        return this.leaves.get(0);
    }

    public boolean isExistingInto() {
        return this.isExistingInto;
    }
}

