/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.AbstractConstraintChecker;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysConstraint;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateForeignReferenceChecker
extends AbstractConstraintChecker {
    private static final XLogger logger = XLogger.getLogger(UpdateForeignReferenceChecker.class);
    private static final String TABLE_ALIAS1 = "t1";
    private static final String TABLE_ALIAS2 = "t2";
    private static final String TABLE_ALIAS3 = "t3";

    public UpdateForeignReferenceChecker(SysTable sysTable, XDBSessionContext xDBSessionContext) {
        super(sysTable, xDBSessionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<SysColumn> scanConstraints(Collection<SysColumn> collection, Collection collection2) {
        try {
            HashSet hashSet = new HashSet();
            Vector<SysReference> vector = this.targetTable.getSysReferences();
            for (SysReference sysReference : vector) {
                if (!sysReference.getDistributedCheck()) continue;
                boolean bl = false;
                HashSet<SysColumn> hashSet2 = new HashSet<SysColumn>();
                Vector vector2 = sysReference.getForeignKeys();
                for (SysForeignKey sysForeignKey : vector2) {
                    SysColumn sysColumn = this.targetTable.getSysColumn(sysForeignKey.getRefcolid());
                    if (collection.contains(sysColumn)) {
                        bl = true;
                        continue;
                    }
                    hashSet2.add(sysColumn);
                }
                if (!bl) continue;
                collection2.add(sysReference);
                hashSet.addAll(hashSet2);
            }
            HashSet hashSet3 = hashSet;
            Object var14_13 = null;
            return hashSet3;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<IExecutable, AbstractConstraintChecker.ViolationCriteria> prepareConstraint(Object object) throws Exception {
        try {
            Object object2;
            Object object422;
            SysConstraint sysConstraint = ((SysReference)object).getConstraint();
            AbstractConstraintChecker.ViolationCriteria violationCriteria = new AbstractConstraintChecker.ViolationCriteria();
            violationCriteria.violationType = 2;
            violationCriteria.message = sysConstraint.toString();
            SysTable sysTable = sysConstraint.getSysTable();
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            Vector vector = ((SysReference)object).getForeignKeys();
            for (Object object422 : vector) {
                SysColumn object32 = sysTable.getSysColumn(((SysForeignKey)object422).getColid());
                object2 = this.targetTable.getSysColumn(((SysForeignKey)object422).getRefcolid());
                stringBuffer.append(TABLE_ALIAS1).append(".");
                stringBuffer.append(object32.getColName()).append("=");
                stringBuffer.append(TABLE_ALIAS2).append(".");
                stringBuffer.append(((SysColumn)object2).getColName()).append("_new AND ");
                stringBuffer2.append(TABLE_ALIAS1).append(".");
                stringBuffer2.append(object32.getColName()).append("=");
                stringBuffer2.append(TABLE_ALIAS3).append(".");
                stringBuffer2.append(((SysColumn)object2).getColName()).append("_old AND ");
            }
            stringBuffer.setLength(stringBuffer.length() - 5);
            stringBuffer2.setLength(stringBuffer2.length() - 5);
            StringBuffer stringBuffer3 = new StringBuffer("SELECT 1 FROM ");
            stringBuffer3.append(sysTable.getTableName()).append(" ").append(TABLE_ALIAS1);
            stringBuffer3.append(" LEFT JOIN ");
            stringBuffer3.append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS2);
            stringBuffer3.append(" ON ").append(stringBuffer);
            stringBuffer3.append(" LEFT JOIN ");
            stringBuffer3.append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS3);
            stringBuffer3.append(" ON ").append(stringBuffer2);
            stringBuffer3.append(" WHERE ");
            for (SysColumn sysColumn : this.targetTable.getRowID()) {
                stringBuffer3.append(TABLE_ALIAS2).append(".").append(sysColumn.getColName()).append("_old IS NULL AND ");
                stringBuffer3.append(TABLE_ALIAS3).append(".").append(sysColumn.getColName()).append("_old IS NOT NULL AND ");
            }
            stringBuffer3.setLength(stringBuffer3.length() - 5);
            object422 = new Parser(this.client);
            ((Parser)object422).parseStatement(stringBuffer3.toString());
            SqlSelect sqlSelect = (SqlSelect)((Parser)object422).getSqlObject();
            sqlSelect.addSkipPermissionCheck(this.targetTable.getTableName());
            sqlSelect.addSkipPermissionCheck(sysTable.getTableName());
            sqlSelect.prepare();
            object2 = Collections.singletonMap(sqlSelect, violationCriteria);
            Object var13_15 = null;
            return object2;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            throw throwable;
        }
    }
}

