/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.AbstractConstraintChecker;
import com.edb.gridsql.constraintchecker.InsertPrimaryKeyChecker;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdatePrimaryKeyChecker
extends AbstractConstraintChecker {
    private static final XLogger logger = XLogger.getLogger(InsertPrimaryKeyChecker.class);
    private static final String TABLE_ALIAS1 = "t1";
    private static final String TABLE_ALIAS2 = "t2";
    private static final String TABLE_ALIAS3 = "t3";

    public UpdatePrimaryKeyChecker(SysTable sysTable, XDBSessionContext xDBSessionContext) {
        super(sysTable, xDBSessionContext);
    }

    @Override
    protected Map<IExecutable, AbstractConstraintChecker.ViolationCriteria> prepareConstraint(Object object) throws Exception {
        AbstractConstraintChecker.ViolationCriteria violationCriteria = new AbstractConstraintChecker.ViolationCriteria(this);
        violationCriteria.violationType = 2;
        violationCriteria.message = object.toString();
        HashMap<IExecutable, AbstractConstraintChecker.ViolationCriteria> hashMap = new HashMap<IExecutable, AbstractConstraintChecker.ViolationCriteria>();
        StringBuffer stringBuffer = new StringBuffer("select 1 from ");
        stringBuffer.append(this.targetTable.getTableName()).append(" ").append(TABLE_ALIAS1);
        stringBuffer.append(" INNER JOIN ").append(this.tempTable.getTableName()).append(" ");
        stringBuffer.append(TABLE_ALIAS2).append(" ON ");
        for (SysColumn object22 : ((SysIndex)object).getKeyColumns()) {
            stringBuffer.append(TABLE_ALIAS1).append(".").append(object22.getColName()).append("=");
            stringBuffer.append(TABLE_ALIAS2).append(".").append(object22.getColName());
            stringBuffer.append("_new AND ");
        }
        stringBuffer.setLength(stringBuffer.length() - 4);
        stringBuffer.append("LEFT OUTER JOIN ");
        stringBuffer.append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS3);
        stringBuffer.append(" ON ");
        for (SysColumn sysColumn : this.targetTable.getRowID()) {
            if (sysColumn.isNullable()) {
                stringBuffer.append("(");
            }
            stringBuffer.append(TABLE_ALIAS1).append(".").append(sysColumn.getColName()).append(" = ");
            stringBuffer.append(TABLE_ALIAS3).append(".").append(sysColumn.getColName()).append("_old");
            if (sysColumn.isNullable()) {
                stringBuffer.append(" OR ");
                stringBuffer.append(TABLE_ALIAS1).append(".").append(sysColumn.getColName()).append(" IS NULL AND ");
                stringBuffer.append(TABLE_ALIAS3).append(".").append(sysColumn.getColName()).append("_old IS NULL)");
            }
            stringBuffer.append(" AND ");
        }
        stringBuffer.setLength(stringBuffer.length() - 5);
        stringBuffer.append(" WHERE ");
        for (SysColumn sysColumn : this.targetTable.getRowID()) {
            stringBuffer.append(TABLE_ALIAS3).append(".").append(sysColumn.getColName()).append("_old IS NULL AND ");
        }
        stringBuffer.setLength(stringBuffer.length() - 5);
        Object object3 = new Parser(this.client);
        ((Parser)object3).parseStatement(stringBuffer.toString());
        SqlSelect sqlSelect = (SqlSelect)((Parser)object3).getSqlObject();
        sqlSelect.addSkipPermissionCheck(this.targetTable.getTableName());
        sqlSelect.prepare();
        hashMap.put(sqlSelect, violationCriteria);
        StringBuffer stringBuffer2 = new StringBuffer("select 1 from ");
        stringBuffer2.append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS1);
        stringBuffer2.append(", ").append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS2);
        stringBuffer2.append(" WHERE ");
        for (SysColumn sysColumn : ((SysIndex)object).getKeyColumns()) {
            stringBuffer2.append(TABLE_ALIAS1).append(".").append(sysColumn.getColName()).append("_new=");
            stringBuffer2.append(TABLE_ALIAS2).append(".").append(sysColumn.getColName());
            stringBuffer2.append("_new AND ");
        }
        for (SysColumn sysColumn : this.targetTable.getRowID()) {
            if (sysColumn.isNullable()) {
                stringBuffer2.append("(");
            }
            stringBuffer2.append(TABLE_ALIAS1).append(".").append(sysColumn.getColName()).append("_old <> ");
            stringBuffer2.append(TABLE_ALIAS2).append(".").append(sysColumn.getColName()).append("_old AND ");
            if (sysColumn.isNullable()) {
                stringBuffer2.append(" OR ");
                stringBuffer2.append(TABLE_ALIAS1).append(".").append(sysColumn.getColName()).append(" IS NULL AND ");
                stringBuffer2.append(TABLE_ALIAS2).append(".").append(sysColumn.getColName()).append("_old IS NULL)");
            }
            stringBuffer.append(" AND ");
        }
        stringBuffer2.setLength(stringBuffer2.length() - 5);
        object3 = new Parser(this.client);
        ((Parser)object3).parseStatement(stringBuffer2.toString());
        SqlSelect sqlSelect2 = (SqlSelect)((Parser)object3).getSqlObject();
        sqlSelect2.addSkipPermissionCheck(this.targetTable.getTableName());
        sqlSelect2.prepare();
        hashMap.put(sqlSelect2, violationCriteria);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<SysColumn> scanConstraints(Collection<SysColumn> collection, Collection collection2) {
        try {
            HashSet hashSet = new HashSet();
            Vector<SysIndex> vector = this.targetTable.getAllUniqueAndPrimarySysIndexes();
            for (SysIndex sysIndex : vector) {
                if (!sysIndex.isDistributed) continue;
                boolean bl = false;
                ArrayList<SysColumn> arrayList = new ArrayList<SysColumn>(sysIndex.keycnt);
                for (SysColumn sysColumn : sysIndex.getKeyColumns()) {
                    if (collection.contains(sysColumn)) {
                        bl = true;
                        continue;
                    }
                    arrayList.add(sysColumn);
                }
                if (!bl) continue;
                collection2.add(sysIndex);
                hashSet.addAll(arrayList);
            }
            HashSet hashSet2 = hashSet;
            Object var12_11 = null;
            return hashSet2;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            throw throwable;
        }
    }
}

