/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.NodeResultSetImpl;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.optimizer.SqlExpression;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Engine {
    private static final XLogger logger = XLogger.getLogger(Engine.class);
    private static final Engine engine = new Engine();

    public static final Engine getInstance() {
        return engine;
    }

    private Engine() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(XDBSessionContext xDBSessionContext, Collection<DBNode> collection) throws XDBServerException {
        xDBSessionContext.setInTransaction(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitTransaction(XDBSessionContext xDBSessionContext, Collection<DBNode> collection) throws XDBServerException {
        xDBSessionContext.getSysDatabase();
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        multinodeExecutor.commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTransaction(XDBSessionContext xDBSessionContext, Collection<DBNode> collection) throws SQLException, XDBServerException {
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        multinodeExecutor.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropNodeTempTables(Collection<String> collection, Collection<DBNode> collection2, XDBSessionContext xDBSessionContext) throws Exception {
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection2);
        multinodeExecutor.dropNodeTempTables(collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startLoaders(String string, String string2, Collection<DBNode> arrayList, XDBSessionContext xDBSessionContext) throws XDBServerException {
        SysDatabase sysDatabase = xDBSessionContext.getSysDatabase();
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor((Collection<DBNode>)(arrayList == null ? new ArrayList<DBNode>(sysDatabase.getDBNodeList()) : arrayList));
        multinodeExecutor.startLoaders(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, ResultSet> executeQueryOnMultipleNodes(String string, Collection<DBNode> collection, XDBSessionContext xDBSessionContext) throws XDBServerException {
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        HashMap<Integer, NodeResultSetImpl> hashMap = new HashMap<Integer, NodeResultSetImpl>();
        for (NodeMessage nodeMessage : multinodeExecutor.execute(string, collection, false)) {
            hashMap.put(nodeMessage.getSourceNodeID(), nodeMessage.getResultSet());
        }
        HashMap<Integer, NodeResultSetImpl> hashMap2 = hashMap;
        return hashMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeOnMultipleNodes(String string, Collection<DBNode> collection, XDBSessionContext xDBSessionContext) throws XDBServerException {
        int n = 0;
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        int n2 = n = multinodeExecutor.executeCommand(string, collection, collection.size() == 1 && !xDBSessionContext.isInTransaction() && !xDBSessionContext.isInSubTransaction());
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeOnMultipleNodes(Map<DBNode, String> map, XDBSessionContext xDBSessionContext) throws XDBServerException {
        int n = 0;
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(map.keySet());
        int n2 = n = multinodeExecutor.executeCommand(map, map.size() == 1 && !xDBSessionContext.isInTransaction() && !xDBSessionContext.isInSubTransaction());
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDDLOnMultipleNodes(String string, Collection<DBNode> collection, IMetaDataUpdate iMetaDataUpdate, XDBSessionContext xDBSessionContext) throws XDBServerException {
        String[] stringArray = new String[]{string};
        this.executeDDLOnMultipleNodes(stringArray, collection, iMetaDataUpdate, xDBSessionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDDLOnMultipleNodes(String[] stringArray, Collection<DBNode> collection, IMetaDataUpdate iMetaDataUpdate, XDBSessionContext xDBSessionContext) throws XDBServerException {
        String string = "";
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        this.beginTransaction(xDBSessionContext, collection);
        try {
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                string = string2;
                multinodeExecutor.executeCommand(string, collection);
            }
        }
        catch (XDBServerException xDBServerException) {
            multinodeExecutor.rollback();
            throw xDBServerException;
        }
        this.doMetadataUpdate(multinodeExecutor, iMetaDataUpdate, xDBSessionContext);
    }

    private synchronized void doMetadataUpdate(MultinodeExecutor multinodeExecutor, IMetaDataUpdate iMetaDataUpdate, XDBSessionContext xDBSessionContext) {
        try {
            MetaData.getMetaData().beginTransaction();
            iMetaDataUpdate.execute(xDBSessionContext);
        }
        catch (Exception exception) {
            try {
                multinodeExecutor.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                MetaData.getMetaData().rollbackTransaction();
            }
            catch (Exception exception3) {
                // empty catch block
            }
            if (exception instanceof XDBServerException) {
                throw (XDBServerException)exception;
            }
            throw new XDBServerException(exception.getMessage(), exception);
        }
        try {
            multinodeExecutor.commit();
        }
        catch (XDBServerException xDBServerException) {
            try {
                MetaData.getMetaData().rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw xDBServerException;
        }
        try {
            MetaData.getMetaData().commitTransaction(iMetaDataUpdate);
        }
        catch (XDBServerException xDBServerException) {
            try {
                MetaData.getMetaData().rollbackTransaction();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw xDBServerException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeDDLOnMultipleNodes(Map<DBNode, String> map, IMetaDataUpdate iMetaDataUpdate, XDBSessionContext xDBSessionContext) {
        boolean bl = false;
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(map.keySet());
        this.beginTransaction(xDBSessionContext, map.keySet());
        try {
            multinodeExecutor.executeCommand(map);
        }
        catch (XDBServerException xDBServerException) {
            multinodeExecutor.rollback();
            throw xDBServerException;
        }
        this.doMetadataUpdate(multinodeExecutor, iMetaDataUpdate, xDBSessionContext);
    }

    public boolean addToBatchOnNodes(Map<DBNode, String> map, XDBSessionContext xDBSessionContext) throws XDBServerException {
        xDBSessionContext.setInBatch(true);
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(map.keySet());
        return multinodeExecutor.addBatchOnNodeList(map);
    }

    public boolean addToBatchOnNodes(String string, Collection<DBNode> collection, XDBSessionContext xDBSessionContext) throws XDBServerException {
        xDBSessionContext.setInBatch(true);
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        return multinodeExecutor.addBatchOnNodeList(string, collection);
    }

    public boolean addToBatchOnNode(String string, DBNode dBNode, XDBSessionContext xDBSessionContext) throws XDBServerException {
        xDBSessionContext.setInBatch(true);
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(Collections.singleton(dBNode));
        return multinodeExecutor.addBatchOnNode(string, dBNode.getNodeId());
    }

    public int[] executeBatchOnNodes(XDBSessionContext xDBSessionContext, boolean bl) {
        List<DBNode> list = Collections.emptyList();
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(list);
        int[] nArray = multinodeExecutor.executeBatch(bl);
        xDBSessionContext.setInBatch(false);
        return nArray;
    }

    public void clearBatchOnNodes(XDBSessionContext xDBSessionContext) {
        List<DBNode> list = Collections.emptyList();
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(list);
        multinodeExecutor.clearBatch();
        xDBSessionContext.setInBatch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareStatement(String string, String string2, int[] nArray, Collection<DBNode> collection, XDBSessionContext xDBSessionContext) throws XDBServerException {
        boolean bl = false;
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(collection);
        String string3 = string = multinodeExecutor.prepareStatement(string, string2, nArray, collection);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executePreparedCommand(String string, String[] stringArray, Collection<DBNode> collection, XDBSessionContext xDBSessionContext) throws XDBServerException {
        int n = 0;
        Set<DBNode> set = Collections.emptySet();
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(set);
        int n2 = n = multinodeExecutor.executePreparedCommand(string, stringArray, collection);
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePreparedStatement(String string, XDBSessionContext xDBSessionContext) throws XDBServerException {
        boolean bl = false;
        Set<DBNode> set = Collections.emptySet();
        MultinodeExecutor multinodeExecutor = xDBSessionContext.getMultinodeExecutor(set);
        multinodeExecutor.closePrepared(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlExpression evaluate(XDBSessionContext xDBSessionContext, SqlExpression sqlExpression) throws SQLException {
        if (sqlExpression == null || sqlExpression.getExprType() == 2) {
            return sqlExpression;
        }
        Connection connection = xDBSessionContext.getAndSetCoordinatorConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + sqlExpression.rebuildString());
        try {
            resultSet.next();
            String string = resultSet.getString(1);
            SqlExpression sqlExpression2 = new SqlExpression(sqlExpression.getBelongsToTree());
            sqlExpression2.setExprType(2);
            sqlExpression2.setExprDataType(sqlExpression.getExprDataType());
            sqlExpression2.setConstantValue(string);
            SqlExpression sqlExpression3 = sqlExpression2;
            return sqlExpression3;
        }
        finally {
            resultSet.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(XDBSessionContext xDBSessionContext, String string) throws SQLException {
        Connection connection = xDBSessionContext.getAndSetCoordinatorConnection();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT " + string);
        try {
            resultSet.next();
            String string2 = resultSet.getString(1);
            return string2;
        }
        finally {
            resultSet.close();
        }
    }
}

