/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.loader.DataReaderAndProcessorBuffer;
import com.edb.gridsql.engine.loader.ILoaderConfigInformation;
import com.edb.gridsql.engine.loader.INodeWriter;
import com.edb.gridsql.engine.loader.INodeWriterFactory;
import com.edb.gridsql.engine.loader.IUniqueValueProvider;
import com.edb.gridsql.engine.loader.TableColumnDescription;
import com.edb.gridsql.exception.XDBGeneratorException;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataProcessorThread<T>
implements Callable<Integer> {
    private static final XLogger logger = XLogger.getLogger(DataProcessorThread.class);
    private static final Map<Integer, String> NO_AUTOINCREMENTS = Collections.emptyMap();
    protected int rowsLoaded = 0;
    protected final int threadId;
    protected HashMap<Integer, INodeWriter> writerThreadsList;
    private final DataReaderAndProcessorBuffer<T> loadBuffer;
    protected long maxSuppliedRowIDValue;
    protected long maxSuppliedSerialValue;
    private final INodeWriterFactory writersFactory;
    protected final PartitionMap gridPartitionMap;
    protected final SysTable table;
    private final List<TableColumnDescription> columns;
    private final int columnCount;
    protected final IUniqueValueProvider rowIdProvider;
    protected final IUniqueValueProvider serialProvider;
    protected final XDBSessionContext client;
    protected final char separator;
    protected final String NULLValue;
    protected final int serialColumnPosition;
    protected final int partColumn;
    protected ExpressionType hashDataType = null;
    protected final int serialColumn;
    protected final int xrowidColumn;
    protected final boolean isDestTypeNodeId;
    protected final boolean suppresSendingNodeId;
    protected final boolean noParse;
    private char quoteChar = '\u0000';
    private char quoteEscape = '\u0000';
    private HashMap<Integer, String> autoincrements = new HashMap();
    private HashMap<Integer, Long> rowCountMap;

    public DataProcessorThread(ILoaderConfigInformation iLoaderConfigInformation, int n, DataReaderAndProcessorBuffer<T> dataReaderAndProcessorBuffer) throws Exception {
        this.threadId = n;
        if (dataReaderAndProcessorBuffer == null) {
            throw new Exception("ReaderAndProcessorBuffer buffer instance is null.");
        }
        this.loadBuffer = dataReaderAndProcessorBuffer;
        this.writersFactory = iLoaderConfigInformation.getWriterFactory();
        this.gridPartitionMap = iLoaderConfigInformation.getPartitionMap();
        this.client = iLoaderConfigInformation.getClient();
        this.table = iLoaderConfigInformation.getTableInformation();
        this.columns = iLoaderConfigInformation.getTableColumnsInformation();
        this.columnCount = iLoaderConfigInformation.getTableColumnsCount();
        this.rowIdProvider = iLoaderConfigInformation.getRowIdProvider();
        this.serialProvider = iLoaderConfigInformation.getSerialProvider();
        this.separator = iLoaderConfigInformation.getSeparator();
        this.partColumn = iLoaderConfigInformation.getPartitionColumnSequence();
        this.hashDataType = iLoaderConfigInformation.getHashDataType();
        this.serialColumnPosition = iLoaderConfigInformation.getSerialColumnPosition();
        this.serialColumn = iLoaderConfigInformation.getSerialColumnSequence();
        this.xrowidColumn = iLoaderConfigInformation.getXRowidColumnSequence();
        this.noParse = iLoaderConfigInformation.noParse();
        this.isDestTypeNodeId = iLoaderConfigInformation.destinationTypeNodeId();
        this.suppresSendingNodeId = iLoaderConfigInformation.suppressSendingNodeId();
        this.NULLValue = iLoaderConfigInformation.getNULLValue();
        this.quoteChar = iLoaderConfigInformation.getQuoteChar();
        this.quoteEscape = iLoaderConfigInformation.getQuoteEscape();
    }

    protected char getQuoteEscape() {
        return this.quoteEscape == '\u0000' ? this.getQuoteChar() : this.quoteEscape;
    }

    protected char getQuoteChar() {
        return this.quoteChar;
    }

    public void initializeDataWriters() throws Exception {
        this.writerThreadsList = new HashMap();
        Collection<Integer> collection = this.gridPartitionMap.allPartitions();
        for (int n : collection) {
            INodeWriter iNodeWriter = this.writersFactory.createWriter(n);
            if (iNodeWriter == null) {
                throw new Exception("Can not setup loading on node " + n);
            }
            if (this.writerThreadsList.put(n, iNodeWriter) != null) {
                throw new Exception("Duplicate node number");
            }
            iNodeWriter.start();
        }
    }

    public void finishLoad(boolean bl) throws Exception {
        Exception exception = null;
        Iterator<INodeWriter> iterator = this.writerThreadsList.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().finish(bl);
            }
            catch (Exception exception2) {
                if (!bl) continue;
                bl = false;
                exception = exception2;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void commitLoad() {
        Iterator<INodeWriter> iterator = this.writerThreadsList.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().commit();
            }
            catch (Exception exception) {}
        }
    }

    public void rollbackLoad() {
        Iterator<INodeWriter> iterator = this.writerThreadsList.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().rollback();
            }
            catch (Exception exception) {}
        }
    }

    public void close() {
        Iterator<INodeWriter> iterator = this.writerThreadsList.values().iterator();
        while (iterator.hasNext()) {
            try {
                iterator.next().close();
            }
            catch (Exception exception) {}
        }
        this.writersFactory.close();
    }

    @Override
    public Integer call() throws Exception {
        try {
            return this.loadData();
        }
        catch (Exception exception) {
            this.loadBuffer.markFinished();
            throw exception;
        }
    }

    protected Integer loadData() throws Exception {
        int n = 0;
        while (this.parseRow()) {
            Iterator<Integer> iterator;
            String string;
            this.insertGeneratedValues(this.noParse ? NO_AUTOINCREMENTS : this.generateAutoincrements());
            String string2 = null;
            if (this.partColumn >= 0) {
                string2 = this.getValue(this.partColumn + 1);
            }
            if (this.isDestTypeNodeId) {
                string = this.getValue(this.getColumnCount());
                iterator = this.writerThreadsList.get(new Integer(string));
                this.outputRow((INodeWriter)((Object)iterator));
            } else {
                INodeWriter iNodeWriter;
                string = this.getNextGroupByHashString();
                if (string != null) {
                    iterator = this.gridPartitionMap.getPartitions(SqlExpression.createConstantExpression(string, this.hashDataType).getNormalizedValue());
                    Integer[] integerArray = (Integer[])iterator.toArray();
                    iNodeWriter = this.writerThreadsList.get(new Integer(integerArray[0]));
                    this.outputRow(iNodeWriter);
                } else {
                    for (int n2 : this.gridPartitionMap.getPartitions(string2 == null ? null : SqlExpression.createConstantExpression(string2, this.hashDataType).getNormalizedValue())) {
                        iNodeWriter = this.writerThreadsList.get(new Integer(n2));
                        this.outputRow(iNodeWriter);
                    }
                }
            }
            if (this.serialColumn > 0) {
                this.maxSuppliedSerialValue = Math.max(this.maxSuppliedSerialValue, Long.parseLong(this.getValue(this.serialColumn + 1)));
            }
            if (this.xrowidColumn > 0) {
                this.maxSuppliedRowIDValue = Math.max(this.maxSuppliedRowIDValue, Long.parseLong(this.getValue(this.xrowidColumn + 1)));
            }
            if (++n != 100000) continue;
            this.rowsLoaded += 100000;
            n = 0;
            logger.log(Level.DEBUG, "DataProcessor: %0% > %1% rows processed so far...", new Object[]{this.threadId, this.rowsLoaded});
        }
        this.rowsLoaded += n;
        logger.log(Level.DEBUG, "DataProcessor: %0% > %1% rows processed.", new Object[]{this.threadId, this.rowsLoaded});
        return this.rowsLoaded;
    }

    protected abstract boolean parseRow() throws Exception;

    protected abstract void insertGeneratedValues(Map<Integer, String> var1) throws Exception;

    protected abstract String getValue(int var1);

    protected abstract void outputRow(INodeWriter var1) throws IOException;

    protected int getColumnCount() {
        return this.columnCount;
    }

    private Map<Integer, String> generateAutoincrements() throws XDBGeneratorException {
        if (this.serialColumnPosition > 0) {
            this.autoincrements.put(this.serialColumnPosition, this.serialProvider.getNextValue());
        } else if (this.serialColumn > 0) {
            this.autoincrements.put(this.serialColumn, this.serialProvider.getNextValue());
        }
        if (this.xrowidColumn > 0) {
            this.autoincrements.put(this.xrowidColumn, this.rowIdProvider.getNextValue());
        }
        if (this.columns != null) {
            for (int i = 0; i < this.columns.size(); ++i) {
                SqlExpression sqlExpression = this.columns.get(i).getDefault();
                if (sqlExpression == null) continue;
                String string = sqlExpression.rebuildString(this.client);
                if (string == null) {
                    string = this.NULLValue;
                } else if (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
                    string = string.substring(1, string.length() - 1).replace("''", "'");
                } else if (string.length() > 7 && (string.startsWith("date '") || string.startsWith("time '")) && string.endsWith("'")) {
                    string = string.substring(6, string.length() - 1);
                } else if (string.length() > 12 && string.startsWith("timestamp '") && string.endsWith("'")) {
                    string = string.substring(11, string.length() - 1);
                }
                this.autoincrements.put(i, string);
            }
        }
        return this.autoincrements;
    }

    protected T getNextRowValue() {
        return this.loadBuffer.getNextRowValue();
    }

    protected String getNextGroupByHashString() {
        return this.loadBuffer.getNextGroupByHashString();
    }

    public long getMaxSuppliedSerialValue() {
        return this.maxSuppliedSerialValue;
    }

    public long getMaxSuppliedRowIDValue() {
        return this.maxSuppliedRowIDValue;
    }

    public HashMap<Integer, Long> getRowCountMap() {
        if (this.rowCountMap == null) {
            this.rowCountMap = new HashMap();
            for (Integer n : this.writerThreadsList.keySet()) {
                this.rowCountMap.put(n, this.writerThreadsList.get(n).getRowCount());
            }
        }
        return this.rowCountMap;
    }

    public void cancel() {
        this.loadBuffer.markFinished();
    }
}

