/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysCheck;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysConstraint;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysForeignKey;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysIndexKey;
import com.edb.gridsql.metadata.SysPermission;
import com.edb.gridsql.metadata.SysReference;
import com.edb.gridsql.metadata.SysRowIDHandler;
import com.edb.gridsql.metadata.SysSerialIDHandler;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.partitions.HashPartitionMap;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.partitions.ReplicatedPartitionMap;
import com.edb.gridsql.metadata.partitions.RobinPartitionMap;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysTable {
    private static final XLogger logger = XLogger.getLogger(SysTable.class);
    public static final int PAGE_SIZE = 8096;
    public static final short PTYPE_ONE = 1;
    public static final short PTYPE_LOOKUP = 2;
    public static final short PTYPE_HASH = 3;
    public static final short PTYPE_RANGE = 4;
    public static final short PTYPE_ROBIN = 5;
    public static final short PTYPE_DEFAULT = 6;
    private SysDatabase database = null;
    private int tableid;
    private String tableName;
    private short partitionScheme;
    private String partitionColumn = "";
    private PartitionMap partitionMap;
    private long numrows = 0L;
    private int estRowsPerPage = 0;
    private int rowSize = 0;
    private SysUser owner = null;
    private SysColumn serialColumn = null;
    private SysSerialIDHandler serialIdHandler;
    private SysRowIDHandler rowIDHandler;
    private List<SysColumn> sysColumnList;
    private Hashtable<String, SysColumn> sysColumnTable;
    private SysConstraint primaryConstraint = null;
    private List<SysColumn> rowID = null;
    private List<SysConstraint> sysConstraintsList;
    private Vector<SysReference> sysFkReferenceList;
    private Collection<SysIndex> sysIndexList;
    private Vector<SysReference> sysReferencesList;
    private HashMap<SysUser, SysPermission> sysPermissions;
    private List<SysCheck> sysChecks;
    private List<SysTable> childrenTables;
    private String clusteridx;
    private boolean tableIsTemporary = false;
    private boolean isTrueRowID = false;
    private int parentTableID = -1;
    private SysTable parentTable = null;
    private int tablespaceID = -1;
    private SysTablespace tablespace = null;
    private boolean loaded = false;

    public static SysTable getPartitionTable(String string, SysDatabase sysDatabase) {
        SysTable sysTable = null;
        SysTable sysTable2 = null;
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            sysTable = sysDatabase.getSysTable(stringArray[i]);
            if (i == 0) {
                sysTable2 = sysTable;
                continue;
            }
            if (sysTable2.getPartitionScheme() != 2 || sysTable.getPartitionScheme() == 2) continue;
            sysTable2 = sysTable;
        }
        return sysTable2;
    }

    public SysTable(SysDatabase sysDatabase, int n, String string, long l, short s, String string2, SysUser sysUser, int n2, int n3, String string3) {
        this.database = sysDatabase;
        this.tableid = n;
        this.tableName = string;
        this.numrows = l;
        this.partitionScheme = s;
        this.partitionColumn = string2;
        if (s == 2) {
            this.partitionMap = new ReplicatedPartitionMap();
        } else if (s == 3) {
            this.partitionMap = new HashPartitionMap();
        } else if (s == 5) {
            this.partitionMap = new RobinPartitionMap();
        } else if (s == 1) {
            this.partitionMap = new ReplicatedPartitionMap();
        }
        this.owner = sysUser;
        this.parentTableID = n2;
        this.tablespaceID = n3;
        this.clusteridx = string3;
        if (sysUser != null) {
            sysUser.addOwned(this);
        }
        this.sysColumnList = new ArrayList<SysColumn>();
        this.sysColumnTable = new Hashtable();
        this.sysIndexList = new ArrayList<SysIndex>();
        this.primaryConstraint = null;
        this.rowID = null;
        this.sysReferencesList = new Vector();
        this.sysConstraintsList = new Vector<SysConstraint>();
        this.sysFkReferenceList = new Vector();
        this.sysPermissions = new HashMap();
        this.sysChecks = new ArrayList<SysCheck>();
        this.childrenTables = new ArrayList<SysTable>();
    }

    void readTableInfo() throws XDBServerException {
        this.readTableInfo(true);
    }

    void readTableInfo(boolean bl) throws XDBServerException {
        try {
            if (this.loaded && !bl) {
                return;
            }
            this.sysPermissions = new HashMap();
            this.sysColumnList = new ArrayList<SysColumn>();
            this.sysColumnTable = new Hashtable();
            this.sysIndexList = new ArrayList<SysIndex>();
            this.sysReferencesList = new Vector();
            this.sysConstraintsList = new Vector<SysConstraint>();
            this.sysFkReferenceList = new Vector();
            this.sysChecks = new ArrayList<SysCheck>();
            this.childrenTables = new ArrayList<SysTable>();
            this.primaryConstraint = null;
            this.rowID = null;
            this.isTrueRowID = false;
            this.loaded = true;
            this.updateParentTableReference();
            this.readPermissionsInfo();
            this.readPartitioningInfo();
            this.readColumnInfo();
            this.readIndexInfo();
            this.readConstraintsInfo();
            this.refreshAssociatedInfo();
        }
        catch (Exception exception) {
            throw new XDBServerException(ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR, exception, ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR_CODE);
        }
    }

    private void readPartitioningInfo() throws XDBServerException {
        try {
            if (this.parentTableID > -1) {
                return;
            }
            this.partitionMap.readMapFromMetadataDB(MetaData.getMetaData(), this);
        }
        catch (SQLException sQLException) {
            throw new XDBServerException(ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR, sQLException, ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR_CODE);
        }
    }

    private void readColumnInfo() throws XDBServerException {
        try {
            ResultSet resultSet = MetaData.getMetaData().executeQuery("SELECT * from xsyscolumns WHERE tableid = " + this.tableid + " order by colseq");
            while (resultSet.next()) {
                String string;
                String string2 = resultSet.getString("defaultexpr");
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if ((string = resultSet.getString("nativecoldef")) != null) {
                    string = string.trim();
                }
                SysColumn sysColumn = new SysColumn(this, resultSet.getInt("colid"), resultSet.getInt("colseq"), resultSet.getString("colname").trim(), resultSet.getInt("coltype"), resultSet.getInt("collength"), resultSet.getInt("colscale"), resultSet.getInt("colprecision"), resultSet.getBoolean("isnullable"), resultSet.getBoolean("isserial"), string, resultSet.getFloat("selectivity"), string2);
                if (string.toUpperCase().contains("WITH TIME ZONE")) {
                    sysColumn.isWithTimeZone = true;
                }
                this.addSysColumn(sysColumn);
            }
        }
        catch (SQLException sQLException) {
            throw new XDBServerException(ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR, sQLException, ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR_CODE);
        }
    }

    void readPermissionsInfo() throws XDBServerException {
        try {
            if (this.parentTableID > -1) {
                return;
            }
            ResultSet resultSet = MetaData.getMetaData().executeQuery("SELECT * from xsystabprivs WHERE tableid = " + this.tableid);
            this.sysPermissions.clear();
            while (resultSet.next()) {
                SysUser sysUser = resultSet.getString("userid") == null ? null : this.database.getSysUser(resultSet.getInt("userid"));
                SysPermission sysPermission = new SysPermission(this, sysUser, resultSet.getInt("privid"), resultSet.getString("selectpriv"), resultSet.getString("insertpriv"), resultSet.getString("updatepriv"), resultSet.getString("deletepriv"), resultSet.getString("referencespriv"), resultSet.getString("indexpriv"), resultSet.getString("alterpriv"));
                this.sysPermissions.put(sysUser, sysPermission);
                sysUser.addGranted(this);
            }
        }
        catch (SQLException sQLException) {
            throw new XDBServerException(ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR, sQLException, ErrorMessageRepository.METADATA_DB_INFO_READ_ERROR_CODE);
        }
    }

    public void ensurePermission(SysUser sysUser, short s) throws XDBSecurityException {
        if (!this.checkPermission(sysUser, s)) {
            XDBSecurityException xDBSecurityException = new XDBSecurityException("Table " + this.tableName + ": Access denied");
            logger.throwing(xDBSecurityException);
            throw xDBSecurityException;
        }
    }

    public boolean checkPermission(SysUser sysUser, short s) {
        if (this.isTemporary() || sysUser != null && sysUser.getUserClass() == 0 || this.sysPermissions.isEmpty() && sysUser == this.owner) {
            return true;
        }
        SysPermission sysPermission = this.getSysPermission(sysUser);
        if (sysPermission != null && sysPermission.checkPermission(s)) {
            return true;
        }
        sysPermission = this.getSysPermission(null);
        return sysPermission != null && sysPermission.checkPermission(s);
    }

    public Collection<SysIndex> getSysIndexList() {
        return this.sysIndexList;
    }

    private void readIndexInfo() throws Exception {
        String string = "SELECT * FROM xsysindexes  WHERE tableid = " + this.tableid;
        ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
        this.sysIndexList.clear();
        while (resultSet.next()) {
            SysIndex sysIndex = new SysIndex(this);
            sysIndex.idxid = resultSet.getInt("idxid");
            sysIndex.idxname = resultSet.getString("idxname").trim();
            sysIndex.tableid = this.tableid;
            sysIndex.keycnt = resultSet.getInt("keycnt");
            sysIndex.issyscreated = resultSet.getInt("issyscreated");
            sysIndex.tablespaceID = resultSet.getInt("tablespaceid");
            sysIndex.usingtype = resultSet.getString("usingtype");
            sysIndex.wherepred = resultSet.getString("wherepred");
            if (resultSet.wasNull()) {
                sysIndex.tablespaceID = -1;
            }
            sysIndex.readIndexKeysInfo();
            sysIndex.is_constrained = this.isIndexConstrained(sysIndex.idxid);
            this.sysIndexList.add(sysIndex);
        }
    }

    private boolean isIndexConstrained(int n) throws XDBServerException {
        try {
            int n2;
            ResultSet resultSet = MetaData.getMetaData().executeQuery("SELECT COUNT(*) FROM xsysreferences WHERE refidxid=" + n);
            if (resultSet.next() && (n2 = resultSet.getInt(1)) > 0) {
                return true;
            }
            resultSet = MetaData.getMetaData().executeQuery("SELECT COUNT(*) FROM xsysconstraints WHERE consttype='P' AND idxid=" + n);
            if (resultSet.next() && (n2 = resultSet.getInt(1)) > 0) {
                return true;
            }
        }
        catch (SQLException sQLException) {
            String string = ErrorMessageRepository.SYSINDEX_READ_FAILURE + " ( " + n + " )";
            throw new XDBServerException(string, sQLException, ErrorMessageRepository.SYSINDEX_READ_FAILURE_CODE);
        }
        return false;
    }

    private void readConstraintsInfo() throws Exception {
        String string = "SELECT * FROM xsysconstraints  WHERE tableid = " + this.tableid;
        ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
        this.sysConstraintsList.clear();
        while (resultSet.next()) {
            Object object;
            String string2 = resultSet.getString("constname");
            if (string2 != null) {
                string2 = string2.trim();
            }
            SysConstraint sysConstraint = new SysConstraint(this, resultSet.getInt("constid"), string2, resultSet.getString("consttype").charAt(0), resultSet.getInt("idxid"), resultSet.getInt("issoft"));
            SysIndex sysIndex = null;
            int n = sysConstraint.getIdxID();
            if (n > 0) {
                sysIndex = this.getSysIndex(n);
            }
            this.sysConstraintsList.add(sysConstraint);
            switch (sysConstraint.getConstType()) {
                case 'P': {
                    sysIndex.idxtype = (char)80;
                    break;
                }
                case 'U': {
                    if (sysIndex.idxtype == 'P') break;
                    sysIndex.idxtype = (char)85;
                    break;
                }
                case 'R': {
                    if (sysIndex.idxtype == 'P' || sysIndex.idxtype == 'U') break;
                    sysIndex.idxtype = (char)82;
                    break;
                }
            }
            if (sysConstraint.getConstType() == 'P') {
                this.primaryConstraint = sysConstraint;
            }
            String string3 = "SELECT * FROM xsysreferences  WHERE constid = " + sysConstraint.getConstID();
            ResultSet resultSet2 = MetaData.getMetaData().executeQuery(string3);
            while (resultSet2.next()) {
                object = new SysReference(sysConstraint, resultSet2.getInt("refid"), resultSet2.getInt("reftableid"), resultSet2.getInt("refidxid"));
                ((SysReference)object).readForeignKeysInfo();
                this.sysFkReferenceList.add((SysReference)object);
            }
            object = "SELECT * FROM xsyschecks  WHERE constid = " + sysConstraint.getConstID() + " ORDER BY seqno";
            ResultSet resultSet3 = MetaData.getMetaData().executeQuery((String)object);
            while (resultSet3.next()) {
                SysCheck sysCheck = new SysCheck(this, resultSet3.getInt("checkid"), resultSet3.getInt("constid"), resultSet3.getInt("seqno"), resultSet3.getString("checkstmt").trim());
                this.sysChecks.add(sysCheck);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readReferencesInfo() throws XDBServerException {
        String string = "SELECT tableid, xsysconstraints.constid FROM xsysconstraints JOIN xsysreferences ON xsysconstraints.constid = xsysreferences.constid WHERE reftableid = " + this.tableid;
        ResultSet resultSet = MetaData.getMetaData().executeQuery(string);
        if (this.sysReferencesList.size() > 0) {
            this.sysReferencesList.removeAllElements();
        }
        try {
            try {
                while (resultSet.next()) {
                    int n = resultSet.getInt("tableid");
                    int n2 = resultSet.getInt("constid");
                    SysReference sysReference = this.database.getSysTable(n).getFkSysReference(n2);
                    sysReference.readForeignKeysInfo();
                    this.sysReferencesList.addElement(sysReference);
                }
            }
            finally {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            String string2 = ErrorMessageRepository.TABLE_DEF_CORRUPTED + " ( " + this.tableName + " )";
            throw new XDBServerException(string2, sQLException, 8);
        }
    }

    void refreshAssociatedInfo() throws Exception {
        this.updateColumnIndexInfo();
        this.updateSizeInfo();
    }

    private void updateColumnIndexInfo() {
        for (SysIndex sysIndex : this.sysIndexList) {
            List<SysIndexKey> list = sysIndex.getIndexKeys();
            for (int i = 0; i < list.size(); ++i) {
                SysIndexKey sysIndexKey = list.get(i);
                int n = 6;
                if (sysIndex.keycnt == 1 && sysIndexKey.idxkeyseq == 0) {
                    n = sysIndex.idxtype == 'P' ? 1 : (sysIndex.idxtype == 'U' ? 2 : 3);
                } else if (sysIndex.keycnt > 1 && sysIndexKey.idxkeyseq == 0) {
                    n = 4;
                } else if (sysIndex.keycnt > 1 && sysIndexKey.idxkeyseq > 0) {
                    n = 5;
                }
                SysColumn sysColumn = this.getSysColumn(sysIndexKey.colid);
                if (n >= sysColumn.getIndexType()) continue;
                sysColumn.setIndexType(n);
            }
        }
    }

    void updateCrossReferences() {
        this.readReferencesInfo();
    }

    private void updateSizeInfo() {
        int n = 0;
        Iterator<SysColumn> iterator = this.getColumns().iterator();
        while (iterator.hasNext()) {
            SysColumn sysColumn;
            SysColumn sysColumn2 = sysColumn = iterator.next();
            int n2 = sysColumn2.getColumnLength();
            n += n2;
        }
        this.rowSize = n;
        this.estRowsPerPage = this.rowSize == 0 ? 0 : 8096 / this.rowSize;
    }

    public PartitionMap getPartitionMap() {
        return this.parentTable == null ? this.partitionMap : this.parentTable.getPartitionMap();
    }

    void setPartitioning(String string, short s, PartitionMap partitionMap) {
        if (this.parentTable == null) {
            this.partitionColumn = string;
            this.partitionScheme = s;
            this.partitionMap = partitionMap;
        }
    }

    public short getPartitionScheme() {
        return this.parentTable == null ? this.partitionScheme : this.parentTable.getPartitionScheme();
    }

    public String getPartitionColumn() {
        return this.parentTable == null ? this.partitionColumn : this.parentTable.getPartitionColumn();
    }

    public SysColumn getPartitionedColumn() {
        if (this.parentTable == null) {
            if (this.partitionScheme == 3 || this.partitionScheme == 4) {
                return this.getSysColumn(this.partitionColumn);
            }
            return null;
        }
        return this.parentTable.getPartitionedColumn();
    }

    private Collection<DBNode> nodeIDs2DBNodes(Collection<Integer> collection) {
        ArrayList<DBNode> arrayList = new ArrayList<DBNode>(collection.size());
        for (Integer n : collection) {
            arrayList.add(this.database.getDBNode(n));
        }
        return arrayList;
    }

    public Collection<DBNode> getNodeList() {
        if (this.parentTable == null) {
            return this.nodeIDs2DBNodes(this.partitionMap.allPartitions());
        }
        return this.parentTable.getNodeList();
    }

    public Collection<DBNode> getJoinNodeList() {
        if (this.parentTable == null) {
            return this.nodeIDs2DBNodes(this.partitionMap.joinPartitions());
        }
        return this.parentTable.getJoinNodeList();
    }

    public Collection<DBNode> getNode(String string) {
        if (this.parentTable == null) {
            return this.nodeIDs2DBNodes(this.partitionMap.getPartitions(string));
        }
        return this.parentTable.getNode(string);
    }

    public Collection<DBNode> findNode(String string) {
        if (this.parentTable == null) {
            return this.nodeIDs2DBNodes(this.partitionMap.findPartitions(string));
        }
        return this.parentTable.getNode(string);
    }

    void addSysColumn(SysColumn sysColumn) {
        if (this.getSysColumn(sysColumn.getColName()) != null) {
            XDBServerException xDBServerException = new XDBServerException("Column \"" + sysColumn.getColName() + "\" already exists in the table \"" + this.tableName + "\"");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        this.sysColumnTable.put(sysColumn.getColName(), sysColumn);
        this.sysColumnList.add(sysColumn);
    }

    public SysColumn getSysColumn(int n) {
        SysColumn sysColumn = null;
        for (int i = 0; i < this.sysColumnList.size(); ++i) {
            sysColumn = this.sysColumnList.get(i);
            if (sysColumn.getColID() != n) continue;
            return sysColumn;
        }
        return this.parentTable == null ? null : this.parentTable.getSysColumn(n);
    }

    public SysColumn getSysColumn(String string) {
        SysColumn sysColumn = this.sysColumnTable.get(string);
        if (sysColumn == null && this.parentTable != null) {
            sysColumn = this.parentTable.getSysColumn(string);
        }
        return sysColumn;
    }

    public List<SysColumn> getColumns() {
        List<SysColumn> list;
        if (this.parentTable == null) {
            list = this.sysColumnList;
        } else {
            list = new ArrayList<SysColumn>();
            list.addAll(this.parentTable.getColumns());
            list.addAll(this.sysColumnList);
        }
        return Collections.unmodifiableList(list);
    }

    public SysColumn getSerialColumn() {
        if (this.serialColumn == null) {
            Enumeration<SysColumn> enumeration = this.sysColumnTable.elements();
            while (enumeration.hasMoreElements()) {
                SysColumn sysColumn = enumeration.nextElement();
                if (!sysColumn.isSerial()) continue;
                this.serialColumn = sysColumn;
                break;
            }
        }
        if (this.serialColumn == null && this.parentTable != null) {
            this.serialColumn = this.parentTable.getSerialColumn();
        }
        return this.serialColumn;
    }

    public SysIndex getPrimaryIndex() {
        return this.primaryConstraint == null ? null : this.getSysIndex(this.primaryConstraint.getIdxID());
    }

    public List<SysColumn> getPrimaryKey() {
        SysIndex sysIndex = this.getPrimaryIndex();
        return sysIndex == null ? null : sysIndex.getKeyColumns();
    }

    public SysIndex getSysIndex(int n) {
        if (this.sysIndexList != null) {
            for (SysIndex sysIndex : this.sysIndexList) {
                if (sysIndex == null || sysIndex.idxid != n) continue;
                return sysIndex;
            }
        }
        return null;
    }

    public SysIndex getSysIndex(String string) {
        if (this.sysIndexList != null) {
            for (SysIndex sysIndex : this.sysIndexList) {
                if (sysIndex == null || !sysIndex.idxname.equalsIgnoreCase(string)) continue;
                return sysIndex;
            }
        }
        return null;
    }

    public List<SysIndex> getSysIndexes(List<String> list) {
        Object object;
        ArrayList<SysIndex> arrayList = new ArrayList<SysIndex>();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            String object2 = list.get(i);
            object = this.getSysColumn(object2);
            nArray[i] = ((SysColumn)object).getColID();
        }
        block1: for (SysIndex sysIndex : this.sysIndexList) {
            if (sysIndex.keycnt != nArray.length) continue;
            object = sysIndex.getIndexKeys();
            for (int i = 0; i < sysIndex.keycnt; ++i) {
                SysIndexKey sysIndexKey = (SysIndexKey)object.get(i);
                if (sysIndexKey.colid != nArray[i]) continue block1;
            }
            arrayList.add(sysIndex);
        }
        return arrayList;
    }

    public SysIndex getPrimaryOrUniqueIndex(List<String> list) {
        SysIndex sysIndex = null;
        SysIndex sysIndex2 = this.getPrimaryIndex();
        for (SysIndex sysIndex3 : this.getSysIndexes(list)) {
            if (sysIndex3 == sysIndex2) {
                return sysIndex2;
            }
            if (sysIndex3.idxtype != 'U' || sysIndex != null && sysIndex3.getIndexLength() >= sysIndex.getIndexLength()) continue;
            sysIndex = sysIndex3;
        }
        return sysIndex;
    }

    public Vector<SysIndex> getAllUniqueAndPrimarySysIndexes() {
        Vector<SysIndex> vector = new Vector<SysIndex>();
        SysIndex sysIndex = this.getPrimaryIndex();
        if (sysIndex != null) {
            vector.add(sysIndex);
        }
        for (SysIndex sysIndex2 : this.sysIndexList) {
            if (sysIndex2.idxtype != 'U') continue;
            vector.add(sysIndex2);
        }
        return vector;
    }

    public List<SysColumn> getRowID() {
        if (this.rowID == null) {
            SysColumn sysColumn = this.getSysColumn("xrowid");
            if (sysColumn != null) {
                this.rowID = Collections.singletonList(sysColumn);
                this.isTrueRowID = true;
            } else {
                this.rowID = this.getPrimaryKey();
                if (this.rowID == null) {
                    SysIndex sysIndex = null;
                    int n = 0;
                    for (SysIndex sysIndex2 : this.sysIndexList) {
                        if (sysIndex2.idxtype != 'U' || sysIndex != null && n <= sysIndex2.getIndexLength()) continue;
                        sysIndex = sysIndex2;
                        n = sysIndex2.getIndexLength();
                    }
                    if (sysIndex == null) {
                        this.rowID = this.sysColumnList;
                    } else {
                        this.rowID = sysIndex.getKeyColumns();
                        this.isTrueRowID = true;
                    }
                }
            }
        }
        return this.rowID;
    }

    public boolean isIndexReferenced(int n) {
        for (int i = 0; i < this.sysReferencesList.size(); ++i) {
            SysReference sysReference = this.sysReferencesList.elementAt(i);
            if (sysReference.getRefIdxID() != n) continue;
            return true;
        }
        return false;
    }

    public boolean isIndexReferenced(SysIndex sysIndex) {
        return this.isIndexReferenced(sysIndex.idxid);
    }

    public SysConstraint getConstraint(String string) {
        for (int i = 0; i < this.sysConstraintsList.size(); ++i) {
            SysConstraint sysConstraint = this.sysConstraintsList.get(i);
            if (sysConstraint.getConstName() == null || string.compareToIgnoreCase(sysConstraint.getConstName()) != 0) continue;
            return sysConstraint;
        }
        return null;
    }

    public SysConstraint getConstraint(int n) {
        for (int i = 0; i < this.sysConstraintsList.size(); ++i) {
            SysConstraint sysConstraint = this.sysConstraintsList.get(i);
            if (n != sysConstraint.getConstID()) continue;
            return sysConstraint;
        }
        return null;
    }

    public List<SysConstraint> getConstraintList() {
        return this.sysConstraintsList;
    }

    public SysConstraint getPrimaryConstraint() {
        return this.primaryConstraint;
    }

    public Vector<SysConstraint> getFkConstList() {
        Vector<SysConstraint> vector = new Vector<SysConstraint>();
        for (SysConstraint sysConstraint : this.sysConstraintsList) {
            if (sysConstraint.getConstType() != 'R') continue;
            vector.add(sysConstraint);
        }
        return vector;
    }

    public SysReference getFkSysReference(int n) {
        Enumeration<SysReference> enumeration = this.sysFkReferenceList.elements();
        while (enumeration.hasMoreElements()) {
            SysReference sysReference = enumeration.nextElement();
            if (sysReference.getConstraint().getConstID() != n) continue;
            return sysReference;
        }
        return null;
    }

    public Vector<SysReference> getSysFkReferenceList() {
        return this.sysFkReferenceList;
    }

    public Vector<SysReference> getSysReferences() {
        return this.sysReferencesList;
    }

    public Hashtable<SysColumn, SysColumn> getReferringSys_ReferrencedColumns_Map() {
        Hashtable<SysColumn, SysColumn> hashtable = new Hashtable<SysColumn, SysColumn>();
        Enumeration<SysReference> enumeration = this.sysFkReferenceList.elements();
        while (enumeration.hasMoreElements()) {
            SysReference sysReference = enumeration.nextElement();
            Vector vector = sysReference.getForeignKeys();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                SysForeignKey sysForeignKey = (SysForeignKey)enumeration2.nextElement();
                SysColumn sysColumn = sysForeignKey.getReferringSysColumn(this.database);
                SysColumn sysColumn2 = sysForeignKey.getReferencedSysColumn(this.database);
                hashtable.put(sysColumn, sysColumn2);
            }
        }
        return hashtable;
    }

    public float getEstRowsPerPage() {
        return this.parentTable == null ? (float)this.estRowsPerPage : (this.rowSize == 0 ? this.parentTable.getEstRowsPerPage() : (float)(8096 / this.getRowSize()));
    }

    public int getRowSize() {
        return this.parentTable == null ? this.rowSize : this.rowSize + this.parentTable.getRowSize();
    }

    public long getRowCount() {
        return this.numrows;
    }

    public SysRowIDHandler getRowIDHandler() {
        if (this.parentTable == null) {
            if (this.rowIDHandler == null) {
                this.rowIDHandler = new SysRowIDHandler(this);
            }
            return this.rowIDHandler;
        }
        return this.parentTable.getRowIDHandler();
    }

    public SysSerialIDHandler getSerialHandler() {
        SysColumn sysColumn;
        if (this.serialIdHandler == null && this.parentTable != null) {
            this.serialIdHandler = this.parentTable.getSerialHandler();
        }
        if (this.serialIdHandler == null && (sysColumn = this.getSerialColumn()) != null) {
            this.serialIdHandler = new SysSerialIDHandler(sysColumn);
        }
        return this.serialIdHandler;
    }

    public SysDatabase getSysDatabase() {
        return this.database;
    }

    public int getSysTableid() throws SQLException, Exception {
        return this.tableid;
    }

    public String getTableDef(boolean bl) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isTemporary()) {
            stringBuffer.append(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_START).append(" ");
        } else {
            stringBuffer.append("CREATE TABLE ");
        }
        stringBuffer.append(IdentifierHandler.quote(this.tableName)).append(" (");
        if (this.sysColumnList.size() > 0) {
            for (SysColumn object2 : this.sysColumnList) {
                object = object2;
                stringBuffer.append(((SysColumn)object).getColumnDefinition()).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
        }
        stringBuffer.append(") ");
        if (bl) {
            if (this.partitionScheme == 3) {
                stringBuffer.append(" partinioning key ").append(this.getPartitionColumn());
                stringBuffer.append(" on nodes (");
                for (DBNode dBNode : this.getNodeList()) {
                    object = dBNode;
                    stringBuffer.append(((DBNode)object).getNodeId()).append(", ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append(")");
            } else if (this.partitionScheme == 1) {
                stringBuffer.append(" on node ");
                Iterator<DBNode> iterator = this.getNodeList().iterator().next();
                stringBuffer.append(((DBNode)((Object)iterator)).getNodeId());
            } else if (this.partitionScheme == 2) {
                stringBuffer.append(" replicated");
            }
        } else if (this.parentTable != null) {
            stringBuffer.append(" inherits (").append(this.parentTable.getTableName()).append(")");
        }
        if (this.isTemporary()) {
            stringBuffer.append(Props.XDB_SQLCOMMAND_CREATETEMPTABLE_SUFFIX);
        }
        return stringBuffer.toString();
    }

    public int getTableId() {
        return this.tableid;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isLookup() {
        return this.parentTable == null ? this.partitionScheme == 2 : this.parentTable.isLookup();
    }

    public boolean isPartitioned() {
        return this.parentTable == null ? this.partitionScheme == 3 || this.partitionScheme == 4 || this.partitionScheme == 5 : this.parentTable.isPartitioned();
    }

    public boolean isPartitionedColumn(String string) {
        return this.isPartitioned() && string.compareToIgnoreCase(this.getPartitionColumn()) == 0;
    }

    public boolean onSameNodes(SysTable sysTable) {
        Collection<DBNode> collection = this.getNodeList();
        Collection<DBNode> collection2 = sysTable.getNodeList();
        if (collection.size() != collection2.size()) {
            return false;
        }
        return this.getPartitionMap().equals(sysTable.getPartitionMap());
    }

    public void setNumrows(long l) {
        long l2 = l - this.numrows;
        this.numrows = l;
        if (this.parentTable != null) {
            this.parentTable.setNumrows(this.parentTable.getRowCount() + l2);
        }
    }

    public boolean isTemporary() {
        return this.tableIsTemporary;
    }

    public void setTableTemporary(boolean bl) {
        this.tableIsTemporary = bl;
    }

    public boolean equals(Object object) {
        if (object instanceof SysTable) {
            SysTable sysTable = (SysTable)object;
            return sysTable.getTableId() == this.getTableId();
        }
        return false;
    }

    public String toString() {
        return this.tableName + ":" + this.tableid;
    }

    void setName(String string) {
        this.tableName = string;
    }

    public void setRowIDHandler(SysRowIDHandler sysRowIDHandler) {
        this.rowIDHandler = sysRowIDHandler;
    }

    void setSerialIDHandler(SysSerialIDHandler sysSerialIDHandler) {
        this.serialIdHandler = sysSerialIDHandler;
    }

    public SysUser getOwner() {
        return this.owner;
    }

    void setOwner(SysUser sysUser) {
        if (this.owner != null) {
            this.owner.removeOwned(this);
        }
        this.owner = sysUser;
        if (this.owner != null) {
            this.owner.addOwned(this);
        }
    }

    SysPermission getSysPermission(SysUser sysUser) {
        if (this.parentTable == null) {
            return this.sysPermissions.get(sysUser);
        }
        return this.parentTable.getSysPermission(sysUser);
    }

    Collection<SysPermission> getSysPermissions() {
        return this.sysPermissions.values();
    }

    public SysTable getParentTable() {
        return this.parentTable;
    }

    void setParentTableID(int n) {
        this.parentTableID = n;
        this.updateParentTableReference();
    }

    int getParentTableID() {
        return this.parentTableID;
    }

    private void updateParentTableReference() {
        if (this.parentTable != null) {
            this.parentTable.removeChildTable(this);
        }
        if (this.parentTableID == -1) {
            this.parentTable = null;
        } else {
            this.parentTable = this.database.getSysTable(this.parentTableID);
            this.parentTable.addChildTable(this);
            this.parentTable.readTableInfo(false);
        }
    }

    private void addChildTable(SysTable sysTable) {
        this.childrenTables.add(sysTable);
    }

    private void removeChildTable(SysTable sysTable) {
        this.childrenTables.remove(sysTable);
    }

    public List getChildrenTables() {
        return this.childrenTables;
    }

    public int getTablespaceID() {
        return this.tablespaceID;
    }

    public Collection<SysCheck> getSysChecks() {
        return this.sysChecks;
    }

    public int getSubtableCount() {
        int n = 0;
        for (SysTable sysTable : this.childrenTables) {
            n += sysTable.getSubtableCount();
        }
        if (this.childrenTables.size() == 0) {
            n = 1;
        }
        return n;
    }

    void setTablespaceID(int n) {
        this.tablespaceID = n;
    }

    public SysTablespace getTablespace() {
        if (this.tablespace == null && this.tablespaceID != -1) {
            for (SysTablespace sysTablespace : MetaData.getMetaData().getTablespaces()) {
                if (sysTablespace.getTablespaceID() != this.tablespaceID) continue;
                this.tablespace = sysTablespace;
                break;
            }
        }
        return this.tablespace;
    }

    void setTablespace(SysTablespace sysTablespace) {
        this.tablespace = sysTablespace;
        this.tablespaceID = sysTablespace == null ? -1 : sysTablespace.getTablespaceID();
    }

    public boolean isPrimaryKey(String string) {
        List<SysColumn> list = this.getPrimaryKey();
        if (list == null || list.size() != 1) {
            return false;
        }
        return string.equalsIgnoreCase(list.get(0).getColName());
    }

    public boolean isUniqueIndex(String string) {
        for (SysIndex sysIndex : this.sysIndexList) {
            SysColumn sysColumn;
            if (sysIndex.idxtype != 'U' || sysIndex.getKeyColumns().size() != 1 || !string.equalsIgnoreCase((sysColumn = sysIndex.getKeyColumns().get(0)).getColName())) continue;
            return true;
        }
        return false;
    }

    public String getClusteridx() {
        return this.clusteridx;
    }

    public void setClusteridx(String string) {
        this.clusteridx = string;
    }

    public boolean isTrueRowID() {
        return this.isTrueRowID;
    }
}

