/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.scheduler;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.exception.XDBServerException;

public class LockType {
    public static final int LOCK_SHARE_READ_INT = 1;
    public static final int LOCK_SHARE_WRITE_INT = 2;
    public static final int LOCK_EXCLUCIVE_INT = 10;
    private static final String LOCK_MODE_STRICT = "S";
    private static final String LOCK_MODE_LOOSE = "L";
    private static final String LOCK_MODE = "L".equalsIgnoreCase(Property.get("xdb.locks.readcommitted.mode")) ? "L" : "S";
    private static final LockType LOCK_SHARE_READ = new LockType(1, false);
    private static final LockType LOCK_SHARE_WRITE = new LockType(2, false);
    private static final LockType LOCK_EXCLUSIVE = new LockType(10, false);
    private int lockType;
    private boolean upgradeable;

    public static LockType get(int n, boolean bl) {
        if (bl) {
            return new LockType(n, true);
        }
        switch (n) {
            case 1: {
                return LOCK_SHARE_READ;
            }
            case 2: {
                return LOCK_SHARE_WRITE;
            }
            case 10: {
                return LOCK_EXCLUSIVE;
            }
        }
        throw new XDBServerException("Unknown lock type: " + n);
    }

    private LockType(int n, boolean bl) {
        this.lockType = n;
        this.upgradeable = bl;
    }

    void upgrade(int n) {
        if (!this.upgradeable) {
            throw new XDBServerException("This lock is not upgradeable");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof LockType) {
            return this.lockType == ((LockType)object).lockType;
        }
        return false;
    }

    public int hashCode() {
        return this.lockType;
    }

    public String toString() {
        String string = "";
        switch (this.lockType) {
            case 1: {
                string = "ShareRead";
                break;
            }
            case 2: {
                string = "ShareWrite";
                break;
            }
            case 10: {
                string = "Exclusive";
            }
        }
        if (this.upgradeable) {
            string = string + "*";
        }
        return string;
    }

    public boolean isCompatible(LockType lockType, int n, int n2) {
        if (this.lockType == 1) {
            return lockType.lockType == 1 || lockType.lockType == 2 && n == 2;
        }
        if (this.lockType == 2) {
            return (lockType.lockType == 1 || lockType.lockType == 2 && LOCK_MODE == LOCK_MODE_LOOSE) && n2 == 2;
        }
        return false;
    }

    boolean stricterThen(LockType lockType) {
        return this.lockType >= lockType.lockType && (lockType.lockType != 1 || this.lockType != 2);
    }

    boolean forRead() {
        return this.lockType == 1 || this.lockType == 10;
    }

    boolean forWrite() {
        return this.lockType == 2 || this.lockType == 10;
    }
}

