/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysTablespace;
import com.edb.gridsql.metadata.partitions.HashPartitionMap;
import com.edb.gridsql.metadata.partitions.PartitionMap;
import com.edb.gridsql.metadata.partitions.ReplicatedPartitionMap;
import com.edb.gridsql.metadata.partitions.RobinPartitionMap;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.OrderByElement;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryNode;
import com.edb.gridsql.optimizer.QuerySubTreeHelper;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.SqlCreateTableColumn;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTree
implements IRebuildString {
    private static final XLogger logger = XLogger.getLogger(QueryTree.class);
    public static final int SCALAR_CORRELATED = 2;
    public static final int SCALAR_NONCORRELATED = 4;
    public static final int NONSCALAR_CORRELATED = 8;
    public static final int NONSCALAR_NONCORRELATED = 16;
    public static final int SCALAR = 6;
    public static final int NONSCALAR = 24;
    public static final int CORRELATED = 10;
    public static final int NONCORRELATED = 20;
    public static final int UNIONTYPE_NONE = 0;
    public static final int UNIONTYPE_UNION = 1;
    public static final int UNIONTYPE_UNIONALL = 2;
    private Map<String, RelationNode> relHandlerInfo = new HashMap<String, RelationNode>();
    private int queryType;
    private Map<QueryTree, RelationNode> placeHolderNodes = new HashMap<QueryTree, RelationNode>();
    private boolean isOuterJoin = false;
    private List<QueryCondition> fromClauseConditions;
    private QueryTree parentQueryTree;
    private RelationNode psuedoRelationNode;
    private QueryCondition whereRoot = null;
    private List<QueryTree> unionQueryTreeList = new ArrayList<QueryTree>();
    private boolean hasUnion = false;
    private int unionType = 0;
    private List<SqlExpression> scalarSubqueryList;
    private List<RelationNode> noncorSubqueryList;
    private List<RelationNode> correlatedSubqueryList;
    private List<RelationNode> relationSubqueryList;
    private QueryNode rootNode;
    private List<SqlExpression> projectionList;
    private List<SqlExpression> hiddenProjectionList;
    private boolean isDistinct = false;
    private List<SqlExpression> finalProjList;
    private List<QueryCondition> conditionList;
    private List<SqlExpression> groupByList;
    private List<QueryCondition> havingList;
    private List<OrderByElement> orderByList;
    private List<RelationNode> relationNodeList;
    private List<Integer> unusedQueryNodeList;
    private Map<Integer, QueryNode> queryNodeTable;
    private boolean containsAggregates = false;
    private int currentNodeId = 0;
    private int currentRelationNodeId = 0;
    private List<SqlExpression> selectOrphans = new ArrayList<SqlExpression>();
    private List<SqlExpression> whereOrphans = new ArrayList<SqlExpression>();
    private List<SqlExpression> orderByOrphans = new ArrayList<SqlExpression>();
    private QueryTree parentTree;
    private int lastOuterLevel = -1;
    private boolean isCorrelatedSubtree = false;
    private boolean isPartOfExistClause = false;
    private boolean isPartitionedGroupBy = false;
    private long limit = -1L;
    private long offset = -1L;
    private boolean isInsertSelect = false;
    private String intoTableName;
    private String intoTableRefName;
    private boolean intoTempTable;
    private short partType = (short)6;
    private PartitionMap partMap = null;
    private String partColumn = null;
    private List<SqlCreateTableColumn> colDefs;
    private SysTablespace tablespace;
    private SysTable intoTable;

    public void setIntoTable(String string, String string2, boolean bl) {
        this.intoTableName = string;
        this.intoTableRefName = string2;
        this.intoTempTable = bl;
    }

    public void setIntoTablePartitioning(short s, String string, PartitionMap partitionMap) {
        this.partType = s;
        this.partColumn = string;
        this.partMap = partitionMap;
    }

    public void setIntoTableColumns(List<String> list) {
        if (list == null) {
            return;
        }
        if (list.size() > this.projectionList.size()) {
            throw new XDBServerException("CREATE TABLE AS specifies too many column names");
        }
        for (int i = 0; i < list.size(); ++i) {
            this.projectionList.get(i).setAlias(list.get(i));
        }
    }

    public void setIntoTableSpace(SysTablespace sysTablespace) {
        this.tablespace = sysTablespace;
    }

    public SysTablespace getIntoTableSpace() {
        return this.tablespace;
    }

    public String getIntoTableName() {
        return this.intoTableName;
    }

    public String getIntoTableRefName() {
        return this.intoTableRefName;
    }

    public boolean isIntoTempTable() {
        return this.intoTempTable;
    }

    public List<SqlCreateTableColumn> getColumnDefinitions() {
        if (this.colDefs == null) {
            this.colDefs = new ArrayList<SqlCreateTableColumn>(this.projectionList.size());
            for (SqlExpression sqlExpression : this.projectionList) {
                this.colDefs.add(new SqlCreateTableColumn(sqlExpression));
            }
        }
        return this.colDefs;
    }

    public void copyIntoTableInfo(QueryTree queryTree) {
        this.intoTable = queryTree.intoTable;
        this.intoTableName = queryTree.intoTableName;
        this.intoTableRefName = queryTree.intoTableRefName;
        this.intoTempTable = queryTree.intoTempTable;
        this.partType = queryTree.partType;
        this.partColumn = queryTree.partColumn;
        this.partMap = queryTree.partMap;
        this.tablespace = queryTree.tablespace;
    }

    public SysTable createIntoTable(XDBSessionContext xDBSessionContext) throws Exception {
        if (this.intoTable == null && this.intoTableName != null) {
            SysDatabase sysDatabase = xDBSessionContext.getSysDatabase();
            List<SqlCreateTableColumn> list = this.getColumnDefinitions();
            if (this.partType == 6) {
                this.partType = (short)5;
                for (SqlCreateTableColumn sqlCreateTableColumn : list) {
                    if (!sqlCreateTableColumn.canBePartitioningKey()) continue;
                    this.partType = (short)3;
                    this.partColumn = sqlCreateTableColumn.columnName;
                    break;
                }
            }
            this.intoTable = sysDatabase.createSysTable(this.intoTableName, this.partType, this.getPartitionMap(sysDatabase), this.partColumn, null, null, this.getColumnDefinitions(), this.tablespace, this.intoTempTable, xDBSessionContext);
        }
        return this.intoTable;
    }

    private PartitionMap getPartitionMap(SysDatabase sysDatabase) {
        if (this.partMap == null) {
            switch (this.partType) {
                case 3: {
                    this.partMap = new HashPartitionMap();
                    break;
                }
                case 1: 
                case 2: {
                    this.partMap = new ReplicatedPartitionMap();
                    break;
                }
                case 5: {
                    this.partMap = new RobinPartitionMap();
                    break;
                }
                default: {
                    return null;
                }
            }
            Collection<DBNode> collection = sysDatabase.getDBNodeList();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(collection.size());
            for (DBNode dBNode : collection) {
                arrayList.add(dBNode.getNodeId());
            }
            this.partMap.generateDistribution(arrayList);
        }
        return this.partMap;
    }

    public String getTableNameOfAlias(String string) {
        String string2 = null;
        for (RelationNode relationNode : this.relHandlerInfo.values()) {
            string2 = relationNode.getTableAlis();
            if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
            return relationNode.getTableName();
        }
        return string;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int n) {
        this.queryType = n;
    }

    public List<QueryCondition> getFromClauseConditions() {
        return this.fromClauseConditions;
    }

    public void setPartOfExistClause(boolean bl) {
        this.isPartOfExistClause = bl;
    }

    public QueryTree() {
        this.projectionList = new ArrayList<SqlExpression>();
        this.hiddenProjectionList = new ArrayList<SqlExpression>();
        this.finalProjList = new ArrayList<SqlExpression>();
        this.conditionList = new ArrayList<QueryCondition>();
        this.groupByList = new ArrayList<SqlExpression>();
        this.havingList = new ArrayList<QueryCondition>();
        this.orderByList = new ArrayList<OrderByElement>();
        this.relationSubqueryList = new ArrayList<RelationNode>();
        this.scalarSubqueryList = new ArrayList<SqlExpression>();
        this.noncorSubqueryList = new ArrayList<RelationNode>();
        this.correlatedSubqueryList = new ArrayList<RelationNode>();
        this.relationNodeList = new ArrayList<RelationNode>();
        this.unusedQueryNodeList = new ArrayList<Integer>();
        this.queryNodeTable = new HashMap<Integer, QueryNode>();
        this.fromClauseConditions = new ArrayList<QueryCondition>();
    }

    public QueryTree copy() {
        QueryNode queryNode;
        QueryTree queryTree = new QueryTree();
        queryTree.projectionList = this.projectionList;
        queryTree.hiddenProjectionList = this.hiddenProjectionList;
        queryTree.whereRoot = this.whereRoot;
        queryTree.conditionList = this.conditionList;
        queryTree.groupByList = this.groupByList;
        queryTree.havingList = this.havingList;
        queryTree.orderByList = this.orderByList;
        queryTree.containsAggregates = this.containsAggregates;
        queryTree.isDistinct = this.isDistinct;
        queryTree.currentNodeId = this.currentNodeId;
        queryTree.currentRelationNodeId = this.currentRelationNodeId;
        queryTree.lastOuterLevel = this.lastOuterLevel;
        queryTree.unionType = this.unionType;
        queryTree.scalarSubqueryList = this.scalarSubqueryList;
        queryTree.noncorSubqueryList = this.noncorSubqueryList;
        queryTree.correlatedSubqueryList = this.correlatedSubqueryList;
        queryTree.relationSubqueryList = this.relationSubqueryList;
        queryTree.relationNodeList = this.relationNodeList;
        for (QueryNode queryNode2 : this.queryNodeTable.values()) {
            if (queryNode2.getNodeType() != 2) continue;
            queryNode = queryNode2.baseCopy();
            queryTree.queryNodeTable.put(queryNode.getNodeId(), queryNode);
        }
        for (QueryNode queryNode2 : this.queryNodeTable.values()) {
            if (queryNode2.getNodeType() != 1 || !queryNode2.isPreserveSubtree()) continue;
            queryNode = this.copySubtreeNodes(queryNode2, queryTree);
            queryTree.queryNodeTable.put(queryNode.getNodeId(), queryNode);
        }
        if (this.rootNode != null) {
            queryTree.rootNode = this.copyTreeNodeLinks(this.rootNode, queryTree);
        }
        for (int i = 0; i < this.unusedQueryNodeList.size(); ++i) {
            queryTree.unusedQueryNodeList.add(this.unusedQueryNodeList.get(i));
        }
        queryTree.parentTree = this.parentTree;
        queryTree.parentQueryTree = this.parentQueryTree;
        queryTree.fromClauseConditions = this.fromClauseConditions;
        queryTree.queryType = this.queryType;
        queryTree.isPartitionedGroupBy = this.isPartitionedGroupBy;
        queryTree.limit = this.limit;
        queryTree.offset = this.offset;
        queryTree.copyIntoTableInfo(this);
        return queryTree;
    }

    public QueryNode copySubtreeNodes(QueryNode queryNode, QueryTree queryTree) {
        QueryNode queryNode2;
        if (queryNode.getNodeType() == 1) {
            queryNode2 = queryNode.baseCopy();
            queryNode2.setLeftNode(this.copySubtreeNodes(queryNode.getLeftNode(), queryTree));
            queryNode2.getLeftNode().setParent(queryNode2);
            queryNode2.setRightNode(this.copySubtreeNodes(queryNode.getRightNode(), queryTree));
            queryNode2.getRightNode().setParent(queryNode2);
        } else {
            queryNode2 = queryTree.getNodeById(queryNode.getNodeId());
        }
        return queryNode2;
    }

    public QueryNode copyTreeNodeLinks(QueryNode queryNode, QueryTree queryTree) {
        QueryNode queryNode2;
        if (queryNode.getNodeType() == 1 && !queryNode.isPreserveSubtree()) {
            queryNode2 = queryNode.baseCopy();
            queryNode2.setLeftNode(this.copyTreeNodeLinks(queryNode.getLeftNode(), queryTree));
            queryNode2.getLeftNode().setParent(queryNode2);
            queryNode2.setRightNode(this.copyTreeNodeLinks(queryNode.getRightNode(), queryTree));
            queryNode2.getRightNode().setParent(queryNode2);
        } else {
            queryNode2 = queryTree.getNodeById(queryNode.getNodeId());
            if (queryNode2 == null) {
                // empty if block
            }
        }
        return queryNode2;
    }

    public RelationNode newRelationNode() {
        RelationNode relationNode = new RelationNode();
        relationNode.setNodeId(++this.currentRelationNodeId);
        this.relationNodeList.add(relationNode);
        return relationNode;
    }

    public QueryNode newQueryNode() {
        QueryNode queryNode = new QueryNode();
        queryNode.setParentTree(this);
        queryNode.setNodeId(++this.currentNodeId);
        queryNode.setNodeType(1);
        return queryNode;
    }

    public QueryNode newQueryNode(RelationNode relationNode) {
        QueryNode queryNode = new QueryNode(relationNode);
        queryNode.setParentTree(this);
        queryNode.setNodeId(++this.currentNodeId);
        queryNode.setNodeType(2);
        return queryNode;
    }

    private String queryNodeToString(QueryNode queryNode, String string) {
        return null;
    }

    public void relabel() {
        this.relabelOne(this.rootNode, "L");
    }

    private void relabelOne(QueryNode queryNode, String string) {
        queryNode.setLabel(string);
        if (queryNode.getRightNode() != null) {
            this.relabelOne(queryNode.getRightNode(), string + "R");
        }
        if (queryNode.getLeftNode() != null) {
            this.relabelOne(queryNode.getLeftNode(), string + "L");
        }
    }

    public QueryCondition getWhereRootCondition() {
        return this.whereRoot;
    }

    public void setWhereRootCondition(QueryCondition queryCondition) {
        this.whereRoot = queryCondition;
    }

    public QueryNode getNodeById(int n) {
        return this.queryNodeTable.get(n);
    }

    public void addToQueryNodeTable(QueryNode queryNode) {
        this.getQueryNodeTable().put(queryNode.getNodeId(), queryNode);
    }

    public void setLimit(long l) {
        this.limit = l;
    }

    public long getLimit() {
        return this.limit;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public String rebuildString() {
        String string = " SELECT ";
        if (this.isDistinct) {
            string = string + " DISTINCT ";
        }
        string = string + this.getListStringOfProjections(this.projectionList);
        string = string + " From  ";
        string = string + this.getListString(this.relationNodeList);
        if (this.getWhereRootCondition() != null) {
            string = string + " WHERE ";
            this.getWhereRootCondition().rebuildCondString();
            string = string + this.getWhereRootCondition().getCondString();
        }
        int n = 0;
        if (this.conditionList.size() != 0) {
            for (QueryCondition iRebuildString : this.conditionList) {
                if (this.getWhereRootCondition() != null && this.getWhereRootCondition().getAndedConditions().contains(iRebuildString)) continue;
                string = n != 0 || this.getWhereRootCondition() != null ? string + " AND " : string + " WHERE ";
                ++n;
                iRebuildString.rebuildCondString();
                string = string + iRebuildString.getCondString();
            }
        }
        if (this.groupByList.size() > 0) {
            string = string + " GROUP BY ";
            string = string + this.getListString(this.groupByList) + " ";
        }
        if (this.getHavingList().size() > 0) {
            string = string + " HAVING ";
            QueryCondition queryCondition = this.havingList.get(0);
            queryCondition.rebuildCondString();
            string = string + " " + queryCondition.getCondString();
        }
        if (this.unionQueryTreeList != null) {
            for (QueryTree queryTree : this.unionQueryTreeList) {
                string = queryTree.unionType == 2 ? string + " UNION ALL " : string + " UNION ";
                string = string + queryTree.rebuildString();
            }
        }
        if (this.orderByList.size() > 0) {
            string = string + " ORDER BY ";
            string = string + this.getListString(this.orderByList);
        }
        return string;
    }

    private String getListString(List<? extends IRebuildString> list) {
        boolean bl = true;
        String string = "";
        for (IRebuildString iRebuildString : list) {
            if (bl) {
                string = string + iRebuildString.rebuildString();
                bl = false;
                continue;
            }
            if (iRebuildString.rebuildString() == null || iRebuildString.rebuildString().equals("")) continue;
            string = string + ", " + iRebuildString.rebuildString();
        }
        return string;
    }

    private String getListStringOfProjections(List<? extends IRebuildString> list) {
        boolean bl = true;
        String string = "";
        for (IRebuildString iRebuildString : list) {
            if (bl) {
                string = string + iRebuildString.rebuildString();
                if (((SqlExpression)iRebuildString).getAlias().length() > 0) {
                    string = string + " as " + IdentifierHandler.quote(((SqlExpression)iRebuildString).getAlias());
                }
                bl = false;
                continue;
            }
            if (iRebuildString.rebuildString() == null || iRebuildString.rebuildString().equals("")) continue;
            string = string + ", " + iRebuildString.rebuildString();
            if (((SqlExpression)iRebuildString).getAlias().length() <= 0) continue;
            string = string + " as " + IdentifierHandler.quote(((SqlExpression)iRebuildString).getAlias());
        }
        return string;
    }

    public int getOrphanCount() {
        return this.orderByOrphans.size() + this.selectOrphans.size() + this.whereOrphans.size();
    }

    public QuerySubTreeHelper processSubTree(SqlExpression sqlExpression, QueryTreeTracker queryTreeTracker) {
        QueryTree queryTree = queryTreeTracker.GetCurrentTree();
        if (this.getOrphanCount() == 0) {
            this.setQueryType(this.queryType & 0x14);
        } else {
            this.setQueryType(this.queryType & 0xA);
        }
        QuerySubTreeHelper querySubTreeHelper = (sqlExpression.getSubqueryTree().getQueryType() & 6) == 0 ? (this.getOrphanCount() > 0 ? this.handleNonScalarCorrelatedQuery(queryTree, sqlExpression) : this.handleNonScalarNonCorrelatedSubquery(queryTree, sqlExpression)) : (this.getOrphanCount() == 0 ? this.handleScalarNonCorrelatedSubQuery(queryTreeTracker, sqlExpression) : this.handleNonScalarCorrelatedQuery(queryTree, sqlExpression));
        return querySubTreeHelper;
    }

    private QuerySubTreeHelper handleNonScalarCorrelatedQuery(QueryTree queryTree, SqlExpression sqlExpression) {
        QuerySubTreeHelper querySubTreeHelper = new QuerySubTreeHelper();
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        RelationNode relationNode = queryTree.newRelationNode();
        relationNode.setNodeType(6);
        relationNode.setSubqueryTree(this);
        relationNode.setTableName("PlaceHolder");
        relationNode.setAlias("PlaceHolder");
        for (SqlExpression sqlExpression2 : this.whereOrphans) {
            relationNode.getCorrelatedColumnList().add(sqlExpression2.getColumn());
            if (relationNode.getJoinList().contains(sqlExpression2.getColumn().relationNode)) continue;
            relationNode.getJoinList().add(sqlExpression2.getColumn().relationNode);
        }
        sqlExpression.setParentContainerNode(relationNode);
        arrayList.addAll(this.whereOrphans);
        SqlExpression sqlExpression3 = new SqlExpression();
        sqlExpression3.setExprType(64);
        sqlExpression3.setSubqueryTree(this);
        sqlExpression3.rebuildString();
        relationNode.setParentCorrelatedExpr(sqlExpression3);
        queryTree.correlatedSubqueryList.add(relationNode);
        relationNode.setSubqueryTree(this);
        relationNode.setParentCorrelatedExpr(sqlExpression);
        queryTree.addPlaceHolderNode(this, relationNode);
        querySubTreeHelper.createdRelationNode = relationNode;
        querySubTreeHelper.projectedSqlExpression.addAll(this.generatePseudoColumnExpressions(this.projectionList, relationNode));
        querySubTreeHelper.correlatedColumnExprList = arrayList;
        return querySubTreeHelper;
    }

    private QuerySubTreeHelper handleNonScalarNonCorrelatedSubquery(QueryTree queryTree, SqlExpression sqlExpression) {
        RelationNode relationNode = queryTree.newRelationNode();
        queryTree.addPlaceHolderNode(this, relationNode);
        relationNode.setTableName("SubQueryTreeNonCorrelatedPlaceHolder");
        relationNode.setAlias("SubQueryTreeNonCorrelatedPlaceHolder");
        relationNode.setNodeType(5);
        relationNode.setSubqueryTree(this);
        relationNode.setParentNoncorExpr(sqlExpression);
        queryTree.noncorSubqueryList.add(relationNode);
        sqlExpression.setParentContainerNode(relationNode);
        QuerySubTreeHelper querySubTreeHelper = new QuerySubTreeHelper();
        querySubTreeHelper.createdRelationNode = relationNode;
        querySubTreeHelper.projectedSqlExpression.addAll(this.generatePseudoColumnExpressions(this.projectionList, relationNode));
        return querySubTreeHelper;
    }

    private QuerySubTreeHelper handleScalarNonCorrelatedSubQuery(QueryTreeTracker queryTreeTracker, SqlExpression sqlExpression) {
        QuerySubTreeHelper querySubTreeHelper = new QuerySubTreeHelper();
        if (!queryTreeTracker.GetCurrentTree().scalarSubqueryList.contains(sqlExpression)) {
            queryTreeTracker.GetCurrentTree().scalarSubqueryList.add(sqlExpression);
        }
        return querySubTreeHelper;
    }

    private ArrayList<SqlExpression> generatePseudoColumnExpressions(List<SqlExpression> list, RelationNode relationNode) {
        ArrayList<SqlExpression> arrayList = new ArrayList<SqlExpression>();
        for (SqlExpression sqlExpression : list) {
            Object object;
            Vector<SqlExpression> vector;
            if (sqlExpression.getExprType() == 4) {
                vector = sqlExpression.getColumn().getTableAlias();
                object = SqlExpression.getSqlColumnExpression(sqlExpression.getColumn().columnName, (String)((Object)vector), (String)((Object)vector), sqlExpression.getColumn().columnAlias, null);
                ((SqlExpression)object).getColumn().relationNode = relationNode;
                ((SqlExpression)object).setMapped(2);
                ((SqlExpression)object).setMappedExpression(sqlExpression);
                ((SqlExpression)object).setExprString(sqlExpression.rebuildString());
                ((SqlExpression)object).getColumn().columnType = sqlExpression.getColumn().columnType;
                ((SqlExpression)object).setExprDataType(sqlExpression.getExprDataType());
                ((SqlExpression)object).setBelongsToTree(this);
                arrayList.add((SqlExpression)object);
                continue;
            }
            if (sqlExpression.getExprType() == 32) {
                arrayList.addAll(this.generatePseudoColumnExpressions(sqlExpression.getFunctionParams(), relationNode));
                continue;
            }
            if (sqlExpression.getExprType() == 16) {
                vector = SqlExpression.getNodes(sqlExpression, 4);
                arrayList.addAll(this.generatePseudoColumnExpressions((List<SqlExpression>)vector, relationNode));
                continue;
            }
            if (sqlExpression.getExprType() == 2 || sqlExpression.getExprType() == 64 || sqlExpression.getExprType() == 128) continue;
            if (sqlExpression.getExprType() == 256) {
                vector = SqlExpression.getNodes(sqlExpression, 4);
                object = this.generatePseudoColumnExpressions(vector, relationNode);
                arrayList.addAll((Collection<SqlExpression>)object);
                continue;
            }
            if (sqlExpression.getExprType() != 512) continue;
        }
        return arrayList;
    }

    public void addPlaceHolderNode(QueryTree queryTree, RelationNode relationNode) {
        if (relationNode == null) {
            throw new XDBServerException("Place Holder Node cannot be Null");
        }
        this.placeHolderNodes.put(queryTree, relationNode);
    }

    public RelationNode getPlaceHodlerNode(QueryTree queryTree) {
        return this.placeHolderNodes.get(queryTree);
    }

    public long getCost() {
        return this.getSubTreeTotalCost(this.rootNode);
    }

    private long getSubTreeTotalCost(QueryNode queryNode) {
        long l = 0L;
        if (queryNode.getLeftNode() != null) {
            l += this.getSubTreeTotalCost(queryNode.getLeftNode());
        }
        if (queryNode.getRightNode() != null) {
            l += this.getSubTreeTotalCost(queryNode.getRightNode());
        }
        return l += queryNode.getEstCost();
    }

    public long getEstimatedCost() {
        if (this.rootNode != null) {
            return this.rootNode.getEstCost();
        }
        throw new XDBServerException("Root Node Of a Query Tree Cannot be NULL");
    }

    public void determinePartitionedGroupBy(SysDatabase sysDatabase) {
        SysTable sysTable;
        QueryNode queryNode;
        SqlExpression sqlExpression;
        this.isPartitionedGroupBy = false;
        if (this.groupByList.size() > 0 && (sqlExpression = this.groupByList.get(0)).getExprType() == 4 && (queryNode = this.rootNode.getRightNode() == null ? this.rootNode.subtreeFind(sqlExpression.getColumn().getTableName(), sqlExpression.getColumn().getTableAlias()) : this.rootNode.getRightNode().subtreeFind(sqlExpression.getColumn().getTableName(), sqlExpression.getColumn().getTableAlias())) != null && (sysTable = sqlExpression.getColumn().getSysTable(sysDatabase)).getPartitionScheme() == 3 && sysTable.getPartitionColumn().compareToIgnoreCase(sqlExpression.getColumn().columnName) == 0) {
            this.isPartitionedGroupBy = true;
        }
    }

    public boolean isPartitionedGroupBy() {
        return this.isPartitionedGroupBy;
    }

    public boolean isSingleTableLookup(SysDatabase sysDatabase) {
        if (this.rootNode.getRightNode() != null) {
            return false;
        }
        RelationNode relationNode = this.rootNode.getRelationNode();
        if (relationNode.getNodeType() != 2) {
            return false;
        }
        SysTable sysTable = relationNode.getSysTable(sysDatabase);
        return sysTable.isLookup();
    }

    public boolean usesSingleDBNode(SysDatabase sysDatabase) {
        if (this.rootNode.getRightNode() != null) {
            return false;
        }
        RelationNode relationNode = this.rootNode.getRelationNode();
        if (relationNode.getNodeType() != 2) {
            return false;
        }
        SysTable sysTable = relationNode.getSysTable(sysDatabase);
        return sysTable.isLookup() || sysTable.getNodeList().size() == 1;
    }

    public void checkExpressionTypes(List<SqlExpression> list) {
        int n;
        if (this.hasUnion) {
            for (n = 0; n < this.unionQueryTreeList.size(); ++n) {
                this.unionQueryTreeList.get(n).checkExpressionTypes(this.projectionList);
            }
        }
        if (list == null || this.projectionList == null || list.size() != this.projectionList.size()) {
            throw new XDBServerException("each UNION query must have the same number of columns.");
        }
        for (n = 0; n < list.size(); ++n) {
            if (SqlExpression.checkCompatibilityForUnion(list.get(n), this.projectionList.get(n))) continue;
            throw new XDBServerException("UNION types " + list.get(n).getExprDataType().getTypeString() + " and " + this.projectionList.get(n).getExprDataType().getTypeString() + " cannot be matched. ");
        }
    }

    private static boolean unionListContainsOnlyLookups(List<QueryTree> list, SysDatabase sysDatabase) {
        if (list == null) {
            return true;
        }
        for (QueryTree queryTree : list) {
            if (queryTree.containsOnlyLookups(sysDatabase)) continue;
            return false;
        }
        return true;
    }

    private static boolean listContainsOnlyLookups(List<RelationNode> list, SysDatabase sysDatabase) {
        for (RelationNode relationNode : list) {
            if (relationNode.getSubqueryTree().containsOnlyLookups(sysDatabase)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsOnlyLookups(SysDatabase sysDatabase) {
        try {
            for (RelationNode relationNode : this.getRelationNodeList()) {
                if (relationNode.getNodeType() == 7 || relationNode.getSysTable(sysDatabase).isLookup()) continue;
                return false;
            }
            if (!QueryTree.listContainsOnlyLookups(this.getNoncorSubqueryList(), sysDatabase)) {
                return false;
            }
            if (!QueryTree.listContainsOnlyLookups(this.getCorrelatedSubqueryList(), sysDatabase)) {
                return false;
            }
            if (!QueryTree.listContainsOnlyLookups(this.getRelationSubqueryList(), sysDatabase)) {
                return false;
            }
            if (QueryTree.unionListContainsOnlyLookups(this.getUnionQueryTreeList(), sysDatabase)) return true;
            return false;
        }
        catch (Throwable throwable) {
            Object var6_16 = null;
            throw throwable;
        }
    }

    public void setConditionList(List<QueryCondition> list) {
        this.conditionList = list;
    }

    public List<QueryCondition> getConditionList() {
        return this.conditionList;
    }

    public void setContainsAggregates(boolean bl) {
        this.containsAggregates = bl;
    }

    public boolean isContainsAggregates() {
        return this.containsAggregates;
    }

    public List<RelationNode> getCorrelatedSubqueryList() {
        return this.correlatedSubqueryList;
    }

    public List<SqlExpression> getFinalProjList() {
        return this.finalProjList;
    }

    public void setGroupByList(List<SqlExpression> list) {
        this.groupByList = list;
    }

    public List<SqlExpression> getGroupByList() {
        return this.groupByList;
    }

    public void setHasUnion(boolean bl) {
        this.hasUnion = bl;
    }

    public boolean isHasUnion() {
        return this.hasUnion;
    }

    public void setHavingList(List<QueryCondition> list) {
        this.havingList = list;
    }

    public List<QueryCondition> getHavingList() {
        return this.havingList;
    }

    public List<SqlExpression> getHiddenProjectionList() {
        return this.hiddenProjectionList;
    }

    public void setCorrelatedSubtree(boolean bl) {
        this.isCorrelatedSubtree = bl;
    }

    public boolean isCorrelatedSubtree() {
        return this.isCorrelatedSubtree;
    }

    public void setDistinct(boolean bl) {
        this.isDistinct = bl;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    public void setOuterJoin(boolean bl) {
        this.isOuterJoin = bl;
    }

    public boolean isOuterJoin() {
        return this.isOuterJoin;
    }

    public boolean isPartOfExistClause() {
        return this.isPartOfExistClause;
    }

    public void setLastOuterLevel(int n) {
        this.lastOuterLevel = n;
    }

    public int getLastOuterLevel() {
        return this.lastOuterLevel;
    }

    public List<RelationNode> getNoncorSubqueryList() {
        return this.noncorSubqueryList;
    }

    public void setOrderByList(List<OrderByElement> list) {
        this.orderByList = list;
    }

    public List<OrderByElement> getOrderByList() {
        return this.orderByList;
    }

    public List<SqlExpression> getOrderByOrphans() {
        return this.orderByOrphans;
    }

    public void setParentQueryTree(QueryTree queryTree) {
        this.parentQueryTree = queryTree;
    }

    public QueryTree getParentQueryTree() {
        return this.parentQueryTree;
    }

    public void setParentTree(QueryTree queryTree) {
        this.parentTree = queryTree;
    }

    public QueryTree getParentTree() {
        return this.parentTree;
    }

    public void setProjectionList(List<SqlExpression> list) {
        this.projectionList = list;
    }

    public List<SqlExpression> getProjectionList() {
        return this.projectionList;
    }

    public void setPseudoRelationNode(RelationNode relationNode) {
        this.psuedoRelationNode = relationNode;
    }

    public RelationNode getPseudoRelationNode() {
        return this.psuedoRelationNode;
    }

    public Map<Integer, QueryNode> getQueryNodeTable() {
        return this.queryNodeTable;
    }

    public List<RelationNode> getRelationNodeList() {
        return this.relationNodeList;
    }

    public List<RelationNode> getRelationSubqueryList() {
        return this.relationSubqueryList;
    }

    public Map<String, RelationNode> getRelHandlerInfo() {
        return this.relHandlerInfo;
    }

    public void setRootNode(QueryNode queryNode) {
        this.rootNode = queryNode;
    }

    public QueryNode getRootNode() {
        return this.rootNode;
    }

    public List<SqlExpression> getScalarSubqueryList() {
        return this.scalarSubqueryList;
    }

    public List<SqlExpression> getSelectOrphans() {
        return this.selectOrphans;
    }

    public List<QueryTree> getUnionQueryTreeList() {
        return this.unionQueryTreeList;
    }

    public void setUnionType(int n) {
        this.unionType = n;
    }

    public int getUnionType() {
        return this.unionType;
    }

    public List<Integer> getUnusedQueryNodeList() {
        return this.unusedQueryNodeList;
    }

    public void setWhereOrphans(List<SqlExpression> list) {
        this.whereOrphans = list;
    }

    public void setIsInsertSelect(boolean bl) {
        this.isInsertSelect = bl;
    }

    public boolean isInsertSelect() {
        return this.isInsertSelect;
    }
}

