/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateView;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.createView;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateView
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateView.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private Command commandToExecute;
    private QueryTree aQueryTree = null;
    private String selectString;
    private boolean isReplace = false;
    private List<String> colList = new ArrayList<String>();
    private List<ExpressionType> colDef = new ArrayList<ExpressionType>();
    private Collection<SysColumn> dependedSysCol = null;
    private String viewName;
    private static int genCount = 0;
    private boolean prepared = false;

    public SqlCreateView(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.commandToExecute = new Command(3, this, new QueryTreeTracker(), xDBSessionContext);
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptySet();
    }

    @Override
    public long getCost() {
        return 10000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        try {
            if (this.client.getCurrentUser().getUserClass() == 2) {
                XDBSecurityException xDBSecurityException = new XDBSecurityException("You are not allowed to create tables");
                logger.throwing(xDBSecurityException);
                throw xDBSecurityException;
            }
            if (this.database.isViewExists(this.viewName) && !this.isReplace) {
                throw new XDBServerException("Duplicate View Name :(" + this.viewName + ")");
            }
            this.prepared = true;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            SyncCreateView syncCreateView = new SyncCreateView(this);
            MetaData metaData = MetaData.getMetaData();
            metaData.beginTransaction();
            try {
                syncCreateView.execute(this.database);
                metaData.commitTransaction(syncCreateView);
            }
            catch (Exception exception) {
                logger.catching(exception);
                metaData.rollbackTransaction();
                throw exception;
            }
            ExecutionResult executionResult = ExecutionResult.createSuccessResult(14);
            Object var6_6 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            throw throwable;
        }
    }

    @Override
    public Object visit(createView createView2, Object object) {
        int n;
        Object var3_3 = null;
        switch (createView2.f0.which) {
            case 0: {
                this.isReplace = false;
                break;
            }
            case 1: {
                this.isReplace = true;
            }
        }
        createView2.f1.accept(this, object);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        createView2.f2.accept(tableNameHandler, object);
        this.viewName = tableNameHandler.getTableName();
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
        this.aQueryTree = new QueryTree();
        createView2.f5.accept(queryTreeHandler, this.aQueryTree);
        for (int i = 0; i < this.aQueryTree.getProjectionList().size(); ++i) {
            if (this.aQueryTree.getProjectionList().get(i).getAlias() == null || this.aQueryTree.getProjectionList().get(i).getAlias().equals("")) {
                if (this.aQueryTree.getProjectionList().get(i).getExprType() != 4) {
                    this.aQueryTree.getProjectionList().get(i).setAlias("VIEW_EXPRESSION" + ++genCount);
                } else {
                    this.aQueryTree.getProjectionList().get(i).setAlias(this.aQueryTree.getProjectionList().get((int)i).getColumn().columnName);
                }
            }
            this.colList.add(this.aQueryTree.getProjectionList().get(i).getAlias());
            this.colDef.add(this.aQueryTree.getProjectionList().get(i).getExprDataType());
        }
        if (createView2.f3.present()) {
            ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
            createView2.f3.accept(columnNameListHandler, null);
            if (this.aQueryTree.getProjectionList().size() < this.colList.size()) {
                throw new XDBServerException("CREATE VIEW specifies more column names than columns");
            }
            for (n = 0; n < columnNameListHandler.getColumnNameList().size(); ++n) {
                this.aQueryTree.getProjectionList().get(n).setAlias(this.colList.get(n));
                this.colList.set(n, columnNameListHandler.getColumnNameList().get(n));
            }
        }
        String string = ((String)object).trim();
        string = string.substring(0, string.length() - 1);
        string = string.trim();
        string = string.replaceAll("\t", " ");
        string = string.replaceAll("\n", " ");
        string = string.replaceAll("\r", " ");
        while (string.contains("  ")) {
            string = string.replaceAll("  ", " ");
        }
        n = string.toUpperCase().indexOf(" AS SELECT ");
        if (n != -1) {
            this.selectString = string.substring(n + 4);
        } else {
            string = string.replaceAll("\\(SELECT ", " ( SELECT ");
            n = (string = string.replaceAll("  ", " ")).toUpperCase().indexOf(" AS ( SELECT ");
            this.selectString = n != -1 ? string.substring(n + 6, string.length() - 1) : this.aQueryTree.rebuildString();
        }
        return var3_3;
    }

    private Collection<SysColumn> getDependedColumns(QueryTree queryTree) {
        HashSet<SysColumn> hashSet = new HashSet<SysColumn>();
        if (queryTree.getRelationSubqueryList() != null && queryTree.getRelationSubqueryList().size() > 0) {
            for (RelationNode iterator : queryTree.getRelationSubqueryList()) {
                this.getDependedColumns(iterator.getSubqueryTree());
            }
        }
        hashSet.addAll(this.getAllSysColumns(queryTree.getProjectionList()));
        ArrayList arrayList = new ArrayList();
        if (queryTree.getWhereRootCondition() != null) {
            for (QueryCondition queryCondition : QueryCondition.getNodes(queryTree.getWhereRootCondition(), 4)) {
                arrayList.add(queryCondition.getExpr());
            }
            hashSet.addAll(this.getAllSysColumns(arrayList));
            arrayList.clear();
        }
        for (QueryCondition queryCondition : queryTree.getConditionList()) {
            for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                arrayList.add(queryCondition2.getExpr());
            }
            hashSet.addAll(this.getAllSysColumns(arrayList));
            arrayList.clear();
        }
        for (RelationNode relationNode : queryTree.getRelationNodeList()) {
            if (relationNode.getNodeType() != 2) continue;
            hashSet.addAll(this.client.getSysDatabase().getSysTable(relationNode.getTableName()).getRowID());
        }
        return hashSet;
    }

    private List<SysColumn> getAllSysColumns(List<SqlExpression> list) {
        ArrayList<SysColumn> arrayList = new ArrayList<SysColumn>();
        for (SqlExpression sqlExpression : list) {
            for (SqlExpression sqlExpression2 : SqlExpression.getNodes(sqlExpression, 4)) {
                while (sqlExpression2.getMappedExpression() != null) {
                    sqlExpression2 = sqlExpression2.getMappedExpression();
                }
                if (sqlExpression2.getColumn() == null || sqlExpression2.getColumn().relationNode.getNodeType() != 2) continue;
                arrayList.add(sqlExpression2.getColumn().getSysColumn(this.client.getSysDatabase()));
            }
        }
        return arrayList;
    }

    public String getSelectString() {
        return this.selectString;
    }

    public void setSelectString(String string) {
        this.selectString = string;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public List<String> getColList() {
        return this.colList;
    }

    public List<ExpressionType> getColDef() {
        return this.colDef;
    }

    public Collection<SysColumn> getDependedSysCol() {
        if (this.dependedSysCol == null) {
            this.dependedSysCol = this.getDependedColumns(this.aQueryTree);
            for (QueryTree queryTree : this.aQueryTree.getUnionQueryTreeList()) {
                this.dependedSysCol.addAll(this.getDependedColumns(queryTree));
            }
        }
        return this.dependedSysCol;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

