/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.ResultSetImpl;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.datatypes.VarcharType;
import com.edb.gridsql.engine.datatypes.XData;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.optimizer.OrderByElement;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Explain;
import com.edb.gridsql.parser.core.syntaxtree.Select;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.OrderByClauseHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlExplain
extends ObjectDepthFirst
implements IXDBSql,
IExecutable,
IPreparable {
    private XDBSessionContext client;
    private boolean verbose;
    private QueryTree aQueryTree = null;
    private Command commandToExecute;
    private QueryProcessor qProc;

    public SqlExplain(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.commandToExecute = new Command(1, this, new QueryTreeTracker(), xDBSessionContext);
        this.aQueryTree = new QueryTree();
    }

    @Override
    public Object visit(Explain explain, Object object) {
        this.verbose = explain.f1.present();
        explain.f2.accept(this, object);
        return null;
    }

    @Override
    public Object visit(Select select, Object object) {
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
        select.f0.accept(queryTreeHandler, this.aQueryTree);
        OrderByClauseHandler orderByClauseHandler = new OrderByClauseHandler(this.commandToExecute);
        select.f1.accept(orderByClauseHandler, this.aQueryTree);
        this.aQueryTree.setOrderByList(orderByClauseHandler.orderByList);
        this.preProcessOrderByList();
        this.FillSQLExpressionInformation(this.aQueryTree.getOrderByList());
        select.f2.accept(queryTreeHandler, this.aQueryTree);
        select.f3.accept(queryTreeHandler, this.aQueryTree);
        this.preProcessUnionList();
        return null;
    }

    private void preProcessUnionList() {
        if (this.aQueryTree.isHasUnion()) {
            for (int i = 0; i < this.aQueryTree.getUnionQueryTreeList().size(); ++i) {
                this.aQueryTree.getUnionQueryTreeList().get(i).checkExpressionTypes(this.aQueryTree.getProjectionList());
            }
        }
    }

    private void preProcessOrderByList() {
        for (OrderByElement orderByElement : this.aQueryTree.getOrderByList()) {
            SqlExpression sqlExpression = orderByElement.orderExpression;
            String string = sqlExpression.rebuildString();
            try {
                int n = Integer.parseInt(string);
                int n2 = n - 1;
                if (n2 >= this.aQueryTree.getProjectionList().size() || n2 < 0) {
                    throw new XDBServerException(ErrorMessageRepository.ORDERBY_CLAUSE_POINTS_TO_ILLEGAL_PROJ_COLUMN, 0, ErrorMessageRepository.ORDERBY_CLAUSE_POINTS_TO_ILLEGAL_PROJ_COLUMN_CODE);
                }
                SqlExpression sqlExpression2 = this.aQueryTree.getProjectionList().get(n2);
                orderByElement.orderExpression = new SqlExpression();
                SqlExpression.copy(sqlExpression2, orderByElement.orderExpression);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void FillSQLExpressionInformation(List<OrderByElement> list) throws ColumnNotFoundException {
        Vector<SqlExpression> vector = new Vector<SqlExpression>();
        for (OrderByElement object2 : list) {
            vector.add(object2.orderExpression);
        }
        QueryTreeHandler.checkAndExpand(vector, this.aQueryTree.getRelationNodeList(), this.client.getSysDatabase(), this.commandToExecute);
        List<SqlExpression> list2 = QueryTreeHandler.checkAndFillTableNames(vector, this.aQueryTree.getRelationNodeList(), this.aQueryTree.getProjectionList(), 4, this.commandToExecute.getaQueryTreeTracker(), this.client.getSysDatabase());
        this.aQueryTree.getOrderByOrphans().addAll((Collection<SqlExpression>)list2);
        Enumeration<SqlExpression> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            SqlExpression sqlExpression = enumeration.nextElement();
            sqlExpression.rebuildExpression();
            SqlExpression.setExpressionResultType(sqlExpression, this.client.getSysDatabase());
        }
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("Query Plan", "Query Plan", 0, 12, 0, 0, "", 0, false)};
        LinkedList<XData[]> linkedList = new LinkedList<XData[]>();
        for (String string : this.qProc.getQueryPlan().toString().split("\n")) {
            linkedList.add(new XData[]{new VarcharType(string)});
        }
        if (this.verbose) {
            linkedList.add(new XData[]{new VarcharType("")});
            linkedList.add(new XData[]{new VarcharType("----------------")});
            linkedList.add(new XData[]{new VarcharType(" Execution Plan")});
            linkedList.add(new XData[]{new VarcharType("----------------")});
            for (String string : this.qProc.getExecPlan().toString().split("\n")) {
                linkedList.add(new XData[]{new VarcharType(string)});
            }
        }
        ResultSetImpl resultSetImpl = new ResultSetImpl(columnMetaDataArray, linkedList);
        return ExecutionResult.createResultSetResult(49, resultSetImpl);
    }

    @Override
    public boolean isPrepared() {
        return this.qProc != null && this.qProc.isPrepared();
    }

    @Override
    public void prepare() throws Exception {
        this.qProc = new QueryProcessor(this.client, this.aQueryTree);
        this.qProc.prepare();
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

