/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncRenameTable;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.RenameTable;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class SqlRenameTable
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlRenameTable.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private SysTable table;
    private String renameTableSql;
    private String oldTableName;
    private String newTableName;

    public SqlRenameTable(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    public Object visit(RenameTable renameTable, Object object) {
        Object var3_3 = null;
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        renameTable.f2.accept(tableNameHandler, object);
        TableNameHandler tableNameHandler2 = new TableNameHandler(this.client);
        renameTable.f4.accept(tableNameHandler2, object);
        this.oldTableName = tableNameHandler.getTableName();
        this.newTableName = tableNameHandler2.getTableName();
        return var3_3;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public String getOldTableName() {
        return this.oldTableName;
    }

    public long getCost() {
        return 1L;
    }

    public LockSpecification getLockSpecs() {
        LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>(Collections.EMPTY_LIST, Collections.singletonList(this.table));
        return lockSpecification;
    }

    public Collection getNodeList() {
        return new ArrayList<DBNode>(this.table.getNodeList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        try {
            if (!this.isPrepared()) {
                this.prepare();
            }
            Vector<DBNode> vector = new Vector<DBNode>(this.table.getNodeList());
            SyncRenameTable syncRenameTable = new SyncRenameTable(this);
            engine.executeDDLOnMultipleNodes(this.renameTableSql, vector, (IMetaDataUpdate)syncRenameTable, this.client);
            ExecutionResult executionResult = ExecutionResult.createSuccessResult(29);
            Object var6_5 = null;
            return executionResult;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }

    public boolean isPrepared() {
        return this.table != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        try {
            Object object;
            this.table = this.database.getSysTable(this.oldTableName);
            Enumeration enumeration = this.database.getAllViews();
            while (enumeration.hasMoreElements()) {
                object = (SysView)enumeration.nextElement();
                if (!((SysView)object).hasDependedTable(this.table.getTableId())) continue;
                if (!((SysView)object).canRenameTable(this.table, this.client)) {
                    XDBSecurityException xDBSecurityException = new XDBSecurityException("cannot rename table " + this.oldTableName + " because other objects depend on it");
                    throw xDBSecurityException;
                }
                try {
                    ((SysView)object).renameTable(this.oldTableName, this.newTableName, this.client);
                }
                catch (Exception exception) {
                    XDBSecurityException xDBSecurityException = new XDBSecurityException("cannot rename table " + this.oldTableName + " because other objects depend on it");
                    throw xDBSecurityException;
                }
            }
            if (this.client.getCurrentUser().getUserClass() != 0 && this.table.getOwner() != this.client.getCurrentUser()) {
                object = new XDBSecurityException("You are not allowed to rename table " + this.oldTableName);
                logger.throwing((Throwable)object);
                throw object;
            }
            if (this.database.isTableExists(this.newTableName)) {
                throw new XDBServerException("Could not rename table " + this.oldTableName + " to " + this.newTableName + ", target table already exists");
            }
            object = Props.XDB_SQLCOMMAND_RENAMETABLE_TEMPLATE;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("oldname", IdentifierHandler.quote(this.oldTableName));
            hashMap.put("newname", IdentifierHandler.quote(this.newTableName));
            this.renameTableSql = ParseCmdLine.substitute((String)object, hashMap);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            throw throwable;
        }
    }

    public boolean needCoordinatorConnection() {
        return true;
    }
}

