/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.util;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.util.ParseArgs;
import com.edb.gridsql.util.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;

public class XdbShutdown {
    private static void terminate(String string) {
        System.err.println(string);
        System.err.println("Parameters: <connect> [-f]\n\twhere <connect> is -j jdbc:edb://<host>:<port>/" + Props.XDB_ADMIN_DATABASE + "?user=<username>&password=<password>\n" + "\tor [-h <host>] [-s <port>] -u <user> [-p <password>]\n" + "\t-h <host> : Host name or IP address where XDBServer is running. Default is localhost\n" + "\t-s <port> : XDBServer's port. Default is 6453\n" + "\t-u <user>, -p <password> : Login to the server\n" + "\t-f : Force mode. Try and shutdown server even if databases are online.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Connection connection = null;
        Statement statement = null;
        try {
            Map<String, List<String>> map = ParseArgs.parse(stringArray, "jhsupf");
            boolean bl = map.containsKey("-f");
            connection = Util.connect(map, true);
            statement = connection.createStatement();
            String string = "SHUTDOWN";
            if (bl) {
                string = string + " FORCE";
            }
            try {
                statement.execute(string);
            }
            catch (SQLException sQLException) {
                if (!"08006".equals(sQLException.getSQLState())) {
                    throw sQLException;
                }
            }
        }
        catch (Exception exception) {
            XdbShutdown.terminate(exception.getMessage());
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        System.out.println("Server is down.");
        System.exit(0);
    }
}

